/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.connection.AutocommitDmlMode;
import com.google.cloud.spanner.connection.ConnectionImpl;
import com.google.cloud.spanner.connection.ConnectionStatementExecutor;
import com.google.cloud.spanner.connection.ConnectionStatementExecutorImpl;
import com.google.cloud.spanner.connection.StatementParser;
import java.util.concurrent.TimeUnit;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ConnectionStatementWithNoParametersTest {
    private final StatementParser parser = StatementParser.INSTANCE;

    @Test
    public void testExecuteGetAutocommit() {
        StatementParser.ParsedStatement statement = this.parser.parse(Statement.of((String)"show variable autocommit"));
        ConnectionImpl connection = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        ConnectionStatementExecutorImpl executor = (ConnectionStatementExecutorImpl)Mockito.mock(ConnectionStatementExecutorImpl.class);
        Mockito.when((Object)executor.getConnection()).thenReturn((Object)connection);
        Mockito.when((Object)executor.statementShowAutocommit()).thenCallRealMethod();
        statement.getClientSideStatement().execute((ConnectionStatementExecutor)executor, "show variable autocommit");
        ((ConnectionImpl)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).isAutocommit();
    }

    @Test
    public void testExecuteGetReadOnly() {
        StatementParser.ParsedStatement statement = this.parser.parse(Statement.of((String)"show variable readonly"));
        ConnectionImpl connection = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        ConnectionStatementExecutorImpl executor = (ConnectionStatementExecutorImpl)Mockito.mock(ConnectionStatementExecutorImpl.class);
        Mockito.when((Object)executor.getConnection()).thenReturn((Object)connection);
        Mockito.when((Object)executor.statementShowReadOnly()).thenCallRealMethod();
        statement.getClientSideStatement().execute((ConnectionStatementExecutor)executor, "show variable readonly");
        ((ConnectionImpl)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).isReadOnly();
    }

    @Test
    public void testExecuteGetAutocommitDmlMode() {
        StatementParser.ParsedStatement statement = this.parser.parse(Statement.of((String)"show variable autocommit_dml_mode"));
        ConnectionImpl connection = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        ConnectionStatementExecutorImpl executor = (ConnectionStatementExecutorImpl)Mockito.mock(ConnectionStatementExecutorImpl.class);
        Mockito.when((Object)executor.getConnection()).thenReturn((Object)connection);
        Mockito.when((Object)executor.statementShowAutocommitDmlMode()).thenCallRealMethod();
        Mockito.when((Object)connection.getAutocommitDmlMode()).thenReturn((Object)AutocommitDmlMode.TRANSACTIONAL);
        statement.getClientSideStatement().execute((ConnectionStatementExecutor)executor, "show variable autocommit_dml_mode");
        ((ConnectionImpl)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).getAutocommitDmlMode();
    }

    @Test
    public void testExecuteGetStatementTimeout() {
        StatementParser.ParsedStatement statement = this.parser.parse(Statement.of((String)"show variable statement_timeout"));
        ConnectionImpl connection = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        ConnectionStatementExecutorImpl executor = (ConnectionStatementExecutorImpl)Mockito.mock(ConnectionStatementExecutorImpl.class);
        Mockito.when((Object)executor.getConnection()).thenReturn((Object)connection);
        Mockito.when((Object)executor.statementShowStatementTimeout()).thenCallRealMethod();
        Mockito.when((Object)connection.hasStatementTimeout()).thenReturn((Object)true);
        Mockito.when((Object)connection.getStatementTimeout(TimeUnit.NANOSECONDS)).thenReturn((Object)1L);
        statement.getClientSideStatement().execute((ConnectionStatementExecutor)executor, "show variable statement_timeout");
        ((ConnectionImpl)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)2))).getStatementTimeout(TimeUnit.NANOSECONDS);
    }

    @Test
    public void testExecuteGetReadTimestamp() {
        StatementParser.ParsedStatement statement = this.parser.parse(Statement.of((String)"show variable read_timestamp"));
        ConnectionImpl connection = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        ConnectionStatementExecutorImpl executor = (ConnectionStatementExecutorImpl)Mockito.mock(ConnectionStatementExecutorImpl.class);
        Mockito.when((Object)executor.getConnection()).thenReturn((Object)connection);
        Mockito.when((Object)executor.statementShowReadTimestamp()).thenCallRealMethod();
        Mockito.when((Object)connection.getReadTimestampOrNull()).thenReturn((Object)Timestamp.now());
        statement.getClientSideStatement().execute((ConnectionStatementExecutor)executor, "show variable read_timestamp");
        ((ConnectionImpl)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).getReadTimestampOrNull();
    }

    @Test
    public void testExecuteGetCommitTimestamp() {
        StatementParser.ParsedStatement statement = this.parser.parse(Statement.of((String)"show variable commit_timestamp"));
        ConnectionImpl connection = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        ConnectionStatementExecutorImpl executor = (ConnectionStatementExecutorImpl)Mockito.mock(ConnectionStatementExecutorImpl.class);
        Mockito.when((Object)executor.getConnection()).thenReturn((Object)connection);
        Mockito.when((Object)executor.statementShowCommitTimestamp()).thenCallRealMethod();
        Mockito.when((Object)connection.getCommitTimestampOrNull()).thenReturn((Object)Timestamp.now());
        statement.getClientSideStatement().execute((ConnectionStatementExecutor)executor, "show variable commit_timestamp");
        ((ConnectionImpl)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).getCommitTimestampOrNull();
    }

    @Test
    public void testExecuteGetReadOnlyStaleness() {
        StatementParser.ParsedStatement statement = this.parser.parse(Statement.of((String)"show variable read_only_staleness"));
        ConnectionImpl connection = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        ConnectionStatementExecutorImpl executor = (ConnectionStatementExecutorImpl)Mockito.mock(ConnectionStatementExecutorImpl.class);
        Mockito.when((Object)executor.getConnection()).thenReturn((Object)connection);
        Mockito.when((Object)executor.statementShowReadOnlyStaleness()).thenCallRealMethod();
        Mockito.when((Object)connection.getReadOnlyStaleness()).thenReturn((Object)TimestampBound.strong());
        statement.getClientSideStatement().execute((ConnectionStatementExecutor)executor, "show variable read_only_staleness");
        ((ConnectionImpl)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).getReadOnlyStaleness();
    }

    @Test
    public void testExecuteGetOptimizerVersion() {
        StatementParser.ParsedStatement statement = this.parser.parse(Statement.of((String)"show variable optimizer_version"));
        ConnectionImpl connection = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        ConnectionStatementExecutorImpl executor = (ConnectionStatementExecutorImpl)Mockito.mock(ConnectionStatementExecutorImpl.class);
        Mockito.when((Object)executor.getConnection()).thenReturn((Object)connection);
        Mockito.when((Object)executor.statementShowOptimizerVersion()).thenCallRealMethod();
        Mockito.when((Object)connection.getOptimizerVersion()).thenReturn((Object)"1");
        statement.getClientSideStatement().execute((ConnectionStatementExecutor)executor, "show variable optimizer_version");
        ((ConnectionImpl)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).getOptimizerVersion();
    }

    @Test
    public void testExecuteBegin() {
        StatementParser.ParsedStatement subject = this.parser.parse(Statement.of((String)"begin"));
        for (String statement : subject.getClientSideStatement().getExampleStatements()) {
            ConnectionImpl connection = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
            ConnectionStatementExecutorImpl executor = (ConnectionStatementExecutorImpl)Mockito.mock(ConnectionStatementExecutorImpl.class);
            Mockito.when((Object)executor.getConnection()).thenReturn((Object)connection);
            Mockito.when((Object)executor.statementBeginTransaction()).thenCallRealMethod();
            subject.getClientSideStatement().execute((ConnectionStatementExecutor)executor, statement);
            ((ConnectionImpl)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).beginTransaction();
        }
    }

    @Test
    public void testExecuteCommit() {
        StatementParser.ParsedStatement subject = this.parser.parse(Statement.of((String)"commit"));
        for (String statement : subject.getClientSideStatement().getExampleStatements()) {
            ConnectionImpl connection = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
            ConnectionStatementExecutorImpl executor = (ConnectionStatementExecutorImpl)Mockito.mock(ConnectionStatementExecutorImpl.class);
            Mockito.when((Object)executor.getConnection()).thenReturn((Object)connection);
            Mockito.when((Object)executor.statementCommit()).thenCallRealMethod();
            subject.getClientSideStatement().execute((ConnectionStatementExecutor)executor, statement);
            ((ConnectionImpl)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).commit();
        }
    }

    @Test
    public void testExecuteRollback() {
        StatementParser.ParsedStatement subject = this.parser.parse(Statement.of((String)"rollback"));
        for (String statement : subject.getClientSideStatement().getExampleStatements()) {
            ConnectionImpl connection = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
            ConnectionStatementExecutorImpl executor = (ConnectionStatementExecutorImpl)Mockito.mock(ConnectionStatementExecutorImpl.class);
            Mockito.when((Object)executor.getConnection()).thenReturn((Object)connection);
            Mockito.when((Object)executor.statementRollback()).thenCallRealMethod();
            subject.getClientSideStatement().execute((ConnectionStatementExecutor)executor, statement);
            ((ConnectionImpl)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).rollback();
        }
    }
}

