/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.api.gax.longrunning.OperationFuture;
import com.google.cloud.spanner.DatabaseAdminClient;
import com.google.cloud.spanner.connection.DdlClient;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Matchers;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class DdlClientTest {
    private final String instanceId = "test-instance";
    private final String databaseId = "test-database";

    private DdlClient createSubject(DatabaseAdminClient client) {
        return DdlClient.newBuilder().setInstanceId("test-instance").setDatabaseName("test-database").setDatabaseAdminClient(client).build();
    }

    @Test
    public void testExecuteDdl() throws InterruptedException, ExecutionException {
        DatabaseAdminClient client = (DatabaseAdminClient)Mockito.mock(DatabaseAdminClient.class);
        OperationFuture operation = (OperationFuture)Mockito.mock(OperationFuture.class);
        Mockito.when((Object)operation.get()).thenReturn(null);
        Mockito.when((Object)client.updateDatabaseDdl((String)Matchers.eq((Object)"test-instance"), (String)Matchers.eq((Object)"test-database"), (Iterable)Matchers.anyListOf(String.class), (String)Matchers.isNull(String.class))).thenReturn((Object)operation);
        DdlClient subject = this.createSubject(client);
        String ddl = "CREATE TABLE FOO";
        subject.executeDdl(ddl);
        ((DatabaseAdminClient)Mockito.verify((Object)client)).updateDatabaseDdl("test-instance", "test-database", Arrays.asList(ddl), null);
        subject = this.createSubject(client);
        List<String> ddlList = Arrays.asList("CREATE TABLE FOO", "DROP TABLE FOO");
        subject.executeDdl(ddlList);
        ((DatabaseAdminClient)Mockito.verify((Object)client)).updateDatabaseDdl("test-instance", "test-database", ddlList, null);
    }
}

