/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.NoCredentials;
import com.google.cloud.spanner.Database;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.IntegrationTestEnv;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TransactionManager;
import com.google.cloud.spanner.connection.AbstractSqlScriptVerifier;
import com.google.cloud.spanner.connection.Connection;
import com.google.cloud.spanner.connection.ConnectionOptions;
import com.google.cloud.spanner.connection.ITConnectionImpl;
import com.google.cloud.spanner.connection.ReadWriteTransaction;
import com.google.cloud.spanner.connection.SqlScriptVerifier;
import com.google.cloud.spanner.connection.StatementExecutionInterceptor;
import com.google.cloud.spanner.connection.StatementExecutionStep;
import com.google.cloud.spanner.connection.StatementParser;
import com.google.cloud.spanner.connection.TransactionRetryListener;
import com.google.cloud.spanner.connection.UnitOfWork;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Strings;
import com.google.protobuf.Duration;
import com.google.protobuf.Message;
import com.google.rpc.RetryInfo;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.protobuf.ProtoUtils;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;

public abstract class ITAbstractSpannerTest {
    @ClassRule
    public static IntegrationTestEnv env = new IntegrationTestEnv();
    private static final String DEFAULT_KEY_FILE = null;
    private static Database database;

    private ITConnection createITConnection(ConnectionOptions options) {
        return new ITConnectionImpl(options);
    }

    protected void closeSpanner() {
        ConnectionOptions.closeSpanner();
    }

    protected static String getKeyFile() {
        return System.getProperty("spanner.gce.config.credentials_file", DEFAULT_KEY_FILE);
    }

    protected static boolean hasValidKeyFile() {
        return ITAbstractSpannerTest.getKeyFile() != null && Files.exists(Paths.get(ITAbstractSpannerTest.getKeyFile(), new String[0]), new LinkOption[0]);
    }

    protected static IntegrationTestEnv getTestEnv() {
        return env;
    }

    protected static Database getDatabase() {
        return database;
    }

    public static StringBuilder extractConnectionUrl(SpannerOptions options, Database database) {
        StringBuilder url = new StringBuilder("cloudspanner:");
        if (options.getHost() != null) {
            url.append(options.getHost().substring(options.getHost().indexOf(58) + 1));
        }
        url.append("/").append(database.getId().getName());
        if (options.getCredentials() == NoCredentials.getInstance()) {
            url.append(";usePlainText=true");
        }
        return url;
    }

    @BeforeClass
    public static void setup() {
        database = env.getTestHelper().createTestDatabase(new String[0]);
    }

    @AfterClass
    public static void teardown() {
        ConnectionOptions.closeSpanner();
    }

    public ITConnection createConnection() {
        return this.createConnection(Collections.emptyList(), Collections.emptyList());
    }

    public ITConnection createConnection(AbortInterceptor interceptor) {
        return this.createConnection(Arrays.asList(interceptor), Collections.emptyList());
    }

    public ITConnection createConnection(AbortInterceptor interceptor, TransactionRetryListener transactionRetryListener) {
        return this.createConnection(Arrays.asList(interceptor), Arrays.asList(transactionRetryListener));
    }

    public ITConnection createConnection(List<StatementExecutionInterceptor> interceptors, List<TransactionRetryListener> transactionRetryListeners) {
        StringBuilder url = ITAbstractSpannerTest.extractConnectionUrl(ITAbstractSpannerTest.getTestEnv().getTestHelper().getOptions(), ITAbstractSpannerTest.getDatabase());
        this.appendConnectionUri(url);
        ConnectionOptions.Builder builder = ConnectionOptions.newBuilder().setUri(url.toString()).setStatementExecutionInterceptors(interceptors);
        if (ITAbstractSpannerTest.hasValidKeyFile()) {
            builder.setCredentialsUrl(ITAbstractSpannerTest.getKeyFile());
        }
        ConnectionOptions options = builder.build();
        ITConnection connection = this.createITConnection(options);
        for (TransactionRetryListener listener : transactionRetryListeners) {
            connection.addTransactionRetryListener(listener);
        }
        return connection;
    }

    protected void appendConnectionUri(StringBuilder uri) {
    }

    protected boolean doCreateDefaultTestTable() {
        return false;
    }

    @Before
    public void createTestTable() {
        if (this.doCreateDefaultTestTable()) {
            try (ITConnection connection = this.createConnection();){
                connection.setAutocommit(true);
                if (!this.tableExists(connection, "TEST")) {
                    connection.setAutocommit(false);
                    connection.startBatchDdl();
                    connection.execute(Statement.of((String)"CREATE TABLE TEST (ID INT64 NOT NULL, NAME STRING(100) NOT NULL) PRIMARY KEY (ID)"));
                    connection.runBatch();
                }
            }
        }
    }

    protected boolean tableExists(Connection connection, String table) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)table) ? 1 : 0) != 0);
        try (ResultSet rs = connection.executeQuery(((Statement.Builder)Statement.newBuilder((String)"SELECT TABLE_NAME FROM INFORMATION_SCHEMA.TABLES WHERE UPPER(TABLE_NAME)=@table_name").bind("table_name").to(table.toUpperCase())).build(), new Options.QueryOption[0]);){
            if (rs.next()) {
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    protected boolean indexExists(Connection connection, String table, String index) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)index) ? 1 : 0) != 0);
        try (ResultSet rs = connection.executeQuery(((Statement.Builder)((Statement.Builder)Statement.newBuilder((String)"SELECT INDEX_NAME FROM INFORMATION_SCHEMA.INDEXES WHERE UPPER(TABLE_NAME)=@table_name AND UPPER(INDEX_NAME)=@index_name").bind("table_name").to(table)).bind("index_name").to(index.toUpperCase())).build(), new Options.QueryOption[0]);){
            if (rs.next()) {
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public static class AbortInterceptor
    implements StatementExecutionInterceptor {
        private double probability;
        private boolean onlyInjectOnce = false;
        private final Random random = new Random();

        public AbortInterceptor(double probability) {
            Preconditions.checkArgument((probability >= 0.0 && probability <= 1.0 ? 1 : 0) != 0);
            this.probability = probability;
        }

        public void setProbability(double probability) {
            Preconditions.checkArgument((probability >= 0.0 && probability <= 1.0 ? 1 : 0) != 0);
            this.probability = probability;
        }

        public void setOnlyInjectOnce(boolean value) {
            this.onlyInjectOnce = value;
        }

        protected boolean shouldAbort(String statement, ExecutionStep step) {
            return this.probability > this.random.nextDouble();
        }

        public void intercept(StatementParser.ParsedStatement statement, StatementExecutionStep step, UnitOfWork transaction) {
            if (this.shouldAbort(statement.getSqlWithoutComments(), ExecutionStep.of(step)) && transaction instanceof ReadWriteTransaction) {
                try {
                    Field field = ReadWriteTransaction.class.getDeclaredField("txManager");
                    field.setAccessible(true);
                    Stopwatch watch = Stopwatch.createStarted();
                    while (field.get(transaction) == null && watch.elapsed(TimeUnit.MILLISECONDS) < 100L) {
                        Thread.sleep(1L);
                    }
                    TransactionManager tx = (TransactionManager)field.get(transaction);
                    if (tx == null) {
                        return;
                    }
                    Class<?> cls = Class.forName("com.google.cloud.spanner.TransactionManagerImpl");
                    Class<?> cls2 = Class.forName("com.google.cloud.spanner.SessionPool$AutoClosingTransactionManager");
                    Field delegateField = cls2.getDeclaredField("delegate");
                    delegateField.setAccessible(true);
                    watch = watch.reset().start();
                    while (delegateField.get(tx) == null && watch.elapsed(TimeUnit.MILLISECONDS) < 100L) {
                        Thread.sleep(1L);
                    }
                    TransactionManager delegate = (TransactionManager)delegateField.get(tx);
                    if (delegate == null) {
                        return;
                    }
                    Field stateField = cls.getDeclaredField("txnState");
                    stateField.setAccessible(true);
                    delegate.rollback();
                    stateField.set(delegate, TransactionManager.TransactionState.ABORTED);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                if (this.onlyInjectOnce) {
                    this.probability = 0.0;
                }
                throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.ABORTED, (String)"Transaction was aborted by interceptor", (Throwable)AbortInterceptor.createAbortedExceptionWithMinimalRetry());
            }
        }

        private static StatusRuntimeException createAbortedExceptionWithMinimalRetry() {
            Metadata.Key key = ProtoUtils.keyForProto((Message)RetryInfo.getDefaultInstance());
            Metadata trailers = new Metadata();
            RetryInfo retryInfo = RetryInfo.newBuilder().setRetryDelay(Duration.newBuilder().setNanos(1).setSeconds(0L)).build();
            trailers.put(key, (Object)retryInfo);
            return Status.ABORTED.asRuntimeException(trailers);
        }

        public static enum ExecutionStep {
            EXECUTE_STATEMENT,
            CALL_NEXT_ON_RESULT_SET,
            RETRY_STATEMENT,
            RETRY_NEXT_ON_RESULT_SET;


            static ExecutionStep of(StatementExecutionStep step) {
                return ExecutionStep.valueOf(step.name());
            }
        }
    }

    protected static interface ITConnection
    extends Connection {
    }

    protected class ITConnectionProvider
    implements AbstractSqlScriptVerifier.GenericConnectionProvider {
        @Override
        public AbstractSqlScriptVerifier.GenericConnection getConnection() {
            return SqlScriptVerifier.SpannerGenericConnection.of(ITAbstractSpannerTest.this.createConnection());
        }
    }
}

