/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.connection.ConnectionImpl;
import com.google.cloud.spanner.connection.ConnectionOptions;
import com.google.cloud.spanner.connection.DdlClient;
import com.google.cloud.spanner.connection.SpannerPool;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public class ReadOnlyStalenessTest {
    private static final String URI = "cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database?readOnly=true";
    private static final String SELECT = "select foo from bar";
    private final DatabaseClient dbClient = (DatabaseClient)Mockito.mock(DatabaseClient.class);

    private ConnectionImpl createConnection(ConnectionOptions options) {
        Spanner spanner = (Spanner)Mockito.mock(Spanner.class);
        SpannerPool spannerPool = (SpannerPool)Mockito.mock(SpannerPool.class);
        Mockito.when((Object)spannerPool.getSpanner((ConnectionOptions)Matchers.any(ConnectionOptions.class), (ConnectionImpl)Matchers.any(ConnectionImpl.class))).thenReturn((Object)spanner);
        DdlClient ddlClient = (DdlClient)Mockito.mock(DdlClient.class);
        ReadOnlyTransaction singleUseReadOnlyTx = (ReadOnlyTransaction)Mockito.mock(ReadOnlyTransaction.class);
        Mockito.when((Object)singleUseReadOnlyTx.executeQuery(Statement.of((String)SELECT), new Options.QueryOption[0])).thenReturn(Mockito.mock(ResultSet.class));
        Mockito.when((Object)this.dbClient.singleUseReadOnlyTransaction((TimestampBound)Matchers.any(TimestampBound.class))).thenReturn((Object)singleUseReadOnlyTx);
        ReadOnlyTransaction readOnlyTx = (ReadOnlyTransaction)Mockito.mock(ReadOnlyTransaction.class);
        Mockito.when((Object)readOnlyTx.executeQuery(Statement.of((String)SELECT), new Options.QueryOption[0])).thenReturn(Mockito.mock(ResultSet.class));
        Mockito.when((Object)this.dbClient.readOnlyTransaction((TimestampBound)Matchers.any(TimestampBound.class))).thenReturn((Object)readOnlyTx);
        return new ConnectionImpl(options, spannerPool, ddlClient, this.dbClient);
    }

    @Test
    public void testDefaultReadOnlyStalenessAutocommitOnce() {
        try (ConnectionImpl connection = this.createConnection(ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setUri(URI).build());){
            MatcherAssert.assertThat((Object)connection.isAutocommit(), (Matcher)CoreMatchers.is((Object)true));
            MatcherAssert.assertThat((Object)connection.isReadOnly(), (Matcher)CoreMatchers.is((Object)true));
            connection.execute(Statement.of((String)SELECT));
            ((DatabaseClient)Mockito.verify((Object)this.dbClient)).singleUseReadOnlyTransaction(TimestampBound.strong());
        }
    }

    @Test
    public void testDefaultReadOnlyStalenessAutocommitTwice() {
        try (ConnectionImpl connection = this.createConnection(ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setUri(URI).build());){
            MatcherAssert.assertThat((Object)connection.isAutocommit(), (Matcher)CoreMatchers.is((Object)true));
            MatcherAssert.assertThat((Object)connection.isReadOnly(), (Matcher)CoreMatchers.is((Object)true));
            connection.execute(Statement.of((String)SELECT));
            connection.execute(Statement.of((String)SELECT));
            ((DatabaseClient)Mockito.verify((Object)this.dbClient, (VerificationMode)Mockito.times((int)2))).singleUseReadOnlyTransaction(TimestampBound.strong());
        }
    }

    @Test
    public void testDefaultReadOnlyStalenessAutocommitChanging() {
        try (ConnectionImpl connection = this.createConnection(ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setUri(URI).build());){
            MatcherAssert.assertThat((Object)connection.isAutocommit(), (Matcher)CoreMatchers.is((Object)true));
            MatcherAssert.assertThat((Object)connection.isReadOnly(), (Matcher)CoreMatchers.is((Object)true));
            connection.execute(Statement.of((String)SELECT));
            ((DatabaseClient)Mockito.verify((Object)this.dbClient)).singleUseReadOnlyTransaction(TimestampBound.strong());
            connection.setReadOnlyStaleness(TimestampBound.ofExactStaleness((long)10L, (TimeUnit)TimeUnit.SECONDS));
            connection.execute(Statement.of((String)SELECT));
            ((DatabaseClient)Mockito.verify((Object)this.dbClient)).singleUseReadOnlyTransaction(TimestampBound.ofExactStaleness((long)10L, (TimeUnit)TimeUnit.SECONDS));
            connection.setReadOnlyStaleness(TimestampBound.ofMaxStaleness((long)5L, (TimeUnit)TimeUnit.SECONDS));
            connection.execute(Statement.of((String)SELECT));
            ((DatabaseClient)Mockito.verify((Object)this.dbClient)).singleUseReadOnlyTransaction(TimestampBound.ofMaxStaleness((long)5L, (TimeUnit)TimeUnit.SECONDS));
            connection.setReadOnlyStaleness(TimestampBound.ofReadTimestamp((Timestamp)Timestamp.MIN_VALUE));
            connection.execute(Statement.of((String)SELECT));
            ((DatabaseClient)Mockito.verify((Object)this.dbClient)).singleUseReadOnlyTransaction(TimestampBound.ofReadTimestamp((Timestamp)Timestamp.MIN_VALUE));
            connection.setReadOnlyStaleness(TimestampBound.ofMinReadTimestamp((Timestamp)Timestamp.MAX_VALUE));
            connection.execute(Statement.of((String)SELECT));
            ((DatabaseClient)Mockito.verify((Object)this.dbClient)).singleUseReadOnlyTransaction(TimestampBound.ofMinReadTimestamp((Timestamp)Timestamp.MAX_VALUE));
        }
    }

    @Test
    public void testDefaultReadOnlyStalenessTransactionalOnce() {
        try (ConnectionImpl connection = this.createConnection(ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setUri(URI).build());){
            connection.setAutocommit(false);
            MatcherAssert.assertThat((Object)connection.isAutocommit(), (Matcher)CoreMatchers.is((Object)false));
            MatcherAssert.assertThat((Object)connection.isReadOnly(), (Matcher)CoreMatchers.is((Object)true));
            connection.execute(Statement.of((String)SELECT));
            ((DatabaseClient)Mockito.verify((Object)this.dbClient)).readOnlyTransaction(TimestampBound.strong());
        }
    }

    @Test
    public void testDefaultReadOnlyStalenessTransactionalTwice() {
        try (ConnectionImpl connection = this.createConnection(ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setUri(URI).build());){
            connection.setAutocommit(false);
            MatcherAssert.assertThat((Object)connection.isAutocommit(), (Matcher)CoreMatchers.is((Object)false));
            MatcherAssert.assertThat((Object)connection.isReadOnly(), (Matcher)CoreMatchers.is((Object)true));
            connection.execute(Statement.of((String)SELECT));
            connection.execute(Statement.of((String)SELECT));
            connection.commit();
            ((DatabaseClient)Mockito.verify((Object)this.dbClient, (VerificationMode)Mockito.times((int)1))).readOnlyTransaction(TimestampBound.strong());
            connection.execute(Statement.of((String)SELECT));
            connection.commit();
            connection.execute(Statement.of((String)SELECT));
            ((DatabaseClient)Mockito.verify((Object)this.dbClient, (VerificationMode)Mockito.times((int)3))).readOnlyTransaction(TimestampBound.strong());
        }
    }

    @Test
    public void testDefaultReadOnlyStalenessTransactionalChanging() {
        try (ConnectionImpl connection = this.createConnection(ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setUri(URI).build());){
            connection.setAutocommit(false);
            MatcherAssert.assertThat((Object)connection.isAutocommit(), (Matcher)CoreMatchers.is((Object)false));
            MatcherAssert.assertThat((Object)connection.isReadOnly(), (Matcher)CoreMatchers.is((Object)true));
            connection.execute(Statement.of((String)SELECT));
            ((DatabaseClient)Mockito.verify((Object)this.dbClient)).readOnlyTransaction(TimestampBound.strong());
            connection.commit();
            connection.setReadOnlyStaleness(TimestampBound.ofExactStaleness((long)10L, (TimeUnit)TimeUnit.SECONDS));
            connection.execute(Statement.of((String)SELECT));
            ((DatabaseClient)Mockito.verify((Object)this.dbClient)).readOnlyTransaction(TimestampBound.ofExactStaleness((long)10L, (TimeUnit)TimeUnit.SECONDS));
            connection.commit();
            connection.setReadOnlyStaleness(TimestampBound.ofReadTimestamp((Timestamp)Timestamp.MIN_VALUE));
            connection.execute(Statement.of((String)SELECT));
            ((DatabaseClient)Mockito.verify((Object)this.dbClient)).readOnlyTransaction(TimestampBound.ofReadTimestamp((Timestamp)Timestamp.MIN_VALUE));
            connection.commit();
        }
    }
}

