/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.connection.AbstractSqlScriptVerifier;
import com.google.cloud.spanner.connection.Connection;
import com.google.cloud.spanner.connection.StatementResult;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;

public class SqlScriptVerifier
extends AbstractSqlScriptVerifier {
    public SqlScriptVerifier() {
        this(null);
    }

    public SqlScriptVerifier(AbstractSqlScriptVerifier.GenericConnectionProvider provider) {
        super(provider);
    }

    @Override
    protected void verifyExpectedException(String statement, Exception e, String code, String messagePrefix) {
        MatcherAssert.assertThat((Object)(e instanceof SpannerException), (Matcher)CoreMatchers.is((Object)true));
        SpannerException spannerException = (SpannerException)((Object)e);
        MatcherAssert.assertThat((String)(statement + " resulted in " + spannerException.toString()), (Object)spannerException.getErrorCode(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)ErrorCode.valueOf((String)code))));
        if (messagePrefix != null) {
            MatcherAssert.assertThat((String)statement, (Object)e.getMessage(), (Matcher)CoreMatchers.startsWith((String)messagePrefix.substring(1, messagePrefix.length() - 1)));
        }
    }

    public static class SpannerGenericConnection
    extends AbstractSqlScriptVerifier.GenericConnection {
        private final Connection connection;

        public static SpannerGenericConnection of(Connection connection) {
            return new SpannerGenericConnection(connection);
        }

        private SpannerGenericConnection(Connection connection) {
            this.connection = connection;
        }

        @Override
        protected AbstractSqlScriptVerifier.GenericStatementResult execute(String sql) {
            return new ConnectionGenericStatementResult(this.connection.execute(Statement.of((String)sql)));
        }

        @Override
        public void close() throws Exception {
            if (this.connection != null) {
                this.connection.close();
            }
        }
    }

    static class ConnectionGenericResultSet
    extends AbstractSqlScriptVerifier.GenericResultSet {
        private final ResultSet resultSet;

        private ConnectionGenericResultSet(ResultSet resultSet) {
            this.resultSet = resultSet;
        }

        @Override
        protected boolean next() {
            return this.resultSet.next();
        }

        @Override
        protected Object getValue(String col) {
            if (this.resultSet.isNull(col)) {
                return null;
            }
            Type type = this.resultSet.getColumnType(col);
            switch (type.getCode()) {
                case ARRAY: {
                    return this.getArrayValue(this.resultSet, col, type.getArrayElementType());
                }
                case BOOL: {
                    return this.resultSet.getBoolean(col);
                }
                case BYTES: {
                    return this.resultSet.getBytes(col);
                }
                case DATE: {
                    return this.resultSet.getDate(col);
                }
                case FLOAT64: {
                    return this.resultSet.getDouble(col);
                }
                case INT64: {
                    return this.resultSet.getLong(col);
                }
                case STRING: {
                    return this.resultSet.getString(col);
                }
                case TIMESTAMP: {
                    return this.resultSet.getTimestamp(col);
                }
                case STRUCT: {
                    throw new IllegalArgumentException("type struct not supported");
                }
            }
            throw new IllegalArgumentException("unknown type: " + type);
        }

        private Object getArrayValue(ResultSet rs, String col, Type type) {
            switch (type.getCode()) {
                case BOOL: {
                    return rs.getBooleanList(col);
                }
                case BYTES: {
                    return rs.getBytesList(col);
                }
                case DATE: {
                    return rs.getDateList(col);
                }
                case FLOAT64: {
                    return rs.getDoubleList(col);
                }
                case INT64: {
                    return rs.getLongList(col);
                }
                case STRING: {
                    return rs.getStringList(col);
                }
                case STRUCT: {
                    return rs.getStructList(col);
                }
                case TIMESTAMP: {
                    return rs.getTimestampList(col);
                }
                case ARRAY: {
                    throw new IllegalArgumentException("array of array not supported");
                }
            }
            throw new IllegalArgumentException("unknown type: " + type);
        }

        @Override
        protected int getColumnCount() throws Exception {
            return this.resultSet.getColumnCount();
        }

        @Override
        protected Object getFirstValue() throws Exception {
            return this.getValue(((Type.StructField)this.resultSet.getType().getStructFields().get(0)).getName());
        }
    }

    static class ConnectionGenericStatementResult
    extends AbstractSqlScriptVerifier.GenericStatementResult {
        private final StatementResult result;

        private ConnectionGenericStatementResult(StatementResult result) {
            this.result = result;
        }

        @Override
        protected StatementResult.ResultType getResultType() {
            return this.result.getResultType();
        }

        @Override
        protected AbstractSqlScriptVerifier.GenericResultSet getResultSet() {
            return new ConnectionGenericResultSet(this.result.getResultSet());
        }

        @Override
        protected long getUpdateCount() {
            return this.result.getUpdateCount();
        }
    }
}

