/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.connection.AbstractConnectionImplTest;
import com.google.cloud.spanner.connection.AbstractMockServerTest;
import com.google.cloud.spanner.connection.AutocommitDmlMode;
import com.google.cloud.spanner.connection.Connection;
import com.google.cloud.spanner.connection.ConnectionOptions;
import com.google.cloud.spanner.connection.ITAbstractSpannerTest;
import com.google.cloud.spanner.connection.ReadOnlyStalenessUtil;
import com.google.common.util.concurrent.Uninterruptibles;
import com.google.longrunning.Operation;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Any;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata;
import com.google.spanner.v1.CommitRequest;
import com.google.spanner.v1.ExecuteSqlRequest;
import io.grpc.Status;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.threeten.bp.Duration;

@RunWith(value=JUnit4.class)
public class StatementTimeoutTest
extends AbstractMockServerTest {
    private static final String SLOW_SELECT = "SELECT foo FROM bar";
    private static final String INVALID_SELECT = "SELECT FROM bar";
    private static final String SLOW_DDL = "CREATE TABLE foo";
    private static final String FAST_DDL = "CREATE TABLE fast_table";
    private static final String SLOW_UPDATE = "UPDATE foo SET col1=1 WHERE id=2";
    private static final int EXECUTION_TIME_SLOW_STATEMENT = 10000;
    private static final long TIMEOUT_FOR_FAST_STATEMENTS = 1000L;
    private static final int TIMEOUT_FOR_SLOW_STATEMENTS = 50;

    @Override
    ITAbstractSpannerTest.ITConnection createConnection() {
        StringBuilder url = new StringBuilder(this.getBaseUrl());
        ConnectionOptions options = ConnectionOptions.newBuilder().setUri(url.toString()).setConfigurator(new ConnectionOptions.SpannerOptionsConfigurator(){

            public void configure(SpannerOptions.Builder options) {
                options.getDatabaseAdminStubSettingsBuilder().updateDatabaseDdlOperationSettings().setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1L)).setMaxRetryDelay(Duration.ofMillis((long)1L)).setRetryDelayMultiplier(1.0).setTotalTimeout(Duration.ofMinutes((long)10L)).build()));
            }
        }).build();
        return this.createITConnection(options);
    }

    @After
    public void clearExecutionTimes() {
        mockSpanner.removeAllExecutionTimes();
    }

    @Test
    public void testTimeoutExceptionReadOnlyAutocommit() {
        mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(10000, 0));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            connection.setReadOnly(true);
            connection.setStatementTimeout(50L, TimeUnit.MILLISECONDS);
            try {
                connection.executeQuery(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]);
                Assert.fail((String)"missing expected exception");
            }
            catch (SpannerException ex) {
                Assert.assertEquals((Object)ErrorCode.DEADLINE_EXCEEDED, (Object)ex.getErrorCode());
            }
        }
    }

    @Test
    public void testTimeoutExceptionReadOnlyAutocommitMultipleStatements() {
        mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(10000, 0));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            connection.setReadOnly(true);
            connection.setStatementTimeout(50L, TimeUnit.MILLISECONDS);
            for (int i = 0; i < 2; ++i) {
                try {
                    connection.executeQuery(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]);
                    Assert.fail((String)"missing expected exception");
                    continue;
                }
                catch (SpannerException e) {
                    Assert.assertEquals((Object)ErrorCode.DEADLINE_EXCEEDED, (Object)e.getErrorCode());
                }
            }
            mockSpanner.removeAllExecutionTimes();
            connection.setStatementTimeout(1000L, TimeUnit.MILLISECONDS);
            try (ResultSet rs = connection.executeQuery(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]);){
                MatcherAssert.assertThat((Object)rs, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
            }
        }
    }

    @Test
    public void testTimeoutExceptionReadOnlyTransactional() {
        mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(10000, 0));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setReadOnly(true);
            connection.setAutocommit(false);
            connection.setStatementTimeout(50L, TimeUnit.MILLISECONDS);
            try {
                connection.executeQuery(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]);
                Assert.fail((String)"missing expected exception");
            }
            catch (SpannerException ex) {
                Assert.assertEquals((Object)ErrorCode.DEADLINE_EXCEEDED, (Object)ex.getErrorCode());
            }
        }
    }

    @Test
    public void testTimeoutExceptionReadOnlyTransactionMultipleStatements() {
        mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(10000, 0));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setReadOnly(true);
            connection.setAutocommit(false);
            connection.setStatementTimeout(50L, TimeUnit.MILLISECONDS);
            for (int i = 0; i < 2; ++i) {
                try {
                    connection.executeQuery(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]);
                    Assert.fail((String)"missing expected exception");
                    continue;
                }
                catch (SpannerException e) {
                    Assert.assertEquals((Object)ErrorCode.DEADLINE_EXCEEDED, (Object)e.getErrorCode());
                }
            }
            connection.clearStatementTimeout();
            connection.rollback();
            mockSpanner.removeAllExecutionTimes();
            connection.setStatementTimeout(1000L, TimeUnit.MILLISECONDS);
            try (ResultSet rs = connection.executeQuery(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]);){
                MatcherAssert.assertThat((Object)rs, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
            }
        }
    }

    @Test
    public void testTimeoutExceptionReadWriteAutocommit() {
        mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(10000, 0));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            connection.setStatementTimeout(50L, TimeUnit.MILLISECONDS);
            try {
                connection.executeQuery(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]);
                Assert.fail((String)"missing expected exception");
            }
            catch (SpannerException ex) {
                Assert.assertEquals((Object)ErrorCode.DEADLINE_EXCEEDED, (Object)ex.getErrorCode());
            }
        }
    }

    @Test
    public void testTimeoutExceptionReadWriteAutocommitMultipleStatements() {
        mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(10000, 0));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            connection.setStatementTimeout(50L, TimeUnit.MILLISECONDS);
            for (int i = 0; i < 2; ++i) {
                try {
                    connection.executeQuery(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]);
                    Assert.fail((String)"missing expected exception");
                    continue;
                }
                catch (SpannerException e) {
                    Assert.assertEquals((Object)ErrorCode.DEADLINE_EXCEEDED, (Object)e.getErrorCode());
                }
            }
            mockSpanner.removeAllExecutionTimes();
            connection.setStatementTimeout(1000L, TimeUnit.MILLISECONDS);
            try (ResultSet rs = connection.executeQuery(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]);){
                MatcherAssert.assertThat((Object)rs, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
            }
        }
    }

    @Test
    public void testTimeoutExceptionReadWriteAutocommitSlowUpdate() {
        mockSpanner.setExecuteSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(10000, 0));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            connection.setStatementTimeout(50L, TimeUnit.MILLISECONDS);
            try {
                connection.execute(INSERT_STATEMENT);
                Assert.fail((String)"Missing expected exception");
            }
            catch (SpannerException ex) {
                Assert.assertEquals((Object)ErrorCode.DEADLINE_EXCEEDED, (Object)ex.getErrorCode());
            }
        }
    }

    @Test
    public void testTimeoutExceptionReadWriteAutocommitSlowUpdateMultipleStatements() {
        mockSpanner.setExecuteSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(10000, 0));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            connection.setStatementTimeout(50L, TimeUnit.MILLISECONDS);
            for (int i = 0; i < 2; ++i) {
                try {
                    connection.execute(Statement.of((String)SLOW_UPDATE));
                    Assert.fail((String)"missing expected exception");
                    continue;
                }
                catch (SpannerException e) {
                    Assert.assertEquals((Object)ErrorCode.DEADLINE_EXCEEDED, (Object)e.getErrorCode());
                }
            }
            mockSpanner.removeAllExecutionTimes();
            connection.setStatementTimeout(1000L, TimeUnit.MILLISECONDS);
            MatcherAssert.assertThat((Object)connection.execute(INSERT_STATEMENT).getUpdateCount(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1L)));
        }
    }

    @Test
    public void testTimeoutExceptionReadWriteAutocommitSlowCommit() {
        mockSpanner.setCommitExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(10000, 0));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setStatementTimeout(1000L, TimeUnit.MILLISECONDS);
            connection.setAutocommit(false);
            connection.execute(INSERT_STATEMENT);
            connection.rollback();
            connection.setStatementTimeout(50L, TimeUnit.MILLISECONDS);
            connection.setAutocommit(true);
            try {
                connection.execute(INSERT_STATEMENT);
                Assert.fail((String)"missing expected exception");
            }
            catch (SpannerException ex) {
                Assert.assertEquals((Object)ErrorCode.DEADLINE_EXCEEDED, (Object)ex.getErrorCode());
            }
        }
    }

    @Test
    public void testTimeoutExceptionReadWriteAutocommitSlowCommitMultipleStatements() {
        mockSpanner.setCommitExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(10000, 0));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            connection.setStatementTimeout(50L, TimeUnit.MILLISECONDS);
            for (int i = 0; i < 2; ++i) {
                try {
                    connection.execute(INSERT_STATEMENT);
                    Assert.fail((String)"Missing expected exception");
                    continue;
                }
                catch (SpannerException e) {
                    MatcherAssert.assertThat((Object)e.getErrorCode(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)ErrorCode.DEADLINE_EXCEEDED)));
                }
            }
            connection.setStatementTimeout(1000L, TimeUnit.MILLISECONDS);
            try (ResultSet rs = connection.executeQuery(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]);){
                MatcherAssert.assertThat((Object)rs, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
            }
        }
    }

    @Test
    public void testTimeoutExceptionReadWriteAutocommitPartitioned() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            connection.setAutocommitDmlMode(AutocommitDmlMode.PARTITIONED_NON_ATOMIC);
            connection.setStatementTimeout(1000L, TimeUnit.MILLISECONDS);
            connection.execute(INSERT_STATEMENT);
            mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(10000, 0));
            connection.setStatementTimeout(50L, TimeUnit.MILLISECONDS);
            try {
                connection.execute(INSERT_STATEMENT);
                Assert.fail((String)"Missing expected exception");
            }
            catch (SpannerException ex) {
                Assert.assertEquals((Object)ErrorCode.DEADLINE_EXCEEDED, (Object)ex.getErrorCode());
            }
        }
    }

    @Test
    public void testTimeoutExceptionReadWriteTransactional() {
        mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(10000, 0));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(false);
            connection.setStatementTimeout(50L, TimeUnit.MILLISECONDS);
            try {
                connection.executeQuery(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]);
                Assert.fail((String)"Missing expected exception");
            }
            catch (SpannerException ex) {
                Assert.assertEquals((Object)ErrorCode.DEADLINE_EXCEEDED, (Object)ex.getErrorCode());
            }
        }
    }

    @Test
    public void testTimeoutExceptionReadWriteTransactionMultipleStatements() {
        mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(10000, 0));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(false);
            connection.setStatementTimeout(50L, TimeUnit.MILLISECONDS);
            for (int i = 0; i < 2; ++i) {
                try {
                    connection.executeQuery(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]);
                    Assert.fail((String)"Missing expected exception");
                    continue;
                }
                catch (SpannerException e) {
                    if (i == 0) {
                        MatcherAssert.assertThat((Object)e.getErrorCode(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)ErrorCode.DEADLINE_EXCEEDED)));
                        continue;
                    }
                    MatcherAssert.assertThat((Object)e.getErrorCode(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)ErrorCode.FAILED_PRECONDITION)));
                }
            }
            connection.clearStatementTimeout();
            connection.rollback();
            mockSpanner.removeAllExecutionTimes();
            connection.setStatementTimeout(1000L, TimeUnit.MILLISECONDS);
            try (ResultSet rs = connection.executeQuery(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]);){
                MatcherAssert.assertThat((Object)rs, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
            }
        }
    }

    @Test
    public void testTimeoutExceptionReadWriteTransactionalSlowCommit() {
        mockSpanner.setCommitExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(10000, 0));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(false);
            connection.setStatementTimeout(1000L, TimeUnit.MILLISECONDS);
            try (ResultSet rs = connection.executeQuery(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]);){
                MatcherAssert.assertThat((Object)rs, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
            }
            connection.setStatementTimeout(50L, TimeUnit.MILLISECONDS);
            try {
                connection.commit();
                Assert.fail((String)"Missing expected exception");
            }
            catch (SpannerException ex) {
                Assert.assertEquals((Object)ErrorCode.DEADLINE_EXCEEDED, (Object)ex.getErrorCode());
            }
        }
    }

    @Test
    public void testTimeoutExceptionReadWriteTransactionalSlowRollback() {
        mockSpanner.setRollbackExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(10000, 0));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(false);
            connection.setStatementTimeout(1000L, TimeUnit.MILLISECONDS);
            try (ResultSet rs = connection.executeQuery(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]);){
                MatcherAssert.assertThat((Object)rs, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
            }
            connection.setStatementTimeout(50L, TimeUnit.MILLISECONDS);
            connection.rollback();
        }
    }

    @Test
    public void testInterruptedExceptionReadOnlyAutocommit() throws InterruptedException, ExecutionException {
        this.testInterruptedException(new ConnectionReadOnlyAutocommit());
    }

    @Test
    public void testInterruptedExceptionReadOnlyTransactional() throws InterruptedException, ExecutionException {
        this.testInterruptedException(new ConnectionReadOnlyTransactional());
    }

    @Test
    public void testInterruptedExceptionReadWriteAutocommit() throws InterruptedException, ExecutionException {
        this.testInterruptedException(new ConnectionReadWriteAutocommit());
    }

    @Test
    public void testInterruptedExceptionReadWriteTransactional() throws InterruptedException, ExecutionException {
        this.testInterruptedException(new ConnectionReadWriteTransactional());
    }

    private void testInterruptedException(AbstractConnectionImplTest.ConnectionConsumer consumer) throws InterruptedException, ExecutionException {
        mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(10000, 0));
        CountDownLatch latch = new CountDownLatch(1);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<Boolean> future = executor.submit(() -> {
            try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
                consumer.accept(connection);
                connection.setStatementTimeout(10000L, TimeUnit.MILLISECONDS);
                latch.countDown();
                ResultSet rs = connection.executeQuery(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]);
                Throwable throwable2 = null;
                if (rs != null) {
                    if (throwable2 != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                    } else {
                        rs.close();
                    }
                }
                Boolean bl = false;
                return bl;
            }
            catch (SpannerException e) {
                boolean bl;
                if (e.getErrorCode() == ErrorCode.CANCELLED) {
                    bl = true;
                    return bl;
                }
                bl = false;
                return bl;
            }
        });
        latch.await(10L, TimeUnit.SECONDS);
        executor.shutdownNow();
        MatcherAssert.assertThat((Object)future.get(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testInvalidQueryReadOnlyAutocommit() {
        mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)Status.INVALID_ARGUMENT.asRuntimeException()));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            connection.setReadOnly(true);
            connection.setStatementTimeout(1000L, TimeUnit.MILLISECONDS);
            try {
                connection.executeQuery(Statement.of((String)INVALID_SELECT), new Options.QueryOption[0]);
                Assert.fail((String)"Missing expected exception");
            }
            catch (SpannerException ex) {
                Assert.assertEquals((Object)ErrorCode.INVALID_ARGUMENT, (Object)ex.getErrorCode());
            }
        }
    }

    @Test
    public void testInvalidQueryReadOnlyTransactional() {
        mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)Status.INVALID_ARGUMENT.asRuntimeException()));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setReadOnly(true);
            connection.setAutocommit(false);
            connection.setStatementTimeout(1000L, TimeUnit.MILLISECONDS);
            try {
                connection.executeQuery(Statement.of((String)INVALID_SELECT), new Options.QueryOption[0]);
                Assert.fail((String)"Missing expected exception");
            }
            catch (SpannerException ex) {
                Assert.assertEquals((Object)ErrorCode.INVALID_ARGUMENT, (Object)ex.getErrorCode());
            }
        }
    }

    @Test
    public void testInvalidQueryReadWriteAutocommit() {
        mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)Status.INVALID_ARGUMENT.asRuntimeException()));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            connection.setStatementTimeout(1000L, TimeUnit.MILLISECONDS);
            try {
                connection.executeQuery(Statement.of((String)INVALID_SELECT), new Options.QueryOption[0]);
                Assert.fail((String)"Missing expected exception");
            }
            catch (SpannerException ex) {
                Assert.assertEquals((Object)ErrorCode.INVALID_ARGUMENT, (Object)ex.getErrorCode());
            }
        }
    }

    @Test
    public void testInvalidQueryReadWriteTransactional() {
        mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)Status.INVALID_ARGUMENT.asRuntimeException()));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(false);
            connection.setStatementTimeout(1000L, TimeUnit.MILLISECONDS);
            try {
                connection.executeQuery(Statement.of((String)INVALID_SELECT), new Options.QueryOption[0]);
                Assert.fail((String)"Missing expected exception");
            }
            catch (SpannerException ex) {
                Assert.assertEquals((Object)ErrorCode.INVALID_ARGUMENT, (Object)ex.getErrorCode());
            }
        }
    }

    static void waitForRequestsToContain(Class<? extends AbstractMessage> request) {
        try {
            mockSpanner.waitForRequestsToContain(request, 10000L);
        }
        catch (InterruptedException e) {
            throw SpannerExceptionFactory.propagateInterrupt((InterruptedException)e);
        }
        catch (TimeoutException e) {
            throw SpannerExceptionFactory.propagateTimeout((TimeoutException)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCancelReadOnlyAutocommit() {
        mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(10000, 0));
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            connection.setReadOnly(true);
            executor.execute(() -> {
                StatementTimeoutTest.waitForRequestsToContain(ExecuteSqlRequest.class);
                connection.cancel();
            });
            try {
                connection.executeQuery(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]);
                Assert.fail((String)"Missing expected exception");
            }
            catch (SpannerException ex) {
                Assert.assertEquals((Object)ErrorCode.CANCELLED, (Object)ex.getErrorCode());
            }
        }
        finally {
            executor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCancelReadOnlyAutocommitMultipleStatements() {
        mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(10000, 0));
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            Throwable throwable;
            ResultSet rs;
            connection.setAutocommit(true);
            connection.setReadOnly(true);
            executor.execute(() -> {
                StatementTimeoutTest.waitForRequestsToContain(ExecuteSqlRequest.class);
                connection.cancel();
            });
            try {
                rs = connection.executeQuery(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]);
                throwable = null;
                try {
                    Assert.fail((String)"Missing expected exception");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (rs != null) {
                        if (throwable != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            rs.close();
                        }
                    }
                }
            }
            catch (SpannerException e) {
                MatcherAssert.assertThat((Object)e.getErrorCode(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)ErrorCode.CANCELLED)));
            }
            mockSpanner.removeAllExecutionTimes();
            connection.setStatementTimeout(1000L, TimeUnit.MILLISECONDS);
            rs = connection.executeQuery(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]);
            throwable = null;
            try {
                MatcherAssert.assertThat((Object)rs, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (rs != null) {
                    if (throwable != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
        finally {
            executor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCancelReadOnlyTransactional() {
        mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(10000, 0));
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setReadOnly(true);
            connection.setAutocommit(false);
            executor.execute(() -> {
                StatementTimeoutTest.waitForRequestsToContain(ExecuteSqlRequest.class);
                connection.cancel();
            });
            try {
                connection.executeQuery(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]);
                Assert.fail((String)"Missing expected exception");
            }
            catch (SpannerException ex) {
                Assert.assertEquals((Object)ErrorCode.CANCELLED, (Object)ex.getErrorCode());
            }
        }
        finally {
            executor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCancelReadOnlyTransactionalMultipleStatements() {
        mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(10000, 0));
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setReadOnly(true);
            connection.setAutocommit(false);
            executor.execute(() -> {
                StatementTimeoutTest.waitForRequestsToContain(ExecuteSqlRequest.class);
                connection.cancel();
            });
            try {
                connection.executeQuery(Statement.of((String)SLOW_SELECT), new Options.QueryOption[0]);
                Assert.fail((String)"Missing expected exception");
            }
            catch (SpannerException e) {
                Assert.assertEquals((Object)ErrorCode.CANCELLED, (Object)e.getErrorCode());
            }
            mockSpanner.removeAllExecutionTimes();
            connection.setStatementTimeout(1000L, TimeUnit.MILLISECONDS);
            try (ResultSet rs = connection.executeQuery(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]);){
                MatcherAssert.assertThat((Object)rs, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
            }
            connection.rollback();
            rs = connection.executeQuery(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]);
            var5_8 = null;
            try {
                MatcherAssert.assertThat((Object)rs, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
            }
            catch (Throwable throwable) {
                var5_8 = throwable;
                throw throwable;
            }
            finally {
                if (rs != null) {
                    if (var5_8 != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable) {
                            var5_8.addSuppressed(throwable);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
        finally {
            executor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCancelReadWriteAutocommit() {
        mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(10000, 0));
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            executor.execute(() -> {
                StatementTimeoutTest.waitForRequestsToContain(ExecuteSqlRequest.class);
                connection.cancel();
            });
            try {
                connection.executeQuery(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]);
                Assert.fail((String)"Missing expected exception");
            }
            catch (SpannerException ex) {
                Assert.assertEquals((Object)ErrorCode.CANCELLED, (Object)ex.getErrorCode());
            }
        }
        finally {
            executor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCancelReadWriteAutocommitMultipleStatements() {
        mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(10000, 0));
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            executor.execute(() -> {
                StatementTimeoutTest.waitForRequestsToContain(ExecuteSqlRequest.class);
                connection.cancel();
            });
            try {
                connection.executeQuery(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]);
                Assert.fail((String)"Missing expected exception");
            }
            catch (SpannerException ex) {
                Assert.assertEquals((Object)ErrorCode.CANCELLED, (Object)ex.getErrorCode());
            }
            mockSpanner.removeAllExecutionTimes();
            connection.setStatementTimeout(1000L, TimeUnit.MILLISECONDS);
            try (ResultSet rs = connection.executeQuery(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]);){
                MatcherAssert.assertThat((Object)rs, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
            }
        }
        finally {
            executor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCancelReadWriteAutocommitSlowUpdate() {
        mockSpanner.setExecuteSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(10000, 0));
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            executor.execute(() -> {
                StatementTimeoutTest.waitForRequestsToContain(ExecuteSqlRequest.class);
                connection.cancel();
            });
            try {
                connection.execute(INSERT_STATEMENT);
                Assert.fail((String)"Missing expected exception");
            }
            catch (SpannerException ex) {
                Assert.assertEquals((Object)ErrorCode.CANCELLED, (Object)ex.getErrorCode());
            }
        }
        finally {
            executor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCancelReadWriteAutocommitSlowCommit() {
        mockSpanner.setCommitExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(10000, 0));
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            executor.execute(() -> {
                StatementTimeoutTest.waitForRequestsToContain(CommitRequest.class);
                connection.cancel();
            });
            connection.execute(INSERT_STATEMENT);
            Assert.fail((String)"Missing expected exception");
        }
        catch (SpannerException ex) {
            Assert.assertEquals((Object)ErrorCode.CANCELLED, (Object)ex.getErrorCode());
        }
        finally {
            executor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCancelReadWriteTransactional() {
        mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(10000, 0));
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(false);
            executor.execute(() -> {
                StatementTimeoutTest.waitForRequestsToContain(ExecuteSqlRequest.class);
                connection.cancel();
            });
            connection.executeQuery(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]);
            Assert.fail((String)"Missing expected exception");
        }
        catch (SpannerException ex) {
            Assert.assertEquals((Object)ErrorCode.CANCELLED, (Object)ex.getErrorCode());
        }
        finally {
            executor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCancelReadWriteTransactionalMultipleStatements() {
        mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(10000, 0));
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(false);
            executor.execute(() -> {
                StatementTimeoutTest.waitForRequestsToContain(ExecuteSqlRequest.class);
                connection.cancel();
            });
            try {
                connection.executeQuery(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]);
                Assert.fail((String)"Missing expected exception");
            }
            catch (SpannerException e) {
                Assert.assertEquals((Object)ErrorCode.CANCELLED, (Object)e.getErrorCode());
            }
            connection.rollback();
            mockSpanner.removeAllExecutionTimes();
            connection.setStatementTimeout(1000L, TimeUnit.MILLISECONDS);
            try (ResultSet rs = connection.executeQuery(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]);){
                MatcherAssert.assertThat((Object)rs, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
            }
        }
        finally {
            executor.shutdown();
        }
    }

    static void addSlowMockDdlOperation() {
        StatementTimeoutTest.addSlowMockDdlOperations(1);
    }

    static void addSlowMockDdlOperations(int count) {
        StatementTimeoutTest.addMockDdlOperations(count, false);
    }

    static void addFastMockDdlOperation() {
        StatementTimeoutTest.addFastMockDdlOperations(1);
    }

    static void addFastMockDdlOperations(int count) {
        StatementTimeoutTest.addMockDdlOperations(count, true);
    }

    static void addMockDdlOperations(int count, boolean done) {
        for (int i = 0; i < count; ++i) {
            mockDatabaseAdmin.addResponse((AbstractMessage)Operation.newBuilder().setMetadata(Any.pack((Message)UpdateDatabaseDdlMetadata.newBuilder().addStatements(SLOW_DDL).setDatabase("projects/proj/instances/inst/databases/db").build())).setName("projects/proj/instances/inst/databases/db/operations/1").setDone(done).setResponse(Any.pack((Message)Empty.getDefaultInstance())).build());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCancelDdlBatch() {
        StatementTimeoutTest.addSlowMockDdlOperation();
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(false);
            connection.startBatchDdl();
            connection.execute(Statement.of((String)SLOW_DDL));
            executor.execute(() -> {
                Uninterruptibles.sleepUninterruptibly((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
                connection.cancel();
            });
            connection.runBatch();
            Assert.fail((String)"Missing expected exception");
        }
        catch (SpannerException ex) {
            Assert.assertEquals((Object)ErrorCode.CANCELLED, (Object)ex.getErrorCode());
        }
        finally {
            executor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCancelDdlAutocommit() {
        StatementTimeoutTest.addSlowMockDdlOperation();
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            executor.execute(() -> {
                Uninterruptibles.sleepUninterruptibly((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
                connection.cancel();
            });
            connection.execute(Statement.of((String)SLOW_DDL));
            Assert.fail((String)"Missing expected exception");
        }
        catch (SpannerException ex) {
            Assert.assertEquals((Object)ErrorCode.CANCELLED, (Object)ex.getErrorCode());
        }
        finally {
            executor.shutdown();
        }
    }

    @Test
    public void testTimeoutExceptionDdlAutocommit() {
        StatementTimeoutTest.addSlowMockDdlOperations(10);
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            connection.setStatementTimeout(50L, TimeUnit.MILLISECONDS);
            connection.execute(Statement.of((String)SLOW_DDL));
            Assert.fail((String)"Missing expected exception");
        }
        catch (SpannerException ex) {
            Assert.assertEquals((Object)ErrorCode.DEADLINE_EXCEEDED, (Object)ex.getErrorCode());
        }
    }

    @Test
    public void testTimeoutExceptionDdlAutocommitMultipleStatements() {
        StatementTimeoutTest.addSlowMockDdlOperations(20);
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            connection.setStatementTimeout(50L, TimeUnit.MILLISECONDS);
            for (int i = 0; i < 2; ++i) {
                try {
                    connection.execute(Statement.of((String)SLOW_DDL));
                    Assert.fail((String)"Missing expected exception");
                    continue;
                }
                catch (SpannerException e) {
                    Assert.assertEquals((Object)ErrorCode.DEADLINE_EXCEEDED, (Object)e.getErrorCode());
                }
            }
            mockDatabaseAdmin.reset();
            StatementTimeoutTest.addFastMockDdlOperation();
            connection.setStatementTimeout(1000L, TimeUnit.MILLISECONDS);
            MatcherAssert.assertThat((Object)connection.execute(Statement.of((String)FAST_DDL)), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        }
    }

    @Test
    public void testTimeoutExceptionDdlBatch() {
        StatementTimeoutTest.addSlowMockDdlOperations(10);
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(false);
            connection.startBatchDdl();
            connection.setStatementTimeout(50L, TimeUnit.MILLISECONDS);
            connection.execute(Statement.of((String)SLOW_DDL));
            connection.runBatch();
            Assert.fail((String)"Missing expected exception");
        }
        catch (SpannerException ex) {
            Assert.assertEquals((Object)ErrorCode.DEADLINE_EXCEEDED, (Object)ex.getErrorCode());
        }
    }

    @Test
    public void testTimeoutExceptionDdlBatchMultipleStatements() {
        StatementTimeoutTest.addSlowMockDdlOperations(20);
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(false);
            connection.setStatementTimeout(50L, TimeUnit.MILLISECONDS);
            for (int i = 0; i < 2; ++i) {
                connection.startBatchDdl();
                connection.execute(Statement.of((String)SLOW_DDL));
                try {
                    connection.runBatch();
                    Assert.fail((String)"Missing expected exception");
                    continue;
                }
                catch (SpannerException e) {
                    Assert.assertEquals((Object)ErrorCode.DEADLINE_EXCEEDED, (Object)e.getErrorCode());
                }
            }
            mockDatabaseAdmin.reset();
            StatementTimeoutTest.addFastMockDdlOperation();
            connection.setStatementTimeout(1000L, TimeUnit.MILLISECONDS);
            connection.startBatchDdl();
            MatcherAssert.assertThat((Object)connection.execute(Statement.of((String)FAST_DDL)), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
            connection.runBatch();
        }
    }

    @Test
    public void testTimeoutDifferentTimeUnits() {
        mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(10000, 0));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            for (TimeUnit unit : ReadOnlyStalenessUtil.SUPPORTED_UNITS) {
                connection.setStatementTimeout(1L, unit);
                try {
                    connection.execute(SELECT_RANDOM_STATEMENT);
                    Assert.fail((String)"Missing expected exception");
                }
                catch (SpannerException e) {
                    Assert.assertEquals((Object)ErrorCode.DEADLINE_EXCEEDED, (Object)e.getErrorCode());
                }
            }
        }
    }

    private static final class ConnectionReadWriteTransactional
    implements AbstractConnectionImplTest.ConnectionConsumer {
        private ConnectionReadWriteTransactional() {
        }

        @Override
        public void accept(Connection t) {
            t.setAutocommit(false);
            t.setReadOnly(false);
        }
    }

    private static final class ConnectionReadWriteAutocommit
    implements AbstractConnectionImplTest.ConnectionConsumer {
        private ConnectionReadWriteAutocommit() {
        }

        @Override
        public void accept(Connection t) {
            t.setAutocommit(true);
            t.setReadOnly(false);
        }
    }

    private static final class ConnectionReadOnlyTransactional
    implements AbstractConnectionImplTest.ConnectionConsumer {
        private ConnectionReadOnlyTransactional() {
        }

        @Override
        public void accept(Connection t) {
            t.setReadOnly(true);
            t.setAutocommit(false);
        }
    }

    private static final class ConnectionReadOnlyAutocommit
    implements AbstractConnectionImplTest.ConnectionConsumer {
        private ConnectionReadOnlyAutocommit() {
        }

        @Override
        public void accept(Connection t) {
            t.setAutocommit(true);
            t.setReadOnly(true);
        }
    }
}

