/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection.it;

import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ParallelIntegrationTest;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.connection.ITAbstractSpannerTest;
import com.google.cloud.spanner.connection.SqlScriptVerifier;
import java.util.Arrays;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@Category(value={ParallelIntegrationTest.class})
@RunWith(value=JUnit4.class)
public class ITTransactionModeTest
extends ITAbstractSpannerTest {
    @Override
    public void appendConnectionUri(StringBuilder uri) {
        uri.append(";autocommit=false");
    }

    @Override
    public boolean doCreateDefaultTestTable() {
        return true;
    }

    @Test
    public void testSqlScript() throws Exception {
        SqlScriptVerifier verifier = new SqlScriptVerifier(new ITAbstractSpannerTest.ITConnectionProvider(this));
        verifier.verifyStatementsInFile("ITTransactionModeTest.sql", SqlScriptVerifier.class);
    }

    @Test
    public void testDoAllowBufferedWriteInReadWriteTransaction() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            MatcherAssert.assertThat((Object)connection.isAutocommit(), (Matcher)CoreMatchers.is((Object)false));
            connection.bufferedWrite(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"TEST").set("ID").to(1L)).set("NAME").to("TEST")).build());
            connection.commit();
            try (ResultSet rs = connection.executeQuery(Statement.of((String)"SELECT NAME FROM TEST WHERE ID=1"), new Options.QueryOption[0]);){
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)true));
                MatcherAssert.assertThat((Object)rs.getString("NAME"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"TEST")));
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)false));
            }
            connection.bufferedWrite(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newUpdateBuilder((String)"TEST").set("ID").to(1L)).set("NAME").to("TEST2")).build());
            connection.commit();
            rs = connection.executeQuery(Statement.of((String)"SELECT NAME FROM TEST WHERE ID=1"), new Options.QueryOption[0]);
            var4_6 = null;
            try {
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)true));
                MatcherAssert.assertThat((Object)rs.getString("NAME"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"TEST2")));
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)false));
            }
            catch (Throwable throwable) {
                var4_6 = throwable;
                throw throwable;
            }
            finally {
                if (rs != null) {
                    if (var4_6 != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable) {
                            var4_6.addSuppressed(throwable);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
            connection.bufferedWrite(Mutation.delete((String)"TEST", (Key)Key.of((Object[])new Object[]{1L})));
            connection.commit();
            rs = connection.executeQuery(Statement.of((String)"SELECT NAME FROM TEST WHERE ID=1"), new Options.QueryOption[0]);
            var4_6 = null;
            try {
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)false));
            }
            catch (Throwable throwable) {
                var4_6 = throwable;
                throw throwable;
            }
            finally {
                if (rs != null) {
                    if (var4_6 != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable) {
                            var4_6.addSuppressed(throwable);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
    }

    @Test
    public void testDoAllowBufferedWriteIterableInReadWriteTransaction() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            MatcherAssert.assertThat((Object)connection.isAutocommit(), (Matcher)CoreMatchers.is((Object)false));
            connection.bufferedWrite(Arrays.asList(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"TEST").set("ID").to(1L)).set("NAME").to("TEST-1")).build(), ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"TEST").set("ID").to(2L)).set("NAME").to("TEST-2")).build()));
            connection.commit();
            try (ResultSet rs = connection.executeQuery(Statement.of((String)"SELECT NAME FROM TEST WHERE ID IN (1,2) ORDER BY ID"), new Options.QueryOption[0]);){
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)true));
                MatcherAssert.assertThat((Object)rs.getString("NAME"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"TEST-1")));
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)true));
                MatcherAssert.assertThat((Object)rs.getString("NAME"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"TEST-2")));
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)false));
            }
            connection.bufferedWrite(Arrays.asList(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newUpdateBuilder((String)"TEST").set("ID").to(1L)).set("NAME").to("TEST-1-2")).build(), ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newUpdateBuilder((String)"TEST").set("ID").to(2L)).set("NAME").to("TEST-2-2")).build()));
            connection.commit();
            rs = connection.executeQuery(Statement.of((String)"SELECT NAME FROM TEST WHERE ID IN (1,2) ORDER BY ID"), new Options.QueryOption[0]);
            var4_6 = null;
            try {
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)true));
                MatcherAssert.assertThat((Object)rs.getString("NAME"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"TEST-1-2")));
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)true));
                MatcherAssert.assertThat((Object)rs.getString("NAME"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"TEST-2-2")));
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)false));
            }
            catch (Throwable throwable) {
                var4_6 = throwable;
                throw throwable;
            }
            finally {
                if (rs != null) {
                    if (var4_6 != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable) {
                            var4_6.addSuppressed(throwable);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
            connection.bufferedWrite(Arrays.asList(Mutation.delete((String)"TEST", (Key)Key.of((Object[])new Object[]{1L})), Mutation.delete((String)"TEST", (Key)Key.of((Object[])new Object[]{2L}))));
            connection.commit();
            rs = connection.executeQuery(Statement.of((String)"SELECT NAME FROM TEST WHERE ID IN (1,2) ORDER BY ID"), new Options.QueryOption[0]);
            var4_6 = null;
            try {
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)false));
            }
            catch (Throwable throwable) {
                var4_6 = throwable;
                throw throwable;
            }
            finally {
                if (rs != null) {
                    if (var4_6 != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable) {
                            var4_6.addSuppressed(throwable);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
    }

    @Test
    public void testDoNotAllowBufferedWriteInReadOnlyTransaction() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.execute(Statement.of((String)"SET TRANSACTION READ ONLY"));
            MatcherAssert.assertThat((Object)connection.isAutocommit(), (Matcher)CoreMatchers.is((Object)false));
            try {
                connection.bufferedWrite(((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"FOO").set("ID").to(1L)).build());
                Assert.fail((String)"Expected exception");
            }
            catch (SpannerException e) {
                Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)e.getErrorCode());
            }
        }
    }

    @Test
    public void testDoNotAllowBufferedWriteIterableInReadOnlyTransaction() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.execute(Statement.of((String)"SET TRANSACTION READ ONLY"));
            MatcherAssert.assertThat((Object)connection.isAutocommit(), (Matcher)CoreMatchers.is((Object)false));
            try {
                connection.bufferedWrite(Arrays.asList(((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"FOO").set("ID").to(1L)).build(), ((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"FOO").set("ID").to(2L)).build()));
                Assert.fail((String)"Expected exception");
            }
            catch (SpannerException ex) {
                Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)ex.getErrorCode());
            }
        }
    }

    @Test
    public void testDoNotAllowBufferedWriteInDdlBatch() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.startBatchDdl();
            MatcherAssert.assertThat((Object)connection.isAutocommit(), (Matcher)CoreMatchers.is((Object)false));
            MatcherAssert.assertThat((Object)connection.isDdlBatchActive(), (Matcher)CoreMatchers.is((Object)true));
            try {
                connection.bufferedWrite(((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"FOO").set("ID").to(1L)).build());
                Assert.fail((String)"Expected exception");
            }
            catch (SpannerException e) {
                Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)e.getErrorCode());
            }
        }
    }

    @Test
    public void testDoNotAllowBufferedWriteIterableInDdlBatch() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.startBatchDdl();
            MatcherAssert.assertThat((Object)connection.isAutocommit(), (Matcher)CoreMatchers.is((Object)false));
            MatcherAssert.assertThat((Object)connection.isDdlBatchActive(), (Matcher)CoreMatchers.is((Object)true));
            try {
                connection.bufferedWrite(Arrays.asList(((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"FOO").set("ID").to(1L)).build(), ((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"FOO").set("ID").to(2L)).build()));
                Assert.fail((String)"Expected exception");
            }
            catch (SpannerException e) {
                Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)e.getErrorCode());
            }
        }
    }
}

