/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.it;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.SettableApiFuture;
import com.google.cloud.spanner.AsyncResultSet;
import com.google.cloud.spanner.AsyncRunner;
import com.google.cloud.spanner.Database;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.IntegrationTest;
import com.google.cloud.spanner.IntegrationTestEnv;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.StructReader;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.truth.Truth;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@Category(value={IntegrationTest.class})
@RunWith(value=JUnit4.class)
public class ITAsyncExamplesTest {
    @ClassRule
    public static IntegrationTestEnv env = new IntegrationTestEnv();
    private static final String TABLE_NAME = "TestTable";
    private static final String INDEX_NAME = "TestTableByValue";
    private static final List<String> ALL_COLUMNS = Arrays.asList("Key", "StringValue");
    private static final ImmutableList<String> ALL_VALUES_IN_PK_ORDER = ImmutableList.of((Object)"v0", (Object)"v1", (Object)"v10", (Object)"v11", (Object)"v12", (Object)"v13", (Object)"v14", (Object)"v2", (Object)"v3", (Object)"v4", (Object)"v5", (Object)"v6", (Object[])new String[]{"v7", "v8", "v9"});
    private static Database db;
    private static DatabaseClient client;
    private static ExecutorService executor;

    @BeforeClass
    public static void setUpDatabase() {
        db = env.getTestHelper().createTestDatabase(new String[]{"CREATE TABLE TestTable (  Key                STRING(MAX) NOT NULL,  StringValue        STRING(MAX),) PRIMARY KEY (Key)", "CREATE INDEX TestTableByValue ON TestTable(StringValue)", "CREATE INDEX TestTableByValueDesc ON TestTable(StringValue DESC)"});
        client = env.getTestHelper().getDatabaseClient(db);
        ArrayList<Mutation> mutations = new ArrayList<Mutation>();
        for (int i = 0; i < 15; ++i) {
            mutations.add(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)TABLE_NAME).set("Key").to("k" + i)).set("StringValue").to("v" + i)).build());
        }
        client.write(mutations);
        executor = Executors.newScheduledThreadPool(8);
    }

    @AfterClass
    public static void cleanup() {
        executor.shutdown();
    }

    @Test
    public void readAsync() throws Exception {
        final SettableApiFuture future = SettableApiFuture.create();
        try (AsyncResultSet rs = client.singleUse().readAsync(TABLE_NAME, KeySet.all(), ALL_COLUMNS, new Options.ReadOption[0]);){
            rs.setCallback((Executor)executor, new AsyncResultSet.ReadyCallback(){
                final List<String> values = new LinkedList<String>();

                public AsyncResultSet.CallbackResponse cursorReady(AsyncResultSet resultSet) {
                    try {
                        while (true) {
                            switch (resultSet.tryNext()) {
                                case DONE: {
                                    future.set(this.values);
                                    return AsyncResultSet.CallbackResponse.DONE;
                                }
                                case NOT_READY: {
                                    return AsyncResultSet.CallbackResponse.CONTINUE;
                                }
                                case OK: {
                                    this.values.add(resultSet.getString("StringValue"));
                                }
                            }
                        }
                    }
                    catch (Throwable t) {
                        future.setException(t);
                        return AsyncResultSet.CallbackResponse.DONE;
                    }
                }
            });
        }
        Truth.assertThat((Iterable)((Iterable)future.get())).containsExactlyElementsIn(ALL_VALUES_IN_PK_ORDER);
    }

    @Test
    public void readUsingIndexAsync() throws Exception {
        final SettableApiFuture future = SettableApiFuture.create();
        try (AsyncResultSet rs = client.singleUse().readUsingIndexAsync(TABLE_NAME, INDEX_NAME, KeySet.all(), ALL_COLUMNS, new Options.ReadOption[0]);){
            rs.setCallback((Executor)executor, new AsyncResultSet.ReadyCallback(){
                final List<String> values = new LinkedList<String>();

                public AsyncResultSet.CallbackResponse cursorReady(AsyncResultSet resultSet) {
                    try {
                        while (true) {
                            switch (resultSet.tryNext()) {
                                case DONE: {
                                    future.set(this.values);
                                    return AsyncResultSet.CallbackResponse.DONE;
                                }
                                case NOT_READY: {
                                    return AsyncResultSet.CallbackResponse.CONTINUE;
                                }
                                case OK: {
                                    this.values.add(resultSet.getString("StringValue"));
                                }
                            }
                        }
                    }
                    catch (Throwable t) {
                        future.setException(t);
                        return AsyncResultSet.CallbackResponse.DONE;
                    }
                }
            });
        }
        Truth.assertThat((Iterable)((Iterable)future.get())).containsExactlyElementsIn(ALL_VALUES_IN_PK_ORDER);
    }

    @Test
    public void readRowAsync() throws Exception {
        ApiFuture row = client.singleUse().readRowAsync(TABLE_NAME, Key.of((Object[])new Object[]{"k1"}), ALL_COLUMNS);
        Truth.assertThat((String)((Struct)row.get()).getString("StringValue")).isEqualTo((Object)"v1");
    }

    @Test
    public void readRowUsingIndexAsync() throws Exception {
        ApiFuture row = client.singleUse().readRowUsingIndexAsync(TABLE_NAME, INDEX_NAME, Key.of((Object[])new Object[]{"v2"}), ALL_COLUMNS);
        Truth.assertThat((String)((Struct)row.get()).getString("Key")).isEqualTo((Object)"k2");
    }

    @Test
    public void executeQueryAsync() throws Exception {
        ImmutableList keys = ImmutableList.of((Object)"k3", (Object)"k4");
        final SettableApiFuture future = SettableApiFuture.create();
        try (AsyncResultSet rs = client.singleUse().executeQueryAsync(((Statement.Builder)Statement.newBuilder((String)"SELECT StringValue FROM TestTable WHERE Key IN UNNEST(@keys)").bind("keys").toStringArray((Iterable)keys)).build(), new Options.QueryOption[0]);){
            rs.setCallback((Executor)executor, new AsyncResultSet.ReadyCallback(){
                final List<String> values = new LinkedList<String>();

                public AsyncResultSet.CallbackResponse cursorReady(AsyncResultSet resultSet) {
                    try {
                        while (true) {
                            switch (resultSet.tryNext()) {
                                case DONE: {
                                    future.set(this.values);
                                    return AsyncResultSet.CallbackResponse.DONE;
                                }
                                case NOT_READY: {
                                    return AsyncResultSet.CallbackResponse.CONTINUE;
                                }
                                case OK: {
                                    this.values.add(resultSet.getString("StringValue"));
                                }
                            }
                        }
                    }
                    catch (Throwable t) {
                        future.setException(t);
                        return AsyncResultSet.CallbackResponse.DONE;
                    }
                }
            });
        }
        Truth.assertThat((Iterable)((Iterable)future.get())).containsExactly(new Object[]{"v3", "v4"});
    }

    @Test
    public void runAsync() throws Exception {
        AsyncRunner runner = client.runAsync(new Options.TransactionOption[0]);
        ApiFuture insertCount = runner.runAsync(txn -> txn.executeUpdateAsync(((Statement.Builder)((Statement.Builder)Statement.newBuilder((String)"INSERT INTO TestTable (Key, StringValue) VALUES (@key, @value)").bind("key").to("k999")).bind("value").to("v999")).build(), new Options.UpdateOption[0]), (Executor)executor);
        Truth.assertThat((Long)((Long)insertCount.get())).isEqualTo((Object)1L);
        ApiFuture deleteCount = runner.runAsync(txn -> txn.executeUpdateAsync(((Statement.Builder)Statement.newBuilder((String)"DELETE FROM TestTable WHERE Key=@key").bind("key").to("k999")).build(), new Options.UpdateOption[0]), (Executor)executor);
        Truth.assertThat((Long)((Long)deleteCount.get())).isEqualTo((Object)1L);
    }

    @Test
    public void runAsyncBatchUpdate() throws Exception {
        AsyncRunner runner = client.runAsync(new Options.TransactionOption[0]);
        ApiFuture insertCount = runner.runAsync(txn -> txn.batchUpdateAsync((Iterable)ImmutableList.of((Object)((Statement.Builder)((Statement.Builder)Statement.newBuilder((String)"INSERT INTO TestTable (Key, StringValue) VALUES (@key, @value)").bind("key").to("k997")).bind("value").to("v997")).build(), (Object)((Statement.Builder)((Statement.Builder)Statement.newBuilder((String)"INSERT INTO TestTable (Key, StringValue) VALUES (@key, @value)").bind("key").to("k998")).bind("value").to("v998")).build(), (Object)((Statement.Builder)((Statement.Builder)Statement.newBuilder((String)"INSERT INTO TestTable (Key, StringValue) VALUES (@key, @value)").bind("key").to("k999")).bind("value").to("v999")).build()), new Options.UpdateOption[0]), (Executor)executor);
        Truth.assertThat((long[])((long[])insertCount.get())).asList().containsExactly(new Object[]{1L, 1L, 1L});
        ApiFuture deleteCount = runner.runAsync(txn -> txn.batchUpdateAsync((Iterable)ImmutableList.of((Object)((Statement.Builder)Statement.newBuilder((String)"DELETE FROM TestTable WHERE Key=@key").bind("key").to("k997")).build(), (Object)((Statement.Builder)Statement.newBuilder((String)"DELETE FROM TestTable WHERE Key=@key").bind("key").to("k998")).build(), (Object)((Statement.Builder)Statement.newBuilder((String)"DELETE FROM TestTable WHERE Key=@key").bind("key").to("k999")).build()), new Options.UpdateOption[0]), (Executor)executor);
        Truth.assertThat((long[])((long[])deleteCount.get())).asList().containsExactly(new Object[]{1L, 1L, 1L});
    }

    @Test
    public void readOnlyTransaction() throws Exception {
        ApiFuture values2;
        ApiFuture values1;
        ImmutableList keys1 = ImmutableList.of((Object)"k10", (Object)"k11", (Object)"k12");
        ImmutableList keys2 = ImmutableList.of((Object)"k1", (Object)"k2", (Object)"k3");
        try (ReadOnlyTransaction tx = client.readOnlyTransaction();){
            try (AsyncResultSet rs = tx.executeQueryAsync(((Statement.Builder)Statement.newBuilder((String)"SELECT * FROM TestTable WHERE Key IN UNNEST(@keys)").bind("keys").toStringArray((Iterable)keys1)).build(), new Options.QueryOption[0]);){
                values1 = rs.toListAsync((Function)new Function<StructReader, String>(){

                    public String apply(StructReader input) {
                        return input.getString("StringValue");
                    }
                }, (Executor)executor);
            }
            rs = tx.executeQueryAsync(((Statement.Builder)Statement.newBuilder((String)"SELECT * FROM TestTable WHERE Key IN UNNEST(@keys)").bind("keys").toStringArray((Iterable)keys2)).build(), new Options.QueryOption[0]);
            var8_8 = null;
            try {
                values2 = rs.toListAsync((Function)new Function<StructReader, String>(){

                    public String apply(StructReader input) {
                        return input.getString("StringValue");
                    }
                }, (Executor)executor);
            }
            catch (Throwable throwable) {
                var8_8 = throwable;
                throw throwable;
            }
            finally {
                if (rs != null) {
                    if (var8_8 != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable) {
                            var8_8.addSuppressed(throwable);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
        ApiFuture allValues = ApiFutures.transform((ApiFuture)ApiFutures.allAsList(Arrays.asList(values1, values2)), (ApiFunction)new ApiFunction<List<List<String>>, Iterable<String>>(){

            public Iterable<String> apply(List<List<String>> input) {
                return Iterables.mergeSorted(input, (Comparator)new Comparator<String>(){

                    @Override
                    public int compare(String o1, String o2) {
                        return Integer.valueOf(o1.substring(1)).compareTo(Integer.valueOf(o2.substring(1)));
                    }
                });
            }
        }, (Executor)executor);
        Truth.assertThat((Iterable)((Iterable)allValues.get())).containsExactly(new Object[]{"v1", "v2", "v3", "v10", "v11", "v12"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void pauseResume() throws Exception {
        Statement unevenStatement = Statement.of((String)"SELECT * FROM TestTable WHERE MOD(CAST(SUBSTR(Key, 2) AS INT64), 2) = 1 ORDER BY CAST(SUBSTR(Key, 2) AS INT64)");
        Statement evenStatement = Statement.of((String)"SELECT * FROM TestTable WHERE MOD(CAST(SUBSTR(Key, 2) AS INT64), 2) = 0 ORDER BY CAST(SUBSTR(Key, 2) AS INT64)");
        final Object lock = new Object();
        final SettableApiFuture evenFinished = SettableApiFuture.create();
        final SettableApiFuture unevenFinished = SettableApiFuture.create();
        final CountDownLatch evenReturnedFirstRow = new CountDownLatch(1);
        final LinkedList allValues = new LinkedList();
        try (ReadOnlyTransaction tx = client.readOnlyTransaction();
             AsyncResultSet evenRs = tx.executeQueryAsync(evenStatement, new Options.QueryOption[0]);
             AsyncResultSet unevenRs = tx.executeQueryAsync(unevenStatement, new Options.QueryOption[0]);){
            evenRs.setCallback((Executor)executor, new AsyncResultSet.ReadyCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public AsyncResultSet.CallbackResponse cursorReady(AsyncResultSet resultSet) {
                    try {
                        while (true) {
                            switch (resultSet.tryNext()) {
                                case DONE: {
                                    evenFinished.set((Object)true);
                                    return AsyncResultSet.CallbackResponse.DONE;
                                }
                                case NOT_READY: {
                                    return AsyncResultSet.CallbackResponse.CONTINUE;
                                }
                                case OK: {
                                    Object object = lock;
                                    synchronized (object) {
                                        allValues.add(resultSet.getString("StringValue"));
                                    }
                                    evenReturnedFirstRow.countDown();
                                    return AsyncResultSet.CallbackResponse.PAUSE;
                                }
                            }
                        }
                    }
                    catch (Throwable t) {
                        evenFinished.setException(t);
                        return AsyncResultSet.CallbackResponse.DONE;
                    }
                }
            });
            unevenRs.setCallback((Executor)executor, new AsyncResultSet.ReadyCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public AsyncResultSet.CallbackResponse cursorReady(AsyncResultSet resultSet) {
                    try {
                        evenReturnedFirstRow.await();
                        while (true) {
                            switch (resultSet.tryNext()) {
                                case DONE: {
                                    unevenFinished.set((Object)true);
                                    return AsyncResultSet.CallbackResponse.DONE;
                                }
                                case NOT_READY: {
                                    return AsyncResultSet.CallbackResponse.CONTINUE;
                                }
                                case OK: {
                                    Object object = lock;
                                    synchronized (object) {
                                        allValues.add(resultSet.getString("StringValue"));
                                    }
                                    return AsyncResultSet.CallbackResponse.PAUSE;
                                }
                            }
                        }
                    }
                    catch (Throwable t) {
                        unevenFinished.setException(t);
                        return AsyncResultSet.CallbackResponse.DONE;
                    }
                }
            });
            while (!evenFinished.isDone() || !unevenFinished.isDone()) {
                Object object = lock;
                synchronized (object) {
                    if (allValues.peekLast() != null) {
                        if (Integer.parseInt(((String)allValues.peekLast()).substring(1)) % 2 == 1) {
                            evenRs.resume();
                        } else {
                            unevenRs.resume();
                        }
                    }
                    if (allValues.size() == 15) {
                        unevenRs.resume();
                        evenRs.resume();
                    }
                }
            }
        }
        Truth.assertThat((Iterable)((Iterable)ApiFutures.allAsList(Arrays.asList(evenFinished, unevenFinished)).get())).containsExactly(new Object[]{Boolean.TRUE, Boolean.TRUE});
        Truth.assertThat(allValues).containsExactly(new Object[]{"v0", "v1", "v2", "v3", "v4", "v5", "v6", "v7", "v8", "v9", "v10", "v11", "v12", "v13", "v14"});
    }

    @Test
    public void cancel() throws Exception {
        final LinkedList values = new LinkedList();
        final SettableApiFuture finished = SettableApiFuture.create();
        final CountDownLatch receivedFirstRow = new CountDownLatch(1);
        final CountDownLatch cancelled = new CountDownLatch(1);
        try (AsyncResultSet rs = client.singleUse().readAsync(TABLE_NAME, KeySet.all(), ALL_COLUMNS, new Options.ReadOption[0]);){
            rs.setCallback((Executor)executor, new AsyncResultSet.ReadyCallback(){

                public AsyncResultSet.CallbackResponse cursorReady(AsyncResultSet resultSet) {
                    try {
                        while (true) {
                            switch (resultSet.tryNext()) {
                                case DONE: {
                                    finished.set((Object)true);
                                    return AsyncResultSet.CallbackResponse.DONE;
                                }
                                case NOT_READY: {
                                    return AsyncResultSet.CallbackResponse.CONTINUE;
                                }
                                case OK: {
                                    values.add(resultSet.getString("StringValue"));
                                    receivedFirstRow.countDown();
                                    cancelled.await();
                                }
                            }
                        }
                    }
                    catch (Throwable t) {
                        finished.setException(t);
                        return AsyncResultSet.CallbackResponse.DONE;
                    }
                }
            });
            receivedFirstRow.await();
            rs.cancel();
        }
        cancelled.countDown();
        try {
            finished.get();
            Assert.fail((String)"missing expected exception");
        }
        catch (ExecutionException e) {
            Truth.assertThat((Throwable)e.getCause()).isInstanceOf(SpannerException.class);
            SpannerException se = (SpannerException)e.getCause();
            Truth.assertThat((Comparable)se.getErrorCode()).isEqualTo((Object)ErrorCode.CANCELLED);
            Truth.assertThat(values).containsExactly(new Object[]{"v0"});
        }
    }
}

