/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.it;

import com.google.api.gax.longrunning.OperationFuture;
import com.google.cloud.spanner.Database;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.IntegrationTestEnv;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ParallelIntegrationTest;
import com.google.cloud.spanner.SpannerBatchUpdateException;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TransactionRunner;
import com.google.common.truth.Truth;
import java.util.ArrayList;
import java.util.Arrays;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@Category(value={ParallelIntegrationTest.class})
@RunWith(value=JUnit4.class)
public final class ITBatchDmlTest {
    private static Database db;
    @ClassRule
    public static IntegrationTestEnv env;
    private static final String INSERT_DML = "INSERT INTO T (k, v) VALUES ('boo1', 1), ('boo2', 2), ('boo3', 3), ('boo4', 4);";
    private static final String UPDATE_DML = "UPDATE T SET T.V = 100 WHERE T.K LIKE 'boo%';";
    private static final String DELETE_DML = "DELETE FROM T WHERE T.K like 'boo%';";
    private static DatabaseClient client;

    @BeforeClass
    public static void createDatabase() {
        db = env.getTestHelper().createTestDatabase(new String[0]);
        client = env.getTestHelper().getDatabaseClient(db);
    }

    @Before
    public void createTable() throws Exception {
        String ddl = "CREATE TABLE T (  K    STRING(MAX) NOT NULL,  V    INT64,) PRIMARY KEY (K)";
        OperationFuture op = db.updateDdl(Arrays.asList(ddl), null);
        op.get();
    }

    @After
    public void dropTable() throws Exception {
        String ddl = "DROP TABLE T";
        OperationFuture op = db.updateDdl(Arrays.asList(ddl), null);
        op.get();
    }

    @Test
    public void noStatementsInRequest() {
        TransactionRunner.TransactionCallable callable = transaction -> {
            long[] rowCounts;
            ArrayList stmts = new ArrayList();
            try {
                rowCounts = transaction.batchUpdate(stmts, new Options.UpdateOption[0]);
                Assert.fail((String)"Expecting an exception.");
            }
            catch (SpannerException e) {
                Truth.assertThat((Boolean)(e instanceof SpannerBatchUpdateException)).isFalse();
                Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.INVALID_ARGUMENT);
                rowCounts = new long[]{};
            }
            return rowCounts;
        };
        TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[0]);
        long[] rowCounts = (long[])runner.run(callable);
        Truth.assertThat((Integer)rowCounts.length).isEqualTo((Object)0);
    }

    @Test
    public void batchDml() {
        TransactionRunner.TransactionCallable callable = transaction -> {
            ArrayList<Statement> stmts = new ArrayList<Statement>();
            stmts.add(Statement.of((String)INSERT_DML));
            stmts.add(Statement.of((String)UPDATE_DML));
            stmts.add(Statement.of((String)DELETE_DML));
            return transaction.batchUpdate(stmts, new Options.UpdateOption[0]);
        };
        TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[0]);
        long[] rowCounts = (long[])runner.run(callable);
        Truth.assertThat((Integer)rowCounts.length).isEqualTo((Object)3);
        for (long rc : rowCounts) {
            Truth.assertThat((Long)rc).isEqualTo((Object)4);
        }
    }

    @Test
    public void mixedBatchDmlAndDml() {
        TransactionRunner.TransactionCallable callable = transaction -> {
            long rowCount = transaction.executeUpdate(Statement.of((String)INSERT_DML), new Options.UpdateOption[0]);
            ArrayList<Statement> stmts = new ArrayList<Statement>();
            stmts.add(Statement.of((String)UPDATE_DML));
            stmts.add(Statement.of((String)DELETE_DML));
            long[] batchRowCounts = transaction.batchUpdate(stmts, new Options.UpdateOption[0]);
            long[] rowCounts = new long[batchRowCounts.length + 1];
            System.arraycopy(batchRowCounts, 0, rowCounts, 0, batchRowCounts.length);
            rowCounts[batchRowCounts.length] = rowCount;
            return rowCounts;
        };
        TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[0]);
        long[] rowCounts = (long[])runner.run(callable);
        Truth.assertThat((Integer)rowCounts.length).isEqualTo((Object)3);
        for (long rc : rowCounts) {
            Truth.assertThat((Long)rc).isEqualTo((Object)4);
        }
    }

    @Test
    public void errorBatchDmlIllegalStatement() {
        TransactionRunner.TransactionCallable callable = transaction -> {
            ArrayList<Statement> stmts = new ArrayList<Statement>();
            stmts.add(Statement.of((String)INSERT_DML));
            stmts.add(Statement.of((String)"some illegal statement"));
            stmts.add(Statement.of((String)UPDATE_DML));
            return transaction.batchUpdate(stmts, new Options.UpdateOption[0]);
        };
        TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[0]);
        try {
            runner.run(callable);
            Assert.fail((String)"Expecting an exception.");
        }
        catch (SpannerBatchUpdateException e) {
            Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.INVALID_ARGUMENT);
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"is not valid DML.");
            long[] rowCounts = e.getUpdateCounts();
            Truth.assertThat((Integer)rowCounts.length).isEqualTo((Object)1);
            for (long rc : rowCounts) {
                Truth.assertThat((Long)rc).isEqualTo((Object)4);
            }
        }
    }

    @Test
    public void errorBatchDmlAlreadyExist() {
        TransactionRunner.TransactionCallable callable = transaction -> {
            ArrayList<Statement> stmts = new ArrayList<Statement>();
            stmts.add(Statement.of((String)INSERT_DML));
            stmts.add(Statement.of((String)INSERT_DML));
            stmts.add(Statement.of((String)UPDATE_DML));
            return transaction.batchUpdate(stmts, new Options.UpdateOption[0]);
        };
        TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[0]);
        try {
            runner.run(callable);
            Assert.fail((String)"Expecting an exception.");
        }
        catch (SpannerBatchUpdateException e) {
            Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.ALREADY_EXISTS);
            long[] rowCounts = e.getUpdateCounts();
            Truth.assertThat((Integer)rowCounts.length).isEqualTo((Object)1);
            for (long rc : rowCounts) {
                Truth.assertThat((Long)rc).isEqualTo((Object)4);
            }
        }
    }

    static {
        env = new IntegrationTestEnv();
    }
}

