/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.it;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Database;
import com.google.cloud.spanner.DatabaseAdminClient;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.IntegrationTestEnv;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.ParallelIntegrationTest;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.Value;
import com.google.cloud.spanner.connection.ConnectionOptions;
import com.google.cloud.spanner.testing.RemoteSpannerHelper;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.threeten.bp.Duration;
import org.threeten.bp.Instant;
import org.threeten.bp.temporal.TemporalAmount;

@Category(value={ParallelIntegrationTest.class})
@RunWith(value=JUnit4.class)
public class ITCommitTimestampTest {
    @ClassRule
    public static IntegrationTestEnv env = new IntegrationTestEnv();
    private static Database db;
    private static DatabaseClient client;
    private static DatabaseAdminClient dbAdminClient;
    private static RemoteSpannerHelper testHelper;
    private static String instanceId;
    private static String databaseId;

    @BeforeClass
    public static void setUp() {
        testHelper = env.getTestHelper();
        db = testHelper.createTestDatabase(new String[]{"CREATE TABLE T (K  STRING(MAX) NOT NULL,T1   TIMESTAMP OPTIONS (allow_commit_timestamp = true),T2   TIMESTAMP OPTIONS (allow_commit_timestamp = true),T3   TIMESTAMP,) PRIMARY KEY (K)"});
        client = testHelper.getDatabaseClient(db);
        dbAdminClient = testHelper.getClient().getDatabaseAdminClient();
        instanceId = testHelper.getInstanceId().getInstance();
        databaseId = db.getId().getDatabase();
    }

    @AfterClass
    public static void teardown() {
        ConnectionOptions.closeSpanner();
    }

    @After
    public void deleteAllTestRecords() {
        client.write((Iterable)ImmutableList.of((Object)Mutation.delete((String)"T", (KeySet)KeySet.all())));
    }

    private Timestamp write(Mutation m) {
        return client.write(Arrays.asList(m));
    }

    private Struct readRow(DatabaseClient client, String table, Key key, String ... columns) {
        return client.singleUse(TimestampBound.strong()).readRow(table, key, Arrays.asList(columns));
    }

    @Test
    public void writeCommitTimestamp() {
        Timestamp commitTimestamp = this.write(((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"T").set("K").to("a")).set("T1").to(Value.COMMIT_TIMESTAMP)).set("T2").to(Value.COMMIT_TIMESTAMP)).build());
        Struct row = this.readRow(client, "T", Key.of((Object[])new Object[]{"a"}), "T1", "T2");
        Truth.assertThat((Comparable)row.getTimestamp(0)).isEqualTo((Object)commitTimestamp);
        Truth.assertThat((Comparable)row.getTimestamp(1)).isEqualTo((Object)commitTimestamp);
        try {
            this.write(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"T").set("K").to("a")).set("T3").to(Value.COMMIT_TIMESTAMP)).build());
            Assert.fail((String)"missing expected exception");
        }
        catch (SpannerException e) {
            Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.FAILED_PRECONDITION);
        }
    }

    @Test
    public void consistency() {
        this.write(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"T").set("K").to("a")).set("T1").to(Value.COMMIT_TIMESTAMP)).build());
        this.write(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"T").set("K").to("b")).set("T1").to(Value.COMMIT_TIMESTAMP)).build());
        Struct row1 = this.readRow(client, "T", Key.of((Object[])new Object[]{"a"}), "T1");
        Struct row2 = this.readRow(client, "T", Key.of((Object[])new Object[]{"b"}), "T1");
        Truth.assertThat((Comparable)row2.getTimestamp(0)).isGreaterThan((Comparable)row1.getTimestamp(0));
    }

    @Test
    public void schemaChangeTimestampInFuture() throws Exception {
        this.write(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"T").set("K").to("a")).set("T3").to(Timestamp.MAX_VALUE)).build());
        String statement = "ALTER TABLE T ALTER COLUMN T3 SET OPTIONS (allow_commit_timestamp=true)";
        try {
            dbAdminClient.updateDatabaseDdl(instanceId, databaseId, (Iterable)ImmutableList.of((Object)statement), null).get();
            Assert.fail((String)"missing expected exception");
        }
        catch (ExecutionException e) {
            Truth.assertThat((Throwable)e.getCause()).isInstanceOf(SpannerException.class);
            SpannerException se = (SpannerException)e.getCause();
            Truth.assertThat((Comparable)se.getErrorCode()).isEqualTo((Object)ErrorCode.FAILED_PRECONDITION);
        }
    }

    @Test
    public void insertTimestampInFuture() {
        try {
            this.write(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"T").set("K").to("a")).set("T1").to(Timestamp.MAX_VALUE)).build());
            Assert.fail((String)"missing expected exception");
        }
        catch (SpannerException e) {
            Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.FAILED_PRECONDITION);
        }
    }

    @Test
    public void invalidColumnOption() throws Exception {
        String statement = "ALTER TABLE T ALTER COLUMN T3 SET OPTIONS (bogus=null)";
        try {
            dbAdminClient.updateDatabaseDdl(instanceId, databaseId, (Iterable)ImmutableList.of((Object)statement), null).get();
            Assert.fail((String)"missing expected exception");
        }
        catch (ExecutionException e) {
            Truth.assertThat((Throwable)e.getCause()).isInstanceOf(SpannerException.class);
            SpannerException se = (SpannerException)e.getCause();
            Truth.assertThat((Comparable)se.getErrorCode()).isEqualTo((Object)ErrorCode.INVALID_ARGUMENT);
        }
    }

    @Test
    public void invalidColumnOptionValue() throws Exception {
        String statement = "ALTER TABLE T ALTER COLUMN T3 SET OPTIONS (allow_commit_timestamp=bogus)";
        try {
            dbAdminClient.updateDatabaseDdl(instanceId, databaseId, (Iterable)ImmutableList.of((Object)statement), null).get();
            Assert.fail((String)"missing expected exception");
        }
        catch (ExecutionException e) {
            Truth.assertThat((Throwable)e.getCause()).isInstanceOf(SpannerException.class);
            SpannerException se = (SpannerException)e.getCause();
            Truth.assertThat((Comparable)se.getErrorCode()).isEqualTo((Object)ErrorCode.INVALID_ARGUMENT);
        }
    }

    @Test
    public void invalidColumnType() throws Exception {
        String statement = "ALTER TABLE T ADD COLUMN T4 INT64 OPTIONS (allow_commit_timestamp=true)";
        try {
            dbAdminClient.updateDatabaseDdl(instanceId, databaseId, (Iterable)ImmutableList.of((Object)statement), null).get();
            Assert.fail((String)"missing expected exception");
        }
        catch (ExecutionException e) {
            Truth.assertThat((Throwable)e.getCause()).isInstanceOf(SpannerException.class);
            SpannerException se = (SpannerException)e.getCause();
            Truth.assertThat((Comparable)se.getErrorCode()).isEqualTo((Object)ErrorCode.FAILED_PRECONDITION);
        }
    }

    private void alterColumnOption(String databaseId, String table, String opt) throws Exception {
        String statement = "ALTER TABLE " + table + " ALTER COLUMN ts SET OPTIONS (allow_commit_timestamp=" + opt + ")";
        dbAdminClient.updateDatabaseDdl(instanceId, databaseId, (Iterable)ImmutableList.of((Object)statement), null).get();
    }

    private void writeAndVerify(DatabaseClient client, Timestamp ts) {
        Timestamp commitTimestamp = client.write(Arrays.asList(((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"T1").set("ts").to(ts)).build(), ((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"T2").set("ts").to(ts)).build(), ((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"T3").set("ts").to(ts)).build()));
        if (ts == Value.COMMIT_TIMESTAMP) {
            ts = commitTimestamp;
        }
        Truth.assertThat((Comparable)this.readRow(client, "T1", Key.of((Object[])new Object[]{ts}), "ts").getTimestamp(0)).isEqualTo((Object)ts);
        Truth.assertThat((Comparable)this.readRow(client, "T2", Key.of((Object[])new Object[]{ts}), "ts").getTimestamp(0)).isEqualTo((Object)ts);
        Truth.assertThat((Comparable)this.readRow(client, "T3", Key.of((Object[])new Object[]{ts}), "ts").getTimestamp(0)).isEqualTo((Object)ts);
    }

    @Test
    public void interleavedTable() throws Exception {
        Database db = testHelper.createTestDatabase(new String[]{"CREATE TABLE T1 (ts TIMESTAMP) PRIMARY KEY (ts)", "CREATE TABLE T2 (ts TIMESTAMP) PRIMARY KEY (ts), INTERLEAVE IN PARENT T1", "CREATE TABLE T3 (ts TIMESTAMP) PRIMARY KEY (ts), INTERLEAVE IN PARENT T2"});
        DatabaseClient client = testHelper.getDatabaseClient(db);
        String databaseId = db.getId().getDatabase();
        Timestamp timeNow = Timestamp.ofTimeMicroseconds((long)(Instant.now().toEpochMilli() * 1000L));
        Timestamp timeFuture = Timestamp.ofTimeMicroseconds((long)(Instant.now().plus((TemporalAmount)Duration.ofDays((long)300L)).toEpochMilli() * 1000L));
        this.writeAndVerify(client, timeNow);
        this.alterColumnOption(databaseId, "T1", "true");
        this.alterColumnOption(databaseId, "T2", "true");
        this.alterColumnOption(databaseId, "T3", "true");
        this.writeAndVerify(client, Value.COMMIT_TIMESTAMP);
        this.alterColumnOption(databaseId, "T1", "null");
        this.alterColumnOption(databaseId, "T2", "null");
        this.alterColumnOption(databaseId, "T3", "null");
        this.writeAndVerify(client, timeFuture);
    }

    @Test
    public void interleavedTableHierarchy1() {
        Database db = testHelper.createTestDatabase(new String[]{"CREATE TABLE T1 (ts TIMESTAMP) PRIMARY KEY (ts)", "CREATE TABLE T2 (ts TIMESTAMP) PRIMARY KEY (ts), INTERLEAVE IN PARENT T1", "CREATE TABLE T3 (ts TIMESTAMP OPTIONS (allow_commit_timestamp = true)) PRIMARY KEY (ts), INTERLEAVE IN PARENT T2"});
        DatabaseClient client = testHelper.getDatabaseClient(db);
        try {
            client.write(Arrays.asList(((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"T3").set("ts").to(Value.COMMIT_TIMESTAMP)).build()));
            Assert.fail((String)"missing expected exception");
        }
        catch (SpannerException e) {
            Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.FAILED_PRECONDITION);
        }
    }

    @Test
    public void interleavedTableHierarchy2() {
        Database db = testHelper.createTestDatabase(new String[]{"CREATE TABLE T1 (ts TIMESTAMP OPTIONS (allow_commit_timestamp = true)) PRIMARY KEY (ts)", "CREATE TABLE T2 (ts TIMESTAMP) PRIMARY KEY (ts), INTERLEAVE IN PARENT T1", "CREATE TABLE T3 (ts TIMESTAMP OPTIONS (allow_commit_timestamp = true)) PRIMARY KEY (ts), INTERLEAVE IN PARENT T2"});
        DatabaseClient client = testHelper.getDatabaseClient(db);
        try {
            client.write(Arrays.asList(((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"T1").set("ts").to(Value.COMMIT_TIMESTAMP)).build()));
            Assert.fail((String)"missing expected exception");
        }
        catch (SpannerException e) {
            Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.FAILED_PRECONDITION);
        }
    }
}

