/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.it;

import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.Page;
import com.google.cloud.spanner.Database;
import com.google.cloud.spanner.DatabaseAdminClient;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.IntegrationTestEnv;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ParallelIntegrationTest;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.testing.EmulatorSpannerHelper;
import com.google.cloud.spanner.testing.RemoteSpannerHelper;
import com.google.common.truth.Truth;
import com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.threeten.bp.Duration;

@Category(value={ParallelIntegrationTest.class})
@RunWith(value=JUnit4.class)
public class ITPitrUpdateDatabaseTest {
    private static final Duration OPERATION_TIMEOUT = Duration.ofMinutes((long)2L);
    private static final String VERSION_RETENTION_PERIOD = "7d";
    @ClassRule
    public static IntegrationTestEnv env = new IntegrationTestEnv();
    private static DatabaseAdminClient dbAdminClient;
    private static DatabaseClient dbClient;
    private static String instanceId;
    private static String databaseId;
    private static UpdateDatabaseDdlMetadata metadata;

    @BeforeClass
    public static void setUp() throws Exception {
        Assume.assumeFalse((String)"PITR-lite features are not supported by the emulator", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        RemoteSpannerHelper testHelper = env.getTestHelper();
        String projectId = testHelper.getOptions().getProjectId();
        instanceId = testHelper.getInstanceId().getInstance();
        databaseId = testHelper.getUniqueDatabaseId();
        dbAdminClient = testHelper.getClient().getDatabaseAdminClient();
        ITPitrUpdateDatabaseTest.createDatabase(dbAdminClient, instanceId, databaseId, Collections.emptyList());
        metadata = ITPitrUpdateDatabaseTest.updateVersionRetentionPeriod(dbAdminClient, instanceId, databaseId, VERSION_RETENTION_PERIOD);
        dbClient = testHelper.getClient().getDatabaseClient(DatabaseId.of((String)projectId, (String)instanceId, (String)databaseId));
    }

    @AfterClass
    public static void tearDown() {
        if (!EmulatorSpannerHelper.isUsingEmulator()) {
            dbAdminClient.dropDatabase(instanceId, databaseId);
        }
    }

    @Test
    public void checksThatTheOperationWasNotThrottled() {
        Truth.assertThat((Boolean)metadata.getThrottled()).isFalse();
    }

    @Test
    public void returnsTheVersionRetentionPeriodSetThroughGetDatabase() {
        Database database = dbAdminClient.getDatabase(instanceId, databaseId);
        Truth.assertThat((String)database.getVersionRetentionPeriod()).isEqualTo((Object)VERSION_RETENTION_PERIOD);
        Truth.assertThat((Comparable)database.getEarliestVersionTime()).isNotNull();
    }

    @Test
    public void returnsTheVersionRetentionPeriodSetThroughListDatabases() {
        Page page = dbAdminClient.listDatabases(instanceId, new Options.ListOption[0]);
        for (Database database : page.iterateAll()) {
            if (!database.getId().getDatabase().equals(databaseId)) continue;
            Truth.assertThat((String)database.getVersionRetentionPeriod()).isEqualTo((Object)VERSION_RETENTION_PERIOD);
            Truth.assertThat((Comparable)database.getEarliestVersionTime()).isNotNull();
        }
    }

    @Test
    public void returnsTheVersionRetentionPeriodSetThroughGetDatabaseDdl() {
        String ddl;
        List ddls = dbAdminClient.getDatabaseDdl(instanceId, databaseId);
        boolean hasVersionRetentionPeriodStatement = false;
        Iterator iterator = ddls.iterator();
        while (iterator.hasNext() && !(hasVersionRetentionPeriodStatement = (ddl = (String)iterator.next()).contains("version_retention_period = '7d'"))) {
        }
        Truth.assertThat((Boolean)hasVersionRetentionPeriodStatement).isTrue();
    }

    @Test
    public void returnsTheVersionRetentionPeriodSetThroughInformationSchema() {
        try (ResultSet rs = dbClient.singleUse().executeQuery(Statement.of((String)"SELECT OPTION_VALUE AS version_retention_period FROM INFORMATION_SCHEMA.DATABASE_OPTIONS WHERE SCHEMA_NAME = '' AND OPTION_NAME = 'version_retention_period'"), new Options.QueryOption[0]);){
            String versionRetentionPeriod = null;
            while (rs.next()) {
                versionRetentionPeriod = rs.getString("version_retention_period");
            }
            Truth.assertThat(versionRetentionPeriod).isEqualTo((Object)VERSION_RETENTION_PERIOD);
        }
    }

    @Test
    public void returnsAnErrorWhenAnInvalidRetentionPeriodIsGiven() {
        try {
            dbAdminClient.updateDatabaseDdl(instanceId, databaseId, Collections.singletonList("ALTER DATABASE " + databaseId + " SET OPTIONS (version_retention_period = '0d')"), "op_invalid_retention_period_" + databaseId).get(OPERATION_TIMEOUT.toNanos(), TimeUnit.NANOSECONDS);
            Assert.fail((String)"Expected invalid argument error when setting invalid version retention period");
        }
        catch (Exception e) {
            SpannerException spannerException = (SpannerException)e.getCause();
            Truth.assertThat((Comparable)spannerException.getErrorCode()).isEqualTo((Object)ErrorCode.INVALID_ARGUMENT);
        }
        Database database = dbAdminClient.getDatabase(instanceId, databaseId);
        Truth.assertThat((String)database.getVersionRetentionPeriod()).isEqualTo((Object)VERSION_RETENTION_PERIOD);
        Truth.assertThat((Comparable)database.getEarliestVersionTime()).isNotNull();
    }

    private static Database createDatabase(DatabaseAdminClient dbAdminClient, String instanceId, String databaseId, Iterable<String> extraStatements) throws Exception {
        return (Database)dbAdminClient.createDatabase(instanceId, databaseId, extraStatements).get(OPERATION_TIMEOUT.toNanos(), TimeUnit.NANOSECONDS);
    }

    private static UpdateDatabaseDdlMetadata updateVersionRetentionPeriod(DatabaseAdminClient dbAdminClient, String instanceId, String databaseId, String versionRetentionPeriod) throws Exception {
        OperationFuture op = dbAdminClient.updateDatabaseDdl(instanceId, databaseId, Collections.singletonList("ALTER DATABASE " + databaseId + " SET OPTIONS ( version_retention_period = '" + versionRetentionPeriod + "' )"), "updateddl_version_retention_period");
        op.get(OPERATION_TIMEOUT.toNanos(), TimeUnit.NANOSECONDS);
        return (UpdateDatabaseDdlMetadata)op.getMetadata().get(OPERATION_TIMEOUT.toNanos(), TimeUnit.NANOSECONDS);
    }
}

