/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.it;

import com.google.cloud.spanner.Database;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.IntegrationTestEnv;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ParallelIntegrationTest;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.testing.EmulatorSpannerHelper;
import com.google.common.truth.Truth;
import com.google.spanner.v1.ExecuteSqlRequest;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@Category(value={ParallelIntegrationTest.class})
@RunWith(value=JUnit4.class)
public class ITQueryOptionsTest {
    @ClassRule
    public static IntegrationTestEnv env = new IntegrationTestEnv();
    private static Database db;
    private static DatabaseClient client;

    @BeforeClass
    public static void setUpDatabase() {
        Assume.assumeFalse((String)"Emulator ignores query options", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        db = env.getTestHelper().createTestDatabase(new String[]{"CREATE TABLE TEST (ID INT64, NAME STRING(100)) PRIMARY KEY (ID)"});
        client = env.getTestHelper().getDatabaseClient(db);
    }

    @Test
    public void executeQuery() {
        try (ResultSet rs = client.singleUse().executeQuery(Statement.newBuilder((String)"SELECT 1").withQueryOptions(ExecuteSqlRequest.QueryOptions.newBuilder().setOptimizerVersion("1").build()).build(), new Options.QueryOption[0]);){
            while (rs.next()) {
                Truth.assertThat((Long)rs.getLong(0)).isEqualTo((Object)1L);
            }
        }
        rs = client.singleUse().executeQuery(Statement.newBuilder((String)"SELECT 1").withQueryOptions(ExecuteSqlRequest.QueryOptions.newBuilder().setOptimizerVersion("latest").build()).build(), new Options.QueryOption[0]);
        var2_3 = null;
        try {
            while (rs.next()) {
                Truth.assertThat((Long)rs.getLong(0)).isEqualTo((Object)1L);
            }
        }
        catch (Throwable throwable) {
            var2_3 = throwable;
            throw throwable;
        }
        finally {
            if (rs != null) {
                if (var2_3 != null) {
                    try {
                        rs.close();
                    }
                    catch (Throwable throwable) {
                        var2_3.addSuppressed(throwable);
                    }
                } else {
                    rs.close();
                }
            }
        }
        try {
            rs = client.singleUse().executeQuery(Statement.newBuilder((String)"SELECT 1").withQueryOptions(ExecuteSqlRequest.QueryOptions.newBuilder().setOptimizerVersion("100000").build()).build(), new Options.QueryOption[0]);
            var2_3 = null;
            try {
                while (rs.next()) {
                    Assert.fail((String)"should not get any results");
                }
            }
            catch (Throwable throwable) {
                var2_3 = throwable;
                throw throwable;
            }
            finally {
                if (rs != null) {
                    if (var2_3 != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable) {
                            var2_3.addSuppressed(throwable);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
        catch (SpannerException e) {
            Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.INVALID_ARGUMENT);
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"Query optimizer version: 100000 is not supported");
        }
    }

    @Test
    public void executeUpdate() {
        Truth.assertThat((Long)((Long)client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> transaction.executeUpdate(((Statement.Builder)((Statement.Builder)Statement.newBuilder((String)"INSERT INTO TEST (ID, NAME) VALUES (@id, @name)").bind("id").to(1L)).bind("name").to("One")).withQueryOptions(ExecuteSqlRequest.QueryOptions.newBuilder().setOptimizerVersion("1").build()).build(), new Options.UpdateOption[0])))).isEqualTo((Object)1L);
        Truth.assertThat((Long)((Long)client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> transaction.executeUpdate(((Statement.Builder)((Statement.Builder)Statement.newBuilder((String)"INSERT INTO TEST (ID, NAME) VALUES (@id, @name)").bind("id").to(2L)).bind("name").to("Two")).withQueryOptions(ExecuteSqlRequest.QueryOptions.newBuilder().setOptimizerVersion("latest").build()).build(), new Options.UpdateOption[0])))).isEqualTo((Object)1L);
        try {
            client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> transaction.executeUpdate(((Statement.Builder)((Statement.Builder)Statement.newBuilder((String)"INSERT INTO TEST (ID, NAME) VALUES (@id, @name)").bind("id").to(3L)).bind("name").to("Three")).withQueryOptions(ExecuteSqlRequest.QueryOptions.newBuilder().setOptimizerVersion("100000").build()).build(), new Options.UpdateOption[0]));
            Assert.fail((String)"missing expected exception");
        }
        catch (SpannerException e) {
            Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.INVALID_ARGUMENT);
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"Query optimizer version: 100000 is not supported");
        }
        Truth.assertThat((Long)client.executePartitionedUpdate(Statement.newBuilder((String)"UPDATE TEST SET NAME='updated' WHERE 1=1").withQueryOptions(ExecuteSqlRequest.QueryOptions.newBuilder().setOptimizerVersion("1").build()).build(), new Options.UpdateOption[0])).isEqualTo((Object)2L);
    }

    @Test
    public void spannerOptions() {
        Throwable throwable;
        ResultSet rs;
        DatabaseClient client;
        try (Spanner spanner = (Spanner)env.getTestHelper().getOptions().toBuilder().setDefaultQueryOptions(db.getId(), ExecuteSqlRequest.QueryOptions.newBuilder().setOptimizerVersion("1").build()).build().getService();){
            client = spanner.getDatabaseClient(db.getId());
            rs = client.singleUse().executeQuery(Statement.of((String)"SELECT 1"), new Options.QueryOption[0]);
            throwable = null;
            try {
                while (rs.next()) {
                    Truth.assertThat((Long)rs.getLong(0)).isEqualTo((Object)1L);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (rs != null) {
                    if (throwable != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
        spanner = (Spanner)env.getTestHelper().getOptions().toBuilder().setDefaultQueryOptions(db.getId(), ExecuteSqlRequest.QueryOptions.newBuilder().setOptimizerVersion("latest").build()).build().getService();
        var2_2 = null;
        try {
            client = spanner.getDatabaseClient(db.getId());
            rs = client.singleUse().executeQuery(Statement.of((String)"SELECT 1"), new Options.QueryOption[0]);
            throwable = null;
            try {
                while (rs.next()) {
                    Truth.assertThat((Long)rs.getLong(0)).isEqualTo((Object)1L);
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (rs != null) {
                    if (throwable != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
        catch (Throwable client2) {
            var2_2 = client2;
            throw client2;
        }
        finally {
            if (spanner != null) {
                if (var2_2 != null) {
                    try {
                        spanner.close();
                    }
                    catch (Throwable client2) {
                        var2_2.addSuppressed(client2);
                    }
                } else {
                    spanner.close();
                }
            }
        }
        spanner = (Spanner)env.getTestHelper().getOptions().toBuilder().setDefaultQueryOptions(db.getId(), ExecuteSqlRequest.QueryOptions.newBuilder().setOptimizerVersion("100000").build()).build().getService();
        var2_2 = null;
        try {
            client = spanner.getDatabaseClient(db.getId());
            try {
                rs = client.singleUse().executeQuery(Statement.of((String)"SELECT 1"), new Options.QueryOption[0]);
                throwable = null;
                try {
                    while (rs.next()) {
                        Assert.fail((String)"should not get any results");
                    }
                }
                catch (Throwable throwable6) {
                    throwable = throwable6;
                    throw throwable6;
                }
                finally {
                    if (rs != null) {
                        if (throwable != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable7) {
                                throwable.addSuppressed(throwable7);
                            }
                        } else {
                            rs.close();
                        }
                    }
                }
            }
            catch (SpannerException e) {
                Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.INVALID_ARGUMENT);
                Truth.assertThat((String)e.getMessage()).contains((CharSequence)"Query optimizer version: 100000 is not supported");
            }
        }
        catch (Throwable throwable8) {
            var2_2 = throwable8;
            throw throwable8;
        }
        finally {
            if (spanner != null) {
                if (var2_2 != null) {
                    try {
                        spanner.close();
                    }
                    catch (Throwable throwable9) {
                        var2_2.addSuppressed(throwable9);
                    }
                } else {
                    spanner.close();
                }
            }
        }
    }
}

