/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.it;

import com.google.cloud.spanner.Database;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.IntegrationTestEnv;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ParallelIntegrationTest;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.common.truth.Truth;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@Category(value={ParallelIntegrationTest.class})
@RunWith(value=JUnit4.class)
public class ITSpannerOptionsTest {
    @ClassRule
    public static IntegrationTestEnv env = new IntegrationTestEnv();
    private static Database db;

    @BeforeClass
    public static void setUp() throws Exception {
        db = env.getTestHelper().createTestDatabase(new String[0]);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        db.drop();
    }

    @Test
    public void testCompression() {
        for (String compressorName : new String[]{"gzip", "identity", null}) {
            SpannerOptions options = env.getTestHelper().getOptions().toBuilder().setCompressorName(compressorName).build();
            try (Spanner spanner = (Spanner)options.getService();){
                DatabaseClient client = spanner.getDatabaseClient(db.getId());
                try (ResultSet rs = client.singleUse().executeQuery(Statement.of((String)"SELECT 1 AS COL1"), new Options.QueryOption[0]);){
                    Truth.assertThat((Boolean)rs.next()).isTrue();
                    Truth.assertThat((Long)rs.getLong(0)).isEqualTo((Object)1L);
                    Truth.assertThat((Boolean)rs.next()).isFalse();
                }
            }
        }
    }
}

