/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.spi.v1;

import com.google.api.core.ApiFunction;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.auth.Credentials;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.OAuth2Credentials;
import com.google.cloud.spanner.DatabaseAdminClient;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.InstanceAdminClient;
import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.admin.database.v1.MockDatabaseAdminImpl;
import com.google.cloud.spanner.admin.instance.v1.MockInstanceAdminImpl;
import com.google.cloud.spanner.spi.v1.GapicSpannerRpc;
import com.google.cloud.spanner.spi.v1.SpannerRpc;
import com.google.common.base.Stopwatch;
import com.google.common.truth.Truth;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.ListValue;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Value;
import com.google.rpc.ErrorInfo;
import com.google.spanner.admin.database.v1.Database;
import com.google.spanner.admin.database.v1.DatabaseName;
import com.google.spanner.admin.instance.v1.Instance;
import com.google.spanner.admin.instance.v1.InstanceConfigName;
import com.google.spanner.admin.instance.v1.InstanceName;
import com.google.spanner.v1.ExecuteSqlRequest;
import com.google.spanner.v1.GetSessionRequest;
import com.google.spanner.v1.ResultSetMetadata;
import com.google.spanner.v1.SpannerGrpc;
import com.google.spanner.v1.StructType;
import com.google.spanner.v1.Type;
import com.google.spanner.v1.TypeCode;
import io.grpc.BindableService;
import io.grpc.CallCredentials;
import io.grpc.Context;
import io.grpc.Contexts;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Server;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import io.grpc.auth.MoreCallCredentials;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import io.grpc.protobuf.lite.ProtoLiteUtils;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.threeten.bp.Duration;

@RunWith(value=JUnit4.class)
public class GapicSpannerRpcTest {
    private static final Statement SELECT1AND2 = Statement.of((String)"SELECT 1 AS COL1 UNION ALL SELECT 2 AS COL1");
    private static final ResultSetMetadata SELECT1AND2_METADATA = ResultSetMetadata.newBuilder().setRowType(StructType.newBuilder().addFields(StructType.Field.newBuilder().setName("COL1").setType(Type.newBuilder().setCode(TypeCode.INT64).build()).build()).build()).build();
    private static final com.google.spanner.v1.ResultSet SELECT1_RESULTSET = com.google.spanner.v1.ResultSet.newBuilder().addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("1").build()).build()).addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("2").build()).build()).setMetadata(SELECT1AND2_METADATA).build();
    private static final Statement UPDATE_FOO_STATEMENT = Statement.of((String)"UPDATE FOO SET BAR=1 WHERE BAZ=2");
    private static final String STATIC_OAUTH_TOKEN = "STATIC_TEST_OAUTH_TOKEN";
    private static final String VARIABLE_OAUTH_TOKEN = "VARIABLE_TEST_OAUTH_TOKEN";
    private static final OAuth2Credentials STATIC_CREDENTIALS = OAuth2Credentials.create((AccessToken)new AccessToken("STATIC_TEST_OAUTH_TOKEN", new Date(System.currentTimeMillis() + TimeUnit.MILLISECONDS.convert(1L, TimeUnit.DAYS))));
    private static final OAuth2Credentials VARIABLE_CREDENTIALS = OAuth2Credentials.create((AccessToken)new AccessToken("VARIABLE_TEST_OAUTH_TOKEN", new Date(System.currentTimeMillis() + TimeUnit.MILLISECONDS.convert(1L, TimeUnit.DAYS))));
    private MockSpannerServiceImpl mockSpanner;
    private MockInstanceAdminImpl mockInstanceAdmin;
    private MockDatabaseAdminImpl mockDatabaseAdmin;
    private Server server;
    private InetSocketAddress address;
    private final Map<SpannerRpc.Option, Object> optionsMap = new HashMap<SpannerRpc.Option, Object>();
    private Metadata seenHeaders;
    private String defaultUserAgent;
    private static final int NUMBER_OF_TEST_RUNS = 2;
    private static final int NUM_THREADS_PER_CHANNEL = 4;
    private static final String SPANNER_THREAD_NAME = "Cloud-Spanner-TransportChannel";
    private static final String THREAD_PATTERN = "%s-[0-9]+";

    @BeforeClass
    public static void checkNotEmulator() {
        Assume.assumeTrue((String)"Skip tests when emulator is enabled as this test interferes with the check whether the emulator is running", (System.getenv("SPANNER_EMULATOR_HOST") == null ? 1 : 0) != 0);
    }

    @Before
    public void startServer() throws IOException {
        this.defaultUserAgent = "spanner-java/" + GaxProperties.getLibraryVersion(GapicSpannerRpc.class);
        this.mockSpanner = new MockSpannerServiceImpl();
        this.mockSpanner.setAbortProbability(0.0);
        this.mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(SELECT1AND2, SELECT1_RESULTSET));
        this.mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(UPDATE_FOO_STATEMENT, 1L));
        this.mockInstanceAdmin = new MockInstanceAdminImpl();
        this.mockDatabaseAdmin = new MockDatabaseAdminImpl();
        this.address = new InetSocketAddress("localhost", 0);
        this.server = ((NettyServerBuilder)((NettyServerBuilder)((NettyServerBuilder)((NettyServerBuilder)NettyServerBuilder.forAddress((SocketAddress)this.address).addService((BindableService)this.mockSpanner)).addService((BindableService)this.mockInstanceAdmin)).addService((BindableService)this.mockDatabaseAdmin)).intercept(new ServerInterceptor(){

            public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
                GapicSpannerRpcTest.this.seenHeaders = headers;
                String auth = (String)headers.get(Metadata.Key.of((String)"authorization", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
                Truth.assertThat((String)auth).isEqualTo((Object)"Bearer VARIABLE_TEST_OAUTH_TOKEN");
                return Contexts.interceptCall((Context)Context.current(), call, (Metadata)headers, next);
            }
        })).build().start();
        this.optionsMap.put(SpannerRpc.Option.CHANNEL_HINT, 1L);
    }

    @After
    public void stopServer() throws InterruptedException {
        this.server.shutdown();
        this.server.awaitTermination();
    }

    @Test
    public void testCloseAllThreadsWhenClosingSpanner() throws InterruptedException {
        for (int i = 0; i < 2; ++i) {
            int i2;
            MatcherAssert.assertThat((Object)this.getNumberOfThreadsWithName(SPANNER_THREAD_NAME, true), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)0)));
            SpannerOptions options = this.createSpannerOptions();
            Spanner spanner = (Spanner)options.getService();
            DatabaseClient client = spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
            ArrayList<ResultSet> resultSets = new ArrayList<ResultSet>();
            for (int i22 = 0; i22 < options.getSessionPoolOptions().getMaxSessions(); ++i22) {
                ResultSet rs = client.singleUse().executeQuery(SELECT1AND2, new Options.QueryOption[0]);
                rs.next();
                resultSets.add(rs);
                if (this.getNumberOfThreadsWithName(SPANNER_THREAD_NAME, false) == options.getNumChannels() * 4) break;
            }
            for (ResultSet rs : resultSets) {
                rs.close();
            }
            for (i2 = 0; i2 < options.getNumChannels() * 2; ++i2) {
                this.mockGetInstanceResponse();
                InstanceAdminClient instanceAdminClient = spanner.getInstanceAdminClient();
                instanceAdminClient.getInstance("projects/[PROJECT]/instances/[INSTANCE]");
            }
            for (i2 = 0; i2 < options.getNumChannels() * 2; ++i2) {
                this.mockGetDatabaseResponse();
                DatabaseAdminClient databaseAdminClient = spanner.getDatabaseAdminClient();
                databaseAdminClient.getDatabase("projects/[PROJECT]/instances/[INSTANCE]", "[DATABASE]");
            }
            spanner.close();
            Stopwatch watch = Stopwatch.createStarted();
            while (this.getNumberOfThreadsWithName(SPANNER_THREAD_NAME, false) > 0 && watch.elapsed(TimeUnit.SECONDS) < 2L) {
                Thread.sleep(10L);
            }
            MatcherAssert.assertThat((Object)this.getNumberOfThreadsWithName(SPANNER_THREAD_NAME, true), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)0)));
        }
    }

    @Test
    public void testMultipleOpenSpanners() throws InterruptedException {
        ArrayList<Spanner> spanners = new ArrayList<Spanner>();
        MatcherAssert.assertThat((Object)this.getNumberOfThreadsWithName(SPANNER_THREAD_NAME, true), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)0)));
        for (int openSpanners = 1; openSpanners <= 3; ++openSpanners) {
            SpannerOptions options = this.createSpannerOptions();
            Spanner spanner = (Spanner)options.getService();
            spanners.add(spanner);
            DatabaseClient client = spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
            ArrayList<ResultSet> resultSets = new ArrayList<ResultSet>();
            for (int sessionCount = 0; sessionCount < options.getSessionPoolOptions().getMaxSessions() && this.getNumberOfThreadsWithName(SPANNER_THREAD_NAME, false) < options.getNumChannels() * 4 * openSpanners; ++sessionCount) {
                ResultSet rs = client.singleUse().executeQuery(SELECT1AND2, new Options.QueryOption[0]);
                rs.next();
                resultSets.add(rs);
            }
            for (ResultSet rs : resultSets) {
                rs.close();
            }
        }
        for (Spanner spanner : spanners) {
            spanner.close();
        }
        Stopwatch watch = Stopwatch.createStarted();
        while (this.getNumberOfThreadsWithName(SPANNER_THREAD_NAME, false) > 0 && watch.elapsed(TimeUnit.SECONDS) < 2L) {
            Thread.sleep(10L);
        }
        MatcherAssert.assertThat((Object)this.getNumberOfThreadsWithName(SPANNER_THREAD_NAME, true), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)0)));
    }

    @Test
    public void testCallCredentialsProviderPreferenceAboveCredentials() {
        SpannerOptions options = ((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("some-project")).setCredentials((Credentials)STATIC_CREDENTIALS)).setCallCredentialsProvider(new SpannerOptions.CallCredentialsProvider(){

            public CallCredentials getCallCredentials() {
                return MoreCallCredentials.from((Credentials)VARIABLE_CREDENTIALS);
            }
        }).build();
        GapicSpannerRpc rpc = new GapicSpannerRpc(options);
        Truth.assertThat((Object)rpc.newCallContext(this.optionsMap, "/some/resource", (Object)GetSessionRequest.getDefaultInstance(), SpannerGrpc.getGetSessionMethod()).getCallOptions().getCredentials()).isNotNull();
        rpc.shutdown();
    }

    @Test
    public void testCallCredentialsProviderReturnsNull() {
        SpannerOptions options = ((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("some-project")).setCredentials((Credentials)STATIC_CREDENTIALS)).setCallCredentialsProvider(new SpannerOptions.CallCredentialsProvider(){

            public CallCredentials getCallCredentials() {
                return null;
            }
        }).build();
        GapicSpannerRpc rpc = new GapicSpannerRpc(options);
        Truth.assertThat((Object)rpc.newCallContext(this.optionsMap, "/some/resource", (Object)GetSessionRequest.getDefaultInstance(), SpannerGrpc.getGetSessionMethod()).getCallOptions().getCredentials()).isNull();
        rpc.shutdown();
    }

    @Test
    public void testNoCallCredentials() {
        SpannerOptions options = ((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("some-project")).setCredentials((Credentials)STATIC_CREDENTIALS)).build();
        GapicSpannerRpc rpc = new GapicSpannerRpc(options);
        Truth.assertThat((Object)rpc.newCallContext(this.optionsMap, "/some/resource", (Object)GetSessionRequest.getDefaultInstance(), SpannerGrpc.getGetSessionMethod()).getCallOptions().getCredentials()).isNull();
        rpc.shutdown();
    }

    @Test
    public void testCallContextTimeout() {
        final TimeoutHolder timeoutHolder = new TimeoutHolder();
        SpannerOptions.CallContextConfigurator configurator = new SpannerOptions.CallContextConfigurator(){

            public <ReqT, RespT> ApiCallContext configure(ApiCallContext context, ReqT request, MethodDescriptor<ReqT, RespT> method) {
                ExecuteSqlRequest sqlRequest;
                if (request instanceof ExecuteSqlRequest && method.equals((Object)SpannerGrpc.getExecuteSqlMethod()) && (sqlRequest = (ExecuteSqlRequest)request).getSeqno() > 0L) {
                    return context.withTimeout(timeoutHolder.timeout);
                }
                return null;
            }
        };
        this.mockSpanner.setExecuteSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(10, 0));
        SpannerOptions options = this.createSpannerOptions();
        try (Spanner spanner = (Spanner)options.getService();){
            DatabaseClient client = spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
            Context context = Context.current().withValue(SpannerOptions.CALL_CONTEXT_CONFIGURATOR_KEY, (Object)configurator);
            context.run(() -> {
                try {
                    timeoutHolder.timeout = Duration.ofNanos((long)1L);
                    client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> transaction.executeUpdate(UPDATE_FOO_STATEMENT, new Options.UpdateOption[0]));
                    Assert.fail((String)"missing expected timeout exception");
                }
                catch (SpannerException e) {
                    Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.DEADLINE_EXCEEDED);
                }
                timeoutHolder.timeout = Duration.ofMinutes((long)1L);
                Long updateCount = (Long)client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> transaction.executeUpdate(UPDATE_FOO_STATEMENT, new Options.UpdateOption[0]));
                Truth.assertThat((Long)updateCount).isEqualTo((Object)1L);
            });
        }
    }

    @Test
    public void testNewCallContextWithNullRequestAndNullMethod() {
        SpannerOptions options = ((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("some-project")).build();
        GapicSpannerRpc rpc = new GapicSpannerRpc(options);
        Truth.assertThat((Object)rpc.newCallContext(this.optionsMap, "/some/resource", null, null)).isNotNull();
        rpc.shutdown();
    }

    @Test
    public void testAdminRequestsLimitExceededRetryAlgorithm() {
        GapicSpannerRpc.AdminRequestsLimitExceededRetryAlgorithm alg = new GapicSpannerRpc.AdminRequestsLimitExceededRetryAlgorithm();
        Truth.assertThat((Boolean)alg.shouldRetry(null, (Object)1L)).isFalse();
        ErrorInfo info = ErrorInfo.newBuilder().putMetadata("quota_limit", "AdminMethodQuotaPerMinutePerProject").build();
        Metadata.Key key = Metadata.Key.of((String)(info.getDescriptorForType().getFullName() + "-bin"), (Metadata.BinaryMarshaller)ProtoLiteUtils.metadataMarshaller((MessageLite)info));
        Metadata trailers = new Metadata();
        trailers.put(key, (Object)info);
        SpannerException adminRateExceeded = SpannerExceptionFactory.newSpannerException((Throwable)Status.RESOURCE_EXHAUSTED.withDescription("foo").asRuntimeException(trailers));
        Truth.assertThat((Boolean)alg.shouldRetry((Throwable)adminRateExceeded, null)).isTrue();
        SpannerException numDatabasesExceeded = SpannerExceptionFactory.newSpannerException((Throwable)Status.RESOURCE_EXHAUSTED.withDescription("Too many databases on instance").asRuntimeException());
        Truth.assertThat((Boolean)alg.shouldRetry((Throwable)numDatabasesExceeded, null)).isFalse();
        Truth.assertThat((Boolean)alg.shouldRetry((Throwable)new Exception("random exception"), null)).isFalse();
    }

    @Test
    public void testDefaultUserAgent() {
        SpannerOptions options = this.createSpannerOptions();
        try (Spanner spanner = (Spanner)options.getService();){
            DatabaseClient databaseClient = spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
            try (ResultSet rs = databaseClient.singleUse().executeQuery(SELECT1AND2, new Options.QueryOption[0]);){
                rs.next();
            }
            Truth.assertThat((String)((String)this.seenHeaders.get(Metadata.Key.of((String)"user-agent", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER)))).contains((CharSequence)this.defaultUserAgent);
        }
    }

    @Test
    public void testCustomUserAgent() {
        HeaderProvider userAgentHeaderProvider = new HeaderProvider(){

            public Map<String, String> getHeaders() {
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.put("user-agent", "test-agent");
                return headers;
            }
        };
        SpannerOptions options = ((SpannerOptions.Builder)this.createSpannerOptions().toBuilder().setHeaderProvider(userAgentHeaderProvider)).build();
        try (Spanner spanner = (Spanner)options.getService();){
            DatabaseClient databaseClient = spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
            try (ResultSet rs = databaseClient.singleUse().executeQuery(SELECT1AND2, new Options.QueryOption[0]);){
                rs.next();
            }
            Truth.assertThat((String)((String)this.seenHeaders.get(Metadata.Key.of((String)"user-agent", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER)))).contains((CharSequence)("test-agent " + this.defaultUserAgent));
        }
    }

    private SpannerOptions createSpannerOptions() {
        String endpoint = this.address.getHostString() + ":" + this.server.getPort();
        return ((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("[PROJECT]")).setChannelConfigurator((ApiFunction)new ApiFunction<ManagedChannelBuilder, ManagedChannelBuilder>(){

            public ManagedChannelBuilder apply(ManagedChannelBuilder input) {
                input.usePlaintext();
                return input;
            }
        }).setHost("http://" + endpoint).setCredentials((Credentials)STATIC_CREDENTIALS)).setCallCredentialsProvider(new SpannerOptions.CallCredentialsProvider(){

            public CallCredentials getCallCredentials() {
                return MoreCallCredentials.from((Credentials)VARIABLE_CREDENTIALS);
            }
        }).build();
    }

    private int getNumberOfThreadsWithName(String serviceName, boolean dumpStack) {
        Pattern pattern = Pattern.compile(String.format(THREAD_PATTERN, serviceName));
        ThreadGroup group = Thread.currentThread().getThreadGroup();
        while (group.getParent() != null) {
            group = group.getParent();
        }
        Thread[] threads = new Thread[200];
        int numberOfThreads = group.enumerate(threads);
        int res = 0;
        for (int i = 0; i < numberOfThreads; ++i) {
            if (!pattern.matcher(threads[i].getName()).matches()) continue;
            if (dumpStack) {
                this.dumpThread(threads[i]);
            }
            ++res;
        }
        return res;
    }

    private void dumpThread(Thread thread) {
        StackTraceElement[] stackTraceElements;
        StringBuilder dump = new StringBuilder();
        dump.append('\"');
        dump.append(thread.getName());
        dump.append("\" ");
        Thread.State state = thread.getState();
        dump.append("\n   java.lang.Thread.State: ");
        dump.append((Object)state);
        for (StackTraceElement stackTraceElement : stackTraceElements = thread.getStackTrace()) {
            dump.append("\n        at ");
            dump.append(stackTraceElement);
        }
        dump.append("\n\n");
        System.out.print(dump.toString());
    }

    private void mockGetInstanceResponse() {
        InstanceName name2 = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
        InstanceConfigName config = InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]");
        String displayName = "displayName1615086568";
        int nodeCount = 1539922066;
        Instance expectedResponse = Instance.newBuilder().setName(name2.toString()).setConfig(config.toString()).setDisplayName(displayName).setNodeCount(nodeCount).build();
        this.mockInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
    }

    private void mockGetDatabaseResponse() {
        DatabaseName name2 = DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]");
        Database expectedResponse = Database.newBuilder().setName(name2.toString()).build();
        this.mockDatabaseAdmin.addResponse((AbstractMessage)expectedResponse);
    }

    private static final class TimeoutHolder {
        private Duration timeout;

        private TimeoutHolder() {
        }
    }
}

