/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.grpc.GrpcTransportOptions;
import com.google.cloud.spanner.DatabaseClientImpl;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SessionPoolOptions;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerImpl;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TransactionRunner;
import com.google.common.truth.Truth;
import com.google.protobuf.ListValue;
import com.google.protobuf.Value;
import com.google.spanner.v1.ResultSetMetadata;
import com.google.spanner.v1.StructType;
import com.google.spanner.v1.Type;
import com.google.spanner.v1.TypeCode;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.Status;
import io.grpc.inprocess.InProcessServerBuilder;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class BackendExhaustedTest {
    private static final String TEST_PROJECT = "my-project";
    private static final String TEST_INSTANCE = "my-instance";
    private static final String TEST_DATABASE = "my-database";
    private static MockSpannerServiceImpl mockSpanner;
    private static Server server;
    private static LocalChannelProvider channelProvider;
    private static final Statement UPDATE_STATEMENT;
    private static final Statement INVALID_UPDATE_STATEMENT;
    private static final long UPDATE_COUNT = 1L;
    private static final Statement SELECT1;
    private static final ResultSetMetadata SELECT1_METADATA;
    private static final com.google.spanner.v1.ResultSet SELECT1_RESULTSET;
    private Spanner spanner;
    private DatabaseClientImpl client;

    @BeforeClass
    public static void startStaticServer() throws IOException {
        mockSpanner = new MockSpannerServiceImpl();
        mockSpanner.setAbortProbability(0.0);
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(UPDATE_STATEMENT, 1L));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(SELECT1, SELECT1_RESULTSET));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.exception(INVALID_UPDATE_STATEMENT, Status.INVALID_ARGUMENT.withDescription("invalid statement").asRuntimeException()));
        String uniqueName = InProcessServerBuilder.generateName();
        server = ((InProcessServerBuilder)InProcessServerBuilder.forName((String)uniqueName).scheduledExecutorService((ScheduledExecutorService)new ScheduledThreadPoolExecutor(1)).addService((BindableService)mockSpanner)).build().start();
        channelProvider = LocalChannelProvider.create((String)uniqueName);
    }

    @AfterClass
    public static void stopServer() throws InterruptedException {
        server.shutdownNow();
        server.awaitTermination();
    }

    @Before
    public void setUp() throws Exception {
        SpannerOptions options = ((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId(TEST_PROJECT)).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance())).build();
        GrpcTransportOptions.ExecutorFactory executorFactory = ((GrpcTransportOptions)options.getTransportOptions()).getExecutorFactory();
        ScheduledThreadPoolExecutor executor = (ScheduledThreadPoolExecutor)executorFactory.get();
        options = options.toBuilder().setSessionPoolOption(SessionPoolOptions.newBuilder().setMinSessions(executor.getCorePoolSize()).setMaxSessions(executor.getCorePoolSize() * 3).build()).build();
        executorFactory.release((ExecutorService)executor);
        this.spanner = (Spanner)options.getService();
        this.client = (DatabaseClientImpl)this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        while (this.client.pool.getNumberOfSessionsInPool() < ((SpannerOptions)this.spanner.getOptions()).getSessionPoolOptions().getMinSessions()) {
            Thread.sleep(1L);
        }
    }

    @After
    public void tearDown() {
        mockSpanner.reset();
        mockSpanner.removeAllExecutionTimes();
        try {
            ((SpannerImpl)this.spanner).close(10L, TimeUnit.MILLISECONDS);
        }
        catch (SpannerException spannerException) {
            // empty catch block
        }
    }

    @Test
    public void test() throws Exception {
        int i;
        mockSpanner.setBatchCreateSessionsExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(Integer.MAX_VALUE, 0));
        ScheduledExecutorService executor = Executors.newScheduledThreadPool(((SpannerOptions)this.spanner.getOptions()).getSessionPoolOptions().getMinSessions() * 2);
        mockSpanner.freeze();
        for (i = 0; i < ((SpannerOptions)this.spanner.getOptions()).getSessionPoolOptions().getMinSessions() * 2; ++i) {
            executor.submit(new ReadRunnable());
        }
        for (i = 0; i < ((SpannerOptions)this.spanner.getOptions()).getSessionPoolOptions().getMaxSessions(); ++i) {
            executor.submit(new WriteRunnable());
        }
        mockSpanner.unfreeze();
        executor.shutdown();
        Truth.assertThat((Boolean)executor.awaitTermination(10L, TimeUnit.SECONDS)).isTrue();
    }

    static {
        UPDATE_STATEMENT = Statement.of((String)"UPDATE FOO SET BAR=1 WHERE BAZ=2");
        INVALID_UPDATE_STATEMENT = Statement.of((String)"UPDATE NON_EXISTENT_TABLE SET BAR=1 WHERE BAZ=2");
        SELECT1 = Statement.of((String)"SELECT 1 AS COL1");
        SELECT1_METADATA = ResultSetMetadata.newBuilder().setRowType(StructType.newBuilder().addFields(StructType.Field.newBuilder().setName("COL1").setType(Type.newBuilder().setCode(TypeCode.INT64).build()).build()).build()).build();
        SELECT1_RESULTSET = com.google.spanner.v1.ResultSet.newBuilder().addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("1").build()).build()).setMetadata(SELECT1_METADATA).build();
    }

    private final class WriteRunnable
    implements Runnable {
        private WriteRunnable() {
        }

        @Override
        public void run() {
            TransactionRunner runner = BackendExhaustedTest.this.client.readWriteTransaction(new Options.TransactionOption[0]);
            runner.run(transaction -> transaction.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]));
        }
    }

    private final class ReadRunnable
    implements Runnable {
        private ReadRunnable() {
        }

        @Override
        public void run() {
            try (ResultSet rs = BackendExhaustedTest.this.client.singleUse().executeQuery(SELECT1, new Options.QueryOption[0]);){
                while (rs.next()) {
                }
            }
        }
    }
}

