/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.connection.AbstractStatementParser;
import com.google.cloud.spanner.connection.ConnectionImpl;
import com.google.cloud.spanner.connection.ConnectionStatementExecutor;
import com.google.cloud.spanner.connection.ConnectionStatementExecutorImpl;
import com.google.cloud.spanner.connection.TransactionMode;
import com.google.common.collect.ImmutableList;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public class BeginPgTransactionTest {
    private final AbstractStatementParser parser = AbstractStatementParser.getInstance((Dialect)Dialect.POSTGRESQL);

    @Test
    public void testBeginWithNoOption() {
        ConnectionImpl connection = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        ConnectionStatementExecutorImpl executor = new ConnectionStatementExecutorImpl(connection);
        int index = 1;
        for (String sql : ImmutableList.of((Object)"begin", (Object)"begin transaction", (Object)"begin work", (Object)"start", (Object)"start transaction", (Object)"start work", (Object)"begin isolation level default", (Object)"begin transaction isolation level default", (Object)"begin work isolation level default", (Object)"start isolation level default", (Object)"start transaction isolation level default", (Object)"start work isolation level default", (Object[])new String[]{"begin isolation level serializable", "begin transaction isolation level serializable", "begin work isolation level serializable", "start isolation level serializable", "start transaction isolation level serializable", "start work isolation level serializable"})) {
            AbstractStatementParser.ParsedStatement statement = this.parser.parse(Statement.of((String)sql));
            Assert.assertEquals((String)sql, (Object)AbstractStatementParser.StatementType.CLIENT_SIDE, (Object)statement.getType());
            statement.getClientSideStatement().execute((ConnectionStatementExecutor)executor, sql);
            ((ConnectionImpl)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)index))).beginTransaction();
            ((ConnectionImpl)Mockito.verify((Object)connection, (VerificationMode)Mockito.never())).setTransactionMode((TransactionMode)ArgumentMatchers.any());
            ++index;
        }
    }

    @Test
    public void testBeginReadOnly() {
        ConnectionImpl connection = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        ConnectionStatementExecutorImpl executor = new ConnectionStatementExecutorImpl(connection);
        int index = 1;
        for (String sql : ImmutableList.of((Object)"begin read only", (Object)"begin transaction read only", (Object)"begin work read only", (Object)"start read only", (Object)"start transaction read only", (Object)"start work read only")) {
            AbstractStatementParser.ParsedStatement statement = this.parser.parse(Statement.of((String)sql));
            Assert.assertEquals((String)sql, (Object)AbstractStatementParser.StatementType.CLIENT_SIDE, (Object)statement.getType());
            statement.getClientSideStatement().execute((ConnectionStatementExecutor)executor, sql);
            ((ConnectionImpl)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)index))).beginTransaction();
            ((ConnectionImpl)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)index))).setTransactionMode(TransactionMode.READ_ONLY_TRANSACTION);
            ((ConnectionImpl)Mockito.verify((Object)connection, (VerificationMode)Mockito.never())).setTransactionMode(TransactionMode.READ_WRITE_TRANSACTION);
            ++index;
        }
    }

    @Test
    public void testBeginReadWrite() {
        ConnectionImpl connection = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        ConnectionStatementExecutorImpl executor = new ConnectionStatementExecutorImpl(connection);
        int index = 1;
        for (String sql : ImmutableList.of((Object)"begin read write", (Object)"begin transaction read write", (Object)"begin work read write", (Object)"start read write", (Object)"start transaction read write", (Object)"start work read write")) {
            AbstractStatementParser.ParsedStatement statement = this.parser.parse(Statement.of((String)sql));
            Assert.assertEquals((String)sql, (Object)AbstractStatementParser.StatementType.CLIENT_SIDE, (Object)statement.getType());
            statement.getClientSideStatement().execute((ConnectionStatementExecutor)executor, sql);
            ((ConnectionImpl)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)index))).beginTransaction();
            ((ConnectionImpl)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)index))).setTransactionMode(TransactionMode.READ_WRITE_TRANSACTION);
            ((ConnectionImpl)Mockito.verify((Object)connection, (VerificationMode)Mockito.never())).setTransactionMode(TransactionMode.READ_ONLY_TRANSACTION);
            ++index;
        }
    }

    @Test
    public void testBeginReadOnlyWithIsolationLevel() {
        ConnectionImpl connection = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        ConnectionStatementExecutorImpl executor = new ConnectionStatementExecutorImpl(connection);
        int index = 1;
        for (String sql : ImmutableList.of((Object)"begin read only isolation level serializable", (Object)"begin read only isolation level default", (Object)"begin isolation level serializable read only", (Object)"begin isolation level default read only", (Object)"begin read write isolation level default read only", (Object)"begin read write, isolation level default, read only", (Object)"begin read write  ,   \nisolation level default\n\t,read only")) {
            AbstractStatementParser.ParsedStatement statement = this.parser.parse(Statement.of((String)sql));
            Assert.assertEquals((String)sql, (Object)AbstractStatementParser.StatementType.CLIENT_SIDE, (Object)statement.getType());
            statement.getClientSideStatement().execute((ConnectionStatementExecutor)executor, sql);
            ((ConnectionImpl)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)index))).beginTransaction();
            ((ConnectionImpl)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)index))).setTransactionMode(TransactionMode.READ_ONLY_TRANSACTION);
            ((ConnectionImpl)Mockito.verify((Object)connection, (VerificationMode)Mockito.never())).setTransactionMode(TransactionMode.READ_WRITE_TRANSACTION);
            ++index;
        }
    }

    @Test
    public void testBeginWithNotDeferrable() {
        ConnectionImpl connection = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        ConnectionStatementExecutorImpl executor = new ConnectionStatementExecutorImpl(connection);
        int index = 1;
        for (String sql : ImmutableList.of((Object)"begin read only isolation level serializable not deferrable", (Object)"begin read only isolation level default not deferrable", (Object)"begin isolation level serializable read only not deferrable", (Object)"begin isolation level default read only not deferrable", (Object)"begin read write isolation level default read only not deferrable", (Object)"begin read write, isolation level default, read only not deferrable", (Object)"begin read write  ,   \nisolation level default\n\t,read only \n\n not \t deferrable", (Object)"begin not deferrable read only isolation level serializable", (Object)"begin not deferrable read only isolation level default", (Object)"begin not deferrable isolation level serializable read only", (Object)"begin not deferrable isolation level default read only", (Object)"begin not deferrable read write isolation level default read only", (Object[])new String[]{"begin not deferrable read write, isolation level default, read only", "begin not deferrable read write  ,   \nisolation level default\n\t,read only"})) {
            AbstractStatementParser.ParsedStatement statement = this.parser.parse(Statement.of((String)sql));
            Assert.assertEquals((String)sql, (Object)AbstractStatementParser.StatementType.CLIENT_SIDE, (Object)statement.getType());
            statement.getClientSideStatement().execute((ConnectionStatementExecutor)executor, sql);
            ((ConnectionImpl)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)index))).beginTransaction();
            ((ConnectionImpl)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)index))).setTransactionMode(TransactionMode.READ_ONLY_TRANSACTION);
            ((ConnectionImpl)Mockito.verify((Object)connection, (VerificationMode)Mockito.never())).setTransactionMode(TransactionMode.READ_WRITE_TRANSACTION);
            ++index;
        }
    }
}

