/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.api.gax.longrunning.OperationFuture;
import com.google.cloud.spanner.DatabaseAdminClient;
import com.google.cloud.spanner.connection.DdlClient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class DdlClientTests {
    private final String instanceId = "test-instance";
    private final String databaseId = "test-database";

    private DdlClient createSubject(DatabaseAdminClient client) {
        return DdlClient.newBuilder().setInstanceId("test-instance").setDatabaseName("test-database").setDatabaseAdminClient(client).build();
    }

    @Test
    public void testExecuteDdl() throws InterruptedException, ExecutionException {
        DatabaseAdminClient client = (DatabaseAdminClient)Mockito.mock(DatabaseAdminClient.class);
        OperationFuture operation = (OperationFuture)Mockito.mock(OperationFuture.class);
        Mockito.when((Object)((Void)operation.get())).thenReturn(null);
        Mockito.when((Object)client.updateDatabaseDdl((String)Mockito.eq((Object)"test-instance"), (String)Mockito.eq((Object)"test-database"), (Iterable)Mockito.anyList(), (String)Mockito.isNull())).thenReturn((Object)operation);
        DdlClient subject = this.createSubject(client);
        String ddl = "CREATE TABLE FOO";
        subject.executeDdl(ddl);
        ((DatabaseAdminClient)Mockito.verify((Object)client)).updateDatabaseDdl("test-instance", "test-database", Collections.singletonList(ddl), null);
        subject = this.createSubject(client);
        List<String> ddlList = Arrays.asList("CREATE TABLE FOO", "DROP TABLE FOO");
        subject.executeDdl(ddlList);
        ((DatabaseAdminClient)Mockito.verify((Object)client)).updateDatabaseDdl("test-instance", "test-database", ddlList, null);
    }

    @Test
    public void testIsCreateDatabase() {
        Assert.assertTrue((boolean)DdlClient.isCreateDatabaseStatement((String)"CREATE DATABASE foo"));
        Assert.assertTrue((boolean)DdlClient.isCreateDatabaseStatement((String)"CREATE DATABASE \"foo\""));
        Assert.assertTrue((boolean)DdlClient.isCreateDatabaseStatement((String)"CREATE DATABASE `foo`"));
        Assert.assertTrue((boolean)DdlClient.isCreateDatabaseStatement((String)"CREATE DATABASE\tfoo"));
        Assert.assertTrue((boolean)DdlClient.isCreateDatabaseStatement((String)"CREATE DATABASE\n foo"));
        Assert.assertTrue((boolean)DdlClient.isCreateDatabaseStatement((String)"CREATE DATABASE\t\n foo"));
        Assert.assertTrue((boolean)DdlClient.isCreateDatabaseStatement((String)"CREATE DATABASE"));
        Assert.assertTrue((boolean)DdlClient.isCreateDatabaseStatement((String)"CREATE\t \n DATABASE  foo"));
        Assert.assertTrue((boolean)DdlClient.isCreateDatabaseStatement((String)"create\t \n DATABASE  foo"));
        Assert.assertTrue((boolean)DdlClient.isCreateDatabaseStatement((String)"create database foo"));
        Assert.assertFalse((boolean)DdlClient.isCreateDatabaseStatement((String)"CREATE VIEW foo"));
        Assert.assertFalse((boolean)DdlClient.isCreateDatabaseStatement((String)"CREATE DATABAS foo"));
        Assert.assertFalse((boolean)DdlClient.isCreateDatabaseStatement((String)"CREATE DATABASEfoo"));
        Assert.assertFalse((boolean)DdlClient.isCreateDatabaseStatement((String)"CREATE foo"));
    }
}

