/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection.it;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AbortedDueToConcurrentModificationException;
import com.google.cloud.spanner.AbortedException;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ParallelIntegrationTest;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.connection.ITAbstractSpannerTest;
import com.google.cloud.spanner.connection.TransactionRetryListener;
import com.google.cloud.spanner.testing.EmulatorSpannerHelper;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@Category(value={ParallelIntegrationTest.class})
@RunWith(value=JUnit4.class)
public class ITTransactionRetryTest
extends ITAbstractSpannerTest {
    private static final Logger logger = Logger.getLogger(ITTransactionRetryTest.class.getName());
    @Rule
    public TestName testName = new TestName();
    public static final RetryStatistics RETRY_STATISTICS = new RetryStatistics();

    @Override
    protected void appendConnectionUri(StringBuilder uri) {
        uri.append(";autocommit=false;retryAbortsInternally=true");
    }

    @Override
    public boolean doCreateDefaultTestTable() {
        return true;
    }

    @Before
    public void clearTable() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.bufferedWrite(Mutation.delete((String)"TEST", (KeySet)KeySet.all()));
            connection.commit();
        }
    }

    @Before
    public void clearStatistics() {
        ITTransactionRetryTest.RETRY_STATISTICS.clear();
    }

    @Before
    public void logStart() {
        logger.fine("--------------------------------------------------------------\n" + this.testName.getMethodName() + " started");
    }

    @After
    public void logFinished() {
        logger.fine("--------------------------------------------------------------\n" + this.testName.getMethodName() + " finished");
    }

    @Test
    public void testCommitAborted() {
        ITAbstractSpannerTest.AbortInterceptor interceptor = new ITAbstractSpannerTest.AbortInterceptor(0.0);
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection(interceptor, new CountTransactionRetryListener());){
            try (ResultSet rs = connection.executeQuery(Statement.of((String)"SELECT COUNT(*) AS C FROM TEST WHERE ID=1"), new Options.QueryOption[0]);){
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)true));
                MatcherAssert.assertThat((Object)rs.getLong("C"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)0L)));
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)false));
            }
            connection.executeUpdate(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (1, 'test aborted')"));
            interceptor.setProbability(1.0);
            interceptor.setOnlyInjectOnce(true);
            connection.commit();
            MatcherAssert.assertThat((Object)(RETRY_STATISTICS.totalRetryAttemptsStarted >= 1 ? 1 : 0), (Matcher)CoreMatchers.is((Object)true));
            MatcherAssert.assertThat((Object)(RETRY_STATISTICS.totalRetryAttemptsFinished >= 1 ? 1 : 0), (Matcher)CoreMatchers.is((Object)true));
            MatcherAssert.assertThat((Object)(RETRY_STATISTICS.totalSuccessfulRetries >= 1 ? 1 : 0), (Matcher)CoreMatchers.is((Object)true));
            MatcherAssert.assertThat((Object)RETRY_STATISTICS.totalErroredRetries, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)0)));
            MatcherAssert.assertThat((Object)RETRY_STATISTICS.totalConcurrentModifications, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)0)));
            MatcherAssert.assertThat((Object)RETRY_STATISTICS.totalMaxAttemptsExceeded, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)0)));
            rs = connection.executeQuery(Statement.of((String)"SELECT COUNT(*) AS C FROM TEST WHERE ID=1"), new Options.QueryOption[0]);
            try {
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)true));
                MatcherAssert.assertThat((Object)rs.getLong("C"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1L)));
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)false));
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
    }

    @Test
    public void testInsertAborted() {
        ITAbstractSpannerTest.AbortInterceptor interceptor = new ITAbstractSpannerTest.AbortInterceptor(0.0);
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection(interceptor, new CountTransactionRetryListener());){
            try (ResultSet rs = connection.executeQuery(Statement.of((String)"SELECT COUNT(*) AS C FROM TEST WHERE ID=1"), new Options.QueryOption[0]);){
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)true));
                MatcherAssert.assertThat((Object)rs.getLong("C"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)0L)));
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)false));
            }
            interceptor.setProbability(1.0);
            interceptor.setOnlyInjectOnce(true);
            connection.executeUpdate(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (1, 'test aborted')"));
            connection.commit();
            MatcherAssert.assertThat((Object)(RETRY_STATISTICS.totalSuccessfulRetries >= 1 ? 1 : 0), (Matcher)CoreMatchers.is((Object)true));
            rs = connection.executeQuery(Statement.of((String)"SELECT COUNT(*) AS C FROM TEST WHERE ID=1"), new Options.QueryOption[0]);
            try {
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)true));
                MatcherAssert.assertThat((Object)rs.getLong("C"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1L)));
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)false));
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
    }

    @Test
    public void testUpdateAborted() {
        ITAbstractSpannerTest.AbortInterceptor interceptor = new ITAbstractSpannerTest.AbortInterceptor(0.0);
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection(interceptor, new CountTransactionRetryListener());){
            try (ResultSet rs = connection.executeQuery(Statement.of((String)"SELECT COUNT(*) AS C FROM TEST WHERE ID=1"), new Options.QueryOption[0]);){
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)true));
                MatcherAssert.assertThat((Object)rs.getLong("C"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)0L)));
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)false));
            }
            connection.executeUpdate(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (1, 'test aborted')"));
            interceptor.setProbability(1.0);
            interceptor.setOnlyInjectOnce(true);
            connection.executeUpdate(Statement.of((String)"UPDATE TEST SET NAME='update aborted' WHERE ID=1"));
            connection.commit();
            MatcherAssert.assertThat((Object)(RETRY_STATISTICS.totalSuccessfulRetries >= 1 ? 1 : 0), (Matcher)CoreMatchers.is((Object)true));
            rs = connection.executeQuery(Statement.of((String)"SELECT COUNT(*) AS C FROM TEST WHERE ID=1 AND NAME='update aborted'"), new Options.QueryOption[0]);
            try {
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)true));
                MatcherAssert.assertThat((Object)rs.getLong("C"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1L)));
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)false));
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
    }

    @Test
    public void testQueryAborted() {
        ITAbstractSpannerTest.AbortInterceptor interceptor = new ITAbstractSpannerTest.AbortInterceptor(0.0);
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection(interceptor, new CountTransactionRetryListener());){
            try (ResultSet rs = connection.executeQuery(Statement.of((String)"SELECT COUNT(*) AS C FROM TEST WHERE ID=1"), new Options.QueryOption[0]);){
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)true));
                MatcherAssert.assertThat((Object)rs.getLong("C"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)0L)));
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)false));
            }
            connection.executeUpdate(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (1, 'test aborted')"));
            interceptor.setProbability(1.0);
            interceptor.setOnlyInjectOnce(true);
            rs = connection.executeQuery(Statement.of((String)"SELECT COUNT(*) AS C FROM TEST WHERE ID=1"), new Options.QueryOption[0]);
            try {
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)true));
                MatcherAssert.assertThat((Object)rs.getLong("C"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1L)));
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)false));
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            connection.commit();
            MatcherAssert.assertThat((Object)(RETRY_STATISTICS.totalSuccessfulRetries >= 1 ? 1 : 0), (Matcher)CoreMatchers.is((Object)true));
            rs = connection.executeQuery(Statement.of((String)"SELECT COUNT(*) AS C FROM TEST WHERE ID=1"), new Options.QueryOption[0]);
            try {
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)true));
                MatcherAssert.assertThat((Object)rs.getLong("C"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1L)));
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)false));
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
    }

    @Test
    public void testNextCallAborted() {
        ITAbstractSpannerTest.AbortInterceptor interceptor = new ITAbstractSpannerTest.AbortInterceptor(0.0);
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection(interceptor, new CountTransactionRetryListener());){
            connection.executeUpdate(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (1, 'test 1')"));
            connection.executeUpdate(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (2, 'test 2')"));
            try (ResultSet rs = connection.executeQuery(Statement.of((String)"SELECT * FROM TEST ORDER BY ID"), new Options.QueryOption[0]);){
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)true));
                MatcherAssert.assertThat((Object)rs.getLong("ID"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1L)));
                interceptor.setProbability(1.0);
                interceptor.setOnlyInjectOnce(true);
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)true));
                MatcherAssert.assertThat((Object)rs.getLong("ID"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2L)));
                MatcherAssert.assertThat((Object)(RETRY_STATISTICS.totalSuccessfulRetries >= 1 ? 1 : 0), (Matcher)CoreMatchers.is((Object)true));
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)false));
            }
            connection.commit();
            MatcherAssert.assertThat((Object)(RETRY_STATISTICS.totalSuccessfulRetries >= 1 ? 1 : 0), (Matcher)CoreMatchers.is((Object)true));
            rs = connection.executeQuery(Statement.of((String)"SELECT COUNT(*) AS C FROM TEST"), new Options.QueryOption[0]);
            try {
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)true));
                MatcherAssert.assertThat((Object)rs.getLong("C"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2L)));
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)false));
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
    }

    @Test
    public void testMultipleAborts() {
        ITAbstractSpannerTest.AbortInterceptor interceptor = new ITAbstractSpannerTest.AbortInterceptor(0.0);
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection(interceptor, new CountTransactionRetryListener());){
            try (ResultSet rs = connection.executeQuery(Statement.of((String)"SELECT COUNT(*) AS C FROM TEST WHERE ID=1"), new Options.QueryOption[0]);){
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)true));
                MatcherAssert.assertThat((Object)rs.getLong("C"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)0L)));
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)false));
            }
            interceptor.setProbability(1.0);
            interceptor.setOnlyInjectOnce(true);
            connection.executeUpdate(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (1, 'test 1')"));
            interceptor.setProbability(1.0);
            interceptor.setOnlyInjectOnce(true);
            connection.executeUpdate(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (2, 'test 2')"));
            interceptor.setProbability(1.0);
            interceptor.setOnlyInjectOnce(true);
            connection.executeUpdate(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (3, 'test 3')"));
            connection.commit();
            MatcherAssert.assertThat((Object)(RETRY_STATISTICS.totalSuccessfulRetries >= 3 ? 1 : 0), (Matcher)CoreMatchers.is((Object)true));
            rs = connection.executeQuery(Statement.of((String)"SELECT COUNT(*) AS C FROM TEST"), new Options.QueryOption[0]);
            try {
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)true));
                MatcherAssert.assertThat((Object)rs.getLong("C"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)3L)));
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)false));
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
    }

    @Test
    public void testAbortAfterSelect() {
        ITAbstractSpannerTest.AbortInterceptor interceptor = new ITAbstractSpannerTest.AbortInterceptor(0.0);
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection(interceptor, new CountTransactionRetryListener());){
            try (ResultSet rs = connection.executeQuery(Statement.of((String)"SELECT COUNT(*) AS C FROM TEST WHERE ID=1"), new Options.QueryOption[0]);){
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)true));
                MatcherAssert.assertThat((Object)rs.getLong("C"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)0L)));
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)false));
            }
            connection.executeUpdate(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (1, 'test 1')"));
            rs = connection.executeQuery(Statement.of((String)"SELECT * FROM TEST WHERE ID=1"), new Options.QueryOption[0]);
            try {
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)true));
                MatcherAssert.assertThat((Object)rs.getLong("ID"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1L)));
                MatcherAssert.assertThat((Object)rs.getString("NAME"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"test 1")));
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)false));
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            interceptor.setProbability(1.0);
            interceptor.setOnlyInjectOnce(true);
            connection.executeUpdate(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (2, 'test 2')"));
            rs = connection.executeQuery(Statement.of((String)"SELECT * FROM TEST WHERE ID=1"), new Options.QueryOption[0]);
            try {
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)true));
                MatcherAssert.assertThat((Object)rs.getLong("ID"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1L)));
                MatcherAssert.assertThat((Object)rs.getString("NAME"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"test 1")));
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)false));
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            connection.commit();
            MatcherAssert.assertThat((Object)(RETRY_STATISTICS.totalSuccessfulRetries >= 1 ? 1 : 0), (Matcher)CoreMatchers.is((Object)true));
        }
    }

    @Test
    public void testAbortWithResultSetHalfway() {
        ITAbstractSpannerTest.AbortInterceptor interceptor = new ITAbstractSpannerTest.AbortInterceptor(0.0);
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection(interceptor, new CountTransactionRetryListener());){
            connection.executeUpdate(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (1, 'test 1')"));
            connection.executeUpdate(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (2, 'test 2')"));
            try (ResultSet rs = connection.executeQuery(Statement.of((String)"SELECT * FROM TEST ORDER BY ID"), new Options.QueryOption[0]);){
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)true));
                MatcherAssert.assertThat((Object)rs.getLong("ID"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1L)));
                interceptor.setProbability(1.0);
                interceptor.setOnlyInjectOnce(true);
                connection.executeUpdate(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (3, 'test 3')"));
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)true));
                MatcherAssert.assertThat((Object)rs.getLong("ID"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2L)));
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)false));
            }
            connection.commit();
            MatcherAssert.assertThat((Object)(RETRY_STATISTICS.totalSuccessfulRetries >= 1 ? 1 : 0), (Matcher)CoreMatchers.is((Object)true));
            rs = connection.executeQuery(Statement.of((String)"SELECT COUNT(*) AS C FROM TEST"), new Options.QueryOption[0]);
            try {
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)true));
                MatcherAssert.assertThat((Object)rs.getLong("C"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)3L)));
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)false));
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
    }

    @Test
    public void testAbortWithResultSetFullyConsumed() {
        ITAbstractSpannerTest.AbortInterceptor interceptor = new ITAbstractSpannerTest.AbortInterceptor(0.0);
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection(interceptor, new CountTransactionRetryListener());){
            connection.executeUpdate(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (1, 'test 1')"));
            connection.executeUpdate(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (2, 'test 2')"));
            try (ResultSet rs = connection.executeQuery(Statement.of((String)"SELECT * FROM TEST ORDER BY ID"), new Options.QueryOption[0]);){
                while (rs.next()) {
                }
            }
            interceptor.setProbability(1.0);
            interceptor.setOnlyInjectOnce(true);
            connection.executeUpdate(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (3, 'test 3')"));
            connection.commit();
            MatcherAssert.assertThat((Object)(RETRY_STATISTICS.totalSuccessfulRetries >= 1 ? 1 : 0), (Matcher)CoreMatchers.is((Object)true));
            rs = connection.executeQuery(Statement.of((String)"SELECT COUNT(*) AS C FROM TEST"), new Options.QueryOption[0]);
            try {
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)true));
                MatcherAssert.assertThat((Object)rs.getLong("C"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)3L)));
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)false));
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
    }

    @Test
    public void testAbortWithConcurrentInsert() {
        Assume.assumeFalse((String)"concurrent transactions are not supported on the emulator", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        ITAbstractSpannerTest.AbortInterceptor interceptor = new ITAbstractSpannerTest.AbortInterceptor(0.0);
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection(interceptor, new CountTransactionRetryListener());){
            connection.executeUpdate(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (1, 'test 1')"));
            connection.executeUpdate(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (2, 'test 2')"));
            try (ResultSet rs = connection.executeQuery(Statement.of((String)"SELECT * FROM TEST ORDER BY ID"), new Options.QueryOption[0]);){
                while (rs.next()) {
                }
            }
            try (ITAbstractSpannerTest.ITConnection connection2 = this.createConnection();){
                connection2.executeUpdate(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (3, 'test 3')"));
                connection2.commit();
            }
            interceptor.setProbability(1.0);
            interceptor.setOnlyInjectOnce(true);
            boolean expectedException = false;
            try {
                connection.executeUpdate(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (4, 'test 4')"));
            }
            catch (AbortedDueToConcurrentModificationException e) {
                expectedException = true;
            }
            MatcherAssert.assertThat((Object)expectedException, (Matcher)CoreMatchers.is((Object)true));
            this.assertRetryStatistics(1, 1, 0);
        }
    }

    @Test
    public void testAbortWithConcurrentDelete() {
        Assume.assumeFalse((String)"concurrent transactions are not supported on the emulator", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        ITAbstractSpannerTest.AbortInterceptor interceptor = new ITAbstractSpannerTest.AbortInterceptor(0.0);
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.executeUpdate(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (1, 'test 1')"));
            connection.executeUpdate(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (2, 'test 2')"));
            connection.commit();
        }
        connection = this.createConnection(interceptor, new CountTransactionRetryListener());
        try {
            try (ResultSet rs = connection.executeQuery(Statement.of((String)"SELECT * FROM TEST ORDER BY ID"), new Options.QueryOption[0]);){
                while (rs.next()) {
                }
            }
            try (ITAbstractSpannerTest.ITConnection connection2 = this.createConnection();){
                connection2.executeUpdate(Statement.of((String)"DELETE FROM TEST WHERE ID=1"));
                connection2.commit();
            }
            interceptor.setProbability(1.0);
            interceptor.setOnlyInjectOnce(true);
            boolean expectedException = false;
            try {
                connection.executeUpdate(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (3, 'test 3')"));
            }
            catch (AbortedDueToConcurrentModificationException e) {
                expectedException = true;
            }
            MatcherAssert.assertThat((Object)expectedException, (Matcher)CoreMatchers.is((Object)true));
            this.assertRetryStatistics(1, 1, 0);
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    @Test
    public void testAbortWithConcurrentUpdate() {
        Assume.assumeFalse((String)"concurrent transactions are not supported on the emulator", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        ITAbstractSpannerTest.AbortInterceptor interceptor = new ITAbstractSpannerTest.AbortInterceptor(0.0);
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.executeUpdate(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (1, 'test 1')"));
            connection.executeUpdate(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (2, 'test 2')"));
            connection.commit();
        }
        connection = this.createConnection(interceptor, new CountTransactionRetryListener());
        try {
            try (ResultSet rs = connection.executeQuery(Statement.of((String)"SELECT * FROM TEST ORDER BY ID"), new Options.QueryOption[0]);){
                while (rs.next()) {
                }
            }
            try (ITAbstractSpannerTest.ITConnection connection2 = this.createConnection();){
                connection2.executeUpdate(Statement.of((String)"UPDATE TEST SET NAME='test updated' WHERE ID=2"));
                connection2.commit();
            }
            interceptor.setProbability(1.0);
            interceptor.setOnlyInjectOnce(true);
            boolean expectedException = false;
            try {
                connection.executeUpdate(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (3, 'test 3')"));
            }
            catch (AbortedDueToConcurrentModificationException e) {
                expectedException = true;
            }
            MatcherAssert.assertThat((Object)expectedException, (Matcher)CoreMatchers.is((Object)true));
            this.assertRetryStatistics(1, 1, 0);
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    @Test
    public void testAbortWithUnseenConcurrentInsert() {
        Assume.assumeFalse((String)"concurrent transactions are not supported on the emulator", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        ITAbstractSpannerTest.AbortInterceptor interceptor = new ITAbstractSpannerTest.AbortInterceptor(0.0);
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection(interceptor, new CountTransactionRetryListener());){
            connection.executeUpdate(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (1, 'test 1')"));
            connection.executeUpdate(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (2, 'test 2')"));
            ResultSet rs = connection.executeQuery(Statement.of((String)"SELECT * FROM TEST ORDER BY ID"), new Options.QueryOption[0]);
            MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)true));
            MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)true));
            try (ITAbstractSpannerTest.ITConnection connection2 = this.createConnection();){
                connection2.executeUpdate(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (3, 'test 3')"));
                connection2.commit();
            }
            interceptor.setProbability(1.0);
            interceptor.setOnlyInjectOnce(true);
            int currentRetryCount = RETRY_STATISTICS.totalRetryAttemptsStarted;
            connection.executeUpdate(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (4, 'test 4')"));
            MatcherAssert.assertThat((Object)(RETRY_STATISTICS.totalRetryAttemptsStarted >= currentRetryCount + 1 ? 1 : 0), (Matcher)CoreMatchers.is((Object)true));
            MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)true));
            MatcherAssert.assertThat((Object)rs.getLong("ID"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)3L)));
            MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)false));
            rs.close();
            connection.commit();
            MatcherAssert.assertThat((Object)(RETRY_STATISTICS.totalSuccessfulRetries >= 1 ? 1 : 0), (Matcher)CoreMatchers.is((Object)true));
        }
    }

    @Test
    public void testAbortWithUnseenConcurrentInsertAbortOnNext() {
        Assume.assumeFalse((String)"concurrent transactions are not supported on the emulator", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        MatcherAssert.assertThat((Object)(this.testAbortWithUnseenConcurrentInsertAbortOnNext(0) >= 1 ? 1 : 0), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)(this.testAbortWithUnseenConcurrentInsertAbortOnNext(1) >= 1 ? 1 : 0), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)(this.testAbortWithUnseenConcurrentInsertAbortOnNext(2) >= 1 ? 1 : 0), (Matcher)CoreMatchers.is((Object)true));
        boolean expectedException = false;
        try {
            this.testAbortWithUnseenConcurrentInsertAbortOnNext(3);
        }
        catch (AbortedDueToConcurrentModificationException e) {
            expectedException = true;
        }
        MatcherAssert.assertThat((Object)expectedException, (Matcher)CoreMatchers.is((Object)true));
    }

    private int testAbortWithUnseenConcurrentInsertAbortOnNext(int callsToNext) throws AbortedDueToConcurrentModificationException {
        Assume.assumeFalse((String)"concurrent transactions are not supported on the emulator", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        int retries = 0;
        this.clearTable();
        this.clearStatistics();
        ITAbstractSpannerTest.AbortInterceptor interceptor = new ITAbstractSpannerTest.AbortInterceptor(0.0);
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection(interceptor, new CountTransactionRetryListener());){
            int totalRecordsSeen = 0;
            connection.executeUpdate(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (1, 'test 1')"));
            connection.executeUpdate(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (2, 'test 2')"));
            ResultSet rs = connection.executeQuery(Statement.of((String)"SELECT * FROM TEST ORDER BY ID"), new Options.QueryOption[0]);
            for (int counter = 0; counter < callsToNext; ++counter) {
                if (!rs.next()) continue;
                ++totalRecordsSeen;
            }
            try (ITAbstractSpannerTest.ITConnection connection2 = this.createConnection();){
                connection2.executeUpdate(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (3, 'test 3')"));
                connection2.commit();
            }
            int currentRetryCount = RETRY_STATISTICS.totalRetryAttemptsStarted;
            interceptor.setProbability(1.0);
            interceptor.setOnlyInjectOnce(true);
            while (rs.next()) {
                if (++totalRecordsSeen != 3) continue;
                MatcherAssert.assertThat((Object)rs.getLong("ID"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)3L)));
            }
            MatcherAssert.assertThat((Object)(RETRY_STATISTICS.totalSuccessfulRetries > currentRetryCount ? 1 : 0), (Matcher)CoreMatchers.is((Object)true));
            rs.close();
            connection.commit();
            retries = RETRY_STATISTICS.totalSuccessfulRetries;
        }
        return retries;
    }

    @Test
    public void testAbortWithConcurrentInsertAndContinue() {
        Assume.assumeFalse((String)"concurrent transactions are not supported on the emulator", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        ITAbstractSpannerTest.AbortInterceptor interceptor = new ITAbstractSpannerTest.AbortInterceptor(0.0);
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection(interceptor, new CountTransactionRetryListener());){
            connection.executeUpdate(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (1, 'test 1')"));
            connection.executeUpdate(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (2, 'test 2')"));
            try (ResultSet rs = connection.executeQuery(Statement.of((String)"SELECT * FROM TEST ORDER BY ID"), new Options.QueryOption[0]);){
                while (rs.next()) {
                }
            }
            try (ITAbstractSpannerTest.ITConnection connection2 = this.createConnection();){
                connection2.executeUpdate(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (3, 'test 3')"));
                connection2.commit();
            }
            interceptor.setProbability(1.0);
            interceptor.setOnlyInjectOnce(true);
            boolean expectedException = false;
            try {
                connection.executeUpdate(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (4, 'test 4')"));
            }
            catch (AbortedDueToConcurrentModificationException e) {
                expectedException = true;
            }
            MatcherAssert.assertThat((Object)expectedException, (Matcher)CoreMatchers.is((Object)true));
            this.assertRetryStatistics(1, 1, 0);
            connection.rollback();
            try (ResultSet rs = connection.executeQuery(Statement.of((String)"SELECT * FROM TEST"), new Options.QueryOption[0]);){
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)true));
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)false));
            }
        }
    }

    @Test
    public void testAbortTwiceOnCommit() {
        ITAbstractSpannerTest.AbortInterceptor interceptor = new ITAbstractSpannerTest.AbortInterceptor(0.0){
            private int commitCount;
            {
                this.commitCount = 0;
            }

            @Override
            protected boolean shouldAbort(String statement, ITAbstractSpannerTest.AbortInterceptor.ExecutionStep step) {
                if ("COMMIT".equalsIgnoreCase(statement)) {
                    ++this.commitCount;
                    return this.commitCount <= 2;
                }
                return false;
            }
        };
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection(interceptor, new CountTransactionRetryListener());){
            connection.executeUpdate(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (1, 'test aborted')"));
            connection.commit();
            this.assertRetryStatistics(2, 0, 2);
            try (ResultSet rs = connection.executeQuery(Statement.of((String)"SELECT COUNT(*) AS C FROM TEST WHERE ID=1"), new Options.QueryOption[0]);){
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)true));
                MatcherAssert.assertThat((Object)rs.getLong("C"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1L)));
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)false));
            }
        }
    }

    @Test
    public void testNestedAbortOnInsert() {
        ITAbstractSpannerTest.AbortInterceptor interceptor = new ITAbstractSpannerTest.AbortInterceptor(0.0){
            private int commitCount;
            private int insertCount;
            {
                this.commitCount = 0;
                this.insertCount = 0;
            }

            @Override
            protected boolean shouldAbort(String statement, ITAbstractSpannerTest.AbortInterceptor.ExecutionStep step) {
                if ("COMMIT".equalsIgnoreCase(statement)) {
                    ++this.commitCount;
                    return this.commitCount == 1;
                }
                if (statement.startsWith("INSERT INTO TEST")) {
                    ++this.insertCount;
                    return this.insertCount == 2;
                }
                return false;
            }
        };
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection(interceptor, new CountTransactionRetryListener());){
            connection.executeUpdate(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (1, 'test aborted')"));
            connection.commit();
            this.assertRetryStatistics(2, 0, 1);
            MatcherAssert.assertThat((Object)(RETRY_STATISTICS.totalNestedAborts > 0 ? 1 : 0), (Matcher)CoreMatchers.is((Object)true));
            try (ResultSet rs = connection.executeQuery(Statement.of((String)"SELECT COUNT(*) AS C FROM TEST WHERE ID=1"), new Options.QueryOption[0]);){
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)true));
                MatcherAssert.assertThat((Object)rs.getLong("C"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1L)));
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)false));
            }
        }
    }

    @Test
    public void testNestedAbortOnNextCall() {
        ITAbstractSpannerTest.AbortInterceptor interceptor = new ITAbstractSpannerTest.AbortInterceptor(0.0){
            private int nextCallsDuringRetry;
            private int commitCount;
            {
                this.nextCallsDuringRetry = 0;
                this.commitCount = 0;
            }

            @Override
            protected boolean shouldAbort(String statement, ITAbstractSpannerTest.AbortInterceptor.ExecutionStep step) {
                if ("COMMIT".equalsIgnoreCase(statement)) {
                    ++this.commitCount;
                    return this.commitCount == 1;
                }
                if (statement.equals("SELECT * FROM TEST ORDER BY ID") && step == ITAbstractSpannerTest.AbortInterceptor.ExecutionStep.RETRY_NEXT_ON_RESULT_SET) {
                    ++this.nextCallsDuringRetry;
                    return this.nextCallsDuringRetry == 1;
                }
                return false;
            }
        };
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection(interceptor, new CountTransactionRetryListener());){
            connection.executeUpdate(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (1, 'test 1')"));
            connection.executeUpdate(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (2, 'test 2')"));
            try (ResultSet rs = connection.executeQuery(Statement.of((String)"SELECT * FROM TEST ORDER BY ID"), new Options.QueryOption[0]);){
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)true));
                MatcherAssert.assertThat((Object)rs.getLong("ID"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1L)));
                connection.executeUpdate(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (3, 'test 3')"));
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)true));
                MatcherAssert.assertThat((Object)rs.getLong("ID"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2L)));
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)false));
            }
            connection.commit();
            this.assertRetryStatistics(2, 0, 1);
            MatcherAssert.assertThat((Object)(RETRY_STATISTICS.totalNestedAborts > 0 ? 1 : 0), (Matcher)CoreMatchers.is((Object)true));
            rs = connection.executeQuery(Statement.of((String)"SELECT COUNT(*) AS C FROM TEST"), new Options.QueryOption[0]);
            try {
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)true));
                MatcherAssert.assertThat((Object)rs.getLong("C"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)3L)));
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)false));
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
    }

    @Test
    public void testNestedAbortWithConcurrentInsert() {
        Assume.assumeFalse((String)"concurrent transactions are not supported on the emulator", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        ITAbstractSpannerTest.AbortInterceptor interceptor = new ITAbstractSpannerTest.AbortInterceptor(0.0){
            private boolean alreadyAborted;
            {
                this.alreadyAborted = false;
            }

            @Override
            protected boolean shouldAbort(String statement, ITAbstractSpannerTest.AbortInterceptor.ExecutionStep step) {
                if (!this.alreadyAborted && statement.equals("SELECT * FROM TEST ORDER BY ID") && step == ITAbstractSpannerTest.AbortInterceptor.ExecutionStep.RETRY_STATEMENT) {
                    this.alreadyAborted = true;
                    return true;
                }
                return super.shouldAbort(statement, step);
            }
        };
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection(interceptor, new CountTransactionRetryListener());){
            connection.executeUpdate(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (1, 'test 1')"));
            connection.executeUpdate(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (2, 'test 2')"));
            try (ResultSet rs = connection.executeQuery(Statement.of((String)"SELECT * FROM TEST ORDER BY ID"), new Options.QueryOption[0]);){
                while (rs.next()) {
                }
            }
            try (ITAbstractSpannerTest.ITConnection connection2 = this.createConnection();){
                connection2.executeUpdate(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (3, 'test 3')"));
                connection2.commit();
            }
            interceptor.setProbability(1.0);
            interceptor.setOnlyInjectOnce(true);
            boolean expectedException = false;
            try {
                connection.executeUpdate(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (4, 'test 4')"));
            }
            catch (AbortedDueToConcurrentModificationException e) {
                expectedException = true;
            }
            MatcherAssert.assertThat((Object)expectedException, (Matcher)CoreMatchers.is((Object)true));
            this.assertRetryStatistics(2, 1, 0);
            MatcherAssert.assertThat((Object)(RETRY_STATISTICS.totalNestedAborts > 0 ? 1 : 0), (Matcher)CoreMatchers.is((Object)true));
        }
    }

    @Test
    public void testAbortWithDifferentUpdateCount() {
        Assume.assumeFalse((String)"concurrent transactions are not supported on the emulator", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        ITAbstractSpannerTest.AbortInterceptor interceptor = new ITAbstractSpannerTest.AbortInterceptor(0.0);
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.executeUpdate(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (1, 'test 1')"));
            connection.executeUpdate(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (2, 'test 2')"));
            connection.commit();
        }
        connection = this.createConnection(interceptor, new CountTransactionRetryListener());
        try {
            connection.executeUpdate(Statement.of((String)"UPDATE TEST SET NAME='test update that will fail' WHERE TRUE"));
            try (ITAbstractSpannerTest.ITConnection connection2 = this.createConnection();){
                connection2.executeUpdate(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (3, 'test 3')"));
                connection2.commit();
            }
            interceptor.setProbability(1.0);
            interceptor.setOnlyInjectOnce(true);
            boolean expectedException = false;
            try {
                connection.executeUpdate(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (4, 'test 4')"));
            }
            catch (AbortedDueToConcurrentModificationException e) {
                expectedException = true;
            }
            this.assertRetryStatistics(1, 1, 0);
            MatcherAssert.assertThat((Object)expectedException, (Matcher)CoreMatchers.is((Object)true));
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    @Test
    public void testAbortWithExceptionOnSelect() {
        Assume.assumeFalse((String)"resume after error in transaction is not supported on the emulator", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        ITAbstractSpannerTest.AbortInterceptor interceptor = new ITAbstractSpannerTest.AbortInterceptor(0.0);
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.executeUpdate(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (1, 'test 1')"));
            connection.executeUpdate(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (2, 'test 2')"));
            connection.commit();
        }
        connection = this.createConnection(interceptor, new CountTransactionRetryListener());
        try {
            ResultSet rs;
            boolean expectedException = false;
            try {
                rs = connection.executeQuery(Statement.of((String)"SELECT * FROM FOO"), new Options.QueryOption[0]);
                try {
                    while (rs.next()) {
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            catch (SpannerException e) {
                expectedException = true;
            }
            MatcherAssert.assertThat((Object)expectedException, (Matcher)CoreMatchers.is((Object)true));
            rs = connection.executeQuery(Statement.of((String)"SELECT * FROM TEST"), new Options.QueryOption[0]);
            try {
                while (rs.next()) {
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            interceptor.setProbability(1.0);
            interceptor.setOnlyInjectOnce(true);
            connection.executeUpdate(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (3, 'test 3')"));
            this.assertRetryStatistics(1, 0, 1);
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    @Test
    public void testAbortWithExceptionOnSelectAndConcurrentModification() {
        Assume.assumeFalse((String)"concurrent transactions are not supported on the emulator", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        boolean abortedDueToConcurrentModification = false;
        ITAbstractSpannerTest.AbortInterceptor interceptor = new ITAbstractSpannerTest.AbortInterceptor(0.0);
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.executeUpdate(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (1, 'test 1')"));
            connection.executeUpdate(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (2, 'test 2')"));
            connection.commit();
        }
        connection = this.createConnection(interceptor, new CountTransactionRetryListener());
        try {
            ResultSet rs;
            boolean expectedException = false;
            try {
                rs = connection.executeQuery(Statement.of((String)"SELECT * FROM FOO"), new Options.QueryOption[0]);
                try {
                    while (rs.next()) {
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            catch (SpannerException e) {
                expectedException = true;
            }
            MatcherAssert.assertThat((Object)expectedException, (Matcher)CoreMatchers.is((Object)true));
            rs = connection.executeQuery(Statement.of((String)"SELECT * FROM TEST"), new Options.QueryOption[0]);
            try {
                while (rs.next()) {
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            try (ITAbstractSpannerTest.ITConnection connection2 = this.createConnection();){
                connection2.setAutocommit(true);
                connection2.execute(Statement.of((String)"CREATE TABLE FOO (ID INT64, NAME STRING(100)) PRIMARY KEY (ID)"));
            }
            interceptor.setProbability(1.0);
            interceptor.setOnlyInjectOnce(true);
            try {
                connection.executeUpdate(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (3, 'test 3')"));
            }
            catch (AbortedDueToConcurrentModificationException e) {
                abortedDueToConcurrentModification = true;
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        try (ITAbstractSpannerTest.ITConnection connection2 = this.createConnection();){
            connection2.setAutocommit(true);
            connection2.execute(Statement.of((String)"DROP TABLE FOO"));
        }
        MatcherAssert.assertThat((Object)abortedDueToConcurrentModification, (Matcher)CoreMatchers.is((Object)true));
        this.assertRetryStatistics(1, 1, 0);
    }

    @Test
    public void testAbortWithExceptionOnInsertAndConcurrentModification() {
        Assume.assumeFalse((String)"concurrent transactions are not supported on the emulator", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        boolean abortedDueToConcurrentModification = false;
        ITAbstractSpannerTest.AbortInterceptor interceptor = new ITAbstractSpannerTest.AbortInterceptor(0.0);
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.executeUpdate(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (1, 'test 1')"));
            connection.executeUpdate(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (2, 'test 2')"));
            connection.commit();
        }
        connection = this.createConnection(interceptor, new CountTransactionRetryListener());
        try {
            boolean expectedException = false;
            try {
                connection.executeUpdate(Statement.of((String)"INSERT INTO FOO (ID, NAME) VALUES (1, 'test 1')"));
            }
            catch (SpannerException e) {
                expectedException = true;
            }
            MatcherAssert.assertThat((Object)expectedException, (Matcher)CoreMatchers.is((Object)true));
            try (ResultSet rs = connection.executeQuery(Statement.of((String)"SELECT * FROM TEST"), new Options.QueryOption[0]);){
                while (rs.next()) {
                }
            }
            try (ITAbstractSpannerTest.ITConnection connection2 = this.createConnection();){
                connection2.setAutocommit(true);
                connection2.execute(Statement.of((String)"CREATE TABLE FOO (ID INT64, NAME STRING(100)) PRIMARY KEY (ID)"));
            }
            interceptor.setProbability(1.0);
            interceptor.setOnlyInjectOnce(true);
            try {
                connection.executeUpdate(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (3, 'test 3')"));
            }
            catch (AbortedDueToConcurrentModificationException e) {
                abortedDueToConcurrentModification = true;
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        try (ITAbstractSpannerTest.ITConnection connection2 = this.createConnection();){
            connection2.setAutocommit(true);
            connection2.execute(Statement.of((String)"DROP TABLE FOO"));
        }
        MatcherAssert.assertThat((Object)abortedDueToConcurrentModification, (Matcher)CoreMatchers.is((Object)true));
        this.assertRetryStatistics(1, 1, 0);
    }

    @Test
    public void testAbortWithDroppedTableConcurrentModification() {
        Assume.assumeFalse((String)"concurrent transactions are not supported on the emulator", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        boolean abortedDueToConcurrentModification = false;
        ITAbstractSpannerTest.AbortInterceptor interceptor = new ITAbstractSpannerTest.AbortInterceptor(0.0);
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.executeUpdate(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (1, 'test 1')"));
            connection.executeUpdate(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (2, 'test 2')"));
            connection.commit();
        }
        try (ITAbstractSpannerTest.ITConnection connection2 = this.createConnection();){
            connection2.setAutocommit(true);
            connection2.execute(Statement.of((String)"CREATE TABLE FOO (ID INT64, NAME STRING(100)) PRIMARY KEY (ID)"));
            connection2.executeUpdate(Statement.of((String)"INSERT INTO FOO (ID, NAME) VALUES (1, 'test 1')"));
        }
        connection = this.createConnection(interceptor, new CountTransactionRetryListener());
        try {
            try (ResultSet rs = connection.executeQuery(Statement.of((String)"SELECT * FROM FOO"), new Options.QueryOption[0]);){
                while (rs.next()) {
                }
            }
            rs = connection.executeQuery(Statement.of((String)"SELECT * FROM TEST"), new Options.QueryOption[0]);
            try {
                while (rs.next()) {
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            try (ITAbstractSpannerTest.ITConnection connection2 = this.createConnection();){
                connection2.setAutocommit(true);
                connection2.execute(Statement.of((String)"DROP TABLE FOO"));
            }
            interceptor.setProbability(1.0);
            interceptor.setOnlyInjectOnce(true);
            try {
                connection.executeUpdate(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (3, 'test 3')"));
            }
            catch (AbortedDueToConcurrentModificationException e) {
                abortedDueToConcurrentModification = true;
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        MatcherAssert.assertThat((Object)abortedDueToConcurrentModification, (Matcher)CoreMatchers.is((Object)true));
        this.assertRetryStatistics(1, 1, 0);
    }

    @Test
    public void testAbortWithInsertOnDroppedTableConcurrentModification() {
        Assume.assumeFalse((String)"concurrent transactions are not supported on the emulator", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        boolean abortedDueToConcurrentModification = false;
        ITAbstractSpannerTest.AbortInterceptor interceptor = new ITAbstractSpannerTest.AbortInterceptor(0.0);
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.executeUpdate(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (1, 'test 1')"));
            connection.executeUpdate(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (2, 'test 2')"));
            connection.commit();
        }
        try (ITAbstractSpannerTest.ITConnection connection2 = this.createConnection();){
            connection2.setAutocommit(true);
            connection2.execute(Statement.of((String)"CREATE TABLE FOO (ID INT64, NAME STRING(100)) PRIMARY KEY (ID)"));
            connection2.executeUpdate(Statement.of((String)"INSERT INTO FOO (ID, NAME) VALUES (1, 'test 1')"));
        }
        connection = this.createConnection(interceptor, new CountTransactionRetryListener());
        try {
            connection.executeUpdate(Statement.of((String)"INSERT INTO FOO (ID, NAME) VALUES (2, 'test 2')"));
            try (ResultSet rs = connection.executeQuery(Statement.of((String)"SELECT * FROM TEST"), new Options.QueryOption[0]);){
                while (rs.next()) {
                }
            }
            try (ITAbstractSpannerTest.ITConnection connection2 = this.createConnection();){
                connection2.setAutocommit(true);
                connection2.execute(Statement.of((String)"DROP TABLE FOO"));
            }
            interceptor.setProbability(1.0);
            interceptor.setOnlyInjectOnce(true);
            try {
                connection.executeUpdate(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (3, 'test 3')"));
            }
            catch (AbortedDueToConcurrentModificationException e) {
                abortedDueToConcurrentModification = true;
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        MatcherAssert.assertThat((Object)abortedDueToConcurrentModification, (Matcher)CoreMatchers.is((Object)true));
        this.assertRetryStatistics(1, 1, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAbortWithCursorHalfwayDroppedTableConcurrentModification() {
        Assume.assumeFalse((String)"concurrent transactions are not supported on the emulator", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        boolean abortedDueToConcurrentModification = false;
        ITAbstractSpannerTest.AbortInterceptor interceptor = new ITAbstractSpannerTest.AbortInterceptor(0.0);
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.executeUpdate(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (1, 'test 1')"));
            connection.executeUpdate(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (2, 'test 2')"));
            connection.commit();
        }
        try (ITAbstractSpannerTest.ITConnection connection2 = this.createConnection();){
            connection2.setAutocommit(true);
            connection2.execute(Statement.of((String)"CREATE TABLE FOO (ID INT64, NAME STRING(100)) PRIMARY KEY (ID)"));
            connection2.executeUpdate(Statement.of((String)"INSERT INTO FOO (ID, NAME) VALUES (1, 'test 1')"));
            connection2.executeUpdate(Statement.of((String)"INSERT INTO FOO (ID, NAME) VALUES (2, 'test 2')"));
        }
        connection = this.createConnection(interceptor, new CountTransactionRetryListener());
        try {
            try (ResultSet rs = connection.executeQuery(Statement.of((String)"SELECT * FROM TEST"), new Options.QueryOption[0]);){
                while (rs.next()) {
                }
            }
            rs = connection.executeQuery(Statement.of((String)"SELECT * FROM FOO"), new Options.QueryOption[0]);
            MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)true));
            try (ITAbstractSpannerTest.ITConnection connection2 = this.createConnection();){
                connection2.setAutocommit(true);
                connection2.execute(Statement.of((String)"DROP TABLE FOO"));
            }
            interceptor.setProbability(1.0);
            interceptor.setOnlyInjectOnce(true);
            try {
                rs.next();
            }
            catch (AbortedDueToConcurrentModificationException e) {
                abortedDueToConcurrentModification = true;
            }
            finally {
                rs.close();
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        MatcherAssert.assertThat((Object)abortedDueToConcurrentModification, (Matcher)CoreMatchers.is((Object)true));
        this.assertRetryStatistics(1, 1, 0);
    }

    @Test
    public void testRetryLargeResultSet() {
        int NUMBER_OF_TEST_RECORDS = 100000;
        long UPDATED_RECORDS = 1000L;
        ITAbstractSpannerTest.AbortInterceptor interceptor = new ITAbstractSpannerTest.AbortInterceptor(0.0);
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            for (int i = 0; i < 100000; ++i) {
                connection.bufferedWrite(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"TEST").set("ID").to((long)i)).set("NAME").to("test " + i)).build());
                if (i % 1000 != 0) continue;
                connection.commit();
            }
            connection.commit();
        }
        connection = this.createConnection(interceptor, new CountTransactionRetryListener());
        try {
            try (ResultSet rs = connection.executeQuery(Statement.of((String)"SELECT * FROM TEST ORDER BY ID"), new Options.QueryOption[0]);){
                while (rs.next()) {
                }
            }
            interceptor.setProbability(1.0);
            interceptor.setOnlyInjectOnce(true);
            connection.executeUpdate(((Statement.Builder)Statement.newBuilder((String)"UPDATE TEST SET NAME='updated' WHERE ID<@max_id").bind("max_id").to(1000L)).build());
            connection.commit();
            rs = connection.executeQuery(Statement.of((String)"SELECT COUNT(*) AS C FROM TEST WHERE NAME='updated'"), new Options.QueryOption[0]);
            try {
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)true));
                MatcherAssert.assertThat((Object)rs.getLong("C"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1000L)));
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)false));
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            this.assertRetryStatistics(1, 0, 1);
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    @Test
    public void testRetryHighAbortRate() {
        int NUMBER_OF_TEST_RECORDS = 10000;
        long UPDATED_RECORDS = 1000L;
        ITAbstractSpannerTest.AbortInterceptor interceptor = new ITAbstractSpannerTest.AbortInterceptor(0.25);
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection(interceptor, new CountTransactionRetryListener());){
            for (int i = 0; i < 10000; ++i) {
                connection.bufferedWrite(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"TEST").set("ID").to((long)i)).set("NAME").to("test " + i)).build());
                if (i % 1000 != 0) continue;
                connection.commit();
            }
            connection.commit();
            interceptor.setProbability(1.0E-4);
            try (ResultSet rs = connection.executeQuery(Statement.of((String)"SELECT * FROM TEST ORDER BY ID"), new Options.QueryOption[0]);){
                while (rs.next()) {
                }
            }
            interceptor.setProbability(0.5);
            connection.executeUpdate(((Statement.Builder)Statement.newBuilder((String)"UPDATE TEST SET NAME='updated' WHERE ID<@max_id").bind("max_id").to(1000L)).build());
            connection.commit();
            rs = connection.executeQuery(Statement.of((String)"SELECT COUNT(*) AS C FROM TEST WHERE NAME='updated'"), new Options.QueryOption[0]);
            try {
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)true));
                MatcherAssert.assertThat((Object)rs.getLong("C"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1000L)));
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)false));
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            connection.commit();
        }
        catch (AbortedException e) {
            logger.log(Level.FINE, "testRetryHighAbortRate aborted because of too many retries", e);
        }
        logger.fine("Total number of retries started: " + RETRY_STATISTICS.totalRetryAttemptsStarted);
        logger.fine("Total number of retries finished: " + RETRY_STATISTICS.totalRetryAttemptsFinished);
        logger.fine("Total number of retries successful: " + RETRY_STATISTICS.totalSuccessfulRetries);
        logger.fine("Total number of retries aborted: " + RETRY_STATISTICS.totalNestedAborts);
        logger.fine("Total number of times the max retry count was exceeded: " + RETRY_STATISTICS.totalMaxAttemptsExceeded);
    }

    @Test
    public void testAbortWithConcurrentInsertOnEmptyTable() {
        Assume.assumeFalse((String)"concurrent transactions are not supported on the emulator", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        ITAbstractSpannerTest.AbortInterceptor interceptor = new ITAbstractSpannerTest.AbortInterceptor(0.0);
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection(interceptor, new CountTransactionRetryListener());){
            try (ResultSet rs = connection.executeQuery(Statement.of((String)"SELECT * FROM TEST ORDER BY ID"), new Options.QueryOption[0]);){
                try (ITAbstractSpannerTest.ITConnection connection2 = this.createConnection();){
                    connection2.executeUpdate(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (1, 'test 1')"));
                    connection2.commit();
                }
                interceptor.setProbability(1.0);
                interceptor.setOnlyInjectOnce(true);
                int currentSuccessfulRetryCount = RETRY_STATISTICS.totalSuccessfulRetries;
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)true));
                MatcherAssert.assertThat((Object)RETRY_STATISTICS.totalSuccessfulRetries, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)(currentSuccessfulRetryCount + 1))));
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)false));
            }
            connection.commit();
            this.clearTable();
            this.clearStatistics();
            rs = connection.executeQuery(Statement.of((String)"SELECT * FROM TEST ORDER BY ID"), new Options.QueryOption[0]);
            try {
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)false));
                try (ITAbstractSpannerTest.ITConnection connection2 = this.createConnection();){
                    connection2.executeUpdate(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (1, 'test 1')"));
                    connection2.commit();
                }
                interceptor.setProbability(1.0);
                interceptor.setOnlyInjectOnce(true);
                boolean expectedException = false;
                try {
                    connection.commit();
                }
                catch (AbortedDueToConcurrentModificationException e) {
                    expectedException = true;
                }
                this.assertRetryStatistics(1, 1, 0);
                MatcherAssert.assertThat((Object)expectedException, (Matcher)CoreMatchers.is((Object)true));
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
    }

    private void assertRetryStatistics(int minAttemptsStartedExpected, int concurrentModificationsExpected, int successfulRetriesExpected) {
        MatcherAssert.assertThat((Object)(RETRY_STATISTICS.totalRetryAttemptsStarted >= minAttemptsStartedExpected ? 1 : 0), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)RETRY_STATISTICS.totalConcurrentModifications, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)concurrentModificationsExpected)));
        MatcherAssert.assertThat((Object)(RETRY_STATISTICS.totalSuccessfulRetries >= successfulRetriesExpected ? 1 : 0), (Matcher)CoreMatchers.is((Object)true));
    }

    public static class CountTransactionRetryListener
    implements TransactionRetryListener {
        public void retryStarting(Timestamp transactionStarted, long transactionId, int retryAttempt) {
            RETRY_STATISTICS.totalRetryAttemptsStarted++;
        }

        public void retryFinished(Timestamp transactionStarted, long transactionId, int retryAttempt, TransactionRetryListener.RetryResult result) {
            RETRY_STATISTICS.totalRetryAttemptsFinished++;
            switch (result) {
                case RETRY_ABORTED_AND_MAX_ATTEMPTS_EXCEEDED: {
                    RETRY_STATISTICS.totalMaxAttemptsExceeded++;
                    break;
                }
                case RETRY_ABORTED_AND_RESTARTING: {
                    RETRY_STATISTICS.totalNestedAborts++;
                    break;
                }
                case RETRY_ABORTED_DUE_TO_CONCURRENT_MODIFICATION: {
                    RETRY_STATISTICS.totalConcurrentModifications++;
                    break;
                }
                case RETRY_ERROR: {
                    RETRY_STATISTICS.totalErroredRetries++;
                    break;
                }
                case RETRY_SUCCESSFUL: {
                    RETRY_STATISTICS.totalSuccessfulRetries++;
                    break;
                }
            }
        }
    }

    private static class RetryStatistics {
        private int totalRetryAttemptsStarted;
        private int totalRetryAttemptsFinished;
        private int totalSuccessfulRetries;
        private int totalErroredRetries;
        private int totalNestedAborts;
        private int totalMaxAttemptsExceeded;
        private int totalConcurrentModifications;

        private RetryStatistics() {
        }

        private void clear() {
            this.totalRetryAttemptsStarted = 0;
            this.totalRetryAttemptsFinished = 0;
            this.totalSuccessfulRetries = 0;
            this.totalErroredRetries = 0;
            this.totalNestedAborts = 0;
            this.totalMaxAttemptsExceeded = 0;
            this.totalConcurrentModifications = 0;
        }
    }
}

