/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.it;

import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.Page;
import com.google.cloud.spanner.Database;
import com.google.cloud.spanner.DatabaseAdminClient;
import com.google.cloud.spanner.DatabaseRole;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.IntegrationTestEnv;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ParallelIntegrationTest;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.testing.EmulatorSpannerHelper;
import com.google.cloud.spanner.testing.RemoteSpannerHelper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.truth.Truth;
import com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@Category(value={ParallelIntegrationTest.class})
@RunWith(value=JUnit4.class)
public class ITDatabaseAdminTest {
    private static final long TIMEOUT_MINUTES = 5L;
    @ClassRule
    public static IntegrationTestEnv env = new IntegrationTestEnv();
    private DatabaseAdminClient dbAdminClient;
    private RemoteSpannerHelper testHelper;
    private List<Database> dbs = new ArrayList<Database>();

    @Before
    public void setUp() {
        this.testHelper = env.getTestHelper();
        this.dbAdminClient = this.testHelper.getClient().getDatabaseAdminClient();
    }

    @After
    public void tearDown() {
        for (Database db : this.dbs) {
            db.drop();
        }
        this.dbs.clear();
    }

    @Test
    public void testDatabaseOperations() throws Exception {
        String databaseId = this.testHelper.getUniqueDatabaseId();
        String instanceId = this.testHelper.getInstanceId().getInstance();
        String createTableT = "CREATE TABLE T (\n  K STRING(MAX),\n) PRIMARY KEY(K)";
        Database createdDatabase = (Database)this.dbAdminClient.createDatabase(instanceId, databaseId, (Iterable)ImmutableList.of((Object)"CREATE TABLE T (\n  K STRING(MAX),\n) PRIMARY KEY(K)")).get(5L, TimeUnit.MINUTES);
        this.dbs.add(createdDatabase);
        Assert.assertEquals((Object)databaseId, (Object)createdDatabase.getId().getDatabase());
        Assert.assertEquals((Object)Dialect.GOOGLE_STANDARD_SQL, (Object)createdDatabase.getDialect());
        Database retrievedDatabase = this.dbAdminClient.getDatabase(instanceId, databaseId);
        Assert.assertEquals((Object)databaseId, (Object)retrievedDatabase.getId().getDatabase());
        Assert.assertEquals((Object)Dialect.GOOGLE_STANDARD_SQL, (Object)retrievedDatabase.getDialect());
        Optional<Object> maybeDatabaseInList = Optional.empty();
        for (Database listedDatabase : this.dbAdminClient.listDatabases(instanceId, new Options.ListOption[0]).iterateAll()) {
            if (!listedDatabase.getId().getDatabase().equals(databaseId)) continue;
            maybeDatabaseInList = Optional.of(listedDatabase);
            break;
        }
        Assert.assertTrue((String)"Expected to find database in list", (boolean)maybeDatabaseInList.isPresent());
        Assert.assertEquals((Object)databaseId, (Object)((Database)maybeDatabaseInList.get()).getId().getDatabase());
        Assert.assertEquals((Object)Dialect.GOOGLE_STANDARD_SQL, (Object)((Database)maybeDatabaseInList.get()).getDialect());
        String createTableT2 = "CREATE TABLE T2 (\n  K2 STRING(MAX),\n) PRIMARY KEY(K2)";
        this.dbAdminClient.updateDatabaseDdl(instanceId, databaseId, (Iterable)ImmutableList.of((Object)"CREATE TABLE T2 (\n  K2 STRING(MAX),\n) PRIMARY KEY(K2)"), null).get(5L, TimeUnit.MINUTES);
        List databaseDdl = this.dbAdminClient.getDatabaseDdl(instanceId, databaseId);
        Assert.assertEquals((Object)databaseDdl, (Object)ImmutableList.of((Object)"CREATE TABLE T (\n  K STRING(MAX),\n) PRIMARY KEY(K)", (Object)"CREATE TABLE T2 (\n  K2 STRING(MAX),\n) PRIMARY KEY(K2)"));
        this.dbAdminClient.dropDatabase(instanceId, databaseId);
        this.dbs.clear();
        try {
            this.dbAdminClient.getDatabase(instanceId, databaseId);
            Assert.fail((String)"Expected exception");
        }
        catch (SpannerException e) {
            Assert.assertEquals((Object)ErrorCode.NOT_FOUND, (Object)e.getErrorCode());
        }
    }

    @Test
    public void updateDdlRetry() throws Exception {
        String dbId = this.testHelper.getUniqueDatabaseId();
        String instanceId = this.testHelper.getInstanceId().getInstance();
        String statement1 = "CREATE TABLE T (\n  K STRING(MAX),\n) PRIMARY KEY(K)";
        OperationFuture op = this.dbAdminClient.createDatabase(instanceId, dbId, (Iterable)ImmutableList.of((Object)statement1));
        Database db = (Database)op.get(5L, TimeUnit.MINUTES);
        this.dbs.add(db);
        String statement2 = "CREATE TABLE T2 (\n  K2 STRING(MAX),\n) PRIMARY KEY(K2)";
        OperationFuture op1 = this.dbAdminClient.updateDatabaseDdl(instanceId, dbId, (Iterable)ImmutableList.of((Object)statement2), "myop");
        OperationFuture op2 = this.dbAdminClient.updateDatabaseDdl(instanceId, dbId, (Iterable)ImmutableList.of((Object)statement2), "myop");
        op1.get(5L, TimeUnit.MINUTES);
        op2.get(5L, TimeUnit.MINUTES);
        UpdateDatabaseDdlMetadata metadata1 = ((UpdateDatabaseDdlMetadata)op1.getMetadata().get()).toBuilder().clearProgress().build();
        UpdateDatabaseDdlMetadata metadata2 = ((UpdateDatabaseDdlMetadata)op2.getMetadata().get()).toBuilder().clearProgress().build();
        Truth.assertThat((Object)metadata1).isEqualTo((Object)metadata2);
    }

    @Test
    public void databaseOperationsViaEntity() throws Exception {
        String dbId = this.testHelper.getUniqueDatabaseId();
        String instanceId = this.testHelper.getInstanceId().getInstance();
        String statement1 = "CREATE TABLE T (\n  K STRING(MAX),\n) PRIMARY KEY(K)";
        OperationFuture op = this.dbAdminClient.createDatabase(instanceId, dbId, (Iterable)ImmutableList.of((Object)statement1));
        Database db = (Database)op.get(5L, TimeUnit.MINUTES);
        this.dbs.add(db);
        Truth.assertThat((String)db.getId().getDatabase()).isEqualTo((Object)dbId);
        db = db.reload();
        Truth.assertThat((String)db.getId().getDatabase()).isEqualTo((Object)dbId);
        String statement2 = "CREATE TABLE T2 (\n  K2 STRING(MAX),\n) PRIMARY KEY(K2)";
        OperationFuture op2 = db.updateDdl((Iterable)ImmutableList.of((Object)statement2), null);
        op2.get(5L, TimeUnit.MINUTES);
        Iterable statementsInDb = db.getDdl();
        Truth.assertThat((Iterable)statementsInDb).containsExactly(new Object[]{statement1, statement2});
        db.drop();
        this.dbs.clear();
        try {
            db.reload();
            Assert.fail((String)"Expected exception");
        }
        catch (SpannerException ex) {
            Truth.assertThat((Comparable)ex.getErrorCode()).isEqualTo((Object)ErrorCode.NOT_FOUND);
        }
    }

    @Test
    public void listPagination() throws Exception {
        ImmutableList dbIds = ImmutableList.of((Object)this.testHelper.getUniqueDatabaseId(), (Object)this.testHelper.getUniqueDatabaseId(), (Object)this.testHelper.getUniqueDatabaseId());
        String instanceId = this.testHelper.getInstanceId().getInstance();
        for (String dbId : dbIds) {
            this.dbs.add((Database)this.dbAdminClient.createDatabase(instanceId, dbId, (Iterable)ImmutableList.of()).get());
        }
        ArrayList<String> dbIdsGot = new ArrayList<String>();
        for (Page page = this.dbAdminClient.listDatabases(instanceId, new Options.ListOption[]{Options.pageSize((int)1)}); page != null && page.getValues().iterator().hasNext(); page = page.getNextPage()) {
            Database db = (Database)Iterables.getOnlyElement((Iterable)page.getValues());
            dbIdsGot.add(db.getId().getDatabase());
        }
        Truth.assertThat(dbIdsGot).containsAtLeastElementsIn((Iterable)dbIds);
    }

    @Test
    public void createAndListDatabaseRoles() throws Exception {
        Assume.assumeFalse((String)"Emulator does not support create & list database roles", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        ImmutableList dbRoles = ImmutableList.of((Object)this.testHelper.getUniqueDatabaseRole(), (Object)this.testHelper.getUniqueDatabaseRole(), (Object)this.testHelper.getUniqueDatabaseRole());
        String instanceId = this.testHelper.getInstanceId().getInstance();
        Database database = (Database)this.dbAdminClient.createDatabase(instanceId, this.testHelper.getUniqueDatabaseId(), (Iterable)ImmutableList.of()).get();
        ArrayList<String> dbRolesCreateStatements = new ArrayList<String>();
        for (String dbRole : dbRoles) {
            dbRolesCreateStatements.add(String.format("CREATE ROLE %s", dbRole));
        }
        this.dbAdminClient.updateDatabaseDdl(instanceId, database.getId().getDatabase(), dbRolesCreateStatements, null).get();
        ArrayList<String> dbRolesGot = new ArrayList<String>();
        for (Page page = this.dbAdminClient.listDatabaseRoles(instanceId, database.getId().getDatabase(), new Options.ListOption[0]); page != null && page.getValues().iterator().hasNext(); page = page.getNextPage()) {
            for (DatabaseRole value : page.getValues()) {
                String[] split = value.getName().split("/");
                dbRolesGot.add(split[split.length - 1]);
            }
        }
        Truth.assertThat(dbRolesGot).containsAtLeastElementsIn((Iterable)dbRoles);
        ArrayList<String> dbRolesDropStatements = new ArrayList<String>();
        for (String dbRole : dbRoles) {
            dbRolesDropStatements.add(String.format("DROP ROLE %s", dbRole));
        }
        this.dbAdminClient.updateDatabaseDdl(instanceId, database.getId().getDatabase(), dbRolesDropStatements, null).get();
        ArrayList<String> dbRolesRemaining = new ArrayList<String>();
        for (Page pageRemainingRoles = this.dbAdminClient.listDatabaseRoles(instanceId, database.getId().getDatabase(), new Options.ListOption[0]); pageRemainingRoles != null && pageRemainingRoles.getValues().iterator().hasNext(); pageRemainingRoles = pageRemainingRoles.getNextPage()) {
            for (DatabaseRole value : pageRemainingRoles.getValues()) {
                String[] split = value.getName().split("/");
                dbRolesRemaining.add(split[split.length - 1]);
            }
        }
        Truth.assertThat(dbRolesRemaining).containsNoneIn((Iterable)dbRoles);
    }
}

