/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SessionPoolOptions;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.ListValue;
import com.google.protobuf.Value;
import com.google.spanner.v1.ResultSetMetadata;
import com.google.spanner.v1.SpannerGrpc;
import com.google.spanner.v1.StructType;
import com.google.spanner.v1.Type;
import com.google.spanner.v1.TypeCode;
import io.grpc.Attributes;
import io.grpc.BindableService;
import io.grpc.Context;
import io.grpc.Contexts;
import io.grpc.Grpc;
import io.grpc.Metadata;
import io.grpc.Server;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ChannelUsageTest {
    @Parameterized.Parameter(value=0)
    public int numChannels;
    @Parameterized.Parameter(value=1)
    public boolean enableGcpPool;
    private static final Statement SELECT1 = Statement.of((String)"SELECT 1 AS COL1");
    private static final ResultSetMetadata SELECT1_METADATA = ResultSetMetadata.newBuilder().setRowType(StructType.newBuilder().addFields(StructType.Field.newBuilder().setName("COL1").setType(Type.newBuilder().setCode(TypeCode.INT64).build()).build()).build()).build();
    private static final com.google.spanner.v1.ResultSet SELECT1_RESULTSET = com.google.spanner.v1.ResultSet.newBuilder().addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("1").build()).build()).setMetadata(SELECT1_METADATA).build();
    private static MockSpannerServiceImpl mockSpanner;
    private static Server server;
    private static InetSocketAddress address;
    private static final Set<InetSocketAddress> batchCreateSessionLocalIps;
    private static final Set<InetSocketAddress> executeSqlLocalIps;

    @Parameterized.Parameters(name="num channels = {0}, enable GCP pool = {1}")
    public static Collection<Object[]> data() {
        return Arrays.asList({1, true}, {1, false}, {2, true}, {2, false}, {4, true}, {4, false});
    }

    @BeforeClass
    public static void startServer() throws IOException {
        mockSpanner = new MockSpannerServiceImpl();
        mockSpanner.setAbortProbability(0.0);
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(SELECT1, SELECT1_RESULTSET));
        address = new InetSocketAddress("localhost", 0);
        server = ((NettyServerBuilder)((NettyServerBuilder)NettyServerBuilder.forAddress((SocketAddress)address).addService((BindableService)mockSpanner)).intercept(new ServerInterceptor(){

            public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
                Assert.assertEquals((Object)"gzip", (Object)headers.get(Metadata.Key.of((String)"x-response-encoding", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER)));
                Attributes attributes = call.getAttributes();
                Attributes.Key key = attributes.keys().stream().filter(k -> k.equals(Grpc.TRANSPORT_ATTR_REMOTE_ADDR)).findFirst().orElse(null);
                if (key != null) {
                    if (call.getMethodDescriptor().equals(SpannerGrpc.getBatchCreateSessionsMethod())) {
                        batchCreateSessionLocalIps.add((InetSocketAddress)attributes.get(key));
                    }
                    if (call.getMethodDescriptor().equals(SpannerGrpc.getExecuteStreamingSqlMethod())) {
                        executeSqlLocalIps.add((InetSocketAddress)attributes.get(key));
                    }
                }
                return Contexts.interceptCall((Context)Context.current(), call, (Metadata)headers, next);
            }
        })).build().start();
    }

    @AfterClass
    public static void stopServer() throws InterruptedException {
        server.shutdown();
        server.awaitTermination();
    }

    @After
    public void reset() {
        mockSpanner.reset();
        batchCreateSessionLocalIps.clear();
        executeSqlLocalIps.clear();
    }

    private SpannerOptions createSpannerOptions() {
        String endpoint = address.getHostString() + ":" + server.getPort();
        SpannerOptions.Builder builder = (SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("[PROJECT]")).setChannelConfigurator(input -> {
            input.usePlaintext();
            return input;
        }).setNumChannels(this.numChannels).setCompressorName("gzip").setSessionPoolOption(SessionPoolOptions.newBuilder().setMinSessions(this.numChannels * 2).setMaxSessions(this.numChannels * 2).build()).setHost("http://" + endpoint).setCredentials((Credentials)NoCredentials.getInstance());
        if (this.enableGcpPool) {
            builder.enableGrpcGcpExtension();
        }
        return builder.build();
    }

    @Test
    public void testCreatesNumChannels() {
        try (Spanner spanner = (Spanner)this.createSpannerOptions().getService();){
            DatabaseClient client = spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
            try (ResultSet resultSet = client.singleUse().executeQuery(SELECT1, new Options.QueryOption[0]);){
                while (resultSet.next()) {
                }
            }
        }
        Assert.assertEquals((long)this.numChannels, (long)batchCreateSessionLocalIps.size());
    }

    @Test
    public void testUsesAllChannels() throws InterruptedException, ExecutionException {
        try (Spanner spanner = (Spanner)this.createSpannerOptions().getService();){
            DatabaseClient client = spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
            ListeningExecutorService executor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(this.numChannels * 2));
            CountDownLatch latch = new CountDownLatch(this.numChannels * 2);
            ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>(this.numChannels * 2);
            for (int run = 0; run < this.numChannels * 2; ++run) {
                futures.add(executor.submit(() -> {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }));
            }
            Assert.assertEquals((long)(this.numChannels * 2), (long)((List)Futures.allAsList(futures).get()).size());
        }
        Assert.assertEquals((long)this.numChannels, (long)executeSqlLocalIps.size());
    }

    static {
        batchCreateSessionLocalIps = ConcurrentHashMap.newKeySet();
        executeSqlLocalIps = ConcurrentHashMap.newKeySet();
    }
}

