/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.ByteArray;
import com.google.cloud.Date;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.KeyRange;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.SpannerMatchers;
import com.google.cloud.spanner.Value;
import com.google.cloud.spanner.ValueBinder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.testing.EqualsTester;
import com.google.common.testing.SerializableTester;
import com.google.common.truth.Truth;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class MutationTest {
    @Test
    public void insertEmpty() {
        Mutation m = Mutation.newInsertBuilder((String)"T1").build();
        Truth.assertThat((String)m.getTable()).isEqualTo((Object)"T1");
        Truth.assertThat((Comparable)m.getOperation()).isEqualTo((Object)Mutation.Op.INSERT);
        Truth.assertThat((Iterable)m.getColumns()).isEmpty();
        Truth.assertThat((Iterable)m.getValues()).isEmpty();
        Truth.assertThat((String)m.toString()).isEqualTo((Object)"insert(T1{})");
    }

    @Test
    public void insert() {
        Mutation m = ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"T1").set("C1").to(true)).set("C2").to(1234L)).build();
        Truth.assertThat((String)m.getTable()).isEqualTo((Object)"T1");
        Truth.assertThat((Comparable)m.getOperation()).isEqualTo((Object)Mutation.Op.INSERT);
        Truth.assertThat((Iterable)m.getColumns()).containsExactly(new Object[]{"C1", "C2"}).inOrder();
        Truth.assertThat((Iterable)m.getValues()).containsExactly(new Object[]{Value.bool((boolean)true), Value.int64((long)1234L)}).inOrder();
        Truth.assertThat((String)m.toString()).isEqualTo((Object)"insert(T1{C1=true,C2=1234})");
    }

    @Test
    public void insertOrUpdateEmpty() {
        Mutation m = Mutation.newInsertOrUpdateBuilder((String)"T2").build();
        Truth.assertThat((String)m.getTable()).isEqualTo((Object)"T2");
        Truth.assertThat((Comparable)m.getOperation()).isEqualTo((Object)Mutation.Op.INSERT_OR_UPDATE);
        Truth.assertThat((Iterable)m.getColumns()).isEmpty();
        Truth.assertThat((Iterable)m.getValues()).isEmpty();
        Truth.assertThat((String)m.toString()).isEqualTo((Object)"insert_or_update(T2{})");
    }

    @Test
    public void insertOrUpdate() {
        Mutation m = ((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"T1").set("C1").to(true)).build();
        Truth.assertThat((String)m.getTable()).isEqualTo((Object)"T1");
        Truth.assertThat((Comparable)m.getOperation()).isEqualTo((Object)Mutation.Op.INSERT_OR_UPDATE);
        Truth.assertThat((Iterable)m.getColumns()).containsExactly(new Object[]{"C1"});
        Truth.assertThat((Iterable)m.getValues()).containsExactly(new Object[]{Value.bool((boolean)true)});
        Truth.assertThat((String)m.toString()).isEqualTo((Object)"insert_or_update(T1{C1=true})");
    }

    @Test
    public void updateEmpty() {
        Mutation m = Mutation.newUpdateBuilder((String)"T2").build();
        Truth.assertThat((String)m.getTable()).isEqualTo((Object)"T2");
        Truth.assertThat((Comparable)m.getOperation()).isEqualTo((Object)Mutation.Op.UPDATE);
        Truth.assertThat((Iterable)m.getColumns()).isEmpty();
        Truth.assertThat((Iterable)m.getValues()).isEmpty();
        Truth.assertThat((String)m.toString()).isEqualTo((Object)"update(T2{})");
    }

    @Test
    public void update() {
        Mutation m = ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newUpdateBuilder((String)"T1").set("C1").to(true)).set("C2").to(1234L)).build();
        Truth.assertThat((String)m.getTable()).isEqualTo((Object)"T1");
        Truth.assertThat((Comparable)m.getOperation()).isEqualTo((Object)Mutation.Op.UPDATE);
        Truth.assertThat((Iterable)m.getColumns()).containsExactly(new Object[]{"C1", "C2"}).inOrder();
        Truth.assertThat((Iterable)m.getValues()).containsExactly(new Object[]{Value.bool((boolean)true), Value.int64((long)1234L)}).inOrder();
        Truth.assertThat((String)m.toString()).isEqualTo((Object)"update(T1{C1=true,C2=1234})");
    }

    @Test
    public void replaceEmpty() {
        Mutation m = Mutation.newReplaceBuilder((String)"T2").build();
        Truth.assertThat((String)m.getTable()).isEqualTo((Object)"T2");
        Truth.assertThat((Comparable)m.getOperation()).isEqualTo((Object)Mutation.Op.REPLACE);
        Truth.assertThat((Iterable)m.getColumns()).isEmpty();
        Truth.assertThat((Iterable)m.getValues()).isEmpty();
        Truth.assertThat((String)m.toString()).isEqualTo((Object)"replace(T2{})");
    }

    @Test
    public void replace() {
        Mutation m = ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newReplaceBuilder((String)"T1").set("C1").to(true)).set("C2").to(1234L)).build();
        Truth.assertThat((String)m.getTable()).isEqualTo((Object)"T1");
        Truth.assertThat((Comparable)m.getOperation()).isEqualTo((Object)Mutation.Op.REPLACE);
        Truth.assertThat((Iterable)m.getColumns()).containsExactly(new Object[]{"C1", "C2"}).inOrder();
        Truth.assertThat((Iterable)m.getValues()).containsExactly(new Object[]{Value.bool((boolean)true), Value.int64((long)1234L)}).inOrder();
        Truth.assertThat((String)m.toString()).isEqualTo((Object)"replace(T1{C1=true,C2=1234})");
    }

    @Test
    public void duplicateColumn() {
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"T1").set("C1").to(true)).set("C1").to(false)).build());
        Truth.assertThat((String)e.getMessage()).contains((CharSequence)"Duplicate column");
    }

    @Test
    public void duplicateColumnCaseInsensitive() {
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"T1").set("C1").to(true)).set("c1").to(false)).build());
        Truth.assertThat((String)e.getMessage()).contains((CharSequence)"Duplicate column");
    }

    @Test
    public void asMap() {
        Mutation m = Mutation.newInsertBuilder((String)"T").build();
        Truth.assertThat((Map)m.asMap()).isEqualTo((Object)ImmutableMap.of());
        m = ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"T").set("C1").to(true)).set("C2").to(1234L)).build();
        Truth.assertThat((Map)m.asMap()).isEqualTo((Object)ImmutableMap.of((Object)"C1", (Object)Value.bool((boolean)true), (Object)"C2", (Object)Value.int64((long)1234L)));
    }

    @Test
    public void unfinishedBindingV1() {
        Mutation.WriteBuilder b = Mutation.newInsertBuilder((String)"T1");
        b.set("C1");
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> b.build());
        Truth.assertThat((String)e.getMessage()).contains((CharSequence)"Incomplete binding for column C1");
    }

    @Test
    public void unfinishedBindingV2() {
        Mutation.WriteBuilder b = Mutation.newInsertBuilder((String)"T1");
        b.set("C1");
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> b.set("C2"));
        Truth.assertThat((String)e.getMessage()).contains((CharSequence)"Incomplete binding for column C1");
    }

    @Test
    public void notInBinding() {
        ValueBinder binder = Mutation.newInsertBuilder((String)"T1").set("C1");
        binder.to(1234L);
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> binder.to(5678L));
        Truth.assertThat((String)e.getMessage()).contains((CharSequence)"No binding currently active");
    }

    @Test
    public void delete() {
        KeySet keySet = KeySet.singleKey((Key)Key.of((Object[])new Object[]{"k1"}));
        Mutation m = Mutation.delete((String)"T1", (KeySet)keySet);
        Truth.assertThat((Comparable)m.getOperation()).isEqualTo((Object)Mutation.Op.DELETE);
        Truth.assertThat((Object)m.getKeySet()).isEqualTo((Object)keySet);
        Truth.assertThat((String)m.toString()).isEqualTo((Object)"delete(T1{[k1]})");
    }

    @Test
    public void equalsAndHashCode() {
        EqualsTester tester = new EqualsTester();
        tester.addEqualityGroup(new Object[]{Mutation.newInsertBuilder((String)"T1").build(), Mutation.newInsertBuilder((String)"T1").build()});
        tester.addEqualityGroup(new Object[]{Mutation.newInsertOrUpdateBuilder((String)"T1").build()});
        tester.addEqualityGroup(new Object[]{Mutation.newUpdateBuilder((String)"T1").build()});
        tester.addEqualityGroup(new Object[]{Mutation.newReplaceBuilder((String)"T1").build()});
        tester.addEqualityGroup(new Object[]{Mutation.newInsertBuilder((String)"T2").build()});
        tester.addEqualityGroup(new Object[]{((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"T1").set("C").to("V")).build(), ((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"T1").set("C").to("V")).build()});
        tester.addEqualityGroup(new Object[]{Mutation.delete((String)"T1", (KeySet)KeySet.all())});
        tester.addEqualityGroup(new Object[]{Mutation.delete((String)"T1", (KeySet)KeySet.singleKey((Key)Key.of((Object[])new Object[]{"k"}))), Mutation.delete((String)"T1", (Key)Key.of((Object[])new Object[]{"k"}))});
        tester.addEqualityGroup(new Object[]{((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"T1").set("C").to(Double.NaN)).build(), ((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"T1").set("C").to(Value.float64((double)Double.NaN))).build(), ((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"T1").set("C").to(Double.NaN)).build(), ((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"T1").set("C").to(Value.float64((double)Double.NaN))).build()});
        tester.addEqualityGroup(new Object[]{((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"T1").set("C").toFloat64Array(new double[]{Double.NaN})).build(), ((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"T1").set("C").toFloat64Array(new double[]{Double.NaN})).build(), ((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"T1").set("C").toFloat64Array(new double[]{Double.NaN}, 0, 1)).build(), ((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"T1").set("C").toFloat64Array(new double[]{Double.NaN}, 0, 1)).build(), ((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"T1").set("C").toFloat64Array(Collections.singletonList(Double.NaN))).build(), ((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"T1").set("C").toFloat64Array(Collections.singletonList(Double.NaN))).build(), ((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"T1").set("C").to(Value.float64Array((double[])new double[]{Double.NaN}))).build(), ((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"T1").set("C").to(Value.float64Array((double[])new double[]{Double.NaN}))).build(), ((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"T1").set("C").to(Value.float64Array((double[])new double[]{Double.NaN}, (int)0, (int)1))).build(), ((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"T1").set("C").to(Value.float64Array((double[])new double[]{Double.NaN}, (int)0, (int)1))).build(), ((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"T1").set("C").to(Value.float64Array(Collections.singletonList(Double.NaN)))).build(), ((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"T1").set("C").to(Value.float64Array(Collections.singletonList(Double.NaN)))).build()});
        tester.addEqualityGroup(new Object[]{((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"T1").set("C").toFloat64Array(Arrays.asList(null, Double.NaN))).build(), ((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"T1").set("C").toFloat64Array(Arrays.asList(null, Double.NaN))).build()});
        tester.testEquals();
    }

    @Test
    public void serializationBasic() {
        List<Mutation> mutations = Arrays.asList(((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"T").set("C").to("V")).build(), ((Mutation.WriteBuilder)Mutation.newUpdateBuilder((String)"T").set("C").to("V")).build(), ((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"T").set("C").to("V")).build(), ((Mutation.WriteBuilder)Mutation.newReplaceBuilder((String)"T").set("C").to("V")).build(), Mutation.delete((String)"T", (KeySet)KeySet.singleKey((Key)Key.of((Object[])new Object[]{"k"}))));
        ArrayList<com.google.spanner.v1.Mutation> proto = new ArrayList<com.google.spanner.v1.Mutation>();
        com.google.spanner.v1.Mutation existingProto = com.google.spanner.v1.Mutation.getDefaultInstance();
        proto.add(existingProto);
        Mutation.toProto(mutations, proto);
        Truth.assertThat((Integer)proto.size()).isAtLeast((Comparable)Integer.valueOf(1));
        Truth.assertThat(proto.get(0)).isSameInstanceAs((Object)existingProto);
        proto.remove(0);
        Truth.assertThat((Integer)proto.size()).isEqualTo((Object)5);
        MatcherAssert.assertThat((Object)((com.google.spanner.v1.Mutation)proto.get(0)), MutationTest.matchesProto("insert { table: 'T' columns: 'C' values { values { string_value: 'V' } } }"));
        MatcherAssert.assertThat((Object)((com.google.spanner.v1.Mutation)proto.get(1)), MutationTest.matchesProto("update { table: 'T' columns: 'C' values { values { string_value: 'V' } } }"));
        MatcherAssert.assertThat((Object)((com.google.spanner.v1.Mutation)proto.get(2)), MutationTest.matchesProto("insert_or_update { table: 'T' columns: 'C' values { values { string_value: 'V' } } }"));
        MatcherAssert.assertThat((Object)((com.google.spanner.v1.Mutation)proto.get(3)), MutationTest.matchesProto("replace { table: 'T' columns: 'C' values { values { string_value: 'V' } } }"));
        MatcherAssert.assertThat((Object)((com.google.spanner.v1.Mutation)proto.get(4)), MutationTest.matchesProto("delete { table: 'T' key_set { keys { values { string_value: 'k' } } } }"));
    }

    @Test
    public void toProtoCoalescingChangeOfTable() {
        List<Mutation> mutations = Arrays.asList(((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"T1").set("C").to("V1")).build(), ((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"T1").set("C").to("V2")).build(), ((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"T1").set("C").to("V3")).build(), ((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"T2").set("C").to("V4")).build(), ((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"T2").set("C").to("V5")).build());
        ArrayList proto = new ArrayList();
        Mutation.toProto(mutations, proto);
        Truth.assertThat((Integer)proto.size()).isEqualTo((Object)2);
        MatcherAssert.assertThat((Object)((com.google.spanner.v1.Mutation)proto.get(0)), MutationTest.matchesProto("insert { table: 'T1' columns: 'C' values { values { string_value: 'V1' } } values { values { string_value: 'V2' } } values { values { string_value: 'V3' } } }"));
        MatcherAssert.assertThat((Object)((com.google.spanner.v1.Mutation)proto.get(1)), MutationTest.matchesProto("insert { table: 'T2' columns: 'C' values { values { string_value: 'V4' } } values { values { string_value: 'V5' } } }"));
    }

    @Test
    public void toProtoCoalescingChangeOfOperation() {
        List<Mutation> mutations = Arrays.asList(((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"T").set("C").to("V1")).build(), ((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"T").set("C").to("V2")).build(), ((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"T").set("C").to("V3")).build(), ((Mutation.WriteBuilder)Mutation.newUpdateBuilder((String)"T").set("C").to("V4")).build(), ((Mutation.WriteBuilder)Mutation.newUpdateBuilder((String)"T").set("C").to("V5")).build());
        ArrayList proto = new ArrayList();
        Mutation.toProto(mutations, proto);
        Truth.assertThat((Integer)proto.size()).isEqualTo((Object)2);
        MatcherAssert.assertThat((Object)((com.google.spanner.v1.Mutation)proto.get(0)), MutationTest.matchesProto("insert { table: 'T' columns: 'C' values { values { string_value: 'V1' } } values { values { string_value: 'V2' } } values { values { string_value: 'V3' } } }"));
        MatcherAssert.assertThat((Object)((com.google.spanner.v1.Mutation)proto.get(1)), MutationTest.matchesProto("update { table: 'T' columns: 'C' values { values { string_value: 'V4' } } values { values { string_value: 'V5' } } }"));
    }

    @Test
    public void toProtoCoalescingChangeOfColumn() {
        List<Mutation> mutations = Arrays.asList(((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"T").set("C1").to("V1")).build(), ((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"T").set("C1").to("V2")).build(), ((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"T").set("C1").to("V3")).build(), ((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"T").set("C2").to("V4")).build(), ((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"T").set("C2").to("V5")).build());
        ArrayList proto = new ArrayList();
        Mutation.toProto(mutations, proto);
        Truth.assertThat((Integer)proto.size()).isEqualTo((Object)2);
        MatcherAssert.assertThat((Object)((com.google.spanner.v1.Mutation)proto.get(0)), MutationTest.matchesProto("insert { table: 'T' columns: 'C1' values { values { string_value: 'V1' } } values { values { string_value: 'V2' } } values { values { string_value: 'V3' } } }"));
        MatcherAssert.assertThat((Object)((com.google.spanner.v1.Mutation)proto.get(1)), MutationTest.matchesProto("insert { table: 'T' columns: 'C2' values { values { string_value: 'V4' } } values { values { string_value: 'V5' } } }"));
    }

    @Test
    public void toProtoCoalescingDelete() {
        List<Mutation> mutations = Arrays.asList(Mutation.delete((String)"T", (Key)Key.of((Object[])new Object[]{"k1"})), Mutation.delete((String)"T", (Key)Key.of((Object[])new Object[]{"k2"})), Mutation.delete((String)"T", (KeySet)KeySet.range((KeyRange)KeyRange.closedOpen((Key)Key.of((Object[])new Object[]{"ka"}), (Key)Key.of((Object[])new Object[]{"kb"})))), Mutation.delete((String)"T", (KeySet)KeySet.range((KeyRange)KeyRange.closedClosed((Key)Key.of((Object[])new Object[]{"kc"}), (Key)Key.of((Object[])new Object[]{"kd"})))));
        ArrayList proto = new ArrayList();
        Mutation.toProto(mutations, proto);
        Truth.assertThat((Integer)proto.size()).isEqualTo((Object)1);
        MatcherAssert.assertThat((Object)((com.google.spanner.v1.Mutation)proto.get(0)), MutationTest.matchesProto("delete {  table: 'T'  key_set {    keys { values { string_value: 'k1' } }    keys { values { string_value: 'k2' } }    ranges { start_closed { values { string_value: 'ka' } }              end_open { values { string_value: 'kb' } } }    ranges { start_closed { values { string_value: 'kc' } }              end_closed { values { string_value: 'kd' } } }  }} "));
    }

    @Test
    public void toProtoCoalescingDeleteChanges() {
        List<Mutation> mutations = Arrays.asList(((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"T1").set("C").to("V1")).build(), Mutation.delete((String)"T1", (Key)Key.of((Object[])new Object[]{"k1"})), Mutation.delete((String)"T1", (Key)Key.of((Object[])new Object[]{"k2"})), Mutation.delete((String)"T2", (Key)Key.of((Object[])new Object[]{"k3"})), Mutation.delete((String)"T2", (Key)Key.of((Object[])new Object[]{"k4"})), ((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"T2").set("C").to("V1")).build());
        ArrayList proto = new ArrayList();
        Mutation.toProto(mutations, proto);
        Truth.assertThat((Integer)proto.size()).isEqualTo((Object)4);
        MatcherAssert.assertThat((Object)((com.google.spanner.v1.Mutation)proto.get(0)), MutationTest.matchesProto("insert { table: 'T1' columns: 'C' values { values { string_value: 'V1' } } }"));
        MatcherAssert.assertThat((Object)((com.google.spanner.v1.Mutation)proto.get(1)), MutationTest.matchesProto("delete { table: 'T1' key_set { keys { values { string_value: 'k1' } } keys { values { string_value: 'k2' } } } }"));
        MatcherAssert.assertThat((Object)((com.google.spanner.v1.Mutation)proto.get(2)), MutationTest.matchesProto("delete { table: 'T2' key_set { keys { values { string_value: 'k3' } } keys { values { string_value: 'k4' } } } }"));
        MatcherAssert.assertThat((Object)((com.google.spanner.v1.Mutation)proto.get(3)), MutationTest.matchesProto("insert { table: 'T2', columns: 'C', values { values { string_value: 'V1' } } }"));
    }

    @Test
    public void javaSerialization() {
        SerializableTester.reserializeAndAssert((Object)this.appendAllTypes(Mutation.newInsertBuilder((String)"test")).build());
        SerializableTester.reserializeAndAssert((Object)this.appendAllTypes(Mutation.newUpdateBuilder((String)"test")).build());
        SerializableTester.reserializeAndAssert((Object)this.appendAllTypes(Mutation.newReplaceBuilder((String)"test")).build());
        SerializableTester.reserializeAndAssert((Object)this.appendAllTypes(Mutation.newInsertOrUpdateBuilder((String)"test")).build());
        SerializableTester.reserializeAndAssert((Object)Mutation.delete((String)"test", (Key)Key.of((Object[])new Object[]{"one", 2, null, true, 2.3, ByteArray.fromBase64((String)"abcd"), Timestamp.ofTimeSecondsAndNanos((long)1L, (int)2), Date.fromYearMonthDay((int)2017, (int)4, (int)17)})));
        SerializableTester.reserializeAndAssert((Object)Mutation.delete((String)"test", (KeySet)KeySet.all()));
        SerializableTester.reserializeAndAssert((Object)Mutation.delete((String)"test", (KeySet)KeySet.newBuilder().addRange(KeyRange.closedClosed((Key)Key.of((Object[])new Object[]{"one", 2, null}), (Key)Key.of((Object[])new Object[]{"two", 3, null}))).build()));
        SerializableTester.reserializeAndAssert((Object)Mutation.delete((String)"test", (KeySet)KeySet.newBuilder().addRange(KeyRange.closedOpen((Key)Key.of((Object[])new Object[]{"one", 2, null}), (Key)Key.of((Object[])new Object[]{"two", 3, null}))).build()));
        SerializableTester.reserializeAndAssert((Object)Mutation.delete((String)"test", (KeySet)KeySet.newBuilder().addRange(KeyRange.openClosed((Key)Key.of((Object[])new Object[]{"one", 2, null}), (Key)Key.of((Object[])new Object[]{"two", 3, null}))).build()));
        SerializableTester.reserializeAndAssert((Object)Mutation.delete((String)"test", (KeySet)KeySet.newBuilder().addRange(KeyRange.openOpen((Key)Key.of((Object[])new Object[]{"one", 2, null}), (Key)Key.of((Object[])new Object[]{"two", 3, null}))).build()));
    }

    private Mutation.WriteBuilder appendAllTypes(Mutation.WriteBuilder builder) {
        return (Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)builder.set("bool").to(true)).set("boolNull").to((Boolean)null)).set("boolValue").to(Value.bool((boolean)false))).set("int").to(42L)).set("intNull").to((Long)null)).set("intValue").to(Value.int64((long)1L))).set("float").to(42.1)).set("floatNull").to((Double)null)).set("floatValue").to(Value.float64((double)10.0))).set("string").to("str")).set("stringNull").to((String)null)).set("stringValue").to(Value.string((String)"strValue"))).set("bigDecimal").to(BigDecimal.valueOf(123L, 2))).set("bigDecimalNull").to((BigDecimal)null)).set("bigDecimalValueAsNumeric").to(Value.numeric((BigDecimal)BigDecimal.TEN))).set("pgNumericValue").to(Value.pgNumeric((String)"4.2"))).set("json").to(Value.json((String)"{\"key\": \"value\"}}"))).set("jsonNull").to(Value.json(null))).set("pgJsonb").to(Value.pgJsonb((String)"{\"key\": \"value\"}}"))).set("pgJsonbNull").to(Value.pgJsonb(null))).set("timestamp").to(Timestamp.MAX_VALUE)).set("timestampNull").to((Timestamp)null)).set("timestampValue").to(Value.timestamp((Timestamp)Timestamp.MIN_VALUE))).set("date").to(Date.fromYearMonthDay((int)2017, (int)4, (int)17))).set("dateNull").to((Date)null)).set("dateValue").to(Value.date((Date)Date.fromYearMonthDay((int)2021, (int)1, (int)2)))).set("boolArr").toBoolArray(new boolean[]{true, false})).set("boolArrNull").toBoolArray((boolean[])null)).set("boolArrValue").to(Value.boolArray((Iterable)ImmutableList.of((Object)false, (Object)true)))).set("intArr").toInt64Array(new long[]{1L, 2L, 3L})).set("intArrNull").toInt64Array((long[])null)).set("intArrValue").to(Value.int64Array((Iterable)ImmutableList.of((Object)1L, (Object)2L)))).set("floatArr").toFloat64Array(new double[]{1.1, 2.2, 3.3})).set("floatArrNull").toFloat64Array((double[])null)).set("floatArrValue").to(Value.float64Array((Iterable)ImmutableList.of((Object)10.1, (Object)10.2, (Object)10.3)))).set("stringArr").toStringArray((Iterable)ImmutableList.of((Object)"one", (Object)"two"))).set("stringArrNull").toStringArray(null)).set("stringArrValue").to(Value.stringArray((Iterable)ImmutableList.of((Object)"uno", (Object)"dos")))).set("numericArr").toNumericArray((Iterable)ImmutableList.of((Object)BigDecimal.ONE, (Object)BigDecimal.TEN))).set("numericArrNull").toNumericArray(null)).set("numericArrValue").to(Value.numericArray((Iterable)ImmutableList.of((Object)BigDecimal.ZERO, (Object)BigDecimal.valueOf(234L, 2))))).set("pgNumericArr").toPgNumericArray((Iterable)ImmutableList.of((Object)"1.23", (Object)"2.34"))).set("pgNumericArrNull").toPgNumericArray(null)).set("pgNumericArrValue").to(Value.pgNumericArray((Iterable)ImmutableList.of((Object)"10.20", (Object)"20.30")))).set("jsonArr").toJsonArray((Iterable)ImmutableList.of((Object)"{\"key\": \"value1\"}}", (Object)"{\"key\": \"value2\"}"))).set("jsonArrNull").toJsonArray(null)).set("jsonArrValue").to(Value.jsonArray((Iterable)ImmutableList.of((Object)"{\"key\": \"value1\"}}", (Object)"{\"key\": \"value2\"}")))).set("pgJsonbArr").toPgJsonbArray((Iterable)ImmutableList.of((Object)"{\"key\": \"value1\"}}", (Object)"{\"key\": \"value2\"}"))).set("pgJsonbArrNull").toPgJsonbArray(null)).set("pgJsonbArrValue").to(Value.pgJsonbArray((Iterable)ImmutableList.of((Object)"{\"key\": \"value1\"}}", (Object)"{\"key\": \"value2\"}")))).set("timestampArr").toTimestampArray((Iterable)ImmutableList.of((Object)Timestamp.MAX_VALUE, (Object)Timestamp.MAX_VALUE))).set("timestampArrNull").toTimestampArray(null)).set("timestampArrValue").to(Value.timestampArray((Iterable)ImmutableList.of((Object)Timestamp.MIN_VALUE, (Object)Timestamp.MAX_VALUE)))).set("dateArr").toDateArray((Iterable)ImmutableList.of((Object)Date.fromYearMonthDay((int)2017, (int)4, (int)17), (Object)Date.fromYearMonthDay((int)2017, (int)4, (int)18)))).set("dateArrNull").toDateArray(null)).set("dateArrValue").to(Value.dateArray((Iterable)ImmutableList.of((Object)Date.fromYearMonthDay((int)2021, (int)1, (int)2), (Object)Date.fromYearMonthDay((int)2022, (int)2, (int)3))));
    }

    static Matcher<com.google.spanner.v1.Mutation> matchesProto(String expected) {
        return SpannerMatchers.matchesProto(com.google.spanner.v1.Mutation.class, expected);
    }
}

