/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.ApiFutures;
import com.google.cloud.Timestamp;
import com.google.cloud.grpc.GrpcTransportOptions;
import com.google.cloud.spanner.BaseSessionPoolTest;
import com.google.cloud.spanner.CommitResponse;
import com.google.cloud.spanner.DatabaseClientImpl;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.MetricRegistryConstants;
import com.google.cloud.spanner.MetricRegistryTestUtils;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Session;
import com.google.cloud.spanner.SessionClient;
import com.google.cloud.spanner.SessionImpl;
import com.google.cloud.spanner.SessionNotFoundException;
import com.google.cloud.spanner.SessionPool;
import com.google.cloud.spanner.SessionPoolOptions;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.SpannerExceptionFactoryTest;
import com.google.cloud.spanner.SpannerImpl;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.TransactionContext;
import com.google.cloud.spanner.TransactionRunner;
import com.google.cloud.spanner.TransactionRunnerImpl;
import com.google.cloud.spanner.spi.v1.SpannerRpc;
import com.google.common.truth.Truth;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.Uninterruptibles;
import com.google.protobuf.ByteString;
import com.google.protobuf.Empty;
import com.google.spanner.v1.CommitRequest;
import com.google.spanner.v1.ExecuteBatchDmlRequest;
import com.google.spanner.v1.ExecuteSqlRequest;
import com.google.spanner.v1.ResultSetStats;
import com.google.spanner.v1.RollbackRequest;
import io.opencensus.metrics.LabelValue;
import io.opencensus.metrics.MetricRegistry;
import io.opencensus.trace.Span;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

@RunWith(value=Parameterized.class)
public class SessionPoolTest
extends BaseSessionPoolTest {
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    @Parameterized.Parameter
    public int minSessions;
    @Mock
    SpannerImpl client;
    @Mock
    SessionClient sessionClient;
    @Mock
    SpannerOptions spannerOptions;
    DatabaseId db = DatabaseId.of((String)"projects/p/instances/i/databases/unused");
    SessionPool pool;
    SessionPoolOptions options;
    private String sessionName = String.format("%s/sessions/s", this.db.getName());
    private String TEST_DATABASE_ROLE = "my-role";

    @Parameterized.Parameters(name="min sessions = {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({0}, {1});
    }

    private SessionPool createPool() {
        return SessionPool.createPool((SessionPoolOptions)this.options, (GrpcTransportOptions.ExecutorFactory)new BaseSessionPoolTest.TestExecutorFactory(), (SessionClient)this.client.getSessionClient(this.db));
    }

    private SessionPool createPool(SessionPool.Clock clock) {
        return SessionPool.createPool((SessionPoolOptions)this.options, (GrpcTransportOptions.ExecutorFactory)new BaseSessionPoolTest.TestExecutorFactory(), (SessionClient)this.client.getSessionClient(this.db), (SessionPool.Clock)clock);
    }

    private SessionPool createPool(SessionPool.Clock clock, MetricRegistry metricRegistry, List<LabelValue> labelValues) {
        return SessionPool.createPool((SessionPoolOptions)this.options, (String)this.TEST_DATABASE_ROLE, (GrpcTransportOptions.ExecutorFactory)new BaseSessionPoolTest.TestExecutorFactory(), (SessionClient)this.client.getSessionClient(this.db), (SessionPool.Clock)clock, (MetricRegistry)metricRegistry, labelValues);
    }

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)((SpannerOptions)this.client.getOptions())).thenReturn((Object)this.spannerOptions);
        Mockito.when((Object)this.client.getSessionClient(this.db)).thenReturn((Object)this.sessionClient);
        Mockito.when((Object)this.spannerOptions.getNumChannels()).thenReturn((Object)4);
        Mockito.when((Object)this.spannerOptions.getDatabaseRole()).thenReturn((Object)"role");
        this.options = SessionPoolOptions.newBuilder().setMinSessions(this.minSessions).setMaxSessions(2).setIncStep(1).setBlockIfPoolExhausted().build();
    }

    private void setupMockSessionCreation() {
        ((SessionClient)Mockito.doAnswer(invocation -> {
            this.executor.submit(() -> {
                int sessionCount = (Integer)invocation.getArgument(0, Integer.class);
                SessionPool.SessionConsumerImpl consumer = (SessionPool.SessionConsumerImpl)invocation.getArgument(2, SessionPool.SessionConsumerImpl.class);
                for (int i = 0; i < sessionCount; ++i) {
                    consumer.onSessionReady(this.mockSession());
                }
            });
            return null;
        }).when((Object)this.sessionClient)).asyncBatchCreateSessions(Mockito.anyInt(), Mockito.anyBoolean(), (SessionClient.SessionConsumer)Mockito.any(SessionClient.SessionConsumer.class));
    }

    @Test
    public void testClosedPoolIncludesClosedException() {
        this.pool = this.createPool();
        Assert.assertTrue((boolean)this.pool.isValid());
        this.closePoolWithStacktrace();
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> this.pool.getSession());
        Truth.assertThat((Throwable)e.getCause()).isInstanceOf(SpannerImpl.ClosedException.class);
        StringWriter sw = new StringWriter();
        e.getCause().printStackTrace(new PrintWriter(sw));
        Truth.assertThat((String)sw.toString()).contains((CharSequence)"closePoolWithStacktrace");
    }

    private void closePoolWithStacktrace() {
        this.pool.closeAsync(new SpannerImpl.ClosedException());
    }

    @Test
    public void sessionCreation() {
        this.setupMockSessionCreation();
        this.pool = this.createPool();
        try (SessionPool.PooledSessionFuture session = this.pool.getSession();){
            Truth.assertThat((Object)session).isNotNull();
        }
    }

    @Test
    public void poolLifo() {
        this.setupMockSessionCreation();
        this.pool = this.createPool();
        SessionPool.PooledSession session1 = this.pool.getSession().get();
        SessionPool.PooledSession session2 = this.pool.getSession().get();
        Truth.assertThat((Object)session1).isNotEqualTo((Object)session2);
        session2.close();
        session1.close();
        SessionPool.PooledSession session3 = this.pool.getSession().get();
        SessionPool.PooledSession session4 = this.pool.getSession().get();
        Truth.assertThat((Object)session3).isEqualTo((Object)session1);
        Truth.assertThat((Object)session4).isEqualTo((Object)session2);
        session3.close();
        session4.close();
    }

    @Test
    public void poolClosure() throws Exception {
        this.setupMockSessionCreation();
        this.pool = this.createPool();
        this.pool.closeAsync(new SpannerImpl.ClosedException()).get(5L, TimeUnit.SECONDS);
    }

    @Test
    public void poolClosureClosesLeakedSessions() throws Exception {
        SessionImpl mockSession1 = this.mockSession();
        SessionImpl mockSession2 = this.mockSession();
        LinkedList<SessionImpl> sessions = new LinkedList<SessionImpl>(Arrays.asList(mockSession1, mockSession2));
        ((SessionClient)Mockito.doAnswer(invocation -> {
            this.executor.submit(() -> {
                SessionPool.SessionConsumerImpl consumer = (SessionPool.SessionConsumerImpl)invocation.getArgument(2, SessionPool.SessionConsumerImpl.class);
                consumer.onSessionReady((SessionImpl)sessions.pop());
            });
            return null;
        }).when((Object)this.sessionClient)).asyncBatchCreateSessions(Mockito.eq((int)1), Mockito.anyBoolean(), (SessionClient.SessionConsumer)Mockito.any(SessionClient.SessionConsumer.class));
        this.pool = this.createPool();
        SessionPool.PooledSessionFuture session1 = this.pool.getSession();
        SessionPool.PooledSessionFuture leakedSession = this.pool.getSession();
        leakedSession.clearLeakedException();
        session1.close();
        this.pool.closeAsync(new SpannerImpl.ClosedException()).get(5L, TimeUnit.SECONDS);
        ((SessionImpl)Mockito.verify((Object)mockSession1)).asyncClose();
        ((SessionImpl)Mockito.verify((Object)mockSession2)).asyncClose();
    }

    @Test
    public void poolClosesWhenMaintenanceLoopIsRunning() throws Exception {
        this.setupMockSessionCreation();
        BaseSessionPoolTest.FakeClock clock = new BaseSessionPoolTest.FakeClock();
        this.pool = this.createPool(clock);
        AtomicBoolean stop = new AtomicBoolean(false);
        new Thread(() -> {
            while (!stop.get()) {
                this.runMaintenanceLoop(clock, this.pool, 1L);
            }
        }).start();
        this.pool.closeAsync(new SpannerImpl.ClosedException()).get(5L, TimeUnit.SECONDS);
        stop.set(true);
    }

    @Test
    public void poolClosureFailsPendingReadWaiters() throws Exception {
        CountDownLatch insideCreation = new CountDownLatch(1);
        CountDownLatch releaseCreation = new CountDownLatch(1);
        SessionImpl session1 = this.mockSession();
        SessionImpl session2 = this.mockSession();
        ((SessionClient)Mockito.doAnswer(invocation -> {
            this.executor.submit(() -> {
                SessionPool.SessionConsumerImpl consumer = (SessionPool.SessionConsumerImpl)invocation.getArgument(2, SessionPool.SessionConsumerImpl.class);
                consumer.onSessionReady(session1);
            });
            return null;
        }).doAnswer(invocation -> {
            this.executor.submit(() -> {
                insideCreation.countDown();
                releaseCreation.await();
                SessionPool.SessionConsumerImpl consumer = (SessionPool.SessionConsumerImpl)invocation.getArgument(2, SessionPool.SessionConsumerImpl.class);
                consumer.onSessionReady(session2);
                return null;
            });
            return null;
        }).when((Object)this.sessionClient)).asyncBatchCreateSessions(Mockito.eq((int)1), Mockito.anyBoolean(), (SessionClient.SessionConsumer)Mockito.any(SessionClient.SessionConsumer.class));
        this.pool = this.createPool();
        SessionPool.PooledSessionFuture leakedSession = this.pool.getSession();
        leakedSession.clearLeakedException();
        AtomicBoolean failed = new AtomicBoolean(false);
        CountDownLatch latch = new CountDownLatch(1);
        this.getSessionAsync(latch, failed);
        insideCreation.await();
        this.pool.closeAsync(new SpannerImpl.ClosedException());
        releaseCreation.countDown();
        latch.await(5L, TimeUnit.SECONDS);
        Truth.assertThat((Boolean)failed.get()).isTrue();
    }

    @Test
    public void poolClosureFailsPendingWriteWaiters() throws Exception {
        CountDownLatch insideCreation = new CountDownLatch(1);
        CountDownLatch releaseCreation = new CountDownLatch(1);
        SessionImpl session1 = this.mockSession();
        SessionImpl session2 = this.mockSession();
        ((SessionClient)Mockito.doAnswer(invocation -> {
            this.executor.submit(() -> {
                SessionPool.SessionConsumerImpl consumer = (SessionPool.SessionConsumerImpl)invocation.getArgument(2, SessionPool.SessionConsumerImpl.class);
                consumer.onSessionReady(session1);
            });
            return null;
        }).doAnswer(invocation -> {
            this.executor.submit(() -> {
                insideCreation.countDown();
                releaseCreation.await();
                SessionPool.SessionConsumerImpl consumer = (SessionPool.SessionConsumerImpl)invocation.getArgument(2, SessionPool.SessionConsumerImpl.class);
                consumer.onSessionReady(session2);
                return null;
            });
            return null;
        }).when((Object)this.sessionClient)).asyncBatchCreateSessions(Mockito.eq((int)1), Mockito.anyBoolean(), (SessionClient.SessionConsumer)Mockito.any(SessionClient.SessionConsumer.class));
        this.pool = this.createPool();
        SessionPool.PooledSessionFuture leakedSession = this.pool.getSession();
        leakedSession.clearLeakedException();
        AtomicBoolean failed = new AtomicBoolean(false);
        CountDownLatch latch = new CountDownLatch(1);
        this.getSessionAsync(latch, failed);
        insideCreation.await();
        this.pool.closeAsync(new SpannerImpl.ClosedException());
        releaseCreation.countDown();
        latch.await();
        Truth.assertThat((Boolean)failed.get()).isTrue();
    }

    @Test
    public void poolClosesEvenIfCreationFails() throws Exception {
        CountDownLatch insideCreation = new CountDownLatch(1);
        CountDownLatch releaseCreation = new CountDownLatch(1);
        ((SessionClient)Mockito.doAnswer(invocation -> {
            this.executor.submit(() -> {
                insideCreation.countDown();
                releaseCreation.await();
                SessionPool.SessionConsumerImpl consumer = (SessionPool.SessionConsumerImpl)invocation.getArgument(2, SessionPool.SessionConsumerImpl.class);
                consumer.onSessionCreateFailure((Throwable)SpannerExceptionFactory.newSpannerException((Throwable)new RuntimeException()), 1);
                return null;
            });
            return null;
        }).when((Object)this.sessionClient)).asyncBatchCreateSessions(Mockito.eq((int)1), Mockito.anyBoolean(), (SessionClient.SessionConsumer)Mockito.any(SessionClient.SessionConsumer.class));
        this.pool = this.createPool();
        AtomicBoolean failed = new AtomicBoolean(false);
        CountDownLatch latch = new CountDownLatch(1);
        this.getSessionAsync(latch, failed);
        insideCreation.await();
        ListenableFuture f = this.pool.closeAsync(new SpannerImpl.ClosedException());
        releaseCreation.countDown();
        f.get();
        Truth.assertThat((Boolean)f.isDone()).isTrue();
    }

    @Test
    public void poolClosureFailsNewRequests() {
        SessionImpl session = this.mockSession();
        ((SessionClient)Mockito.doAnswer(invocation -> {
            this.executor.submit(() -> {
                SessionPool.SessionConsumerImpl consumer = (SessionPool.SessionConsumerImpl)invocation.getArgument(2, SessionPool.SessionConsumerImpl.class);
                consumer.onSessionReady(session);
            });
            return null;
        }).when((Object)this.sessionClient)).asyncBatchCreateSessions(Mockito.eq((int)1), Mockito.anyBoolean(), (SessionClient.SessionConsumer)Mockito.any(SessionClient.SessionConsumer.class));
        this.pool = this.createPool();
        SessionPool.PooledSessionFuture leakedSession = this.pool.getSession();
        leakedSession.get();
        leakedSession.clearLeakedException();
        this.pool.closeAsync(new SpannerImpl.ClosedException());
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> this.pool.getSession());
        Assert.assertNotNull((Object)e.getMessage());
    }

    @Test
    public void atMostMaxSessionsCreated() {
        this.setupMockSessionCreation();
        AtomicBoolean failed = new AtomicBoolean(false);
        this.pool = this.createPool();
        int numSessions = 10;
        CountDownLatch latch = new CountDownLatch(numSessions);
        for (int i = 0; i < numSessions; ++i) {
            this.getSessionAsync(latch, failed);
        }
        Uninterruptibles.awaitUninterruptibly((CountDownLatch)latch);
        ((SessionClient)Mockito.verify((Object)this.sessionClient, (VerificationMode)Mockito.atMost((int)this.options.getMaxSessions()))).asyncBatchCreateSessions(Mockito.eq((int)1), Mockito.anyBoolean(), (SessionClient.SessionConsumer)Mockito.any(SessionClient.SessionConsumer.class));
        Truth.assertThat((Boolean)failed.get()).isFalse();
    }

    @Test
    public void creationExceptionPropagatesToReadSession() {
        ((SessionClient)Mockito.doAnswer(invocation -> {
            this.executor.submit(() -> {
                SessionPool.SessionConsumerImpl consumer = (SessionPool.SessionConsumerImpl)invocation.getArgument(2, SessionPool.SessionConsumerImpl.class);
                consumer.onSessionCreateFailure((Throwable)SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INTERNAL, (String)""), 1);
                return null;
            });
            return null;
        }).when((Object)this.sessionClient)).asyncBatchCreateSessions(Mockito.eq((int)1), Mockito.anyBoolean(), (SessionClient.SessionConsumer)Mockito.any(SessionClient.SessionConsumer.class));
        this.pool = this.createPool();
        SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> this.pool.getSession().get());
        Assert.assertEquals((Object)ErrorCode.INTERNAL, (Object)e.getErrorCode());
    }

    @Test
    public void failOnPoolExhaustion() {
        this.options = SessionPoolOptions.newBuilder().setMinSessions(1).setMaxSessions(1).setFailIfPoolExhausted().build();
        ((SessionClient)Mockito.doAnswer(invocation -> {
            this.executor.submit(() -> {
                SessionPool.SessionConsumerImpl consumer = (SessionPool.SessionConsumerImpl)invocation.getArgument(2, SessionPool.SessionConsumerImpl.class);
                consumer.onSessionReady(this.mockSession());
            });
            return null;
        }).when((Object)this.sessionClient)).asyncBatchCreateSessions(Mockito.eq((int)1), Mockito.anyBoolean(), (SessionClient.SessionConsumer)Mockito.any(SessionClient.SessionConsumer.class));
        this.pool = this.createPool();
        SessionPool.PooledSessionFuture session1 = this.pool.getSession();
        SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> this.pool.getSession());
        Assert.assertEquals((Object)ErrorCode.RESOURCE_EXHAUSTED, (Object)e.getErrorCode());
        session1.close();
        session1 = this.pool.getSession();
        Truth.assertThat((Object)session1).isNotNull();
        session1.close();
    }

    @Test
    public void idleSessionCleanup() throws Exception {
        this.options = SessionPoolOptions.newBuilder().setMinSessions(1).setMaxSessions(3).setIncStep(1).setMaxIdleSessions(0).build();
        SessionImpl session1 = this.mockSession();
        SessionImpl session2 = this.mockSession();
        SessionImpl session3 = this.mockSession();
        LinkedList<SessionImpl> sessions = new LinkedList<SessionImpl>(Arrays.asList(session1, session2, session3));
        ((SessionClient)Mockito.doAnswer(invocation -> {
            this.executor.submit(() -> {
                SessionPool.SessionConsumerImpl consumer = (SessionPool.SessionConsumerImpl)invocation.getArgument(2, SessionPool.SessionConsumerImpl.class);
                consumer.onSessionReady((SessionImpl)sessions.pop());
            });
            return null;
        }).when((Object)this.sessionClient)).asyncBatchCreateSessions(Mockito.eq((int)1), Mockito.anyBoolean(), (SessionClient.SessionConsumer)Mockito.any(SessionClient.SessionConsumer.class));
        for (SessionImpl session : sessions) {
            this.mockKeepAlive((Session)session);
        }
        BaseSessionPoolTest.FakeClock clock = new BaseSessionPoolTest.FakeClock();
        clock.currentTimeMillis = System.currentTimeMillis();
        this.pool = this.createPool(clock);
        this.pool.getSession().close();
        this.runMaintenanceLoop(clock, this.pool, this.pool.poolMaintainer.numClosureCycles);
        Truth.assertThat((Long)this.pool.numIdleSessionsRemoved()).isEqualTo((Object)0L);
        SessionPool.PooledSessionFuture readSession1 = this.pool.getSession();
        SessionPool.PooledSessionFuture readSession2 = this.pool.getSession();
        SessionPool.PooledSessionFuture readSession3 = this.pool.getSession();
        readSession1.get();
        readSession2.get();
        readSession3.get();
        readSession1.close();
        readSession2.close();
        readSession3.close();
        this.runMaintenanceLoop(clock, this.pool, this.pool.poolMaintainer.numClosureCycles);
        Truth.assertThat((Long)this.pool.numIdleSessionsRemoved()).isEqualTo((Object)0L);
        this.pool.getSession().close();
        this.pool.getSession().close();
        this.pool.getSession().close();
        long cycles = this.options.getRemoveInactiveSessionAfter().toMillis() / this.pool.poolMaintainer.loopFrequency;
        this.runMaintenanceLoop(clock, this.pool, cycles);
        Truth.assertThat((Long)this.pool.numIdleSessionsRemoved()).isEqualTo((Object)2L);
        this.pool.closeAsync(new SpannerImpl.ClosedException()).get(5L, TimeUnit.SECONDS);
    }

    @Test
    public void keepAlive() throws Exception {
        this.options = SessionPoolOptions.newBuilder().setMinSessions(2).setMaxSessions(3).build();
        SessionImpl session = this.mockSession();
        this.mockKeepAlive((Session)session);
        ((SessionClient)Mockito.doAnswer(invocation -> {
            this.executor.submit(() -> {
                int sessionCount = (Integer)invocation.getArgument(0, Integer.class);
                SessionPool.SessionConsumerImpl consumer = (SessionPool.SessionConsumerImpl)invocation.getArgument(2, SessionPool.SessionConsumerImpl.class);
                for (int i = 0; i < sessionCount; ++i) {
                    consumer.onSessionReady(session);
                }
            });
            return null;
        }).when((Object)this.sessionClient)).asyncBatchCreateSessions(Mockito.anyInt(), Mockito.anyBoolean(), (SessionClient.SessionConsumer)Mockito.any(SessionClient.SessionConsumer.class));
        BaseSessionPoolTest.FakeClock clock = new BaseSessionPoolTest.FakeClock();
        clock.currentTimeMillis = System.currentTimeMillis();
        this.pool = this.createPool(clock);
        SessionPool.PooledSessionFuture session1 = this.pool.getSession();
        SessionPool.PooledSessionFuture session2 = this.pool.getSession();
        session1.get();
        session2.get();
        session1.close();
        session2.close();
        this.runMaintenanceLoop(clock, this.pool, this.pool.poolMaintainer.numKeepAliveCycles);
        ((SessionImpl)Mockito.verify((Object)session, (VerificationMode)Mockito.never())).singleUse((TimestampBound)Mockito.any(TimestampBound.class));
        this.runMaintenanceLoop(clock, this.pool, this.pool.poolMaintainer.numKeepAliveCycles);
        ((SessionImpl)Mockito.verify((Object)session, (VerificationMode)Mockito.times((int)2))).singleUse((TimestampBound)Mockito.any(TimestampBound.class));
        clock.currentTimeMillis += clock.currentTimeMillis + (long)((this.options.getKeepAliveIntervalMinutes() + 5) * 60 * 1000);
        session1 = this.pool.getSession();
        session1.writeAtLeastOnceWithOptions(new ArrayList(), new Options.TransactionOption[0]);
        session1.close();
        this.runMaintenanceLoop(clock, this.pool, this.pool.poolMaintainer.numKeepAliveCycles);
        ((SessionImpl)Mockito.verify((Object)session, (VerificationMode)Mockito.times((int)(this.options.getMinSessions() + this.options.getMaxIdleSessions())))).singleUse((TimestampBound)Mockito.any(TimestampBound.class));
        this.pool.closeAsync(new SpannerImpl.ClosedException()).get(5L, TimeUnit.SECONDS);
    }

    @Test
    public void blockAndTimeoutOnPoolExhaustion() throws Exception {
        this.options = SessionPoolOptions.newBuilder().setMinSessions(this.minSessions).setMaxSessions(1).setInitialWaitForSessionTimeoutMillis(20L).build();
        this.setupMockSessionCreation();
        this.pool = this.createPool();
        SessionPool.PooledSessionFuture checkedOutSession = this.pool.getSession();
        checkedOutSession.get();
        ExecutorService executor = Executors.newFixedThreadPool(1);
        CountDownLatch latch = new CountDownLatch(1);
        Future<Void> fut = executor.submit(() -> {
            latch.countDown();
            SessionPool.PooledSessionFuture session = this.pool.getSession();
            session.close();
            return null;
        });
        latch.await();
        for (int waitCount = 0; this.pool.getNumWaiterTimeouts() == 0L && waitCount < 1000; ++waitCount) {
            Thread.sleep(5L);
        }
        checkedOutSession.close();
        fut.get(10L, TimeUnit.SECONDS);
        executor.shutdown();
        SessionPool.PooledSessionFuture session = this.pool.getSession();
        Truth.assertThat((Object)session).isNotNull();
        session.close();
        Truth.assertThat((Long)this.pool.getNumWaiterTimeouts()).isAtLeast((Comparable)Long.valueOf(1L));
    }

    @Test
    public void testSessionNotFoundSingleUse() {
        Statement statement = Statement.of((String)"SELECT 1");
        SessionImpl closedSession = this.mockSession();
        ReadContext closedContext = (ReadContext)Mockito.mock(ReadContext.class);
        ResultSet closedResultSet = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)closedResultSet.next()).thenThrow(new Throwable[]{SpannerExceptionFactoryTest.newSessionNotFoundException(this.sessionName)});
        Mockito.when((Object)closedContext.executeQuery(statement, new Options.QueryOption[0])).thenReturn((Object)closedResultSet);
        Mockito.when((Object)closedSession.singleUse()).thenReturn((Object)closedContext);
        SessionImpl openSession = this.mockSession();
        ReadContext openContext = (ReadContext)Mockito.mock(ReadContext.class);
        ResultSet openResultSet = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)openResultSet.next()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Mockito.when((Object)openContext.executeQuery(statement, new Options.QueryOption[0])).thenReturn((Object)openResultSet);
        Mockito.when((Object)openSession.singleUse()).thenReturn((Object)openContext);
        ((SessionClient)Mockito.doAnswer(invocation -> {
            this.executor.submit(() -> {
                SessionPool.SessionConsumerImpl consumer = (SessionPool.SessionConsumerImpl)invocation.getArgument(2, SessionPool.SessionConsumerImpl.class);
                consumer.onSessionReady(closedSession);
            });
            return null;
        }).doAnswer(invocation -> {
            this.executor.submit(() -> {
                SessionPool.SessionConsumerImpl consumer = (SessionPool.SessionConsumerImpl)invocation.getArgument(2, SessionPool.SessionConsumerImpl.class);
                consumer.onSessionReady(openSession);
            });
            return null;
        }).when((Object)this.sessionClient)).asyncBatchCreateSessions(Mockito.eq((int)1), Mockito.anyBoolean(), (SessionClient.SessionConsumer)Mockito.any(SessionClient.SessionConsumer.class));
        BaseSessionPoolTest.FakeClock clock = new BaseSessionPoolTest.FakeClock();
        clock.currentTimeMillis = System.currentTimeMillis();
        this.pool = this.createPool(clock);
        ReadContext context = this.pool.getSession().singleUse();
        ResultSet resultSet = context.executeQuery(statement, new Options.QueryOption[0]);
        Truth.assertThat((Boolean)resultSet.next()).isTrue();
    }

    @Test
    public void testSessionNotFoundReadOnlyTransaction() {
        Statement statement = Statement.of((String)"SELECT 1");
        SessionImpl closedSession = this.mockSession();
        Mockito.when((Object)closedSession.readOnlyTransaction()).thenThrow(new Throwable[]{SpannerExceptionFactoryTest.newSessionNotFoundException(this.sessionName)});
        SessionImpl openSession = this.mockSession();
        ReadOnlyTransaction openTransaction = (ReadOnlyTransaction)Mockito.mock(ReadOnlyTransaction.class);
        ResultSet openResultSet = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)openResultSet.next()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Mockito.when((Object)openTransaction.executeQuery(statement, new Options.QueryOption[0])).thenReturn((Object)openResultSet);
        Mockito.when((Object)openSession.readOnlyTransaction()).thenReturn((Object)openTransaction);
        ((SessionClient)Mockito.doAnswer(invocation -> {
            this.executor.submit(() -> {
                SessionPool.SessionConsumerImpl consumer = (SessionPool.SessionConsumerImpl)invocation.getArgument(2, SessionPool.SessionConsumerImpl.class);
                consumer.onSessionReady(closedSession);
            });
            return null;
        }).doAnswer(invocation -> {
            this.executor.submit(() -> {
                SessionPool.SessionConsumerImpl consumer = (SessionPool.SessionConsumerImpl)invocation.getArgument(2, SessionPool.SessionConsumerImpl.class);
                consumer.onSessionReady(openSession);
            });
            return null;
        }).when((Object)this.sessionClient)).asyncBatchCreateSessions(Mockito.eq((int)1), Mockito.anyBoolean(), (SessionClient.SessionConsumer)Mockito.any(SessionClient.SessionConsumer.class));
        BaseSessionPoolTest.FakeClock clock = new BaseSessionPoolTest.FakeClock();
        clock.currentTimeMillis = System.currentTimeMillis();
        this.pool = this.createPool(clock);
        ReadOnlyTransaction transaction = this.pool.getSession().readOnlyTransaction();
        ResultSet resultSet = transaction.executeQuery(statement, new Options.QueryOption[0]);
        Truth.assertThat((Boolean)resultSet.next()).isTrue();
    }

    @Test
    public void testSessionNotFoundReadWriteTransaction() {
        final Statement queryStatement = Statement.of((String)"SELECT 1");
        final Statement updateStatement = Statement.of((String)"UPDATE FOO SET BAR=1 WHERE ID=2");
        SessionNotFoundException sessionNotFound = SpannerExceptionFactoryTest.newSessionNotFoundException(this.sessionName);
        ReadWriteTransactionTestStatementType[] readWriteTransactionTestStatementTypeArray = ReadWriteTransactionTestStatementType.values();
        int n = readWriteTransactionTestStatementTypeArray.length;
        for (int i = 0; i < n; ++i) {
            ReadWriteTransactionTestStatementType statementType;
            final ReadWriteTransactionTestStatementType executeStatementType = statementType = readWriteTransactionTestStatementTypeArray[i];
            SpannerRpc.StreamingCall closedStreamingCall = (SpannerRpc.StreamingCall)Mockito.mock(SpannerRpc.StreamingCall.class);
            ((SpannerRpc.StreamingCall)Mockito.doThrow((Throwable[])new Throwable[]{sessionNotFound}).when((Object)closedStreamingCall)).request(Mockito.anyInt());
            SpannerRpc rpc = (SpannerRpc)Mockito.mock(SpannerRpc.class);
            Mockito.when((Object)rpc.asyncDeleteSession(Mockito.anyString(), Mockito.anyMap())).thenReturn((Object)ApiFutures.immediateFuture((Object)Empty.getDefaultInstance()));
            Mockito.when((Object)rpc.executeQuery((ExecuteSqlRequest)Mockito.any(ExecuteSqlRequest.class), (SpannerRpc.ResultStreamConsumer)Mockito.any(SpannerRpc.ResultStreamConsumer.class), (Map)Mockito.any(Map.class))).thenReturn((Object)closedStreamingCall);
            Mockito.when((Object)rpc.executeQuery((ExecuteSqlRequest)Mockito.any(ExecuteSqlRequest.class), (Map)Mockito.any(Map.class))).thenThrow(new Throwable[]{sessionNotFound});
            Mockito.when((Object)rpc.executeBatchDml((ExecuteBatchDmlRequest)Mockito.any(ExecuteBatchDmlRequest.class), (Map)Mockito.any(Map.class))).thenThrow(new Throwable[]{sessionNotFound});
            Mockito.when((Object)rpc.commitAsync((CommitRequest)Mockito.any(CommitRequest.class), (Map)Mockito.any(Map.class))).thenReturn((Object)ApiFutures.immediateFailedFuture((Throwable)sessionNotFound));
            Mockito.when((Object)rpc.rollbackAsync((RollbackRequest)Mockito.any(RollbackRequest.class), (Map)Mockito.any(Map.class))).thenReturn((Object)ApiFutures.immediateFailedFuture((Throwable)sessionNotFound));
            SessionImpl closedSession = (SessionImpl)Mockito.mock(SessionImpl.class);
            Mockito.when((Object)closedSession.getName()).thenReturn((Object)"projects/dummy/instances/dummy/database/dummy/sessions/session-closed");
            final TransactionRunnerImpl.TransactionContextImpl closedTransactionContext = ((TransactionRunnerImpl.TransactionContextImpl.Builder)((TransactionRunnerImpl.TransactionContextImpl.Builder)TransactionRunnerImpl.TransactionContextImpl.newBuilder().setSession(closedSession)).setOptions(Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[0])).setRpc(rpc)).build();
            Mockito.when((Object)closedSession.asyncClose()).thenReturn((Object)ApiFutures.immediateFuture((Object)Empty.getDefaultInstance()));
            Mockito.when((Object)closedSession.newTransaction(Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[0]))).thenReturn((Object)closedTransactionContext);
            Mockito.when((Object)closedSession.beginTransactionAsync()).thenThrow(new Throwable[]{sessionNotFound});
            TransactionRunnerImpl closedTransactionRunner = new TransactionRunnerImpl(closedSession, new Options.TransactionOption[0]);
            closedTransactionRunner.setSpan((Span)Mockito.mock(Span.class));
            Mockito.when((Object)closedSession.readWriteTransaction(new Options.TransactionOption[0])).thenReturn((Object)closedTransactionRunner);
            SessionImpl openSession = (SessionImpl)Mockito.mock(SessionImpl.class);
            Mockito.when((Object)openSession.asyncClose()).thenReturn((Object)ApiFutures.immediateFuture((Object)Empty.getDefaultInstance()));
            Mockito.when((Object)openSession.getName()).thenReturn((Object)"projects/dummy/instances/dummy/database/dummy/sessions/session-open");
            final TransactionRunnerImpl.TransactionContextImpl openTransactionContext = (TransactionRunnerImpl.TransactionContextImpl)Mockito.mock(TransactionRunnerImpl.TransactionContextImpl.class);
            Mockito.when((Object)openSession.newTransaction(Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[0]))).thenReturn((Object)openTransactionContext);
            Mockito.when((Object)openSession.beginTransactionAsync()).thenReturn((Object)ApiFutures.immediateFuture((Object)ByteString.copyFromUtf8((String)"open-txn")));
            TransactionRunnerImpl openTransactionRunner = new TransactionRunnerImpl(openSession, new Options.TransactionOption[0]);
            openTransactionRunner.setSpan((Span)Mockito.mock(Span.class));
            Mockito.when((Object)openSession.readWriteTransaction(new Options.TransactionOption[0])).thenReturn((Object)openTransactionRunner);
            ResultSet openResultSet = (ResultSet)Mockito.mock(ResultSet.class);
            Mockito.when((Object)openResultSet.next()).thenReturn((Object)true, (Object[])new Boolean[]{false});
            ResultSet planResultSet = (ResultSet)Mockito.mock(ResultSet.class);
            Mockito.when((Object)planResultSet.getStats()).thenReturn((Object)ResultSetStats.getDefaultInstance());
            Mockito.when((Object)openTransactionContext.executeQuery(queryStatement, new Options.QueryOption[0])).thenReturn((Object)openResultSet);
            Mockito.when((Object)openTransactionContext.analyzeQuery(queryStatement, ReadContext.QueryAnalyzeMode.PLAN)).thenReturn((Object)planResultSet);
            Mockito.when((Object)openTransactionContext.executeUpdate(updateStatement, new Options.UpdateOption[0])).thenReturn((Object)1L);
            Mockito.when((Object)openTransactionContext.batchUpdate(Arrays.asList(updateStatement, updateStatement), new Options.UpdateOption[0])).thenReturn((Object)new long[]{1L, 1L});
            SpannerImpl spanner = (SpannerImpl)Mockito.mock(SpannerImpl.class);
            SessionClient sessionClient = (SessionClient)Mockito.mock(SessionClient.class);
            Mockito.when((Object)spanner.getSessionClient(this.db)).thenReturn((Object)sessionClient);
            ((SessionClient)Mockito.doAnswer(invocation -> {
                this.executor.submit(() -> {
                    SessionPool.SessionConsumerImpl consumer = (SessionPool.SessionConsumerImpl)invocation.getArgument(2, SessionPool.SessionConsumerImpl.class);
                    consumer.onSessionReady(closedSession);
                });
                return null;
            }).doAnswer(invocation -> {
                this.executor.submit(() -> {
                    SessionPool.SessionConsumerImpl consumer = (SessionPool.SessionConsumerImpl)invocation.getArgument(2, SessionPool.SessionConsumerImpl.class);
                    consumer.onSessionReady(openSession);
                });
                return null;
            }).when((Object)sessionClient)).asyncBatchCreateSessions(Mockito.eq((int)1), Mockito.anyBoolean(), (SessionClient.SessionConsumer)Mockito.any(SessionClient.SessionConsumer.class));
            SessionPoolOptions options = SessionPoolOptions.newBuilder().setMinSessions(0).setMaxSessions(2).setIncStep(1).setBlockIfPoolExhausted().build();
            SpannerOptions spannerOptions = (SpannerOptions)Mockito.mock(SpannerOptions.class);
            Mockito.when((Object)spannerOptions.getSessionPoolOptions()).thenReturn((Object)options);
            Mockito.when((Object)spannerOptions.getNumChannels()).thenReturn((Object)4);
            Mockito.when((Object)spannerOptions.getDatabaseRole()).thenReturn((Object)"role");
            Mockito.when((Object)((SpannerOptions)spanner.getOptions())).thenReturn((Object)spannerOptions);
            SessionPool pool = SessionPool.createPool((SessionPoolOptions)options, (GrpcTransportOptions.ExecutorFactory)new BaseSessionPoolTest.TestExecutorFactory(), (SessionClient)spanner.getSessionClient(this.db));
            try (SessionPool.PooledSessionFuture readWriteSession = pool.getSession();){
                TransactionRunner runner = readWriteSession.readWriteTransaction(new Options.TransactionOption[0]);
                try {
                    runner.run((TransactionRunner.TransactionCallable)new TransactionRunner.TransactionCallable<Integer>(){
                        private int callNumber = 0;

                        public Integer run(TransactionContext transaction) {
                            ++this.callNumber;
                            if (this.callNumber == 1) {
                                Truth.assertThat((Object)transaction).isEqualTo((Object)closedTransactionContext);
                            } else {
                                Truth.assertThat((Object)transaction).isEqualTo((Object)openTransactionContext);
                            }
                            switch (executeStatementType) {
                                case QUERY: {
                                    ResultSet resultSet = transaction.executeQuery(queryStatement, new Options.QueryOption[0]);
                                    Truth.assertThat((Boolean)resultSet.next()).isTrue();
                                    break;
                                }
                                case ANALYZE: {
                                    ResultSet planResultSet = transaction.analyzeQuery(queryStatement, ReadContext.QueryAnalyzeMode.PLAN);
                                    Truth.assertThat((Boolean)planResultSet.next()).isFalse();
                                    Truth.assertThat((Object)planResultSet.getStats()).isNotNull();
                                    break;
                                }
                                case UPDATE: {
                                    long updateCount = transaction.executeUpdate(updateStatement, new Options.UpdateOption[0]);
                                    Truth.assertThat((Long)updateCount).isEqualTo((Object)1L);
                                    break;
                                }
                                case BATCH_UPDATE: {
                                    long[] updateCounts = transaction.batchUpdate(Arrays.asList(updateStatement, updateStatement), new Options.UpdateOption[0]);
                                    Truth.assertThat((long[])updateCounts).isEqualTo((Object)new long[]{1L, 1L});
                                    break;
                                }
                                case WRITE: {
                                    transaction.buffer(Mutation.delete((String)"FOO", (Key)Key.of((Object[])new Object[]{1L})));
                                    break;
                                }
                                case EXCEPTION: {
                                    throw new RuntimeException("rollback at call " + this.callNumber);
                                }
                                default: {
                                    Assert.fail((String)("Unknown statement type: " + (Object)((Object)executeStatementType)));
                                }
                            }
                            return this.callNumber;
                        }
                    });
                }
                catch (Exception e) {
                    Truth.assertThat((Comparable)((Object)executeStatementType)).isEqualTo((Object)ReadWriteTransactionTestStatementType.EXCEPTION);
                    Truth.assertThat((String)e.getMessage()).contains((CharSequence)"rollback at call 1");
                }
            }
            pool.closeAsync(new SpannerImpl.ClosedException());
        }
    }

    @Test
    public void testSessionNotFoundWrite() {
        SessionNotFoundException sessionNotFound = SpannerExceptionFactoryTest.newSessionNotFoundException(this.sessionName);
        List<Mutation> mutations = Collections.singletonList(Mutation.newInsertBuilder((String)"FOO").build());
        SessionImpl closedSession = this.mockSession();
        Mockito.when((Object)closedSession.writeWithOptions(mutations, new Options.TransactionOption[0])).thenThrow(new Throwable[]{sessionNotFound});
        SessionImpl openSession = this.mockSession();
        CommitResponse response = (CommitResponse)Mockito.mock(CommitResponse.class);
        Mockito.when((Object)response.getCommitTimestamp()).thenReturn((Object)Timestamp.now());
        Mockito.when((Object)openSession.writeWithOptions(mutations, new Options.TransactionOption[0])).thenReturn((Object)response);
        ((SessionClient)Mockito.doAnswer(invocation -> {
            this.executor.submit(() -> {
                SessionPool.SessionConsumerImpl consumer = (SessionPool.SessionConsumerImpl)invocation.getArgument(2, SessionPool.SessionConsumerImpl.class);
                consumer.onSessionReady(closedSession);
            });
            return null;
        }).doAnswer(invocation -> {
            this.executor.submit(() -> {
                SessionPool.SessionConsumerImpl consumer = (SessionPool.SessionConsumerImpl)invocation.getArgument(2, SessionPool.SessionConsumerImpl.class);
                consumer.onSessionReady(openSession);
            });
            return null;
        }).when((Object)this.sessionClient)).asyncBatchCreateSessions(Mockito.eq((int)1), Mockito.anyBoolean(), (SessionClient.SessionConsumer)Mockito.any(SessionClient.SessionConsumer.class));
        BaseSessionPoolTest.FakeClock clock = new BaseSessionPoolTest.FakeClock();
        clock.currentTimeMillis = System.currentTimeMillis();
        this.pool = this.createPool(clock);
        DatabaseClientImpl impl = new DatabaseClientImpl(this.pool);
        Truth.assertThat((Comparable)impl.write(mutations)).isNotNull();
    }

    @Test
    public void testSessionNotFoundWriteAtLeastOnce() {
        SessionNotFoundException sessionNotFound = SpannerExceptionFactoryTest.newSessionNotFoundException(this.sessionName);
        List<Mutation> mutations = Collections.singletonList(Mutation.newInsertBuilder((String)"FOO").build());
        SessionImpl closedSession = this.mockSession();
        Mockito.when((Object)closedSession.writeAtLeastOnceWithOptions(mutations, new Options.TransactionOption[0])).thenThrow(new Throwable[]{sessionNotFound});
        SessionImpl openSession = this.mockSession();
        CommitResponse response = (CommitResponse)Mockito.mock(CommitResponse.class);
        Mockito.when((Object)response.getCommitTimestamp()).thenReturn((Object)Timestamp.now());
        Mockito.when((Object)openSession.writeAtLeastOnceWithOptions(mutations, new Options.TransactionOption[0])).thenReturn((Object)response);
        ((SessionClient)Mockito.doAnswer(invocation -> {
            this.executor.submit(() -> {
                SessionPool.SessionConsumerImpl consumer = (SessionPool.SessionConsumerImpl)invocation.getArgument(2, SessionPool.SessionConsumerImpl.class);
                consumer.onSessionReady(closedSession);
            });
            return null;
        }).doAnswer(invocation -> {
            this.executor.submit(() -> {
                SessionPool.SessionConsumerImpl consumer = (SessionPool.SessionConsumerImpl)invocation.getArgument(2, SessionPool.SessionConsumerImpl.class);
                consumer.onSessionReady(openSession);
            });
            return null;
        }).when((Object)this.sessionClient)).asyncBatchCreateSessions(Mockito.eq((int)1), Mockito.anyBoolean(), (SessionClient.SessionConsumer)Mockito.any(SessionClient.SessionConsumer.class));
        BaseSessionPoolTest.FakeClock clock = new BaseSessionPoolTest.FakeClock();
        clock.currentTimeMillis = System.currentTimeMillis();
        this.pool = this.createPool(clock);
        DatabaseClientImpl impl = new DatabaseClientImpl(this.pool);
        Truth.assertThat((Comparable)impl.writeAtLeastOnce(mutations)).isNotNull();
    }

    @Test
    public void testSessionNotFoundPartitionedUpdate() {
        SessionNotFoundException sessionNotFound = SpannerExceptionFactoryTest.newSessionNotFoundException(this.sessionName);
        Statement statement = Statement.of((String)"UPDATE FOO SET BAR=1 WHERE 1=1");
        SessionImpl closedSession = this.mockSession();
        Mockito.when((Object)closedSession.executePartitionedUpdate(statement, new Options.UpdateOption[0])).thenThrow(new Throwable[]{sessionNotFound});
        SessionImpl openSession = this.mockSession();
        Mockito.when((Object)openSession.executePartitionedUpdate(statement, new Options.UpdateOption[0])).thenReturn((Object)1L);
        ((SessionClient)Mockito.doAnswer(invocation -> {
            this.executor.submit(() -> {
                SessionPool.SessionConsumerImpl consumer = (SessionPool.SessionConsumerImpl)invocation.getArgument(2, SessionPool.SessionConsumerImpl.class);
                consumer.onSessionReady(closedSession);
            });
            return null;
        }).doAnswer(invocation -> {
            this.executor.submit(() -> {
                SessionPool.SessionConsumerImpl consumer = (SessionPool.SessionConsumerImpl)invocation.getArgument(2, SessionPool.SessionConsumerImpl.class);
                consumer.onSessionReady(openSession);
            });
            return null;
        }).when((Object)this.sessionClient)).asyncBatchCreateSessions(Mockito.eq((int)1), Mockito.anyBoolean(), (SessionClient.SessionConsumer)Mockito.any(SessionClient.SessionConsumer.class));
        BaseSessionPoolTest.FakeClock clock = new BaseSessionPoolTest.FakeClock();
        clock.currentTimeMillis = System.currentTimeMillis();
        this.pool = this.createPool(clock);
        DatabaseClientImpl impl = new DatabaseClientImpl(this.pool);
        Truth.assertThat((Long)impl.executePartitionedUpdate(statement, new Options.UpdateOption[0])).isEqualTo((Object)1L);
    }

    @Test
    public void testSessionMetrics() throws Exception {
        this.options = SessionPoolOptions.newBuilder().setMinSessions(1).setMaxSessions(2).setMaxIdleSessions(0).setInitialWaitForSessionTimeoutMillis(50L).build();
        BaseSessionPoolTest.FakeClock clock = new BaseSessionPoolTest.FakeClock();
        clock.currentTimeMillis = System.currentTimeMillis();
        MetricRegistryTestUtils.FakeMetricRegistry metricRegistry = new MetricRegistryTestUtils.FakeMetricRegistry();
        List<LabelValue> labelValues = Arrays.asList(LabelValue.create((String)"client1"), LabelValue.create((String)"database1"), LabelValue.create((String)"instance1"), LabelValue.create((String)"1.0.0"));
        this.setupMockSessionCreation();
        this.pool = this.createPool(clock, metricRegistry, labelValues);
        SessionPool.PooledSessionFuture session1 = this.pool.getSession();
        SessionPool.PooledSessionFuture session2 = this.pool.getSession();
        session1.get();
        session2.get();
        MetricRegistryTestUtils.MetricsRecord record = metricRegistry.pollRecord();
        Truth.assertThat((Integer)record.getMetrics().size()).isEqualTo((Object)6);
        List<MetricRegistryTestUtils.PointWithFunction> maxInUseSessions = record.getMetrics().get("cloud.google.com/java/spanner/max_in_use_sessions");
        Truth.assertThat((Integer)maxInUseSessions.size()).isEqualTo((Object)1);
        Truth.assertThat((Long)maxInUseSessions.get(0).value()).isEqualTo((Object)2L);
        Truth.assertThat(maxInUseSessions.get(0).keys()).isEqualTo((Object)MetricRegistryConstants.SPANNER_LABEL_KEYS);
        Truth.assertThat(maxInUseSessions.get(0).values()).isEqualTo(labelValues);
        List<MetricRegistryTestUtils.PointWithFunction> getSessionsTimeouts = record.getMetrics().get("cloud.google.com/java/spanner/get_session_timeouts");
        Truth.assertThat((Integer)getSessionsTimeouts.size()).isEqualTo((Object)1);
        Truth.assertThat((Long)getSessionsTimeouts.get(0).value()).isAtMost((Comparable)Long.valueOf(1L));
        Truth.assertThat(getSessionsTimeouts.get(0).keys()).isEqualTo((Object)MetricRegistryConstants.SPANNER_LABEL_KEYS);
        Truth.assertThat(getSessionsTimeouts.get(0).values()).isEqualTo(labelValues);
        List<MetricRegistryTestUtils.PointWithFunction> numAcquiredSessions = record.getMetrics().get("cloud.google.com/java/spanner/num_acquired_sessions");
        Truth.assertThat((Integer)numAcquiredSessions.size()).isEqualTo((Object)1);
        Truth.assertThat((Long)numAcquiredSessions.get(0).value()).isEqualTo((Object)2L);
        Truth.assertThat(numAcquiredSessions.get(0).keys()).isEqualTo((Object)MetricRegistryConstants.SPANNER_LABEL_KEYS);
        Truth.assertThat(numAcquiredSessions.get(0).values()).isEqualTo(labelValues);
        List<MetricRegistryTestUtils.PointWithFunction> numReleasedSessions = record.getMetrics().get("cloud.google.com/java/spanner/num_released_sessions");
        Truth.assertThat((Integer)numReleasedSessions.size()).isEqualTo((Object)1);
        Truth.assertThat((Long)numReleasedSessions.get(0).value()).isEqualTo((Object)0);
        Truth.assertThat(numReleasedSessions.get(0).keys()).isEqualTo((Object)MetricRegistryConstants.SPANNER_LABEL_KEYS);
        Truth.assertThat(numReleasedSessions.get(0).values()).isEqualTo(labelValues);
        List<MetricRegistryTestUtils.PointWithFunction> maxAllowedSessions = record.getMetrics().get("cloud.google.com/java/spanner/max_allowed_sessions");
        Truth.assertThat((Integer)maxAllowedSessions.size()).isEqualTo((Object)1);
        Truth.assertThat((Long)maxAllowedSessions.get(0).value()).isEqualTo((Object)this.options.getMaxSessions());
        Truth.assertThat(maxAllowedSessions.get(0).keys()).isEqualTo((Object)MetricRegistryConstants.SPANNER_LABEL_KEYS);
        Truth.assertThat(maxAllowedSessions.get(0).values()).isEqualTo(labelValues);
        List<MetricRegistryTestUtils.PointWithFunction> numSessionsInPool = record.getMetrics().get("cloud.google.com/java/spanner/num_sessions_in_pool");
        Truth.assertThat((Integer)numSessionsInPool.size()).isEqualTo((Object)4);
        MetricRegistryTestUtils.PointWithFunction beingPrepared = numSessionsInPool.get(0);
        ArrayList<LabelValue> labelValuesWithBeingPreparedType = new ArrayList<LabelValue>(labelValues);
        labelValuesWithBeingPreparedType.add(MetricRegistryConstants.NUM_SESSIONS_BEING_PREPARED);
        Truth.assertThat((Long)beingPrepared.value()).isEqualTo((Object)0L);
        Truth.assertThat(beingPrepared.keys()).isEqualTo((Object)MetricRegistryConstants.SPANNER_LABEL_KEYS_WITH_TYPE);
        Truth.assertThat(beingPrepared.values()).isEqualTo(labelValuesWithBeingPreparedType);
        MetricRegistryTestUtils.PointWithFunction numSessionsInUse = numSessionsInPool.get(1);
        ArrayList<LabelValue> labelValuesWithInUseType = new ArrayList<LabelValue>(labelValues);
        labelValuesWithInUseType.add(MetricRegistryConstants.NUM_IN_USE_SESSIONS);
        Truth.assertThat((Long)numSessionsInUse.value()).isEqualTo((Object)2L);
        Truth.assertThat(numSessionsInUse.keys()).isEqualTo((Object)MetricRegistryConstants.SPANNER_LABEL_KEYS_WITH_TYPE);
        Truth.assertThat(numSessionsInUse.values()).isEqualTo(labelValuesWithInUseType);
        MetricRegistryTestUtils.PointWithFunction readSessions = numSessionsInPool.get(2);
        ArrayList<LabelValue> labelValuesWithReadType = new ArrayList<LabelValue>(labelValues);
        labelValuesWithReadType.add(MetricRegistryConstants.NUM_READ_SESSIONS);
        Truth.assertThat((Long)readSessions.value()).isEqualTo((Object)0L);
        Truth.assertThat(readSessions.keys()).isEqualTo((Object)MetricRegistryConstants.SPANNER_LABEL_KEYS_WITH_TYPE);
        Truth.assertThat(readSessions.values()).isEqualTo(labelValuesWithReadType);
        MetricRegistryTestUtils.PointWithFunction writePreparedSessions = numSessionsInPool.get(3);
        ArrayList<LabelValue> labelValuesWithWriteType = new ArrayList<LabelValue>(labelValues);
        labelValuesWithWriteType.add(MetricRegistryConstants.NUM_WRITE_SESSIONS);
        Truth.assertThat((Long)writePreparedSessions.value()).isEqualTo((Object)0L);
        Truth.assertThat(writePreparedSessions.keys()).isEqualTo((Object)MetricRegistryConstants.SPANNER_LABEL_KEYS_WITH_TYPE);
        Truth.assertThat(writePreparedSessions.values()).isEqualTo(labelValuesWithWriteType);
        CountDownLatch latch = new CountDownLatch(1);
        Future<Void> fut = this.executor.submit(() -> {
            latch.countDown();
            SessionPool.PooledSessionFuture session = this.pool.getSession();
            session.close();
            return null;
        });
        latch.await();
        for (int waitCount = 0; this.pool.getNumWaiterTimeouts() == 0L && waitCount < 1000; ++waitCount) {
            Thread.sleep(5L);
        }
        session2.close();
        fut.get(10L, TimeUnit.SECONDS);
        this.executor.shutdown();
        session1.close();
        numAcquiredSessions = record.getMetrics().get("cloud.google.com/java/spanner/num_acquired_sessions");
        Truth.assertThat((Integer)numAcquiredSessions.size()).isEqualTo((Object)1);
        Truth.assertThat((Long)numAcquiredSessions.get(0).value()).isEqualTo((Object)3L);
        numReleasedSessions = record.getMetrics().get("cloud.google.com/java/spanner/num_released_sessions");
        Truth.assertThat((Integer)numReleasedSessions.size()).isEqualTo((Object)1);
        Truth.assertThat((Long)numReleasedSessions.get(0).value()).isEqualTo((Object)3L);
        maxInUseSessions = record.getMetrics().get("cloud.google.com/java/spanner/max_in_use_sessions");
        Truth.assertThat((Integer)maxInUseSessions.size()).isEqualTo((Object)1);
        Truth.assertThat((Long)maxInUseSessions.get(0).value()).isEqualTo((Object)2L);
        numSessionsInPool = record.getMetrics().get("cloud.google.com/java/spanner/num_sessions_in_pool");
        Truth.assertThat((Integer)numSessionsInPool.size()).isEqualTo((Object)4);
        beingPrepared = numSessionsInPool.get(0);
        Truth.assertThat((Long)beingPrepared.value()).isEqualTo((Object)0L);
        numSessionsInUse = numSessionsInPool.get(1);
        Truth.assertThat((Long)numSessionsInUse.value()).isEqualTo((Object)0L);
        readSessions = numSessionsInPool.get(2);
        Truth.assertThat((Long)readSessions.value()).isEqualTo((Object)2L);
        writePreparedSessions = numSessionsInPool.get(3);
        Truth.assertThat((Long)writePreparedSessions.value()).isEqualTo((Object)0L);
    }

    @Test
    public void testGetDatabaseRole() throws Exception {
        this.setupMockSessionCreation();
        this.pool = this.createPool(new BaseSessionPoolTest.FakeClock(), new MetricRegistryTestUtils.FakeMetricRegistry(), (List<LabelValue>)MetricRegistryConstants.SPANNER_DEFAULT_LABEL_VALUES);
        Assert.assertEquals((Object)this.TEST_DATABASE_ROLE, (Object)this.pool.getDatabaseRole());
    }

    private void mockKeepAlive(Session session) {
        ReadContext context = (ReadContext)Mockito.mock(ReadContext.class);
        ResultSet resultSet = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)resultSet.next()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Mockito.when((Object)session.singleUse((TimestampBound)Mockito.any(TimestampBound.class))).thenReturn((Object)context);
        Mockito.when((Object)context.executeQuery((Statement)Mockito.any(Statement.class), new Options.QueryOption[0])).thenReturn((Object)resultSet);
    }

    private void getSessionAsync(CountDownLatch latch, AtomicBoolean failed) {
        new Thread(() -> {
            try (SessionPool.PooledSessionFuture future = this.pool.getSession();){
                SessionPool.PooledSession session = future.get();
                failed.compareAndSet(false, session == null);
                Uninterruptibles.sleepUninterruptibly((long)10L, (TimeUnit)TimeUnit.MILLISECONDS);
            }
            catch (Throwable e) {
                failed.compareAndSet(false, true);
            }
            finally {
                latch.countDown();
            }
        }).start();
    }

    private static enum ReadWriteTransactionTestStatementType {
        QUERY,
        ANALYZE,
        UPDATE,
        BATCH_UPDATE,
        WRITE,
        EXCEPTION;

    }
}

