/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.connection.AbstractStatementParser;
import com.google.cloud.spanner.connection.AutocommitDmlMode;
import com.google.cloud.spanner.connection.ConnectionImpl;
import com.google.cloud.spanner.connection.ConnectionStatementExecutor;
import com.google.cloud.spanner.connection.ConnectionStatementExecutorImpl;
import com.google.cloud.spanner.connection.DialectNamespaceMapper;
import com.google.cloud.spanner.connection.ReadOnlyStalenessUtil;
import com.google.cloud.spanner.connection.TransactionMode;
import com.google.protobuf.Duration;
import java.util.concurrent.TimeUnit;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=Parameterized.class)
public class ConnectionStatementWithOneParameterTest {
    @Parameterized.Parameter
    public Dialect dialect;
    private AbstractStatementParser parser;

    @Parameterized.Parameters(name="dialect = {0}")
    public static Object[] data() {
        return Dialect.values();
    }

    @Before
    public void setup() {
        this.parser = AbstractStatementParser.getInstance((Dialect)this.dialect);
    }

    @Test
    public void testExecuteSetAutocommit() {
        AbstractStatementParser.ParsedStatement subject = this.parser.parse(Statement.of((String)"set autocommit = true"));
        ConnectionImpl connection = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        ConnectionStatementExecutorImpl executor = (ConnectionStatementExecutorImpl)Mockito.mock(ConnectionStatementExecutorImpl.class);
        Mockito.when((Object)executor.getConnection()).thenReturn((Object)connection);
        Mockito.when((Object)executor.statementSetAutocommit((Boolean)Mockito.any(Boolean.class))).thenCallRealMethod();
        for (Boolean mode : new Boolean[]{Boolean.FALSE, Boolean.TRUE}) {
            subject.getClientSideStatement().execute((ConnectionStatementExecutor)executor, String.format("set autocommit = %s", mode));
            ((ConnectionImpl)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).setAutocommit(mode.booleanValue());
        }
    }

    @Test
    public void testExecuteSetReadOnly() {
        AbstractStatementParser.ParsedStatement subject = this.parser.parse(Statement.of((String)String.format("set %sreadonly = true", DialectNamespaceMapper.getNamespace((Dialect)this.dialect))));
        ConnectionImpl connection = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        ConnectionStatementExecutorImpl executor = (ConnectionStatementExecutorImpl)Mockito.mock(ConnectionStatementExecutorImpl.class);
        Mockito.when((Object)executor.getConnection()).thenReturn((Object)connection);
        Mockito.when((Object)executor.statementSetReadOnly((Boolean)Mockito.any(Boolean.class))).thenCallRealMethod();
        for (Boolean mode : new Boolean[]{Boolean.FALSE, Boolean.TRUE}) {
            subject.getClientSideStatement().execute((ConnectionStatementExecutor)executor, String.format("set %sreadonly = %s", DialectNamespaceMapper.getNamespace((Dialect)this.dialect), mode));
            ((ConnectionImpl)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).setReadOnly(mode.booleanValue());
        }
    }

    @Test
    public void testExecuteSetReadOnlyTo() {
        Assume.assumeTrue((String)"TO is only supported in PostgreSQL dialect", (this.dialect == Dialect.POSTGRESQL ? 1 : 0) != 0);
        AbstractStatementParser.ParsedStatement subject = this.parser.parse(Statement.of((String)String.format("set %sreadonly to true", DialectNamespaceMapper.getNamespace((Dialect)this.dialect))));
        ConnectionImpl connection = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        ConnectionStatementExecutorImpl executor = (ConnectionStatementExecutorImpl)Mockito.mock(ConnectionStatementExecutorImpl.class);
        Mockito.when((Object)executor.getConnection()).thenReturn((Object)connection);
        Mockito.when((Object)executor.statementSetReadOnly((Boolean)Mockito.any(Boolean.class))).thenCallRealMethod();
        for (Boolean mode : new Boolean[]{Boolean.FALSE, Boolean.TRUE}) {
            subject.getClientSideStatement().execute((ConnectionStatementExecutor)executor, String.format("set %sreadonly to %s", DialectNamespaceMapper.getNamespace((Dialect)this.dialect), mode));
            ((ConnectionImpl)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).setReadOnly(mode.booleanValue());
        }
    }

    @Test
    public void testExecuteSetAutocommitDmlMode() {
        AbstractStatementParser.ParsedStatement subject = this.parser.parse(Statement.of((String)String.format("set %sautocommit_dml_mode='foo'", DialectNamespaceMapper.getNamespace((Dialect)this.dialect))));
        ConnectionImpl connection = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        ConnectionStatementExecutorImpl executor = (ConnectionStatementExecutorImpl)Mockito.mock(ConnectionStatementExecutorImpl.class);
        Mockito.when((Object)executor.getConnection()).thenReturn((Object)connection);
        Mockito.when((Object)executor.statementSetAutocommitDmlMode((AutocommitDmlMode)Mockito.any(AutocommitDmlMode.class))).thenCallRealMethod();
        for (AutocommitDmlMode mode : AutocommitDmlMode.values()) {
            subject.getClientSideStatement().execute((ConnectionStatementExecutor)executor, String.format("set %sautocommit_dml_mode='%s'", DialectNamespaceMapper.getNamespace((Dialect)this.dialect), mode.name()));
            ((ConnectionImpl)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).setAutocommitDmlMode(mode);
        }
    }

    @Test
    public void testExecuteSetStatementTimeout() {
        ConnectionStatementExecutorImpl executor = (ConnectionStatementExecutorImpl)Mockito.mock(ConnectionStatementExecutorImpl.class);
        Mockito.when((Object)executor.statementSetStatementTimeout((Duration)Mockito.any(Duration.class))).thenCallRealMethod();
        ConnectionImpl connection = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        Mockito.when((Object)executor.getConnection()).thenReturn((Object)connection);
        for (TimeUnit timeUnit : ReadOnlyStalenessUtil.SUPPORTED_UNITS) {
            for (Long val : new Long[]{1L, 100L, 999L}) {
                AbstractStatementParser.ParsedStatement subject2 = this.parser.parse(Statement.of((String)String.format("set statement_timeout='%d%s'", val, ReadOnlyStalenessUtil.getTimeUnitAbbreviation((TimeUnit)timeUnit))));
                subject2.getClientSideStatement().execute((ConnectionStatementExecutor)executor, String.format("set statement_timeout='%d%s'", val, ReadOnlyStalenessUtil.getTimeUnitAbbreviation((TimeUnit)timeUnit)));
                ((ConnectionImpl)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).setStatementTimeout(val.longValue(), timeUnit);
            }
        }
        if (this.dialect == Dialect.POSTGRESQL) {
            for (Long l : new Long[]{1L, 100L, 999L}) {
                Mockito.clearInvocations((Object[])new ConnectionImpl[]{connection});
                AbstractStatementParser.ParsedStatement subject3 = this.parser.parse(Statement.of((String)String.format("set statement_timeout=%d", l)));
                subject3.getClientSideStatement().execute((ConnectionStatementExecutor)executor, String.format("set statement_timeout=%d", l));
                ((ConnectionImpl)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).setStatementTimeout(l.longValue(), TimeUnit.MILLISECONDS);
            }
            AbstractStatementParser.ParsedStatement parsedStatement = this.parser.parse(Statement.of((String)"set statement_timeout=default"));
            parsedStatement.getClientSideStatement().execute((ConnectionStatementExecutor)executor, "set statement_timeout=default");
        } else {
            AbstractStatementParser.ParsedStatement parsedStatement = this.parser.parse(Statement.of((String)"set statement_timeout=null"));
            parsedStatement.getClientSideStatement().execute((ConnectionStatementExecutor)executor, "set statement_timeout=null");
        }
        ((ConnectionImpl)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).clearStatementTimeout();
    }

    @Test
    public void testExecuteSetReadOnlyStaleness() {
        AbstractStatementParser.ParsedStatement subject = this.parser.parse(Statement.of((String)String.format("set %sread_only_staleness='foo'", DialectNamespaceMapper.getNamespace((Dialect)this.dialect))));
        ConnectionImpl connection = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        ConnectionStatementExecutorImpl executor = (ConnectionStatementExecutorImpl)Mockito.mock(ConnectionStatementExecutorImpl.class);
        Mockito.when((Object)executor.getConnection()).thenReturn((Object)connection);
        Mockito.when((Object)executor.statementSetReadOnlyStaleness((TimestampBound)Mockito.any(TimestampBound.class))).thenCallRealMethod();
        for (TimestampBound val : new TimestampBound[]{TimestampBound.strong(), TimestampBound.ofReadTimestamp((Timestamp)Timestamp.now()), TimestampBound.ofMinReadTimestamp((Timestamp)Timestamp.now()), TimestampBound.ofExactStaleness((long)1000L, (TimeUnit)TimeUnit.SECONDS), TimestampBound.ofMaxStaleness((long)2000L, (TimeUnit)TimeUnit.MICROSECONDS)}) {
            subject.getClientSideStatement().execute((ConnectionStatementExecutor)executor, String.format("set %sread_only_staleness='%s'", DialectNamespaceMapper.getNamespace((Dialect)this.dialect), this.timestampBoundToString(val)));
            ((ConnectionImpl)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).setReadOnlyStaleness(val);
        }
    }

    private String timestampBoundToString(TimestampBound staleness) {
        switch (staleness.getMode()) {
            case STRONG: {
                return "strong";
            }
            case READ_TIMESTAMP: {
                return "read_timestamp " + staleness.getReadTimestamp().toString();
            }
            case MIN_READ_TIMESTAMP: {
                return "min_read_timestamp " + staleness.getMinReadTimestamp().toString();
            }
            case EXACT_STALENESS: {
                return "exact_staleness " + staleness.getExactStaleness(TimeUnit.SECONDS) + "s";
            }
            case MAX_STALENESS: {
                return "max_staleness " + staleness.getMaxStaleness(TimeUnit.MICROSECONDS) + "us";
            }
        }
        throw new IllegalStateException("Unknown mode: " + staleness.getMode());
    }

    @Test
    public void testExecuteSetOptimizerVersion() {
        AbstractStatementParser.ParsedStatement subject = this.parser.parse(Statement.of((String)String.format("set %soptimizer_version='foo'", DialectNamespaceMapper.getNamespace((Dialect)this.dialect))));
        ConnectionImpl connection = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        ConnectionStatementExecutorImpl executor = (ConnectionStatementExecutorImpl)Mockito.mock(ConnectionStatementExecutorImpl.class);
        Mockito.when((Object)executor.getConnection()).thenReturn((Object)connection);
        Mockito.when((Object)executor.statementSetOptimizerVersion((String)Mockito.any(String.class))).thenCallRealMethod();
        for (String version : new String[]{"1", "200", "", "LATEST"}) {
            subject.getClientSideStatement().execute((ConnectionStatementExecutor)executor, String.format("set %soptimizer_version='%s'", DialectNamespaceMapper.getNamespace((Dialect)this.dialect), version));
            ((ConnectionImpl)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).setOptimizerVersion(version);
        }
    }

    @Test
    public void testExecuteSetOptimizerStatisticsPackage() {
        AbstractStatementParser.ParsedStatement subject = this.parser.parse(Statement.of((String)String.format("set %soptimizer_statistics_package='foo'", DialectNamespaceMapper.getNamespace((Dialect)this.dialect))));
        ConnectionImpl connection = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        ConnectionStatementExecutorImpl executor = (ConnectionStatementExecutorImpl)Mockito.mock(ConnectionStatementExecutorImpl.class);
        Mockito.when((Object)executor.getConnection()).thenReturn((Object)connection);
        Mockito.when((Object)executor.statementSetOptimizerStatisticsPackage((String)Mockito.any(String.class))).thenCallRealMethod();
        for (String statisticsPackage : new String[]{"custom-package", ""}) {
            subject.getClientSideStatement().execute((ConnectionStatementExecutor)executor, String.format("set %soptimizer_statistics_package='%s'", DialectNamespaceMapper.getNamespace((Dialect)this.dialect), statisticsPackage));
            ((ConnectionImpl)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).setOptimizerStatisticsPackage(statisticsPackage);
        }
    }

    @Test
    public void testExecuteSetTransaction() {
        AbstractStatementParser.ParsedStatement subject = this.parser.parse(Statement.of((String)"set transaction read_only"));
        ConnectionImpl connection = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        ConnectionStatementExecutorImpl executor = new ConnectionStatementExecutorImpl(connection);
        for (TransactionMode mode : TransactionMode.values()) {
            subject.getClientSideStatement().execute((ConnectionStatementExecutor)executor, String.format("set transaction %s", mode.getStatementString()));
            ((ConnectionImpl)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).setTransactionMode(mode);
        }
    }
}

