/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection.it;

import com.google.api.core.ApiFuture;
import com.google.api.core.SettableApiFuture;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AbortedDueToConcurrentModificationException;
import com.google.cloud.spanner.AbortedException;
import com.google.cloud.spanner.AsyncResultSet;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ParallelIntegrationTest;
import com.google.cloud.spanner.SpannerApiFutures;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.connection.Connection;
import com.google.cloud.spanner.connection.ITAbstractSpannerTest;
import com.google.cloud.spanner.connection.TransactionRetryListener;
import com.google.cloud.spanner.testing.EmulatorSpannerHelper;
import com.google.common.truth.Truth;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@Category(value={ParallelIntegrationTest.class})
@RunWith(value=JUnit4.class)
public class ITAsyncTransactionRetryTest
extends ITAbstractSpannerTest {
    private static final Logger logger = Logger.getLogger(ITAsyncTransactionRetryTest.class.getName());
    @Rule
    public TestName testName = new TestName();
    private static final ExecutorService executor = Executors.newFixedThreadPool(4);
    public static final RetryStatistics RETRY_STATISTICS = new RetryStatistics();

    @AfterClass
    public static void shutdownExecutor() {
        executor.shutdown();
    }

    @Override
    protected void appendConnectionUri(StringBuilder uri) {
        uri.append(";autocommit=false;retryAbortsInternally=true");
    }

    @Override
    public boolean doCreateDefaultTestTable() {
        return true;
    }

    @Before
    public void clearTable() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.bufferedWrite(Mutation.delete((String)"TEST", (KeySet)KeySet.all()));
            SpannerApiFutures.get((ApiFuture)connection.commitAsync());
        }
    }

    @Before
    public void clearStatistics() {
        ITAsyncTransactionRetryTest.RETRY_STATISTICS.clear();
    }

    @Before
    public void logStart() {
        logger.fine("--------------------------------------------------------------\n" + this.testName.getMethodName() + " started");
    }

    @After
    public void logFinished() {
        logger.fine("--------------------------------------------------------------\n" + this.testName.getMethodName() + " finished");
    }

    private ApiFuture<Long> getTestRecordCountAsync(Connection connection) {
        SettableApiFuture count = SettableApiFuture.create();
        try (AsyncResultSet rs = connection.executeQueryAsync(Statement.of((String)"SELECT COUNT(*) AS C FROM TEST WHERE ID=1"), new Options.QueryOption[0]);){
            rs.setCallback((Executor)executor, resultSet -> {
                while (true) {
                    switch (resultSet.tryNext()) {
                        case DONE: {
                            return AsyncResultSet.CallbackResponse.DONE;
                        }
                        case NOT_READY: {
                            return AsyncResultSet.CallbackResponse.CONTINUE;
                        }
                        case OK: {
                            count.set((Object)resultSet.getLong("C"));
                        }
                    }
                }
            });
        }
        return count;
    }

    private void verifyRecordCount(Connection connection, long expected) {
        try (AsyncResultSet rs = connection.executeQueryAsync(Statement.of((String)"SELECT COUNT(*) AS C FROM TEST"), new Options.QueryOption[0]);){
            Truth.assertThat((Boolean)rs.next()).isTrue();
            Truth.assertThat((Long)rs.getLong("C")).isEqualTo((Object)expected);
            Truth.assertThat((Boolean)rs.next()).isFalse();
        }
    }

    @Test
    public void testCommitAborted() {
        ITAbstractSpannerTest.AbortInterceptor interceptor = new ITAbstractSpannerTest.AbortInterceptor(0.0);
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection(interceptor, new CountTransactionRetryListener());){
            ApiFuture<Long> count = this.getTestRecordCountAsync(connection);
            ApiFuture updateCount = connection.executeUpdateAsync(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (1, 'test aborted')"));
            interceptor.setProbability(1.0);
            interceptor.setOnlyInjectOnce(true);
            ApiFuture commit = connection.commitAsync();
            Truth.assertThat((Long)((Long)SpannerApiFutures.get(count))).isEqualTo((Object)0L);
            Truth.assertThat((Object)SpannerApiFutures.get((ApiFuture)commit)).isNull();
            Truth.assertThat((Long)((Long)SpannerApiFutures.get((ApiFuture)updateCount))).isEqualTo((Object)1L);
            Truth.assertThat((Boolean)(RETRY_STATISTICS.totalRetryAttemptsStarted >= 1 ? 1 : 0)).isTrue();
            Truth.assertThat((Boolean)(RETRY_STATISTICS.totalRetryAttemptsFinished >= 1 ? 1 : 0)).isTrue();
            Truth.assertThat((Boolean)(RETRY_STATISTICS.totalSuccessfulRetries >= 1 ? 1 : 0)).isTrue();
            Truth.assertThat((Integer)RETRY_STATISTICS.totalErroredRetries).isEqualTo((Object)0);
            Truth.assertThat((Integer)RETRY_STATISTICS.totalConcurrentModifications).isEqualTo((Object)0);
            Truth.assertThat((Integer)RETRY_STATISTICS.totalMaxAttemptsExceeded).isEqualTo((Object)0);
            this.verifyRecordCount(connection, 1L);
        }
    }

    @Test
    public void testInsertAborted() {
        ITAbstractSpannerTest.AbortInterceptor interceptor = new ITAbstractSpannerTest.AbortInterceptor(0.0);
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection(interceptor, new CountTransactionRetryListener());){
            ApiFuture<Long> count = this.getTestRecordCountAsync(connection);
            interceptor.setProbability(1.0);
            interceptor.setOnlyInjectOnce(true);
            connection.executeUpdateAsync(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (1, 'test aborted')"));
            ApiFuture commit = connection.commitAsync();
            Truth.assertThat((Long)((Long)SpannerApiFutures.get(count))).isEqualTo((Object)0L);
            Truth.assertThat((Object)SpannerApiFutures.get((ApiFuture)commit)).isNull();
            Truth.assertThat((Boolean)(RETRY_STATISTICS.totalSuccessfulRetries >= 1 ? 1 : 0)).isTrue();
            this.verifyRecordCount(connection, 1L);
        }
    }

    @Test
    public void testUpdateAborted() {
        ITAbstractSpannerTest.AbortInterceptor interceptor = new ITAbstractSpannerTest.AbortInterceptor(0.0);
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection(interceptor, new CountTransactionRetryListener());){
            ApiFuture<Long> count = this.getTestRecordCountAsync(connection);
            connection.executeUpdateAsync(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (1, 'test aborted')"));
            interceptor.setProbability(1.0);
            interceptor.setOnlyInjectOnce(true);
            connection.executeUpdateAsync(Statement.of((String)"UPDATE TEST SET NAME='update aborted' WHERE ID=1"));
            ApiFuture commit = connection.commitAsync();
            Truth.assertThat((Long)((Long)SpannerApiFutures.get(count))).isEqualTo((Object)0L);
            Truth.assertThat((Object)SpannerApiFutures.get((ApiFuture)commit)).isNull();
            Truth.assertThat((Boolean)(RETRY_STATISTICS.totalSuccessfulRetries >= 1 ? 1 : 0)).isTrue();
            try (AsyncResultSet rs = connection.executeQueryAsync(Statement.of((String)"SELECT COUNT(*) AS C FROM TEST WHERE ID=1 AND NAME='update aborted'"), new Options.QueryOption[0]);){
                Truth.assertThat((Boolean)rs.next()).isTrue();
                Truth.assertThat((Long)rs.getLong("C")).isEqualTo((Object)1L);
                Truth.assertThat((Boolean)rs.next()).isFalse();
            }
        }
    }

    @Test
    public void testQueryAborted() {
        ITAbstractSpannerTest.AbortInterceptor interceptor = new ITAbstractSpannerTest.AbortInterceptor(0.0);
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection(interceptor, new CountTransactionRetryListener());){
            connection.executeUpdateAsync(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (1, 'test aborted')"));
            interceptor.setProbability(1.0);
            interceptor.setOnlyInjectOnce(true);
            SettableApiFuture countAfterInsert = SettableApiFuture.create();
            try (AsyncResultSet rs = connection.executeQueryAsync(Statement.of((String)"SELECT COUNT(*) AS C FROM TEST WHERE ID=1"), new Options.QueryOption[0]);){
                rs.setCallback((Executor)executor, resultSet -> {
                    try {
                        while (true) {
                            switch (resultSet.tryNext()) {
                                case DONE: {
                                    return AsyncResultSet.CallbackResponse.DONE;
                                }
                                case NOT_READY: {
                                    return AsyncResultSet.CallbackResponse.CONTINUE;
                                }
                                case OK: {
                                    countAfterInsert.set((Object)resultSet.getLong("C"));
                                }
                            }
                        }
                    }
                    catch (Throwable t) {
                        countAfterInsert.setException(t);
                        return AsyncResultSet.CallbackResponse.DONE;
                    }
                });
            }
            connection.commitAsync();
            Truth.assertThat((Long)((Long)SpannerApiFutures.get((ApiFuture)countAfterInsert))).isEqualTo((Object)1L);
            Truth.assertThat((Boolean)(RETRY_STATISTICS.totalSuccessfulRetries >= 1 ? 1 : 0)).isTrue();
            rs = connection.executeQueryAsync(Statement.of((String)"SELECT COUNT(*) AS C FROM TEST WHERE ID=1"), new Options.QueryOption[0]);
            try {
                Truth.assertThat((Boolean)rs.next()).isTrue();
                Truth.assertThat((Long)rs.getLong("C")).isEqualTo((Object)1L);
                Truth.assertThat((Boolean)rs.next()).isFalse();
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
    }

    @Test
    public void testNextCallAborted() {
        ITAbstractSpannerTest.AbortInterceptor interceptor = new ITAbstractSpannerTest.AbortInterceptor(0.0);
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection(interceptor, new CountTransactionRetryListener());){
            connection.executeUpdateAsync(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (1, 'test 1')"));
            connection.executeUpdateAsync(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (2, 'test 2')"));
            try (AsyncResultSet rs = connection.executeQueryAsync(Statement.of((String)"SELECT * FROM TEST ORDER BY ID"), new Options.QueryOption[0]);){
                Truth.assertThat((Boolean)rs.next()).isTrue();
                Truth.assertThat((Long)rs.getLong("ID")).isEqualTo((Object)1L);
                interceptor.setProbability(1.0);
                interceptor.setOnlyInjectOnce(true);
                Truth.assertThat((Boolean)rs.next()).isTrue();
                Truth.assertThat((Long)rs.getLong("ID")).isEqualTo((Object)2L);
                Truth.assertThat((Boolean)(RETRY_STATISTICS.totalSuccessfulRetries >= 1 ? 1 : 0)).isTrue();
                Truth.assertThat((Boolean)rs.next()).isFalse();
            }
            connection.commitAsync();
            this.verifyRecordCount(connection, 2L);
        }
    }

    @Test
    public void testMultipleAborts() {
        ITAbstractSpannerTest.AbortInterceptor interceptor = new ITAbstractSpannerTest.AbortInterceptor(0.0);
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection(interceptor, new CountTransactionRetryListener());){
            ApiFuture<Long> count = this.getTestRecordCountAsync(connection);
            interceptor.setProbability(1.0);
            interceptor.setOnlyInjectOnce(true);
            SpannerApiFutures.get((ApiFuture)connection.executeUpdateAsync(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (1, 'test 1')")));
            interceptor.setProbability(1.0);
            interceptor.setOnlyInjectOnce(true);
            SpannerApiFutures.get((ApiFuture)connection.executeUpdateAsync(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (2, 'test 2')")));
            interceptor.setProbability(1.0);
            interceptor.setOnlyInjectOnce(true);
            SpannerApiFutures.get((ApiFuture)connection.executeUpdateAsync(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (3, 'test 3')")));
            ApiFuture commit = connection.commitAsync();
            Truth.assertThat((Long)((Long)SpannerApiFutures.get(count))).isEqualTo((Object)0L);
            Truth.assertThat((Object)SpannerApiFutures.get((ApiFuture)commit)).isNull();
            Truth.assertThat((Integer)RETRY_STATISTICS.totalSuccessfulRetries).isAtLeast((Comparable)Integer.valueOf(3));
            this.verifyRecordCount(connection, 3L);
        }
    }

    @Test
    public void testAbortAfterSelect() {
        ITAbstractSpannerTest.AbortInterceptor interceptor = new ITAbstractSpannerTest.AbortInterceptor(0.0);
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection(interceptor, new CountTransactionRetryListener());){
            ApiFuture<Long> count = this.getTestRecordCountAsync(connection);
            connection.executeUpdateAsync(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (1, 'test 1')"));
            SettableApiFuture initialRecord = SettableApiFuture.create();
            try (AsyncResultSet rs = connection.executeQueryAsync(Statement.of((String)"SELECT * FROM TEST WHERE ID=1"), new Options.QueryOption[0]);){
                rs.setCallback((Executor)executor, resultSet -> {
                    try {
                        while (true) {
                            switch (resultSet.tryNext()) {
                                case DONE: {
                                    return AsyncResultSet.CallbackResponse.DONE;
                                }
                                case NOT_READY: {
                                    return AsyncResultSet.CallbackResponse.CONTINUE;
                                }
                                case OK: {
                                    initialRecord.set((Object)resultSet.getCurrentRowAsStruct());
                                }
                            }
                        }
                    }
                    catch (Throwable t) {
                        initialRecord.setException(t);
                        return AsyncResultSet.CallbackResponse.DONE;
                    }
                });
            }
            interceptor.setProbability(1.0);
            interceptor.setOnlyInjectOnce(true);
            connection.executeUpdateAsync(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (2, 'test 2')"));
            SettableApiFuture secondRecord = SettableApiFuture.create();
            try (AsyncResultSet rs = connection.executeQueryAsync(Statement.of((String)"SELECT * FROM TEST WHERE ID=1"), new Options.QueryOption[0]);){
                rs.setCallback((Executor)executor, resultSet -> {
                    try {
                        while (true) {
                            switch (resultSet.tryNext()) {
                                case DONE: {
                                    return AsyncResultSet.CallbackResponse.DONE;
                                }
                                case NOT_READY: {
                                    return AsyncResultSet.CallbackResponse.CONTINUE;
                                }
                                case OK: {
                                    secondRecord.set((Object)resultSet.getCurrentRowAsStruct());
                                }
                            }
                        }
                    }
                    catch (Throwable t) {
                        secondRecord.setException(t);
                        return AsyncResultSet.CallbackResponse.DONE;
                    }
                });
            }
            ApiFuture commit = connection.commitAsync();
            Truth.assertThat((Long)((Long)SpannerApiFutures.get(count))).isEqualTo((Object)0L);
            Truth.assertThat((Object)SpannerApiFutures.get((ApiFuture)initialRecord)).isEqualTo(SpannerApiFutures.get((ApiFuture)secondRecord));
            Truth.assertThat((Object)SpannerApiFutures.get((ApiFuture)commit)).isNull();
            Truth.assertThat((Boolean)(RETRY_STATISTICS.totalSuccessfulRetries >= 1 ? 1 : 0)).isTrue();
        }
    }

    @Test
    public void testAbortWithResultSetHalfway() {
        ITAbstractSpannerTest.AbortInterceptor interceptor = new ITAbstractSpannerTest.AbortInterceptor(0.0);
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection(interceptor, new CountTransactionRetryListener());){
            connection.executeUpdateAsync(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (1, 'test 1')"));
            connection.executeUpdateAsync(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (2, 'test 2')"));
            try (AsyncResultSet rs = connection.executeQueryAsync(Statement.of((String)"SELECT * FROM TEST ORDER BY ID"), new Options.QueryOption[0]);){
                Truth.assertThat((Boolean)rs.next()).isTrue();
                Truth.assertThat((Long)rs.getLong("ID")).isEqualTo((Object)1L);
                interceptor.setProbability(1.0);
                interceptor.setOnlyInjectOnce(true);
                connection.executeUpdateAsync(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (3, 'test 3')"));
                Truth.assertThat((Boolean)rs.next()).isTrue();
                Truth.assertThat((Long)rs.getLong("ID")).isEqualTo((Object)2L);
                Truth.assertThat((Boolean)rs.next()).isFalse();
            }
            SpannerApiFutures.get((ApiFuture)connection.commitAsync());
            Truth.assertThat((Integer)RETRY_STATISTICS.totalSuccessfulRetries).isAtLeast((Comparable)Integer.valueOf(1));
            this.verifyRecordCount(connection, 3L);
        }
    }

    @Test
    public void testAbortWithResultSetFullyConsumed() {
        ITAbstractSpannerTest.AbortInterceptor interceptor = new ITAbstractSpannerTest.AbortInterceptor(0.0);
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection(interceptor, new CountTransactionRetryListener());){
            connection.executeUpdateAsync(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (1, 'test 1')"));
            connection.executeUpdateAsync(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (2, 'test 2')"));
            try (AsyncResultSet rs = connection.executeQueryAsync(Statement.of((String)"SELECT * FROM TEST ORDER BY ID"), new Options.QueryOption[0]);){
                rs.setCallback((Executor)executor, resultSet -> {
                    while (true) {
                        switch (resultSet.tryNext()) {
                            case DONE: {
                                return AsyncResultSet.CallbackResponse.DONE;
                            }
                            case NOT_READY: {
                                return AsyncResultSet.CallbackResponse.CONTINUE;
                            }
                        }
                    }
                });
            }
            interceptor.setProbability(1.0);
            interceptor.setOnlyInjectOnce(true);
            connection.executeUpdateAsync(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (3, 'test 3')"));
            SpannerApiFutures.get((ApiFuture)connection.commitAsync());
            Truth.assertThat((Integer)RETRY_STATISTICS.totalSuccessfulRetries).isAtLeast((Comparable)Integer.valueOf(1));
            this.verifyRecordCount(connection, 3L);
        }
    }

    @Test
    public void testAbortWithConcurrentInsert() {
        Assume.assumeFalse((String)"concurrent transactions are not supported on the emulator", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        ITAbstractSpannerTest.AbortInterceptor interceptor = new ITAbstractSpannerTest.AbortInterceptor(0.0);
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection(interceptor, new CountTransactionRetryListener());){
            connection.executeUpdateAsync(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (1, 'test 1')"));
            connection.executeUpdateAsync(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (2, 'test 2')"));
            try (AsyncResultSet rs = connection.executeQueryAsync(Statement.of((String)"SELECT * FROM TEST ORDER BY ID"), new Options.QueryOption[0]);){
                SpannerApiFutures.get((ApiFuture)rs.setCallback((Executor)executor, resultSet -> {
                    while (true) {
                        switch (resultSet.tryNext()) {
                            case DONE: {
                                return AsyncResultSet.CallbackResponse.DONE;
                            }
                            case NOT_READY: {
                                return AsyncResultSet.CallbackResponse.CONTINUE;
                            }
                        }
                    }
                }));
            }
            try (ITAbstractSpannerTest.ITConnection connection2 = this.createConnection();){
                connection2.executeUpdateAsync(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (3, 'test 3')"));
                SpannerApiFutures.get((ApiFuture)connection2.commitAsync());
            }
            interceptor.setProbability(1.0);
            interceptor.setOnlyInjectOnce(true);
            ApiFuture updateCount = connection.executeUpdateAsync(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (4, 'test 4')"));
            try {
                SpannerApiFutures.get((ApiFuture)updateCount);
                Assert.fail((String)"Missing expected exception");
            }
            catch (AbortedDueToConcurrentModificationException e) {
                this.assertRetryStatistics(1, 1, 0);
            }
        }
    }

    @Test
    public void testAbortWithConcurrentDelete() {
        Assume.assumeFalse((String)"concurrent transactions are not supported on the emulator", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        ITAbstractSpannerTest.AbortInterceptor interceptor = new ITAbstractSpannerTest.AbortInterceptor(0.0);
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.executeUpdateAsync(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (1, 'test 1')"));
            connection.executeUpdateAsync(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (2, 'test 2')"));
            SpannerApiFutures.get((ApiFuture)connection.commitAsync());
        }
        connection = this.createConnection(interceptor, new CountTransactionRetryListener());
        try {
            try (AsyncResultSet rs = connection.executeQueryAsync(Statement.of((String)"SELECT * FROM TEST ORDER BY ID"), new Options.QueryOption[0]);){
                SpannerApiFutures.get((ApiFuture)rs.setCallback((Executor)executor, resultSet -> {
                    while (true) {
                        switch (resultSet.tryNext()) {
                            case DONE: {
                                return AsyncResultSet.CallbackResponse.DONE;
                            }
                            case NOT_READY: {
                                return AsyncResultSet.CallbackResponse.CONTINUE;
                            }
                        }
                    }
                }));
            }
            try (ITAbstractSpannerTest.ITConnection connection2 = this.createConnection();){
                connection2.executeUpdateAsync(Statement.of((String)"DELETE FROM TEST WHERE ID=1"));
                SpannerApiFutures.get((ApiFuture)connection2.commitAsync());
            }
            interceptor.setProbability(1.0);
            interceptor.setOnlyInjectOnce(true);
            try {
                SpannerApiFutures.get((ApiFuture)connection.executeUpdateAsync(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (3, 'test 3')")));
                Assert.fail((String)"Missing expected exception");
            }
            catch (AbortedDueToConcurrentModificationException e) {
                this.assertRetryStatistics(1, 1, 0);
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    @Test
    public void testAbortWithConcurrentUpdate() {
        Assume.assumeFalse((String)"concurrent transactions are not supported on the emulator", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        ITAbstractSpannerTest.AbortInterceptor interceptor = new ITAbstractSpannerTest.AbortInterceptor(0.0);
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.executeUpdateAsync(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (1, 'test 1')"));
            connection.executeUpdateAsync(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (2, 'test 2')"));
            SpannerApiFutures.get((ApiFuture)connection.commitAsync());
        }
        connection = this.createConnection(interceptor, new CountTransactionRetryListener());
        try {
            try (AsyncResultSet rs = connection.executeQueryAsync(Statement.of((String)"SELECT * FROM TEST ORDER BY ID"), new Options.QueryOption[0]);){
                SpannerApiFutures.get((ApiFuture)rs.setCallback((Executor)executor, resultSet -> {
                    while (true) {
                        switch (resultSet.tryNext()) {
                            case DONE: {
                                return AsyncResultSet.CallbackResponse.DONE;
                            }
                            case NOT_READY: {
                                return AsyncResultSet.CallbackResponse.CONTINUE;
                            }
                        }
                    }
                }));
            }
            try (ITAbstractSpannerTest.ITConnection connection2 = this.createConnection();){
                connection2.executeUpdateAsync(Statement.of((String)"UPDATE TEST SET NAME='test updated' WHERE ID=2"));
                SpannerApiFutures.get((ApiFuture)connection2.commitAsync());
            }
            interceptor.setProbability(1.0);
            interceptor.setOnlyInjectOnce(true);
            try {
                SpannerApiFutures.get((ApiFuture)connection.executeUpdateAsync(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (3, 'test 3')")));
                Assert.fail((String)"Missing expected exception");
            }
            catch (AbortedDueToConcurrentModificationException e) {
                this.assertRetryStatistics(1, 1, 0);
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    @Test
    public void testAbortWithUnseenConcurrentInsert() throws InterruptedException {
        Assume.assumeFalse((String)"concurrent transactions are not supported on the emulator", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        ITAbstractSpannerTest.AbortInterceptor interceptor = new ITAbstractSpannerTest.AbortInterceptor(0.0);
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection(interceptor, new CountTransactionRetryListener());){
            connection.executeUpdateAsync(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (1, 'test 1')"));
            connection.executeUpdateAsync(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (2, 'test 2')"));
            connection.executeUpdateAsync(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (3, 'test 3')"));
            AtomicInteger count = new AtomicInteger();
            AtomicLong lastSeenId = new AtomicLong();
            CountDownLatch latch1 = new CountDownLatch(1);
            CountDownLatch latch2 = new CountDownLatch(1);
            try (AsyncResultSet rs = connection.executeQueryAsync(Statement.of((String)"SELECT * FROM TEST ORDER BY ID"), new Options.QueryOption[]{Options.bufferRows((int)1)});){
                ApiFuture finished = rs.setCallback((Executor)executor, resultSet -> {
                    try {
                        while (true) {
                            switch (resultSet.tryNext()) {
                                case DONE: {
                                    return AsyncResultSet.CallbackResponse.DONE;
                                }
                                case NOT_READY: {
                                    return AsyncResultSet.CallbackResponse.CONTINUE;
                                }
                                case OK: {
                                    count.incrementAndGet();
                                    lastSeenId.set(resultSet.getLong("ID"));
                                }
                            }
                            if (count.get() != 1) continue;
                            latch1.countDown();
                            if (!latch2.await(120L, TimeUnit.SECONDS)) break;
                        }
                        throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.DEADLINE_EXCEEDED, (String)"Timeout while waiting for latch2");
                    }
                    catch (Throwable t) {
                        throw SpannerExceptionFactory.asSpannerException((Throwable)t);
                    }
                });
                try (ITAbstractSpannerTest.ITConnection connection2 = this.createConnection();){
                    Truth.assertThat((Boolean)latch1.await(60L, TimeUnit.SECONDS)).isTrue();
                    connection2.executeUpdateAsync(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (4, 'test 4')"));
                    SpannerApiFutures.get((ApiFuture)connection2.commitAsync());
                }
                interceptor.setProbability(1.0);
                interceptor.setOnlyInjectOnce(true);
                int currentRetryCount = RETRY_STATISTICS.totalRetryAttemptsStarted;
                SpannerApiFutures.get((ApiFuture)connection.executeUpdateAsync(Statement.of((String)"INSERT INTO TEST (ID, NAME) VALUES (5, 'test 5')")));
                Truth.assertThat((Integer)RETRY_STATISTICS.totalRetryAttemptsStarted).isAtLeast((Comparable)Integer.valueOf(currentRetryCount + 1));
                latch2.countDown();
                SpannerApiFutures.get((ApiFuture)finished);
                Truth.assertThat((Integer)count.get()).isEqualTo((Object)4);
                Truth.assertThat((Long)lastSeenId.get()).isEqualTo((Object)4L);
            }
            SpannerApiFutures.get((ApiFuture)connection.commitAsync());
            Truth.assertThat((Integer)RETRY_STATISTICS.totalSuccessfulRetries).isAtLeast((Comparable)Integer.valueOf(1));
        }
    }

    @Test
    public void testRetryLargeResultSet() {
        int NUMBER_OF_TEST_RECORDS = 100000;
        long UPDATED_RECORDS = 1000L;
        ITAbstractSpannerTest.AbortInterceptor interceptor = new ITAbstractSpannerTest.AbortInterceptor(0.0);
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            for (int i = 0; i < 100000; ++i) {
                connection.bufferedWrite(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"TEST").set("ID").to((long)i)).set("NAME").to("test " + i)).build());
                if (i % 1000 != 0) continue;
                connection.commitAsync();
            }
            SpannerApiFutures.get((ApiFuture)connection.commitAsync());
        }
        connection = this.createConnection(interceptor, new CountTransactionRetryListener());
        try {
            try (AsyncResultSet rs = connection.executeQueryAsync(Statement.of((String)"SELECT * FROM TEST ORDER BY ID"), new Options.QueryOption[0]);){
                ApiFuture finished = rs.setCallback((Executor)executor, resultSet -> {
                    while (true) {
                        switch (resultSet.tryNext()) {
                            case DONE: {
                                return AsyncResultSet.CallbackResponse.DONE;
                            }
                            case NOT_READY: {
                                return AsyncResultSet.CallbackResponse.CONTINUE;
                            }
                        }
                    }
                });
                SpannerApiFutures.get((ApiFuture)finished);
            }
            interceptor.setProbability(1.0);
            interceptor.setOnlyInjectOnce(true);
            connection.executeUpdateAsync(((Statement.Builder)Statement.newBuilder((String)"UPDATE TEST SET NAME='updated' WHERE ID<@max_id").bind("max_id").to(1000L)).build());
            connection.commitAsync();
            rs = connection.executeQueryAsync(Statement.of((String)"SELECT COUNT(*) AS C FROM TEST WHERE NAME='updated'"), new Options.QueryOption[0]);
            try {
                Truth.assertThat((Boolean)rs.next()).isTrue();
                Truth.assertThat((Long)rs.getLong("C")).isEqualTo((Object)1000L);
                Truth.assertThat((Boolean)rs.next()).isFalse();
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            this.assertRetryStatistics(1, 0, 1);
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    @Test
    public void testRetryHighAbortRate() {
        int NUMBER_OF_TEST_RECORDS = 10000;
        long UPDATED_RECORDS = 1000L;
        ITAbstractSpannerTest.AbortInterceptor interceptor = new ITAbstractSpannerTest.AbortInterceptor(0.25);
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection(interceptor, new CountTransactionRetryListener());){
            for (int i = 0; i < 10000; ++i) {
                connection.bufferedWrite(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"TEST").set("ID").to((long)i)).set("NAME").to("test " + i)).build());
                if (i % 1000 != 0) continue;
                connection.commitAsync();
            }
            connection.commitAsync();
            interceptor.setProbability(1.0E-4);
            try (AsyncResultSet rs = connection.executeQueryAsync(Statement.of((String)"SELECT * FROM TEST ORDER BY ID"), new Options.QueryOption[0]);){
                ApiFuture finished = rs.setCallback((Executor)executor, resultSet -> {
                    while (true) {
                        switch (resultSet.tryNext()) {
                            case DONE: {
                                return AsyncResultSet.CallbackResponse.DONE;
                            }
                            case NOT_READY: {
                                return AsyncResultSet.CallbackResponse.CONTINUE;
                            }
                        }
                    }
                });
                SpannerApiFutures.get((ApiFuture)finished);
            }
            interceptor.setProbability(0.5);
            connection.executeUpdateAsync(((Statement.Builder)Statement.newBuilder((String)"UPDATE TEST SET NAME='updated' WHERE ID<@max_id").bind("max_id").to(1000L)).build());
            SpannerApiFutures.get((ApiFuture)connection.commitAsync());
            rs = connection.executeQueryAsync(Statement.of((String)"SELECT COUNT(*) AS C FROM TEST WHERE NAME='updated'"), new Options.QueryOption[0]);
            try {
                Truth.assertThat((Boolean)rs.next()).isTrue();
                Truth.assertThat((Long)rs.getLong("C")).isEqualTo((Object)1000L);
                Truth.assertThat((Boolean)rs.next()).isFalse();
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            SpannerApiFutures.get((ApiFuture)connection.commitAsync());
        }
        catch (AbortedException e) {
            logger.log(Level.FINE, "testRetryHighAbortRate aborted because of too many retries", e);
        }
        logger.fine("Total number of retries started: " + RETRY_STATISTICS.totalRetryAttemptsStarted);
        logger.fine("Total number of retries finished: " + RETRY_STATISTICS.totalRetryAttemptsFinished);
        logger.fine("Total number of retries successful: " + RETRY_STATISTICS.totalSuccessfulRetries);
        logger.fine("Total number of retries aborted: " + RETRY_STATISTICS.totalNestedAborts);
        logger.fine("Total number of times the max retry count was exceeded: " + RETRY_STATISTICS.totalMaxAttemptsExceeded);
    }

    private void assertRetryStatistics(int minAttemptsStartedExpected, int concurrentModificationsExpected, int successfulRetriesExpected) {
        Truth.assertThat((Integer)RETRY_STATISTICS.totalRetryAttemptsStarted).isAtLeast((Comparable)Integer.valueOf(minAttemptsStartedExpected));
        Truth.assertThat((Integer)RETRY_STATISTICS.totalConcurrentModifications).isEqualTo((Object)concurrentModificationsExpected);
        Truth.assertThat((Integer)RETRY_STATISTICS.totalSuccessfulRetries).isAtLeast((Comparable)Integer.valueOf(successfulRetriesExpected));
    }

    public static class CountTransactionRetryListener
    implements TransactionRetryListener {
        public void retryStarting(Timestamp transactionStarted, long transactionId, int retryAttempt) {
            RETRY_STATISTICS.totalRetryAttemptsStarted++;
        }

        public void retryFinished(Timestamp transactionStarted, long transactionId, int retryAttempt, TransactionRetryListener.RetryResult result) {
            RETRY_STATISTICS.totalRetryAttemptsFinished++;
            switch (result) {
                case RETRY_ABORTED_AND_MAX_ATTEMPTS_EXCEEDED: {
                    RETRY_STATISTICS.totalMaxAttemptsExceeded++;
                    break;
                }
                case RETRY_ABORTED_AND_RESTARTING: {
                    RETRY_STATISTICS.totalNestedAborts++;
                    break;
                }
                case RETRY_ABORTED_DUE_TO_CONCURRENT_MODIFICATION: {
                    RETRY_STATISTICS.totalConcurrentModifications++;
                    break;
                }
                case RETRY_ERROR: {
                    RETRY_STATISTICS.totalErroredRetries++;
                    break;
                }
                case RETRY_SUCCESSFUL: {
                    RETRY_STATISTICS.totalSuccessfulRetries++;
                    break;
                }
            }
        }
    }

    private static class RetryStatistics {
        private int totalRetryAttemptsStarted;
        private int totalRetryAttemptsFinished;
        private int totalSuccessfulRetries;
        private int totalErroredRetries;
        private int totalNestedAborts;
        private int totalMaxAttemptsExceeded;
        private int totalConcurrentModifications;

        private RetryStatistics() {
        }

        private void clear() {
            this.totalRetryAttemptsStarted = 0;
            this.totalRetryAttemptsFinished = 0;
            this.totalSuccessfulRetries = 0;
            this.totalErroredRetries = 0;
            this.totalNestedAborts = 0;
            this.totalMaxAttemptsExceeded = 0;
            this.totalConcurrentModifications = 0;
        }
    }
}

