/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.it;

import com.google.cloud.spanner.Database;
import com.google.cloud.spanner.DatabaseAdminClient;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.IntegrationTestEnv;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ParallelIntegrationTest;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Value;
import com.google.cloud.spanner.testing.EmulatorSpannerHelper;
import com.google.cloud.spanner.testing.RemoteSpannerHelper;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.NullValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.threeten.bp.Duration;

@Ignore(value="Feature is not yet generally available")
@Category(value={ParallelIntegrationTest.class})
@RunWith(value=JUnit4.class)
public class ITPgJsonbTest {
    private static final Duration OPERATION_TIMEOUT = Duration.ofMinutes((long)5L);
    @ClassRule
    public static IntegrationTestEnv env = new IntegrationTestEnv();
    private static RemoteSpannerHelper testHelper;
    private static DatabaseAdminClient databaseAdminClient;
    private static List<DatabaseId> databasesToDrop;
    private static String projectId;
    private static String instanceId;
    private static String databaseId;
    private DatabaseClient databaseClient;
    private String tableName;
    private static final String JSON_VALUE_1 = "{\"color\":\"red\",\"value\":\"#f00\"}";
    private static final String JSON_VALUE_2 = "[   {\"color\":\"red\",\"value\":\"#f00\"},   {\"color\":\"green\",\"value\":\"#0f0\"},   {\"color\":\"blue\",\"value\":\"#00f\"}]";

    @BeforeClass
    public static void beforeClass() throws Exception {
        Assume.assumeFalse((String)"PgJsonb is not supported in the emulator", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        testHelper = env.getTestHelper();
        databaseAdminClient = testHelper.getClient().getDatabaseAdminClient();
        databasesToDrop = new ArrayList<DatabaseId>();
        projectId = testHelper.getInstanceId().getProject();
        instanceId = testHelper.getInstanceId().getInstance();
        databaseId = testHelper.getUniqueDatabaseId();
        Database database = databaseAdminClient.newDatabaseBuilder(DatabaseId.of((String)projectId, (String)instanceId, (String)databaseId)).setDialect(Dialect.POSTGRESQL).build();
        databaseAdminClient.createDatabase(database, Collections.emptyList()).get(OPERATION_TIMEOUT.toMillis(), TimeUnit.MILLISECONDS);
        databasesToDrop.add(database.getId());
    }

    @AfterClass
    public static void afterClass() throws Exception {
        if (databasesToDrop != null) {
            for (DatabaseId id : databasesToDrop) {
                try {
                    databaseAdminClient.dropDatabase(id.getInstanceId().getInstance(), id.getDatabase());
                }
                catch (Exception e) {
                    System.err.println("Failed to drop database " + id + ", skipping...: " + e.getMessage());
                }
            }
        }
    }

    @Before
    public void setUp() throws Exception {
        this.databaseClient = testHelper.getClient().getDatabaseClient(DatabaseId.of((String)projectId, (String)instanceId, (String)databaseId));
        this.tableName = testHelper.getUniqueDatabaseId();
        databaseAdminClient.updateDatabaseDdl(instanceId, databaseId, Collections.singletonList("CREATE TABLE \"" + this.tableName + "\" (id BIGINT PRIMARY KEY, col1 JSONB)"), null).get(OPERATION_TIMEOUT.toMillis(), TimeUnit.MILLISECONDS);
    }

    @Test
    public void testPgJsonbAsPrimaryKey() {
        ExecutionException executionException = (ExecutionException)Assert.assertThrows(ExecutionException.class, () -> databaseAdminClient.updateDatabaseDdl(instanceId, databaseId, Collections.singletonList("CREATE TABLE with_jsonb_pk (id jsonb primary key)"), null).get(OPERATION_TIMEOUT.toMillis(), TimeUnit.MILLISECONDS));
        SpannerException spannerException = SpannerExceptionFactory.asSpannerException((Throwable)executionException.getCause());
        Assert.assertEquals((Object)ErrorCode.INVALID_ARGUMENT, (Object)spannerException.getErrorCode());
        Assert.assertTrue((String)spannerException.getMessage(), (boolean)spannerException.getMessage().contains("Column with_jsonb_pk.id has type PG.JSONB, but is part of the primary key."));
    }

    @Test
    public void testPgJsonbInSecondaryIndex() {
        ExecutionException executionException = (ExecutionException)Assert.assertThrows(ExecutionException.class, () -> databaseAdminClient.updateDatabaseDdl(instanceId, databaseId, Collections.singletonList("CREATE INDEX idx_jsonb on \"" + this.tableName + "\" (col1)"), null).get(OPERATION_TIMEOUT.toMillis(), TimeUnit.MILLISECONDS));
        SpannerException spannerException = SpannerExceptionFactory.asSpannerException((Throwable)executionException.getCause());
        Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)spannerException.getErrorCode());
        Assert.assertTrue((String)spannerException.getMessage(), (boolean)spannerException.getMessage().contains("Index idx_jsonb is defined on a column of unsupported type PG.JSONB."));
    }

    @Test
    public void testLiteralPgJsonb() {
        Assume.assumeFalse((String)"PgJsonb is not supported in the emulator", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        this.databaseClient.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
            transaction.executeUpdate(Statement.of((String)("INSERT INTO " + this.tableName + " (id, col1) VALUES (1, '" + JSON_VALUE_1 + "'), (2, '" + JSON_VALUE_2 + "'), (3, '{}'), (4, '[]'), (5, null)")), new Options.UpdateOption[0]);
            return null;
        });
        this.verifyContents();
    }

    @Test
    public void testPgJsonbParameter() {
        Assume.assumeFalse((String)"PgJsonb is not supported in the emulator", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        this.databaseClient.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
            transaction.executeUpdate(((Statement.Builder)((Statement.Builder)((Statement.Builder)((Statement.Builder)((Statement.Builder)Statement.newBuilder((String)("INSERT INTO " + this.tableName + " (id, col1) VALUES (1, $1), (2, $2), (3, $3), (4, $4), (5, $5)")).bind("p1").to(Value.pgJsonb((String)JSON_VALUE_1))).bind("p2").to(Value.pgJsonb((String)JSON_VALUE_2))).bind("p3").to(Value.pgJsonb((String)"{}"))).bind("p4").to(Value.pgJsonb((String)"[]"))).bind("p5").to(Value.pgJsonb(null))).build(), new Options.UpdateOption[0]);
            return null;
        });
        this.verifyContents();
    }

    @Ignore(value="Untyped jsonb parameters are not yet supported")
    @Test
    public void testPgJsonbUntypedParameter() {
        Assume.assumeFalse((String)"PgJsonb is not supported in the emulator", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        this.databaseClient.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
            transaction.executeUpdate(((Statement.Builder)((Statement.Builder)((Statement.Builder)((Statement.Builder)((Statement.Builder)Statement.newBuilder((String)("INSERT INTO " + this.tableName + " (id, col1) VALUES (1, $1), (2, $2), (3, $3), (4, $4), (5, $5)")).bind("p1").to(Value.untyped((com.google.protobuf.Value)com.google.protobuf.Value.newBuilder().setStringValue(JSON_VALUE_1).build()))).bind("p2").to(Value.untyped((com.google.protobuf.Value)com.google.protobuf.Value.newBuilder().setStringValue(JSON_VALUE_2).build()))).bind("p3").to(Value.untyped((com.google.protobuf.Value)com.google.protobuf.Value.newBuilder().setStringValue("{}").build()))).bind("p4").to(Value.untyped((com.google.protobuf.Value)com.google.protobuf.Value.newBuilder().setStringValue("[]").build()))).bind("p5").to(Value.untyped((com.google.protobuf.Value)com.google.protobuf.Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build()))).build(), new Options.UpdateOption[0]);
            return null;
        });
        this.verifyContents();
    }

    @Test
    public void testMutationsWithPgJsonbAsString() {
        Assume.assumeFalse((String)"PgJsonb is not supported in the emulator", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        this.databaseClient.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
            transaction.buffer((Iterable)ImmutableList.of((Object)((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)this.tableName).set("id").to(1L)).set("col1").to(JSON_VALUE_1)).build(), (Object)((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)this.tableName).set("id").to(2L)).set("col1").to(JSON_VALUE_2)).build(), (Object)((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)this.tableName).set("id").to(3L)).set("col1").to("{}")).build(), (Object)((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)this.tableName).set("id").to(4L)).set("col1").to("[]")).build(), (Object)((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)this.tableName).set("id").to(5L)).set("col1").to((String)null)).build()));
            return null;
        });
        this.verifyContents();
    }

    @Test
    public void testMutationsWithPgJsonbAsValue() {
        Assume.assumeFalse((String)"PgJsonb is not supported in the emulator", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        this.databaseClient.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
            transaction.buffer((Iterable)ImmutableList.of((Object)((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)this.tableName).set("id").to(1L)).set("col1").to(Value.pgJsonb((String)JSON_VALUE_1))).build(), (Object)((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)this.tableName).set("id").to(2L)).set("col1").to(Value.pgJsonb((String)JSON_VALUE_2))).build(), (Object)((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)this.tableName).set("id").to(3L)).set("col1").to(Value.pgJsonb((String)"{}"))).build(), (Object)((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)this.tableName).set("id").to(4L)).set("col1").to(Value.pgJsonb((String)"[]"))).build(), (Object)((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)this.tableName).set("id").to(5L)).set("col1").to(Value.pgJsonb(null))).build()));
            return null;
        });
        this.verifyContents();
    }

    private void verifyContents() {
        try (ResultSet resultSet = this.databaseClient.singleUse().executeQuery(Statement.of((String)("SELECT * FROM " + this.tableName + " ORDER BY id")), new Options.QueryOption[0]);){
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)"{\"color\": \"red\", \"value\": \"#f00\"}", (Object)resultSet.getPgJsonb("col1"));
            Assert.assertEquals((Object)Value.pgJsonb((String)"{\"color\": \"red\", \"value\": \"#f00\"}"), (Object)resultSet.getValue("col1"));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)"[{\"color\": \"red\", \"value\": \"#f00\"}, {\"color\": \"green\", \"value\": \"#0f0\"}, {\"color\": \"blue\", \"value\": \"#00f\"}]", (Object)resultSet.getPgJsonb("col1"));
            Assert.assertEquals((Object)Value.pgJsonb((String)"[{\"color\": \"red\", \"value\": \"#f00\"}, {\"color\": \"green\", \"value\": \"#0f0\"}, {\"color\": \"blue\", \"value\": \"#00f\"}]"), (Object)resultSet.getValue("col1"));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)"{}", (Object)resultSet.getPgJsonb("col1"));
            Assert.assertEquals((Object)Value.pgJsonb((String)"{}"), (Object)resultSet.getValue("col1"));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)"[]", (Object)resultSet.getPgJsonb("col1"));
            Assert.assertEquals((Object)Value.pgJsonb((String)"[]"), (Object)resultSet.getValue("col1"));
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertTrue((boolean)resultSet.isNull("col1"));
            Assert.assertFalse((boolean)resultSet.next());
        }
    }
}

