/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.gax.grpc.GrpcInterceptorProvider;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.TestEnvConfig;
import com.google.cloud.spanner.spi.v1.SpannerInterceptorProvider;
import com.google.common.base.Preconditions;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Grpc;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;

public class GceTestEnvConfig
implements TestEnvConfig {
    public static final String GCE_PROJECT_ID = "spanner.gce.config.project_id";
    public static final String GCE_SERVER_URL = "spanner.gce.config.server_url";
    public static final String GCE_CREDENTIALS_FILE = "spanner.gce.config.credentials_file";
    public static final String GCE_STREAM_BROKEN_PROBABILITY = "spanner.gce.config.stream_broken_probability";
    public static final String ATTEMPT_DIRECT_PATH = "spanner.attempt_directpath";
    public static final String DIRECT_PATH_TEST_SCENARIO = "spanner.directpath_test_scenario";
    public static final String DP_IPV6_PREFIX = "2001:4860:8040";
    public static final String DP_IPV4_PREFIX = "34.126";
    private static final String DIRECT_PATH_ENDPOINT = "wrenchworks-nonprod.googleapis.com:443";
    private final SpannerOptions options;

    public GceTestEnvConfig() {
        String projectId = System.getProperty(GCE_PROJECT_ID, "");
        String serverUrl = System.getProperty(GCE_SERVER_URL, "");
        String credentialsFile = System.getProperty(GCE_CREDENTIALS_FILE, "");
        double errorProbability = Double.parseDouble(System.getProperty(GCE_STREAM_BROKEN_PROBABILITY, "0.0"));
        Preconditions.checkState((errorProbability <= 1.0 ? 1 : 0) != 0);
        boolean attemptDirectPath = Boolean.getBoolean(ATTEMPT_DIRECT_PATH);
        String directPathTestScenario = System.getProperty(DIRECT_PATH_TEST_SCENARIO, "");
        SpannerOptions.Builder builder = SpannerOptions.newBuilder().setAutoThrottleAdministrativeRequests().setTrackTransactionStarter();
        if (!projectId.isEmpty()) {
            builder.setProjectId(projectId);
        }
        if (!serverUrl.isEmpty()) {
            builder.setHost(serverUrl);
        }
        if (!credentialsFile.isEmpty()) {
            try {
                builder.setCredentials((Credentials)GoogleCredentials.fromStream((InputStream)new FileInputStream(credentialsFile)));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        SpannerInterceptorProvider interceptorProvider = SpannerInterceptorProvider.createDefault().with((ClientInterceptor)new GrpcErrorInjector(errorProbability));
        if (attemptDirectPath) {
            interceptorProvider = interceptorProvider.with((ClientInterceptor)new DirectPathAddressCheckInterceptor(directPathTestScenario));
        }
        builder.setInterceptorProvider((GrpcInterceptorProvider)interceptorProvider);
        InstantiatingGrpcChannelProvider.Builder customChannelProviderBuilder = InstantiatingGrpcChannelProvider.newBuilder();
        if (attemptDirectPath) {
            customChannelProviderBuilder.setEndpoint(DIRECT_PATH_ENDPOINT).setAttemptDirectPath(true).setInterceptorProvider((GrpcInterceptorProvider)interceptorProvider);
            builder.setChannelProvider((TransportChannelProvider)customChannelProviderBuilder.build());
        }
        this.options = builder.build();
    }

    @Override
    public SpannerOptions spannerOptions() {
        return this.options;
    }

    @Override
    public void setUp() {
    }

    @Override
    public void tearDown() {
    }

    private static class DirectPathAddressCheckInterceptor
    implements ClientInterceptor {
        private final String directPathTestScenario;

        DirectPathAddressCheckInterceptor(String directPathTestScenario) {
            this.directPathTestScenario = directPathTestScenario;
        }

        public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
            final ClientCall clientCall = next.newCall(method, callOptions);
            return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(clientCall){

                public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                    super.start((ClientCall.Listener)new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                        public void onHeaders(Metadata headers) {
                            SocketAddress remoteAddr = (SocketAddress)clientCall.getAttributes().get(Grpc.TRANSPORT_ATTR_REMOTE_ADDR);
                            if (!this.verifyRemoteAddress(remoteAddr)) {
                                throw new RuntimeException(String.format("Synthetically aborting the current request because it did not adhere to the test environment's requirement for DirectPath. Expected test for DirectPath %s scenario, but RPC was destined for %s", directPathTestScenario, remoteAddr.toString()));
                            }
                            super.onHeaders(headers);
                        }
                    }, headers);
                }
            };
        }

        private boolean verifyRemoteAddress(SocketAddress remoteAddr) {
            if (remoteAddr instanceof InetSocketAddress) {
                InetAddress inetAddress = ((InetSocketAddress)remoteAddr).getAddress();
                String addr = inetAddress.getHostAddress();
                if (this.directPathTestScenario.equals("ipv4")) {
                    return addr.startsWith(GceTestEnvConfig.DP_IPV4_PREFIX);
                }
                if (this.directPathTestScenario.equals("ipv6")) {
                    return addr.startsWith(GceTestEnvConfig.DP_IPV6_PREFIX) || addr.startsWith(GceTestEnvConfig.DP_IPV4_PREFIX);
                }
            }
            return true;
        }
    }

    private static class GrpcErrorInjector
    implements ClientInterceptor {
        private final double errorProbability;
        private final Random random = new Random();

        GrpcErrorInjector(double errorProbability) {
            this.errorProbability = errorProbability;
        }

        public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
            if (!method.getFullMethodName().startsWith("google.spanner.v1.Spanner")) {
                return next.newCall(method, callOptions);
            }
            final AtomicBoolean errorInjected = new AtomicBoolean();
            final ClientCall clientCall = next.newCall(method, callOptions);
            return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(clientCall){

                public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                    super.start((ClientCall.Listener)new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                        public void onMessage(RespT message) {
                            super.onMessage(message);
                            if (this.mayInjectError()) {
                                errorInjected.set(true);
                                clientCall.cancel("Cancelling call for injected error", null);
                            }
                        }

                        public void onClose(Status status, Metadata metadata) {
                            if (errorInjected.get()) {
                                status = Status.UNAVAILABLE.augmentDescription("INJECTED BY TEST");
                            }
                            super.onClose(status, metadata);
                        }
                    }, headers);
                }
            };
        }

        private boolean mayInjectError() {
            return this.random.nextDouble() < this.errorProbability;
        }
    }
}

