/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.ByteArray;
import com.google.cloud.Date;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AbstractResultSet;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.StructReader;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.Value;
import com.google.cloud.spanner.spi.v1.SpannerRpc;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.testing.SerializableTester;
import com.google.common.truth.Truth;
import com.google.protobuf.ByteString;
import com.google.spanner.v1.ExecuteSqlRequest;
import com.google.spanner.v1.PartialResultSet;
import com.google.spanner.v1.QueryPlan;
import com.google.spanner.v1.ResultSetMetadata;
import com.google.spanner.v1.ResultSetStats;
import com.google.spanner.v1.Transaction;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class GrpcResultSetTest {
    private AbstractResultSet.GrpcResultSet resultSet;
    private SpannerRpc.ResultStreamConsumer consumer;
    private AbstractResultSet.GrpcStreamIterator stream;

    @Before
    public void setUp() {
        this.stream = new AbstractResultSet.GrpcStreamIterator(10);
        this.stream.setCall(new SpannerRpc.StreamingCall(){

            public void cancel(@Nullable String message) {
            }

            public void request(int numMessages) {
            }
        }, false);
        this.consumer = this.stream.consumer();
        this.resultSet = new AbstractResultSet.GrpcResultSet((AbstractResultSet.CloseableIterator)this.stream, (AbstractResultSet.Listener)new NoOpListener());
    }

    public AbstractResultSet.GrpcResultSet resultSetWithMode(ExecuteSqlRequest.QueryMode queryMode) {
        return new AbstractResultSet.GrpcResultSet((AbstractResultSet.CloseableIterator)this.stream, (AbstractResultSet.Listener)new NoOpListener());
    }

    @Test
    public void metadata() {
        Type rowType = Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"f", (Type)Type.string())});
        ResultSetMetadata.Builder metadataBuilder = ResultSetMetadata.newBuilder();
        metadataBuilder.setRowType(rowType.toProto().getStructType()).getTransactionBuilder().setId(ByteString.copyFromUtf8((String)"t1"));
        PartialResultSet partialResultSet = PartialResultSet.newBuilder().setMetadata(metadataBuilder.build()).build();
        this.consumer.onPartialResultSet(partialResultSet);
        this.consumer.onCompleted();
        Truth.assertThat((Boolean)this.resultSet.next()).isFalse();
        Truth.assertThat((Object)this.resultSet.getType()).isEqualTo((Object)rowType);
    }

    @Test
    public void metadataFailure() {
        SpannerException t = SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.DEADLINE_EXCEEDED, (String)"outatime");
        this.consumer.onError(t);
        SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> this.resultSet.next());
        Assert.assertEquals((Object)ErrorCode.DEADLINE_EXCEEDED, (Object)e.getErrorCode());
        Truth.assertThat((String)e.getMessage()).contains((CharSequence)"outatime");
    }

    @Test
    public void noMetadata() {
        this.consumer.onCompleted();
        SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> this.resultSet.next());
        Assert.assertEquals((Object)ErrorCode.INTERNAL, (Object)e.getErrorCode());
    }

    @Test
    public void empty() {
        Type type = Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"f", (Type)Type.string())});
        PartialResultSet partialResultSet = PartialResultSet.newBuilder().setMetadata(GrpcResultSetTest.makeMetadata(type)).build();
        this.consumer.onPartialResultSet(partialResultSet);
        this.consumer.onCompleted();
        Truth.assertThat((Boolean)this.resultSet.next()).isFalse();
        Truth.assertThat((Object)this.resultSet.getType()).isEqualTo((Object)type);
    }

    @Test
    public void emptyMultipleResponses() {
        PartialResultSet partialResultSet = PartialResultSet.newBuilder().setMetadata(GrpcResultSetTest.makeMetadata(Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"f", (Type)Type.string())}))).build();
        this.consumer.onPartialResultSet(partialResultSet);
        this.consumer.onPartialResultSet(PartialResultSet.getDefaultInstance());
        this.consumer.onPartialResultSet(PartialResultSet.getDefaultInstance());
        this.consumer.onCompleted();
        Truth.assertThat((Boolean)this.resultSet.next()).isFalse();
    }

    private List<String> consumeAllString() {
        ArrayList<String> results = new ArrayList<String>();
        while (this.resultSet.next()) {
            results.add(this.resultSet.getString(0));
        }
        return results;
    }

    @Test
    public void singleResponse() {
        this.consumer.onPartialResultSet(PartialResultSet.newBuilder().setMetadata(GrpcResultSetTest.makeMetadata(Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"f", (Type)Type.string())}))).addValues(Value.string((String)"a").toProto()).addValues(Value.string((String)"b").toProto()).addValues(Value.string((String)"c").toProto()).build());
        this.consumer.onCompleted();
        Truth.assertThat(this.consumeAllString()).containsExactly(new Object[]{"a", "b", "c"}).inOrder();
    }

    @Test
    public void multiResponse() {
        this.consumer.onPartialResultSet(PartialResultSet.newBuilder().setMetadata(GrpcResultSetTest.makeMetadata(Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"f", (Type)Type.string())}))).addValues(Value.string((String)"a").toProto()).addValues(Value.string((String)"b").toProto()).build());
        this.consumer.onPartialResultSet(PartialResultSet.newBuilder().addValues(Value.string((String)"c").toProto()).addValues(Value.string((String)"d").toProto()).build());
        this.consumer.onPartialResultSet(PartialResultSet.newBuilder().addValues(Value.string((String)"e").toProto()).addValues(Value.string((String)"f").toProto()).build());
        this.consumer.onCompleted();
        Truth.assertThat(this.consumeAllString()).containsExactly(new Object[]{"a", "b", "c", "d", "e", "f"}).inOrder();
    }

    @Test
    public void multiResponseChunkingStreamClosed() {
        this.consumer.onPartialResultSet(PartialResultSet.newBuilder().setMetadata(GrpcResultSetTest.makeMetadata(Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"f", (Type)Type.string())}))).addValues(Value.string((String)"abcdefg").toProto()).setChunkedValue(true).build());
        this.consumer.onCompleted();
        SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> this.resultSet.next());
        Assert.assertEquals((Object)ErrorCode.INTERNAL, (Object)e.getErrorCode());
    }

    @Test
    public void multiResponseChunkingStrings() {
        this.consumer.onPartialResultSet(PartialResultSet.newBuilder().setMetadata(GrpcResultSetTest.makeMetadata(Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"f", (Type)Type.string())}))).addValues(Value.string((String)"before").toProto()).addValues(Value.string((String)"abcdefg").toProto()).setChunkedValue(true).build());
        this.consumer.onPartialResultSet(PartialResultSet.newBuilder().addValues(Value.string((String)"hijklmnop").toProto()).setChunkedValue(true).build());
        this.consumer.onPartialResultSet(PartialResultSet.newBuilder().addValues(Value.string((String)"qrstuvwxyz").toProto()).addValues(Value.string((String)"after").toProto()).setChunkedValue(false).build());
        this.consumer.onCompleted();
        Truth.assertThat(this.consumeAllString()).containsExactly(new Object[]{"before", "abcdefghijklmnopqrstuvwxyz", "after"}).inOrder();
    }

    @Test
    public void multiResponseChunkingBytes() {
        ByteArray expectedBytes = ByteArray.copyFrom((String)"abcdefghijklmnopqrstuvwxyz");
        String base64 = expectedBytes.toBase64();
        String chunk1 = base64.substring(0, 10);
        String chunk2 = base64.substring(10, 20);
        String chunk3 = base64.substring(20);
        this.consumer.onPartialResultSet(PartialResultSet.newBuilder().setMetadata(GrpcResultSetTest.makeMetadata(Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"f", (Type)Type.bytes())}))).addValues(Value.bytes((ByteArray)ByteArray.copyFrom((String)"before")).toProto()).addValues(com.google.protobuf.Value.newBuilder().setStringValue(chunk1)).setChunkedValue(true).build());
        this.consumer.onPartialResultSet(PartialResultSet.newBuilder().addValues(com.google.protobuf.Value.newBuilder().setStringValue(chunk2)).setChunkedValue(true).build());
        this.consumer.onPartialResultSet(PartialResultSet.newBuilder().addValues(com.google.protobuf.Value.newBuilder().setStringValue(chunk3)).addValues(Value.bytes((ByteArray)ByteArray.copyFrom((String)"after")).toProto()).setChunkedValue(false).build());
        this.consumer.onCompleted();
        ArrayList<ByteArray> results = new ArrayList<ByteArray>();
        while (this.resultSet.next()) {
            results.add(this.resultSet.getBytes(0));
        }
        Truth.assertThat(results).containsExactly(new Object[]{ByteArray.copyFrom((String)"before"), expectedBytes, ByteArray.copyFrom((String)"after")}).inOrder();
    }

    @Test
    public void multiResponseChunkingBoolArray() {
        List<Boolean> beforeValue = Collections.singletonList(true);
        List<Boolean> chunkedValue = Arrays.asList(false, null, true, true, true, null, null, false);
        List<Boolean> afterValue = Collections.singletonList(true);
        this.doArrayTest(beforeValue, chunkedValue, afterValue, Type.bool(), input -> Value.boolArray((Iterable)input).toProto(), input -> input.getBooleanList(0));
    }

    @Test
    public void multiResponseChunkingInt64Array() {
        List<Long> beforeValue = Collections.singletonList(10L);
        List<Long> chunkedValue = Arrays.asList(1L, 2L, null, null, 5L, null, 7L, 8L);
        List<Long> afterValue = Collections.singletonList(20L);
        this.doArrayTest(beforeValue, chunkedValue, afterValue, Type.int64(), input -> Value.int64Array((Iterable)input).toProto(), input -> input.getLongList(0));
    }

    @Test
    public void multiResponseChunkingFloat64Array() {
        List<Double> beforeValue = Collections.singletonList(10.0);
        List<Double> chunkedValue = Arrays.asList(null, 2.0, 3.0, 4.0, null, 6.0, 7.0, null);
        List<Double> afterValue = Collections.singletonList(20.0);
        this.doArrayTest(beforeValue, chunkedValue, afterValue, Type.float64(), input -> Value.float64Array((Iterable)input).toProto(), input -> input.getDoubleList(0));
    }

    @Test
    public void multiResponseChunkingStringArray() {
        List<String> beforeValue = Collections.singletonList("before");
        List<String> chunkedValue = Arrays.asList("a", "b", null, "d", null, "f", null, "h");
        List<String> afterValue = Collections.singletonList("after");
        this.doArrayTest(beforeValue, chunkedValue, afterValue, Type.string(), input -> Value.stringArray((Iterable)input).toProto(), input -> input.getStringList(0));
    }

    private static ByteArray b(String data) {
        return ByteArray.copyFrom((String)data);
    }

    @Test
    public void multiResponseChunkingBytesArray() {
        List<ByteArray> beforeValue = Collections.singletonList(GrpcResultSetTest.b("before"));
        List<ByteArray> chunkedValue = Arrays.asList(GrpcResultSetTest.b("a"), GrpcResultSetTest.b("b"), null, GrpcResultSetTest.b("d"), null, GrpcResultSetTest.b("f"), null, GrpcResultSetTest.b("h"));
        List<ByteArray> afterValue = Collections.singletonList(GrpcResultSetTest.b("after"));
        this.doArrayTest(beforeValue, chunkedValue, afterValue, Type.bytes(), input -> Value.bytesArray((Iterable)input).toProto(), input -> input.getBytesList(0));
    }

    private static Struct s(String a, long b) {
        return ((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("a").to(a)).set("b").to(b)).build();
    }

    @Test
    public void multiResponseChunkingStructArray() {
        Type elementType = Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"a", (Type)Type.string()), Type.StructField.of((String)"b", (Type)Type.int64())});
        List<Struct> beforeValue = Collections.singletonList(GrpcResultSetTest.s("before", 10L));
        List<Struct> chunkedValue = Arrays.asList(GrpcResultSetTest.s("a", 1L), GrpcResultSetTest.s("b", 2L), GrpcResultSetTest.s("c", 3L), null, GrpcResultSetTest.s(null, 5L), null, GrpcResultSetTest.s("g", 7L), GrpcResultSetTest.s("h", 8L));
        List<Struct> afterValue = Collections.singletonList(GrpcResultSetTest.s("after", 20L));
        this.doArrayTest(beforeValue, chunkedValue, afterValue, elementType, input -> Value.structArray((Type)elementType, (Iterable)input).toProto(), input -> input.getStructList(0));
    }

    @Test
    public void profileResultInFinalResultSet() {
        ImmutableMap statsMap = ImmutableMap.of((Object)"f1", (Object)Value.string((String)"").toProto(), (Object)"f2", (Object)Value.string((String)"").toProto());
        ResultSetStats stats = ResultSetStats.newBuilder().setQueryPlan(QueryPlan.newBuilder().build()).setQueryStats(com.google.protobuf.Struct.newBuilder().putAllFields((Map)statsMap).build()).build();
        ArrayList<Type.StructField> dataType = new ArrayList<Type.StructField>();
        dataType.add(Type.StructField.of((String)"data", (Type)Type.string()));
        this.consumer.onPartialResultSet(PartialResultSet.newBuilder().setMetadata(GrpcResultSetTest.makeMetadata(Type.struct(dataType))).addValues(Value.string((String)"d1").toProto()).setChunkedValue(false).setStats(stats).build());
        this.resultSet = this.resultSetWithMode(ExecuteSqlRequest.QueryMode.PROFILE);
        this.consumer.onCompleted();
        Truth.assertThat((Boolean)this.resultSet.next()).isTrue();
        Truth.assertThat((Boolean)this.resultSet.next()).isFalse();
        ResultSetStats receivedStats = this.resultSet.getStats();
        Truth.assertThat((Object)stats).isEqualTo((Object)receivedStats);
        this.resultSet.close();
    }

    @Test
    public void profileResultInExtraFinalResultSet() {
        ImmutableMap statsMap = ImmutableMap.of((Object)"f1", (Object)Value.string((String)"").toProto(), (Object)"f2", (Object)Value.string((String)"").toProto());
        ResultSetStats stats = ResultSetStats.newBuilder().setQueryPlan(QueryPlan.newBuilder().build()).setQueryStats(com.google.protobuf.Struct.newBuilder().putAllFields((Map)statsMap).build()).build();
        ArrayList<Type.StructField> dataType = new ArrayList<Type.StructField>();
        dataType.add(Type.StructField.of((String)"data", (Type)Type.string()));
        this.consumer.onPartialResultSet(PartialResultSet.newBuilder().setMetadata(GrpcResultSetTest.makeMetadata(Type.struct(dataType))).addValues(Value.string((String)"d1").toProto()).setChunkedValue(false).build());
        this.consumer.onPartialResultSet(PartialResultSet.newBuilder().setMetadata(GrpcResultSetTest.makeMetadata(Type.struct(dataType))).setChunkedValue(false).setStats(stats).build());
        this.resultSet = this.resultSetWithMode(ExecuteSqlRequest.QueryMode.PROFILE);
        this.consumer.onCompleted();
        Truth.assertThat((Boolean)this.resultSet.next()).isTrue();
        Truth.assertThat((Boolean)this.resultSet.next()).isFalse();
        ResultSetStats receivedStats = this.resultSet.getStats();
        Truth.assertThat((Object)stats).isEqualTo((Object)receivedStats);
        this.resultSet.close();
    }

    @Test
    public void planResult() {
        ResultSetStats stats = ResultSetStats.newBuilder().setQueryPlan(QueryPlan.newBuilder().build()).build();
        this.consumer.onPartialResultSet(PartialResultSet.newBuilder().setMetadata(GrpcResultSetTest.makeMetadata(Type.struct(new ArrayList()))).setChunkedValue(false).setStats(stats).build());
        this.resultSet = this.resultSetWithMode(ExecuteSqlRequest.QueryMode.PLAN);
        this.consumer.onCompleted();
        Truth.assertThat((Boolean)this.resultSet.next()).isFalse();
        ResultSetStats receivedStats = this.resultSet.getStats();
        Truth.assertThat((Object)stats).isEqualTo((Object)receivedStats);
        this.resultSet.close();
    }

    @Test
    public void statsUnavailable() {
        ResultSetStats stats = ResultSetStats.newBuilder().build();
        this.consumer.onPartialResultSet(PartialResultSet.newBuilder().setMetadata(GrpcResultSetTest.makeMetadata(Type.struct(new ArrayList()))).setChunkedValue(false).setStats(stats).build());
        this.resultSet = this.resultSetWithMode(ExecuteSqlRequest.QueryMode.PROFILE);
        this.consumer.onCompleted();
        Truth.assertThat((Object)this.resultSet.getStats()).isNull();
    }

    private <T> void doArrayTest(List<T> beforeValue, List<T> chunkedValue, List<T> afterValue, Type elementType, Function<List<T>, com.google.protobuf.Value> toProto, Function<StructReader, List<T>> getter) {
        this.consumer.onPartialResultSet(PartialResultSet.newBuilder().setMetadata(GrpcResultSetTest.makeMetadata(Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"f", (Type)Type.array((Type)elementType))}))).addValues((com.google.protobuf.Value)toProto.apply(beforeValue)).addValues((com.google.protobuf.Value)toProto.apply(chunkedValue.subList(0, 3))).setChunkedValue(true).build());
        this.consumer.onPartialResultSet(PartialResultSet.newBuilder().addValues((com.google.protobuf.Value)toProto.apply(chunkedValue.subList(3, 5))).setChunkedValue(true).build());
        this.consumer.onPartialResultSet(PartialResultSet.newBuilder().addValues((com.google.protobuf.Value)toProto.apply(chunkedValue.subList(5, chunkedValue.size()))).addValues((com.google.protobuf.Value)toProto.apply(afterValue)).setChunkedValue(false).build());
        this.consumer.onCompleted();
        Truth.assertThat((Boolean)this.resultSet.next()).isTrue();
        Truth.assertThat((Iterable)((Iterable)getter.apply((Object)this.resultSet))).containsExactlyElementsIn(beforeValue).inOrder();
        Truth.assertThat((Boolean)this.resultSet.next()).isTrue();
        Truth.assertThat((Iterable)((Iterable)getter.apply((Object)this.resultSet))).containsExactlyElementsIn(chunkedValue).inOrder();
        Truth.assertThat((Boolean)this.resultSet.next()).isTrue();
        Truth.assertThat((Iterable)((Iterable)getter.apply((Object)this.resultSet))).containsExactlyElementsIn(afterValue).inOrder();
        Truth.assertThat((Boolean)this.resultSet.next()).isFalse();
    }

    private static ResultSetMetadata makeMetadata(Type rowType) {
        com.google.spanner.v1.Type typeProto = rowType.toProto();
        return ResultSetMetadata.newBuilder().setRowType(typeProto.getStructType()).build();
    }

    @Test
    public void serialization() {
        Type structType = Type.struct(Arrays.asList(Type.StructField.of((String)"a", (Type)Type.string()), Type.StructField.of((String)"b", (Type)Type.int64())));
        this.verifySerialization(Value.string((String)"a"), Value.string(null), Value.bool((boolean)true), Value.bool(null), Value.int64((long)1L), Value.int64(null), Value.float64((double)1.0), Value.float64(null), Value.bytes((ByteArray)ByteArray.fromBase64((String)"abcd")), Value.bytes(null), Value.timestamp((Timestamp)Timestamp.ofTimeSecondsAndNanos((long)1L, (int)2)), Value.timestamp(null), Value.date((Date)Date.fromYearMonthDay((int)2017, (int)4, (int)17)), Value.date(null), Value.stringArray((Iterable)ImmutableList.of((Object)"one", (Object)"two")), Value.stringArray(null), Value.boolArray((boolean[])new boolean[]{true, false}), Value.boolArray((boolean[])null), Value.int64Array((long[])new long[]{1L, 2L, 3L}), Value.int64Array((long[])null), Value.timestampArray((Iterable)ImmutableList.of((Object)Timestamp.MAX_VALUE, (Object)Timestamp.MAX_VALUE)), Value.timestampArray(null), Value.dateArray((Iterable)ImmutableList.of((Object)Date.fromYearMonthDay((int)2017, (int)4, (int)17), (Object)Date.fromYearMonthDay((int)2017, (int)5, (int)18))), Value.dateArray(null), Value.struct((Struct)GrpcResultSetTest.s(null, 30L)), Value.struct((Type)structType, null), Value.structArray((Type)structType, Arrays.asList(GrpcResultSetTest.s("def", 10L), null)), Value.structArray((Type)structType, Collections.singletonList(null)), Value.structArray((Type)structType, null));
    }

    @Test
    public void nestedStructSerialization() {
        Type structType = Type.struct(Arrays.asList(Type.StructField.of((String)"a", (Type)Type.string()), Type.StructField.of((String)"b", (Type)Type.int64())));
        Struct nestedStruct = GrpcResultSetTest.s("1", 2L);
        Value struct = Value.structArray((Type)structType, Collections.singletonList(nestedStruct));
        this.verifySerialization(new Function<Value, com.google.protobuf.Value>(){

            @Nullable
            public com.google.protobuf.Value apply(@Nullable Value input) {
                return input.toProto();
            }
        }, struct);
    }

    private void verifySerialization(Value ... values) {
        this.verifySerialization(new Function<Value, com.google.protobuf.Value>(){

            @Nullable
            public com.google.protobuf.Value apply(@Nullable Value input) {
                return input.toProto();
            }
        }, values);
    }

    private void verifySerialization(Function<Value, com.google.protobuf.Value> protoFn, Value ... values) {
        this.resultSet = new AbstractResultSet.GrpcResultSet((AbstractResultSet.CloseableIterator)this.stream, (AbstractResultSet.Listener)new NoOpListener());
        PartialResultSet.Builder builder = PartialResultSet.newBuilder();
        ArrayList<Type.StructField> types = new ArrayList<Type.StructField>();
        for (Value value : values) {
            types.add(Type.StructField.of((String)"f", (Type)value.getType()));
            builder.addValues((com.google.protobuf.Value)protoFn.apply((Object)value));
        }
        this.consumer.onPartialResultSet(builder.setMetadata(GrpcResultSetTest.makeMetadata(Type.struct(types))).build());
        this.consumer.onCompleted();
        Truth.assertThat((Boolean)this.resultSet.next()).isTrue();
        Struct row = this.resultSet.getCurrentRowAsStruct();
        Struct copy = (Struct)SerializableTester.reserialize((Object)row);
        Truth.assertThat((Object)row).isEqualTo((Object)copy);
    }

    @Test
    public void getBoolean() {
        this.consumer.onPartialResultSet(PartialResultSet.newBuilder().setMetadata(GrpcResultSetTest.makeMetadata(Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"f", (Type)Type.bool())}))).addValues(Value.bool((boolean)true).toProto()).addValues(Value.bool((boolean)false).toProto()).build());
        this.consumer.onCompleted();
        Truth.assertThat((Boolean)this.resultSet.next()).isTrue();
        Truth.assertThat((Boolean)this.resultSet.getBoolean(0)).isTrue();
        Truth.assertThat((Boolean)this.resultSet.next()).isTrue();
        Truth.assertThat((Boolean)this.resultSet.getBoolean(0)).isFalse();
    }

    @Test
    public void getDouble() {
        this.consumer.onPartialResultSet(PartialResultSet.newBuilder().setMetadata(GrpcResultSetTest.makeMetadata(Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"f", (Type)Type.float64())}))).addValues(Value.float64((double)Double.MIN_VALUE).toProto()).addValues(Value.float64((double)Double.MAX_VALUE).toProto()).build());
        this.consumer.onCompleted();
        Truth.assertThat((Boolean)this.resultSet.next()).isTrue();
        Truth.assertThat((Double)this.resultSet.getDouble(0)).isWithin(0.0).of(Double.MIN_VALUE);
        Truth.assertThat((Boolean)this.resultSet.next()).isTrue();
        Truth.assertThat((Double)this.resultSet.getDouble(0)).isWithin(0.0).of(Double.MAX_VALUE);
    }

    @Test
    public void getBigDecimal() {
        this.consumer.onPartialResultSet(PartialResultSet.newBuilder().setMetadata(GrpcResultSetTest.makeMetadata(Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"f", (Type)Type.numeric())}))).addValues(Value.numeric((BigDecimal)new BigDecimal("-" + Strings.repeat((String)"9", (int)29) + "." + Strings.repeat((String)"9", (int)9))).toProto()).addValues(Value.numeric((BigDecimal)new BigDecimal(Strings.repeat((String)"9", (int)29) + "." + Strings.repeat((String)"9", (int)9))).toProto()).addValues(Value.numeric((BigDecimal)BigDecimal.ZERO).toProto()).addValues(Value.numeric((BigDecimal)new BigDecimal("1.23456")).toProto()).build());
        this.consumer.onCompleted();
        Truth.assertThat((Boolean)this.resultSet.next()).isTrue();
        Truth.assertThat((String)this.resultSet.getBigDecimal(0).toPlainString()).isEqualTo((Object)"-99999999999999999999999999999.999999999");
        Truth.assertThat((Boolean)this.resultSet.next()).isTrue();
        Truth.assertThat((String)this.resultSet.getBigDecimal(0).toPlainString()).isEqualTo((Object)"99999999999999999999999999999.999999999");
        Truth.assertThat((Boolean)this.resultSet.next()).isTrue();
        Truth.assertThat((BigDecimal)this.resultSet.getBigDecimal(0)).isEqualTo((Object)BigDecimal.ZERO);
        Truth.assertThat((Boolean)this.resultSet.next()).isTrue();
        Truth.assertThat((BigDecimal)this.resultSet.getBigDecimal(0)).isEqualTo((Object)BigDecimal.valueOf(123456L, 5));
    }

    @Test
    public void getLong() {
        this.consumer.onPartialResultSet(PartialResultSet.newBuilder().setMetadata(GrpcResultSetTest.makeMetadata(Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"f", (Type)Type.int64())}))).addValues(Value.int64((long)Long.MIN_VALUE).toProto()).addValues(Value.int64((long)Long.MAX_VALUE).toProto()).build());
        this.consumer.onCompleted();
        Truth.assertThat((Boolean)this.resultSet.next()).isTrue();
        Truth.assertThat((Long)this.resultSet.getLong(0)).isEqualTo((Object)Long.MIN_VALUE);
        Truth.assertThat((Boolean)this.resultSet.next()).isTrue();
        Truth.assertThat((Long)this.resultSet.getLong(0)).isEqualTo((Object)Long.MAX_VALUE);
    }

    @Test
    public void getDate() {
        this.consumer.onPartialResultSet(PartialResultSet.newBuilder().setMetadata(GrpcResultSetTest.makeMetadata(Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"f", (Type)Type.date())}))).addValues(Value.date((Date)Date.fromYearMonthDay((int)2018, (int)5, (int)29)).toProto()).build());
        this.consumer.onCompleted();
        Truth.assertThat((Boolean)this.resultSet.next()).isTrue();
        Truth.assertThat((Comparable)this.resultSet.getDate(0)).isEqualTo((Object)Date.fromYearMonthDay((int)2018, (int)5, (int)29));
    }

    @Test
    public void getTimestamp() {
        this.consumer.onPartialResultSet(PartialResultSet.newBuilder().setMetadata(GrpcResultSetTest.makeMetadata(Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"f", (Type)Type.timestamp())}))).addValues(Value.timestamp((Timestamp)Timestamp.parseTimestamp((String)"0001-01-01T00:00:00Z")).toProto()).build());
        this.consumer.onCompleted();
        Truth.assertThat((Boolean)this.resultSet.next()).isTrue();
        Truth.assertThat((Comparable)this.resultSet.getTimestamp(0)).isEqualTo((Object)Timestamp.parseTimestamp((String)"0001-01-01T00:00:00Z"));
    }

    @Test
    public void getJson() {
        this.consumer.onPartialResultSet(PartialResultSet.newBuilder().setMetadata(GrpcResultSetTest.makeMetadata(Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"f", (Type)Type.json())}))).addValues(Value.json((String)"{\"color\":\"red\",\"value\":\"#f00\"}").toProto()).addValues(Value.json((String)"{}").toProto()).addValues(Value.json((String)"[]").toProto()).build());
        this.consumer.onCompleted();
        Assert.assertTrue((boolean)this.resultSet.next());
        Assert.assertEquals((Object)"{\"color\":\"red\",\"value\":\"#f00\"}", (Object)this.resultSet.getJson(0));
        Assert.assertTrue((boolean)this.resultSet.next());
        Assert.assertEquals((Object)"{}", (Object)this.resultSet.getJson(0));
        Assert.assertTrue((boolean)this.resultSet.next());
        Assert.assertEquals((Object)"[]", (Object)this.resultSet.getJson(0));
    }

    @Test
    public void getPgJsonb() {
        this.consumer.onPartialResultSet(PartialResultSet.newBuilder().setMetadata(GrpcResultSetTest.makeMetadata(Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"f", (Type)Type.pgJsonb())}))).addValues(Value.pgJsonb((String)"{\"color\":\"red\",\"value\":\"#f00\"}").toProto()).addValues(Value.pgJsonb((String)"{}").toProto()).addValues(Value.pgJsonb((String)"[]").toProto()).build());
        this.consumer.onCompleted();
        Assert.assertTrue((boolean)this.resultSet.next());
        Assert.assertEquals((Object)"{\"color\":\"red\",\"value\":\"#f00\"}", (Object)this.resultSet.getPgJsonb(0));
        Assert.assertTrue((boolean)this.resultSet.next());
        Assert.assertEquals((Object)"{}", (Object)this.resultSet.getPgJsonb(0));
        Assert.assertTrue((boolean)this.resultSet.next());
        Assert.assertEquals((Object)"[]", (Object)this.resultSet.getPgJsonb(0));
    }

    @Test
    public void getBooleanArray() {
        boolean[] boolArray = new boolean[]{true, true, false};
        this.consumer.onPartialResultSet(PartialResultSet.newBuilder().setMetadata(GrpcResultSetTest.makeMetadata(Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"f", (Type)Type.array((Type)Type.bool()))}))).addValues(Value.boolArray((boolean[])boolArray).toProto()).build());
        this.consumer.onCompleted();
        Truth.assertThat((Boolean)this.resultSet.next()).isTrue();
        Truth.assertThat((boolean[])this.resultSet.getBooleanArray(0)).isEqualTo((Object)boolArray);
    }

    @Test
    public void getLongArray() {
        long[] longArray = new long[]{111L, 333L, 444L, 0L, -1L, -2234L, Long.MAX_VALUE, Long.MIN_VALUE};
        this.consumer.onPartialResultSet(PartialResultSet.newBuilder().setMetadata(GrpcResultSetTest.makeMetadata(Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"f", (Type)Type.array((Type)Type.int64()))}))).addValues(Value.int64Array((long[])longArray).toProto()).build());
        this.consumer.onCompleted();
        Truth.assertThat((Boolean)this.resultSet.next()).isTrue();
        Truth.assertThat((long[])this.resultSet.getLongArray(0)).isEqualTo((Object)longArray);
    }

    @Test
    public void getDoubleArray() {
        double[] doubleArray = new double[]{Double.MAX_VALUE, Double.MIN_VALUE, 111.0, 333.0, 444.0, 0.0, -1.0, -2234.0};
        this.consumer.onPartialResultSet(PartialResultSet.newBuilder().setMetadata(GrpcResultSetTest.makeMetadata(Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"f", (Type)Type.array((Type)Type.float64()))}))).addValues(Value.float64Array((double[])doubleArray).toProto()).build());
        this.consumer.onCompleted();
        Truth.assertThat((Boolean)this.resultSet.next()).isTrue();
        Truth.assertThat((double[])this.resultSet.getDoubleArray(0)).usingTolerance(0.0).containsExactly(doubleArray).inOrder();
    }

    @Test
    public void getBigDecimalList() {
        ArrayList<BigDecimal> bigDecimalsList = new ArrayList<BigDecimal>();
        bigDecimalsList.add(BigDecimal.valueOf(Double.MIN_VALUE));
        bigDecimalsList.add(BigDecimal.valueOf(Double.MAX_VALUE));
        bigDecimalsList.add(BigDecimal.ZERO);
        bigDecimalsList.add(new BigDecimal("1.23456"));
        this.consumer.onPartialResultSet(PartialResultSet.newBuilder().setMetadata(GrpcResultSetTest.makeMetadata(Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"f", (Type)Type.array((Type)Type.numeric()))}))).addValues(Value.numericArray(bigDecimalsList).toProto()).build());
        this.consumer.onCompleted();
        Truth.assertThat((Boolean)this.resultSet.next()).isTrue();
        Truth.assertThat((Iterable)this.resultSet.getBigDecimalList(0)).isEqualTo(bigDecimalsList);
    }

    @Test
    public void getTimestampList() {
        ArrayList<Timestamp> timestampList = new ArrayList<Timestamp>();
        timestampList.add(Timestamp.parseTimestamp((String)"0001-01-01T00:00:00Z"));
        timestampList.add(Timestamp.parseTimestamp((String)"0002-02-02T02:00:00Z"));
        this.consumer.onPartialResultSet(PartialResultSet.newBuilder().setMetadata(GrpcResultSetTest.makeMetadata(Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"f", (Type)Type.array((Type)Type.timestamp()))}))).addValues(Value.timestampArray(timestampList).toProto()).build());
        this.consumer.onCompleted();
        Truth.assertThat((Boolean)this.resultSet.next()).isTrue();
        Truth.assertThat((Iterable)this.resultSet.getTimestampList(0)).isEqualTo(timestampList);
    }

    @Test
    public void getDateList() {
        ArrayList<Date> dateList = new ArrayList<Date>();
        dateList.add(Date.fromYearMonthDay((int)1999, (int)8, (int)23));
        dateList.add(Date.fromYearMonthDay((int)1986, (int)3, (int)17));
        this.consumer.onPartialResultSet(PartialResultSet.newBuilder().setMetadata(GrpcResultSetTest.makeMetadata(Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"f", (Type)Type.array((Type)Type.date()))}))).addValues(Value.dateArray(dateList).toProto()).build());
        this.consumer.onCompleted();
        Truth.assertThat((Boolean)this.resultSet.next()).isTrue();
        Truth.assertThat((Iterable)this.resultSet.getDateList(0)).isEqualTo(dateList);
    }

    @Test
    public void getJsonList() {
        ArrayList<String> jsonList = new ArrayList<String>();
        jsonList.add("{\"color\":\"red\",\"value\":\"#f00\"}");
        jsonList.add("{\"special\":\"%\ud83d\ude03\u222e\u03c0\u03c1\u1f79\u03c4\u03b5\u03c1\u03bf\u03bd\u0e41\u0e1c\u0e48\u0e19\u0e14\u0e34\u0e19\u0e2e\u0e31\u0e48\u0e19\u0e40\u0e2a\u0e37\u0e48\u0e2d\u0e21\u1230\u121b\u12ed\u16bb\u16d6\"}");
        jsonList.add("[]");
        this.consumer.onPartialResultSet(PartialResultSet.newBuilder().setMetadata(GrpcResultSetTest.makeMetadata(Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"f", (Type)Type.array((Type)Type.json()))}))).addValues(Value.jsonArray(jsonList).toProto()).build());
        this.consumer.onCompleted();
        Assert.assertTrue((boolean)this.resultSet.next());
        Assert.assertEquals(jsonList, (Object)this.resultSet.getJsonList(0));
    }

    @Test
    public void getPgJsonbList() {
        ArrayList<String> jsonList = new ArrayList<String>();
        jsonList.add("{\"color\":\"red\",\"value\":\"#f00\"}");
        jsonList.add("{\"special\":\"%\ud83d\ude03\u222e\u03c0\u03c1\u1f79\u03c4\u03b5\u03c1\u03bf\u03bd\u0e41\u0e1c\u0e48\u0e19\u0e14\u0e34\u0e19\u0e2e\u0e31\u0e48\u0e19\u0e40\u0e2a\u0e37\u0e48\u0e2d\u0e21\u1230\u121b\u12ed\u16bb\u16d6\"}");
        jsonList.add("[]");
        this.consumer.onPartialResultSet(PartialResultSet.newBuilder().setMetadata(GrpcResultSetTest.makeMetadata(Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"f", (Type)Type.array((Type)Type.pgJsonb()))}))).addValues(Value.pgJsonbArray(jsonList).toProto()).build());
        this.consumer.onCompleted();
        Assert.assertTrue((boolean)this.resultSet.next());
        Assert.assertEquals(jsonList, (Object)this.resultSet.getPgJsonbList(0));
    }

    private static class NoOpListener
    implements AbstractResultSet.Listener {
        private NoOpListener() {
        }

        public void onTransactionMetadata(Transaction transaction, boolean shouldIncludeId) throws SpannerException {
        }

        public SpannerException onError(SpannerException e, boolean withBeginTransaction) {
            return e;
        }

        public void onDone(boolean withBeginTransaction) {
        }
    }
}

