/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.spanner.DatabaseClientImpl;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.InstanceId;
import com.google.cloud.spanner.IntegrationTestEnv;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.Session;
import com.google.cloud.spanner.SessionPool;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerImpl;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.testing.RemoteSpannerHelper;

public class IntegrationTestWithClosedSessionsEnv
extends IntegrationTestEnv {
    @Override
    RemoteSpannerHelper createTestHelper(SpannerOptions options, InstanceId instanceId) {
        SpannerWithClosedSessionsImpl spanner = new SpannerWithClosedSessionsImpl(options);
        return new RemoteSpannerHelperWithClosedSessions(options, instanceId, (Spanner)spanner);
    }

    public static class DatabaseClientWithClosedSessionImpl
    extends DatabaseClientImpl {
        private boolean invalidateNextSession = false;
        private boolean allowReplacing = true;

        DatabaseClientWithClosedSessionImpl(String clientId, SessionPool pool) {
            super(clientId, pool);
        }

        public void invalidateNextSession() {
            this.invalidateNextSession = true;
        }

        public void setAllowSessionReplacing(boolean allow) {
            this.allowReplacing = allow;
        }

        SessionPool.PooledSessionFuture getSession() {
            SessionPool.PooledSessionFuture session = super.getSession();
            if (this.invalidateNextSession) {
                session.get().delegate.close();
                session.get().setAllowReplacing(false);
                this.awaitDeleted((Session)session.get().delegate);
                session.get().setAllowReplacing(this.allowReplacing);
                this.invalidateNextSession = false;
            }
            session.get().setAllowReplacing(this.allowReplacing);
            return session;
        }

        /*
         * Unable to fully structure code
         */
        private void awaitDeleted(Session session) {
            try {
                while (true) lbl-1000:
                // 3 sources

                {
                    rs = session.singleUse().executeQuery(Statement.of((String)"SELECT 1"), new Options.QueryOption[0]);
                    try {
                        while (rs.next()) {
                        }
                        Thread.sleep(500L);
                    }
                    finally {
                        if (rs == null) continue;
                        rs.close();
                        continue;
                    }
                    break;
                }
            }
            catch (SpannerException e) {
                if (e.getErrorCode() != ErrorCode.NOT_FOUND || !e.getMessage().contains("Session not found") && !e.getMessage().contains("Session was concurrently deleted")) {
                    throw e;
                }
            }
            catch (InterruptedException e) {
            }
            ** GOTO lbl-1000
        }
    }

    private static class SpannerWithClosedSessionsImpl
    extends SpannerImpl {
        SpannerWithClosedSessionsImpl(SpannerOptions options) {
            super(options);
        }

        DatabaseClientImpl createDatabaseClient(String clientId, SessionPool pool) {
            return new DatabaseClientWithClosedSessionImpl(clientId, pool);
        }
    }

    private static class RemoteSpannerHelperWithClosedSessions
    extends RemoteSpannerHelper {
        private RemoteSpannerHelperWithClosedSessions(SpannerOptions options, InstanceId instanceId, Spanner client) {
            super(options, instanceId, client);
        }
    }
}

