/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.gax.grpc.testing.MockGrpcService;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.AbstractMessage;
import com.google.spanner.admin.instance.v1.InstanceAdminGrpc;
import io.grpc.ServerServiceDefinition;
import io.grpc.stub.StreamObserver;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class MockInstanceAdminServiceImpl
extends InstanceAdminGrpc.InstanceAdminImplBase
implements MockGrpcService {
    private ConcurrentMap<String, Policy> policies = new ConcurrentHashMap<String, Policy>();

    public void getIamPolicy(GetIamPolicyRequest request, StreamObserver<Policy> responseObserver) {
        Policy policy = (Policy)this.policies.get(request.getResource());
        if (policy != null) {
            responseObserver.onNext((Object)policy);
        } else {
            responseObserver.onNext((Object)Policy.getDefaultInstance());
        }
        responseObserver.onCompleted();
    }

    public void setIamPolicy(SetIamPolicyRequest request, StreamObserver<Policy> responseObserver) {
        this.policies.put(request.getResource(), request.getPolicy());
        responseObserver.onNext((Object)request.getPolicy());
        responseObserver.onCompleted();
    }

    public void testIamPermissions(TestIamPermissionsRequest request, StreamObserver<TestIamPermissionsResponse> responseObserver) {
        responseObserver.onNext((Object)TestIamPermissionsResponse.newBuilder().addAllPermissions((Iterable)request.getPermissionsList()).build());
        responseObserver.onCompleted();
    }

    public List<AbstractMessage> getRequests() {
        return Collections.emptyList();
    }

    public void addResponse(AbstractMessage response) {
        throw new UnsupportedOperationException();
    }

    public void addException(Exception exception) {
        throw new UnsupportedOperationException();
    }

    public ServerServiceDefinition getServiceDefinition() {
        return this.bindService();
    }

    public void reset() {
        this.policies.clear();
    }
}

