/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.spanner.SpannerMatchers;
import com.google.cloud.spanner.Type;
import com.google.common.testing.SerializableTester;
import com.google.common.truth.Truth;
import com.google.spanner.v1.TypeAnnotationCode;
import com.google.spanner.v1.TypeCode;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TypeTest {
    @Test
    public void bool() {
        new ScalarTypeTester(Type.Code.BOOL, TypeCode.BOOL){

            @Override
            Type newType() {
                return Type.bool();
            }
        }.test();
    }

    @Test
    public void int64() {
        new ScalarTypeTester(Type.Code.INT64, TypeCode.INT64){

            @Override
            Type newType() {
                return Type.int64();
            }
        }.test();
    }

    @Test
    public void float64() {
        new ScalarTypeTester(Type.Code.FLOAT64, TypeCode.FLOAT64){

            @Override
            Type newType() {
                return Type.float64();
            }
        }.test();
    }

    @Test
    public void numeric() {
        new ScalarTypeTester(Type.Code.NUMERIC, TypeCode.NUMERIC){

            @Override
            Type newType() {
                return Type.numeric();
            }
        }.test();
    }

    @Test
    public void pgNumeric() {
        new ScalarTypeTester(Type.Code.PG_NUMERIC, TypeCode.NUMERIC, TypeAnnotationCode.PG_NUMERIC){

            @Override
            Type newType() {
                return Type.pgNumeric();
            }
        }.test();
    }

    @Test
    public void string() {
        new ScalarTypeTester(Type.Code.STRING, TypeCode.STRING){

            @Override
            Type newType() {
                return Type.string();
            }
        }.test();
    }

    @Test
    public void json() {
        new ScalarTypeTester(Type.Code.JSON, TypeCode.JSON){

            @Override
            Type newType() {
                return Type.json();
            }
        }.test();
    }

    @Test
    public void pgJsonb() {
        new ScalarTypeTester(Type.Code.PG_JSONB, TypeCode.JSON, TypeAnnotationCode.PG_JSONB){

            @Override
            Type newType() {
                return Type.pgJsonb();
            }
        }.test();
    }

    @Test
    public void bytes() {
        new ScalarTypeTester(Type.Code.BYTES, TypeCode.BYTES){

            @Override
            Type newType() {
                return Type.bytes();
            }
        }.test();
    }

    @Test
    public void timestamp() {
        new ScalarTypeTester(Type.Code.TIMESTAMP, TypeCode.TIMESTAMP){

            @Override
            Type newType() {
                return Type.timestamp();
            }
        }.test();
    }

    @Test
    public void date() {
        new ScalarTypeTester(Type.Code.DATE, TypeCode.DATE){

            @Override
            Type newType() {
                return Type.date();
            }
        }.test();
    }

    @Test
    public void boolArray() {
        new ArrayTypeTester(Type.Code.BOOL, TypeCode.BOOL, true){

            @Override
            Type newElementType() {
                return Type.bool();
            }
        }.test();
    }

    @Test
    public void int64Array() {
        new ArrayTypeTester(Type.Code.INT64, TypeCode.INT64, true){

            @Override
            Type newElementType() {
                return Type.int64();
            }
        }.test();
    }

    @Test
    public void float64Array() {
        new ArrayTypeTester(Type.Code.FLOAT64, TypeCode.FLOAT64, true){

            @Override
            Type newElementType() {
                return Type.float64();
            }
        }.test();
    }

    @Test
    public void numericArray() {
        new ArrayTypeTester(Type.Code.NUMERIC, TypeCode.NUMERIC, true){

            @Override
            Type newElementType() {
                return Type.numeric();
            }
        }.test();
    }

    @Test
    public void pgNumericArray() {
        new ArrayTypeTester(Type.Code.PG_NUMERIC, TypeCode.NUMERIC, TypeAnnotationCode.PG_NUMERIC, true){

            @Override
            Type newElementType() {
                return Type.pgNumeric();
            }
        }.test();
    }

    @Test
    public void stringArray() {
        new ArrayTypeTester(Type.Code.STRING, TypeCode.STRING, true){

            @Override
            Type newElementType() {
                return Type.string();
            }
        }.test();
    }

    @Test
    public void jsonArray() {
        new ArrayTypeTester(Type.Code.JSON, TypeCode.JSON, true){

            @Override
            Type newElementType() {
                return Type.json();
            }
        }.test();
    }

    @Test
    public void pgJsonbArray() {
        new ArrayTypeTester(Type.Code.PG_JSONB, TypeCode.JSON, TypeAnnotationCode.PG_JSONB, true){

            @Override
            Type newElementType() {
                return Type.pgJsonb();
            }
        }.test();
    }

    @Test
    public void bytesArray() {
        new ArrayTypeTester(Type.Code.BYTES, TypeCode.BYTES, true){

            @Override
            Type newElementType() {
                return Type.bytes();
            }
        }.test();
    }

    @Test
    public void timestampArray() {
        new ArrayTypeTester(Type.Code.TIMESTAMP, TypeCode.TIMESTAMP, true){

            @Override
            Type newElementType() {
                return Type.timestamp();
            }
        }.test();
    }

    @Test
    public void dateArray() {
        new ArrayTypeTester(Type.Code.DATE, TypeCode.DATE, true){

            @Override
            Type newElementType() {
                return Type.date();
            }
        }.test();
    }

    @Test
    public void arrayOfArray() {
        new ArrayTypeTester(Type.Code.ARRAY, TypeCode.ARRAY, false){

            @Override
            Type newElementType() {
                return Type.array((Type)Type.int64());
            }
        }.test();
    }

    @Test
    public void struct() {
        Type t = Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"f1", (Type)Type.int64()), Type.StructField.of((String)"f2", (Type)Type.string()), Type.StructField.of((String)"f3", (Type)Type.pgNumeric())});
        Truth.assertThat((Comparable)t.getCode()).isEqualTo((Object)Type.Code.STRUCT);
        Truth.assertThat((Iterable)t.getStructFields()).containsExactly(new Object[]{Type.StructField.of((String)"f1", (Type)Type.int64()), Type.StructField.of((String)"f2", (Type)Type.string()), Type.StructField.of((String)"f3", (Type)Type.pgNumeric())}).inOrder();
        Truth.assertThat((String)((Type.StructField)t.getStructFields().get(0)).getName()).isEqualTo((Object)"f1");
        Truth.assertThat((Object)((Type.StructField)t.getStructFields().get(0)).getType()).isEqualTo((Object)Type.int64());
        Truth.assertThat((String)((Type.StructField)t.getStructFields().get(1)).getName()).isEqualTo((Object)"f2");
        Truth.assertThat((Object)((Type.StructField)t.getStructFields().get(1)).getType()).isEqualTo((Object)Type.string());
        Truth.assertThat((String)((Type.StructField)t.getStructFields().get(2)).getName()).isEqualTo((Object)"f3");
        Truth.assertThat((Object)((Type.StructField)t.getStructFields().get(2)).getType()).isEqualTo((Object)Type.pgNumeric());
        Truth.assertThat((String)t.toString()).isEqualTo((Object)"STRUCT<f1 INT64, f2 STRING, f3 NUMERIC<PG_NUMERIC>>");
        Truth.assertThat((Integer)t.getFieldIndex("f1")).isEqualTo((Object)0);
        Truth.assertThat((Integer)t.getFieldIndex("f2")).isEqualTo((Object)1);
        Truth.assertThat((Integer)t.getFieldIndex("f3")).isEqualTo((Object)2);
        TypeTest.assertProtoEquals(t.toProto(), "code: STRUCT struct_type { fields { name: 'f1' type { code: INT64 } } fields { name: 'f2' type { code: STRING } }  fields { name: 'f3' type { code: NUMERIC, type_annotation: PG_NUMERIC } } }");
    }

    @Test
    public void emptyStruct() {
        Type t = Type.struct((Type.StructField[])new Type.StructField[0]);
        Truth.assertThat((Comparable)t.getCode()).isEqualTo((Object)Type.Code.STRUCT);
        Truth.assertThat((Iterable)t.getStructFields()).isEmpty();
        Truth.assertThat((String)t.toString()).isEqualTo((Object)"STRUCT<>");
        TypeTest.assertProtoEquals(t.toProto(), "code: STRUCT struct_type {}");
    }

    @Test
    public void structFieldIndexNotFound() {
        Type t = Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"f1", (Type)Type.int64())});
        IllegalArgumentException e = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> t.getFieldIndex("f2"));
        Truth.assertThat((Boolean)e.getMessage().contains("Field not found: f2"));
    }

    @Test
    public void structFieldIndexAmbiguous() {
        Type t = Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"f1", (Type)Type.int64()), Type.StructField.of((String)"f1", (Type)Type.string())});
        IllegalArgumentException e = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> t.getFieldIndex("f1"));
        Truth.assertThat((Boolean)e.getMessage().contains("Ambiguous field name: f1"));
    }

    @Test
    public void parseErrorMissingTypeCode() {
        com.google.spanner.v1.Type proto = com.google.spanner.v1.Type.newBuilder().build();
        IllegalArgumentException e = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> Type.fromProto((com.google.spanner.v1.Type)proto));
        Assert.assertNotNull((Object)e.getMessage());
    }

    @Test
    public void parseErrorMissingArrayElementTypeProto() {
        com.google.spanner.v1.Type proto = com.google.spanner.v1.Type.newBuilder().setCode(TypeCode.ARRAY).build();
        IllegalArgumentException e = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> Type.fromProto((com.google.spanner.v1.Type)proto));
        Assert.assertNotNull((Object)e.getMessage());
    }

    private static void assertProtoEquals(com.google.spanner.v1.Type proto, String expected) {
        MatcherAssert.assertThat((Object)proto, SpannerMatchers.matchesProto(com.google.spanner.v1.Type.class, expected));
    }

    static abstract class ArrayTypeTester {
        private final Type.Code expectedElementCode;
        private final TypeCode expectedElementTypeCode;
        private final TypeAnnotationCode expectedTypeAnnotationCode;
        private final boolean expectInterned;

        ArrayTypeTester(Type.Code expectedElementCode, TypeCode expectedElementTypeCode, boolean expectInterned) {
            this(expectedElementCode, expectedElementTypeCode, TypeAnnotationCode.TYPE_ANNOTATION_CODE_UNSPECIFIED, expectInterned);
        }

        ArrayTypeTester(Type.Code expectedElementCode, TypeCode expectedElementTypeCode, TypeAnnotationCode expectedTypeAnnotationCode, boolean expectInterned) {
            this.expectedElementCode = expectedElementCode;
            this.expectedElementTypeCode = expectedElementTypeCode;
            this.expectedTypeAnnotationCode = expectedTypeAnnotationCode;
            this.expectInterned = expectInterned;
        }

        abstract Type newElementType();

        void test() {
            Type elementType = this.newElementType();
            Type t = Type.array((Type)elementType);
            Truth.assertThat((Comparable)t.getCode()).isEqualTo((Object)Type.Code.ARRAY);
            Truth.assertThat((Object)t.getArrayElementType()).isEqualTo((Object)elementType);
            if (this.expectInterned) {
                Truth.assertThat((Object)Type.array((Type)this.newElementType())).isSameInstanceAs((Object)t);
            }
            Truth.assertThat((String)t.toString()).isEqualTo((Object)("ARRAY<" + elementType.toString() + ">"));
            com.google.spanner.v1.Type proto = t.toProto();
            Truth.assertThat((Comparable)proto.getCode()).isEqualTo((Object)TypeCode.ARRAY);
            Truth.assertThat((Object)proto.getArrayElementType()).isEqualTo((Object)elementType.toProto());
            Truth.assertThat((Boolean)proto.hasStructType()).isFalse();
            Type fromProto = Type.fromProto((com.google.spanner.v1.Type)proto);
            Truth.assertThat((Object)fromProto).isEqualTo((Object)t);
            if (this.expectInterned) {
                Truth.assertThat((Object)fromProto).isSameInstanceAs((Object)t);
            }
            SerializableTester.reserializeAndAssert((Object)t);
        }
    }

    private static abstract class ScalarTypeTester {
        private final Type.Code expectedCode;
        private final TypeCode expectedTypeCode;
        private final TypeAnnotationCode expectedTypeAnnotationCode;

        ScalarTypeTester(Type.Code expectedCode, TypeCode expectedTypeCode) {
            this(expectedCode, expectedTypeCode, TypeAnnotationCode.TYPE_ANNOTATION_CODE_UNSPECIFIED);
        }

        ScalarTypeTester(Type.Code expectedCode, TypeCode expectedTypeCode, TypeAnnotationCode expectedTypeAnnotationCode) {
            this.expectedCode = expectedCode;
            this.expectedTypeCode = expectedTypeCode;
            this.expectedTypeAnnotationCode = expectedTypeAnnotationCode;
        }

        abstract Type newType();

        void test() {
            Type t = this.newType();
            Truth.assertThat((Comparable)t.getCode()).isEqualTo((Object)this.expectedCode);
            Truth.assertThat((Object)this.newType()).isSameInstanceAs((Object)t);
            if (this.expectedTypeAnnotationCode != TypeAnnotationCode.TYPE_ANNOTATION_CODE_UNSPECIFIED) {
                Truth.assertThat((String)t.toString()).isEqualTo((Object)(this.expectedTypeCode.toString() + "<" + this.expectedTypeAnnotationCode.toString() + ">"));
            } else {
                Truth.assertThat((String)t.toString()).isEqualTo((Object)this.expectedTypeCode.toString());
            }
            com.google.spanner.v1.Type proto = t.toProto();
            Truth.assertThat((Comparable)proto.getCode()).isEqualTo((Object)this.expectedTypeCode);
            Truth.assertThat((Comparable)proto.getTypeAnnotation()).isEqualTo((Object)this.expectedTypeAnnotationCode);
            Truth.assertThat((Boolean)proto.hasArrayElementType()).isFalse();
            Truth.assertThat((Boolean)proto.hasStructType()).isFalse();
            Type fromProto = Type.fromProto((com.google.spanner.v1.Type)proto);
            Truth.assertThat((Object)fromProto).isEqualTo((Object)t);
            Truth.assertThat((Object)fromProto).isSameInstanceAs((Object)t);
            SerializableTester.reserializeAndAssert((Object)t);
        }
    }
}

