/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.spanner.connection.ClientSideStatementImpl;
import com.google.cloud.spanner.connection.ClientSideStatementValueConverters;
import com.google.spanner.v1.RequestOptions;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class RpcPriorityConverterTest {
    @Test
    public void testConvert() throws ClientSideStatementImpl.CompileException {
        String allowedValues = "'(HIGH|MEDIUM|LOW|NULL)'";
        ClientSideStatementValueConverters.RpcPriorityConverter converter = new ClientSideStatementValueConverters.RpcPriorityConverter(allowedValues);
        Assert.assertEquals((Object)RequestOptions.Priority.PRIORITY_HIGH, (Object)converter.convert("high"));
        Assert.assertEquals((Object)RequestOptions.Priority.PRIORITY_HIGH, (Object)converter.convert("HIGH"));
        Assert.assertEquals((Object)RequestOptions.Priority.PRIORITY_HIGH, (Object)converter.convert("High"));
        Assert.assertEquals((Object)RequestOptions.Priority.PRIORITY_MEDIUM, (Object)converter.convert("medium"));
        Assert.assertEquals((Object)RequestOptions.Priority.PRIORITY_MEDIUM, (Object)converter.convert("Medium"));
        Assert.assertEquals((Object)RequestOptions.Priority.PRIORITY_LOW, (Object)converter.convert("Low"));
        Assert.assertNull((Object)converter.convert(""));
        Assert.assertNull((Object)converter.convert(" "));
        Assert.assertNull((Object)converter.convert("random string"));
        Assert.assertEquals((Object)RequestOptions.Priority.PRIORITY_UNSPECIFIED, (Object)converter.convert("NULL"));
    }
}

