/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.encryption;

import com.google.cloud.spanner.encryption.BackupEncryptionConfig;
import com.google.cloud.spanner.encryption.CustomerManagedEncryption;
import com.google.cloud.spanner.encryption.EncryptionConfigProtoMapper;
import com.google.cloud.spanner.encryption.GoogleDefaultEncryption;
import com.google.cloud.spanner.encryption.RestoreEncryptionConfig;
import com.google.cloud.spanner.encryption.UseBackupEncryption;
import com.google.cloud.spanner.encryption.UseDatabaseEncryption;
import com.google.spanner.admin.database.v1.CreateBackupEncryptionConfig;
import com.google.spanner.admin.database.v1.EncryptionConfig;
import com.google.spanner.admin.database.v1.RestoreDatabaseEncryptionConfig;
import org.junit.Assert;
import org.junit.Test;

public class EncryptionConfigProtoMapperTest {
    public static final String KMS_KEY_NAME = "kms-key-name";

    @Test
    public void testEncryptionConfig() {
        EncryptionConfig expected = EncryptionConfig.newBuilder().setKmsKeyName(KMS_KEY_NAME).build();
        EncryptionConfig actual = EncryptionConfigProtoMapper.encryptionConfig((CustomerManagedEncryption)new CustomerManagedEncryption(KMS_KEY_NAME));
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testCreateBackupConfigCustomerManagedEncryption() {
        CreateBackupEncryptionConfig expected = CreateBackupEncryptionConfig.newBuilder().setEncryptionType(CreateBackupEncryptionConfig.EncryptionType.CUSTOMER_MANAGED_ENCRYPTION).setKmsKeyName(KMS_KEY_NAME).build();
        CreateBackupEncryptionConfig actual = EncryptionConfigProtoMapper.createBackupEncryptionConfig((BackupEncryptionConfig)new CustomerManagedEncryption(KMS_KEY_NAME));
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testCreateBackupConfigGoogleDefaultEncryption() {
        CreateBackupEncryptionConfig expected = CreateBackupEncryptionConfig.newBuilder().setEncryptionType(CreateBackupEncryptionConfig.EncryptionType.GOOGLE_DEFAULT_ENCRYPTION).build();
        CreateBackupEncryptionConfig actual = EncryptionConfigProtoMapper.createBackupEncryptionConfig((BackupEncryptionConfig)GoogleDefaultEncryption.INSTANCE);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testCreateBackupConfigUseDatabaseEncryption() {
        CreateBackupEncryptionConfig expected = CreateBackupEncryptionConfig.newBuilder().setEncryptionType(CreateBackupEncryptionConfig.EncryptionType.USE_DATABASE_ENCRYPTION).build();
        CreateBackupEncryptionConfig actual = EncryptionConfigProtoMapper.createBackupEncryptionConfig((BackupEncryptionConfig)UseDatabaseEncryption.INSTANCE);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateBackupInvalidEncryption() {
        EncryptionConfigProtoMapper.createBackupEncryptionConfig(null);
    }

    @Test
    public void testRestoreDatabaseConfigCustomerManagedEncryption() {
        RestoreDatabaseEncryptionConfig expected = RestoreDatabaseEncryptionConfig.newBuilder().setEncryptionType(RestoreDatabaseEncryptionConfig.EncryptionType.CUSTOMER_MANAGED_ENCRYPTION).setKmsKeyName(KMS_KEY_NAME).build();
        RestoreDatabaseEncryptionConfig actual = EncryptionConfigProtoMapper.restoreDatabaseEncryptionConfig((RestoreEncryptionConfig)new CustomerManagedEncryption(KMS_KEY_NAME));
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testRestoreDatabaseConfigGoogleDefaultEncryption() {
        RestoreDatabaseEncryptionConfig expected = RestoreDatabaseEncryptionConfig.newBuilder().setEncryptionType(RestoreDatabaseEncryptionConfig.EncryptionType.GOOGLE_DEFAULT_ENCRYPTION).build();
        RestoreDatabaseEncryptionConfig actual = EncryptionConfigProtoMapper.restoreDatabaseEncryptionConfig((RestoreEncryptionConfig)GoogleDefaultEncryption.INSTANCE);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testRestoreDatabaseConfigUseBackupEncryption() {
        RestoreDatabaseEncryptionConfig expected = RestoreDatabaseEncryptionConfig.newBuilder().setEncryptionType(RestoreDatabaseEncryptionConfig.EncryptionType.USE_CONFIG_DEFAULT_OR_BACKUP_ENCRYPTION).build();
        RestoreDatabaseEncryptionConfig actual = EncryptionConfigProtoMapper.restoreDatabaseEncryptionConfig((RestoreEncryptionConfig)UseBackupEncryption.INSTANCE);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRestoreDatabaseConfigInvalidEncryption() {
        EncryptionConfigProtoMapper.restoreDatabaseEncryptionConfig(null);
    }
}

