/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.it;

import com.google.cloud.spanner.AsyncResultSet;
import com.google.cloud.spanner.Database;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.IntegrationTestEnv;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ParallelIntegrationTest;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.TransactionRunner;
import com.google.cloud.spanner.connection.ConnectionOptions;
import com.google.cloud.spanner.it.DialectTestParameter;
import com.google.cloud.spanner.testing.EmulatorSpannerHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={ParallelIntegrationTest.class})
@RunWith(value=Parameterized.class)
public final class ITDmlReturningTest {
    @ClassRule
    public static IntegrationTestEnv env = new IntegrationTestEnv();
    private static DatabaseClient googleStandardSQLClient;
    private static DatabaseClient postgreSQLClient;
    private static int id;
    private static final long DML_COUNT = 4L;
    @Parameterized.Parameter(value=0)
    public DialectTestParameter dialect;

    @BeforeClass
    public static void setUpDatabase() {
        Assume.assumeFalse((String)"DML Returning is not supported in the emulator", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        Database googleStandardSQLDatabase = env.getTestHelper().createTestDatabase(new String[]{"CREATE TABLE T (  K    STRING(MAX) NOT NULL,  V    INT64,) PRIMARY KEY (K)"});
        googleStandardSQLClient = env.getTestHelper().getDatabaseClient(googleStandardSQLDatabase);
        if (!EmulatorSpannerHelper.isUsingEmulator()) {
            Database postgreSQLDatabase = env.getTestHelper().createTestDatabase(Dialect.POSTGRESQL, Collections.singletonList("CREATE TABLE T (  \"K\"    VARCHAR PRIMARY KEY,  \"V\"    BIGINT)"));
            postgreSQLClient = env.getTestHelper().getDatabaseClient(postgreSQLDatabase);
        }
    }

    @AfterClass
    public static void teardown() {
        ConnectionOptions.closeSpanner();
    }

    @Before
    public void increaseTestIdAndDeleteTestData() {
        if (this.dialect.dialect == Dialect.GOOGLE_STANDARD_SQL) {
            googleStandardSQLClient.writeAtLeastOnce(Collections.singletonList(Mutation.delete((String)"T", (KeySet)KeySet.all())));
        } else {
            postgreSQLClient.writeAtLeastOnce(Collections.singletonList(Mutation.delete((String)"T", (KeySet)KeySet.all())));
        }
        ++id;
    }

    @Parameterized.Parameters(name="Dialect = {0}")
    public static List<DialectTestParameter> data() {
        ArrayList<DialectTestParameter> params = new ArrayList<DialectTestParameter>();
        params.add(new DialectTestParameter(Dialect.GOOGLE_STANDARD_SQL));
        params.add(new DialectTestParameter(Dialect.POSTGRESQL));
        return params;
    }

    private String getInsertDmlReturningTemplate() {
        if (this.dialect.dialect == Dialect.POSTGRESQL) {
            return "INSERT INTO T (\"K\", \"V\") VALUES ('%d-boo1', 1), ('%d-boo2', 2), ('%d-boo3', 3), ('%d-boo4', 4) RETURNING *";
        }
        return "INSERT INTO T (K, V) VALUES ('%d-boo1', 1), ('%d-boo2', 2), ('%d-boo3', 3), ('%d-boo4', 4) THEN RETURN *";
    }

    private String getUpdateDmlReturningTemplate() {
        if (this.dialect.dialect == Dialect.POSTGRESQL) {
            return "UPDATE T SET \"V\" = 100 WHERE \"K\" LIKE '%d-boo%%' RETURNING *";
        }
        return "UPDATE T SET V = 100 WHERE K LIKE '%d-boo%%' THEN RETURN *";
    }

    private String getDeleteDmlReturningTemplate() {
        if (this.dialect.dialect == Dialect.POSTGRESQL) {
            return "DELETE FROM T WHERE \"K\" like '%d-boo%%' RETURNING *";
        }
        return "DELETE FROM T WHERE K like '%d-boo%%' THEN RETURN *";
    }

    private String getDeleteDmlTemplate() {
        if (this.dialect.dialect == Dialect.POSTGRESQL) {
            return "DELETE FROM T WHERE \"K\" like '%d-boo%%'";
        }
        return "DELETE FROM T WHERE K like '%d-boo%%'";
    }

    private String insertDmlReturning() {
        return String.format(this.getInsertDmlReturningTemplate(), id, id, id, id);
    }

    private String updateDmlReturning() {
        return String.format(this.getUpdateDmlReturningTemplate(), id);
    }

    private String deleteDmlReturning() {
        return String.format(this.getDeleteDmlReturningTemplate(), id);
    }

    private String deleteDml() {
        return String.format(this.getDeleteDmlTemplate(), id);
    }

    private DatabaseClient getClient() {
        if (this.dialect.dialect == Dialect.POSTGRESQL) {
            return postgreSQLClient;
        }
        return googleStandardSQLClient;
    }

    @Test
    public void dmlReturningWithExecuteUpdate() {
        this.executeUpdate(4L, this.insertDmlReturning());
        this.executeUpdate(8L, this.updateDmlReturning(), this.deleteDmlReturning());
    }

    private void executeUpdate(long expectedCount, String ... stmts) {
        TransactionRunner.TransactionCallable callable = transaction -> {
            long rowCount = 0L;
            for (String stmt : stmts) {
                rowCount += transaction.executeUpdate(Statement.of((String)stmt), new Options.UpdateOption[0]);
            }
            return rowCount;
        };
        TransactionRunner runner = this.getClient().readWriteTransaction(new Options.TransactionOption[0]);
        Long rowCount = (Long)runner.run(callable);
        Assert.assertEquals((Object)rowCount, (Object)expectedCount);
    }

    @Test
    public void dmlReturningWithExecuteUpdateAsync() {
        this.executeUpdateAsync(4L, this.insertDmlReturning());
        this.executeUpdateAsync(8L, this.updateDmlReturning(), this.deleteDmlReturning());
    }

    private void executeUpdateAsync(long expectedCount, String ... stmts) {
        TransactionRunner.TransactionCallable callable = transaction -> {
            long rowCount = 0L;
            for (String stmt : stmts) {
                rowCount += ((Long)transaction.executeUpdateAsync(Statement.of((String)stmt), new Options.UpdateOption[0]).get(1L, TimeUnit.MINUTES)).longValue();
            }
            return rowCount;
        };
        TransactionRunner runner = this.getClient().readWriteTransaction(new Options.TransactionOption[0]);
        Long rowCount = (Long)runner.run(callable);
        Assert.assertEquals((Object)rowCount, (Object)expectedCount);
    }

    @Test
    public void dmlReturningWithExecutePartitionedUpdate() {
        SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> this.getClient().executePartitionedUpdate(Statement.of((String)this.updateDmlReturning()), new Options.UpdateOption[0]));
        Assert.assertEquals((Object)e.getErrorCode(), (Object)ErrorCode.UNIMPLEMENTED);
    }

    @Test
    public void dmlReturningWithExecuteQuery() {
        int idx;
        List<Struct> rows = this.executeQuery(4L, this.insertDmlReturning());
        Assert.assertEquals((long)this.getClient().singleUse().readRow("T", Key.of((Object[])new Object[]{String.format("%d-boo1", id)}), Collections.singletonList("V")).getLong(0), (long)1L);
        for (idx = 0; idx < rows.size(); ++idx) {
            Assert.assertEquals((long)rows.get(idx).getLong("V"), (long)(idx + 1));
            Assert.assertEquals((Object)rows.get(idx).getString("K"), (Object)String.format("%d-boo%d", id, idx + 1));
        }
        rows = this.executeQuery(4L, this.updateDmlReturning());
        Assert.assertEquals((long)this.getClient().singleUse().readRow("T", Key.of((Object[])new Object[]{String.format("%d-boo1", id)}), Collections.singletonList("V")).getLong(0), (long)100L);
        for (idx = 0; idx < rows.size(); ++idx) {
            Assert.assertEquals((long)rows.get(idx).getLong("V"), (long)100L);
            Assert.assertEquals((Object)rows.get(idx).getString("K"), (Object)String.format("%d-boo%d", id, idx + 1));
        }
        rows = this.executeQuery(4L, this.deleteDmlReturning());
        Assert.assertNull((Object)this.getClient().singleUse().readRow("T", Key.of((Object[])new Object[]{String.format("%d-boo1", id)}), Collections.singletonList("V")));
        for (idx = 0; idx < rows.size(); ++idx) {
            Assert.assertEquals((long)rows.get(idx).getLong("V"), (long)100L);
            Assert.assertEquals((Object)rows.get(idx).getString("K"), (Object)String.format("%d-boo%d", id, idx + 1));
        }
    }

    private List<Struct> executeQuery(long expectedCount, String stmt) {
        ArrayList<Struct> rows = new ArrayList<Struct>();
        TransactionRunner.TransactionCallable callable = transaction -> {
            ResultSet resultSet = transaction.executeQuery(Statement.of((String)stmt), new Options.QueryOption[0]);
            while (resultSet.next()) {
                rows.add(resultSet.getCurrentRowAsStruct());
            }
            Assert.assertFalse((boolean)resultSet.next());
            Assert.assertNotNull((Object)resultSet.getStats());
            Assert.assertEquals((long)expectedCount, (long)resultSet.getStats().getRowCountExact());
            return null;
        };
        TransactionRunner runner = this.getClient().readWriteTransaction(new Options.TransactionOption[0]);
        runner.run(callable);
        rows.sort(Comparator.comparing(a -> a.getString("K")));
        return rows;
    }

    @Test
    public void dmlReturningWithExecuteQueryAsync() {
        int idx;
        List<Struct> rows = this.executeQueryAsync(4L, this.insertDmlReturning());
        Assert.assertEquals((long)this.getClient().singleUse().readRow("T", Key.of((Object[])new Object[]{String.format("%d-boo1", id)}), Collections.singletonList("V")).getLong(0), (long)1L);
        for (idx = 0; idx < rows.size(); ++idx) {
            Assert.assertEquals((long)rows.get(idx).getLong("V"), (long)(idx + 1));
            Assert.assertEquals((Object)rows.get(idx).getString("K"), (Object)String.format("%d-boo%d", id, idx + 1));
        }
        rows = this.executeQueryAsync(4L, this.updateDmlReturning());
        Assert.assertEquals((long)this.getClient().singleUse().readRow("T", Key.of((Object[])new Object[]{String.format("%d-boo1", id)}), Collections.singletonList("V")).getLong(0), (long)100L);
        for (idx = 0; idx < rows.size(); ++idx) {
            Assert.assertEquals((long)rows.get(idx).getLong("V"), (long)100L);
            Assert.assertEquals((Object)rows.get(idx).getString("K"), (Object)String.format("%d-boo%d", id, idx + 1));
        }
        rows = this.executeQueryAsync(4L, this.deleteDmlReturning());
        Assert.assertNull((Object)this.getClient().singleUse().readRow("T", Key.of((Object[])new Object[]{String.format("%d-boo1", id)}), Collections.singletonList("V")));
        for (idx = 0; idx < rows.size(); ++idx) {
            Assert.assertEquals((long)rows.get(idx).getLong("V"), (long)100L);
            Assert.assertEquals((Object)rows.get(idx).getString("K"), (Object)String.format("%d-boo%d", id, idx + 1));
        }
    }

    private List<Struct> executeQueryAsync(long expectedCount, String stmt) {
        ArrayList<Struct> rows = new ArrayList<Struct>();
        TransactionRunner.TransactionCallable callable = transaction -> {
            AsyncResultSet rs = transaction.executeQueryAsync(Statement.of((String)stmt), new Options.QueryOption[0]);
            rs.setCallback((Executor)Executors.newSingleThreadExecutor(), resultSet -> {
                try {
                    block7: while (true) {
                        switch (resultSet.tryNext()) {
                            case OK: {
                                rows.add(resultSet.getCurrentRowAsStruct());
                                continue block7;
                            }
                            case DONE: {
                                Assert.assertNotNull((Object)resultSet.getStats());
                                Assert.assertEquals((long)resultSet.getStats().getRowCountExact(), (long)expectedCount);
                                return AsyncResultSet.CallbackResponse.DONE;
                            }
                            case NOT_READY: {
                                return AsyncResultSet.CallbackResponse.CONTINUE;
                            }
                        }
                        break;
                    }
                    throw new IllegalStateException();
                }
                catch (SpannerException e) {
                    return AsyncResultSet.CallbackResponse.DONE;
                }
            });
            return null;
        };
        TransactionRunner runner = this.getClient().readWriteTransaction(new Options.TransactionOption[0]);
        runner.run(callable);
        rows.sort(Comparator.comparing(a -> a.getString("K")));
        return rows;
    }

    @Test
    public void dmlReturningWithBatchUpdate() {
        long[] rowCounts = this.batchUpdate(this.insertDmlReturning(), this.updateDmlReturning(), this.deleteDml());
        Assert.assertEquals((long)rowCounts.length, (long)3L);
        Assert.assertEquals((long)rowCounts[0], (long)4L);
        Assert.assertEquals((long)rowCounts[1], (long)4L);
        Assert.assertEquals((long)rowCounts[2], (long)4L);
    }

    private long[] batchUpdate(String ... stmts) {
        TransactionRunner.TransactionCallable callable = transaction -> transaction.batchUpdate((Iterable)Arrays.stream(stmts).map(Statement::of).collect(Collectors.toList()), new Options.UpdateOption[0]);
        TransactionRunner runner = this.getClient().readWriteTransaction(new Options.TransactionOption[0]);
        return (long[])runner.run(callable);
    }

    @Test
    public void dmlReturningWithBatchUpdateAsync() {
        long[] rowCounts = this.batchUpdateAsync(this.insertDmlReturning(), this.updateDmlReturning(), this.deleteDml());
        Assert.assertEquals((long)rowCounts.length, (long)3L);
        Assert.assertEquals((long)rowCounts[0], (long)4L);
        Assert.assertEquals((long)rowCounts[1], (long)4L);
        Assert.assertEquals((long)rowCounts[2], (long)4L);
    }

    private long[] batchUpdateAsync(String ... stmts) {
        TransactionRunner.TransactionCallable callable = transaction -> (long[])transaction.batchUpdateAsync((Iterable)Arrays.stream(stmts).map(Statement::of).collect(Collectors.toList()), new Options.UpdateOption[0]).get();
        TransactionRunner runner = this.getClient().readWriteTransaction(new Options.TransactionOption[0]);
        return (long[])runner.run(callable);
    }
}

