/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.it;

import com.google.api.gax.longrunning.OperationFuture;
import com.google.cloud.spanner.Instance;
import com.google.cloud.spanner.InstanceAdminClient;
import com.google.cloud.spanner.InstanceConfig;
import com.google.cloud.spanner.InstanceId;
import com.google.cloud.spanner.InstanceInfo;
import com.google.cloud.spanner.IntegrationTestEnv;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ParallelIntegrationTest;
import com.google.cloud.spanner.testing.EmulatorSpannerHelper;
import com.google.common.collect.Iterators;
import com.google.common.truth.Truth;
import java.util.ArrayList;
import java.util.Random;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@Category(value={ParallelIntegrationTest.class})
@RunWith(value=JUnit4.class)
public class ITInstanceAdminTest {
    @ClassRule
    public static IntegrationTestEnv env = new IntegrationTestEnv(true);
    static InstanceAdminClient instanceClient;

    @BeforeClass
    public static void setUp() {
        instanceClient = env.getTestHelper().getClient().getInstanceAdminClient();
    }

    @Test
    public void instanceConfigOperations() {
        ArrayList configs = new ArrayList();
        Iterators.addAll(configs, instanceClient.listInstanceConfigs(new Options.ListOption[0]).iterateAll().iterator());
        Truth.assertThat((Boolean)configs.isEmpty()).isFalse();
        InstanceConfig config = instanceClient.getInstanceConfig(((InstanceConfig)configs.get(0)).getId().getInstanceConfig());
        Truth.assertThat((Object)config.getId()).isEqualTo((Object)((InstanceConfig)configs.get(0)).getId());
        config = config.reload();
        Truth.assertThat((Object)config.getId()).isEqualTo((Object)((InstanceConfig)configs.get(0)).getId());
    }

    @Ignore(value="Feature is not yet enabled in production")
    @Test
    public void instanceConfigLeaderOptions() {
        Assume.assumeFalse((String)"The emulator does not support leader options", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        ArrayList configs = new ArrayList();
        Iterators.addAll(configs, instanceClient.listInstanceConfigs(new Options.ListOption[0]).iterateAll().iterator());
        configs.forEach(config -> Truth.assertThat((Iterable)config.getReplicas()).isNotEmpty());
        configs.forEach(config -> Truth.assertThat((Iterable)config.getLeaderOptions()).isNotEmpty());
    }

    @Test
    public void listInstances() {
        Assume.assumeFalse((String)"The emulator does not support filtering on instances", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        Instance instance = (Instance)Iterators.getOnlyElement(instanceClient.listInstances(new Options.ListOption[]{Options.filter((String)("name:instances/" + env.getTestHelper().getInstanceId().getInstance()))}).iterateAll().iterator());
        Truth.assertThat((Object)instance.getId()).isEqualTo((Object)env.getTestHelper().getInstanceId());
    }

    @Test
    public void updateInstance() throws Exception {
        Assume.assumeFalse((String)"The emulator does not support updating instances", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        Instance instance = instanceClient.getInstance(env.getTestHelper().getInstanceId().getInstance());
        String rand = new Random().nextInt() + "";
        String newDisplayName = "instance test" + rand;
        InstanceInfo toUpdate = InstanceInfo.newBuilder((InstanceId)env.getTestHelper().getInstanceId()).setDisplayName(newDisplayName).setNodeCount(instance.getNodeCount() + 1).build();
        OperationFuture op = instanceClient.updateInstance(toUpdate, new InstanceInfo.InstanceField[]{InstanceInfo.InstanceField.DISPLAY_NAME});
        Instance newInstance = (Instance)op.get();
        Truth.assertThat((Integer)newInstance.getNodeCount()).isEqualTo((Object)instance.getNodeCount());
        Truth.assertThat((String)newInstance.getDisplayName()).isEqualTo((Object)newDisplayName);
        Instance newInstanceFromGet = instanceClient.getInstance(env.getTestHelper().getInstanceId().getInstance());
        Truth.assertThat((Object)newInstanceFromGet).isEqualTo((Object)newInstance);
        toUpdate = InstanceInfo.newBuilder((InstanceId)instance.getId()).setDisplayName(instance.getDisplayName()).build();
        instanceClient.updateInstance(toUpdate, new InstanceInfo.InstanceField[]{InstanceInfo.InstanceField.DISPLAY_NAME}).get();
    }

    @Test
    public void updateInstanceViaEntity() throws Exception {
        Assume.assumeFalse((String)"The emulator does not support updating instances", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        Instance instance = instanceClient.getInstance(env.getTestHelper().getInstanceId().getInstance());
        String rand = new Random().nextInt() + "";
        String newDisplayName = "instance test" + rand;
        Instance toUpdate = instance.toBuilder().setDisplayName(newDisplayName).setNodeCount(instance.getNodeCount() + 1).build();
        OperationFuture op = toUpdate.update(new InstanceInfo.InstanceField[]{InstanceInfo.InstanceField.DISPLAY_NAME});
        Instance newInstance = (Instance)op.get();
        Truth.assertThat((Integer)newInstance.getNodeCount()).isEqualTo((Object)instance.getNodeCount());
        Truth.assertThat((String)newInstance.getDisplayName()).isEqualTo((Object)newDisplayName);
        Instance newInstanceFromGet = instance.reload();
        Truth.assertThat((Object)newInstanceFromGet).isEqualTo((Object)newInstance);
        toUpdate = newInstance.toBuilder().setDisplayName(instance.getDisplayName()).build();
        toUpdate.update(new InstanceInfo.InstanceField[]{InstanceInfo.InstanceField.DISPLAY_NAME}).get();
    }
}

