/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.it;

import com.google.cloud.spanner.Database;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.IntegrationTestEnv;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ParallelIntegrationTest;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.testing.EmulatorSpannerHelper;
import com.google.common.truth.Truth;
import com.google.spanner.v1.ExecuteSqlRequest;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@Category(value={ParallelIntegrationTest.class})
@RunWith(value=JUnit4.class)
public class ITQueryOptionsTest {
    @ClassRule
    public static IntegrationTestEnv env = new IntegrationTestEnv();
    private static Database db;
    private static DatabaseClient client;

    @BeforeClass
    public static void setUpDatabase() {
        Assume.assumeFalse((String)"Emulator ignores query options", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        db = env.getTestHelper().createTestDatabase(new String[]{"CREATE TABLE TEST (ID INT64, NAME STRING(100)) PRIMARY KEY (ID)"});
        client = env.getTestHelper().getDatabaseClient(db);
    }

    @Test
    public void executeQuery() {
        try (ResultSet rs = client.singleUse().executeQuery(Statement.newBuilder((String)"SELECT 1").withQueryOptions(ExecuteSqlRequest.QueryOptions.newBuilder().setOptimizerVersion("1").setOptimizerStatisticsPackage("custom-package").build()).build(), new Options.QueryOption[0]);){
            while (rs.next()) {
                Truth.assertThat((Long)rs.getLong(0)).isEqualTo((Object)1L);
            }
        }
        rs = client.singleUse().executeQuery(Statement.newBuilder((String)"SELECT 1").withQueryOptions(ExecuteSqlRequest.QueryOptions.newBuilder().setOptimizerVersion("latest").build()).build(), new Options.QueryOption[0]);
        try {
            while (rs.next()) {
                Truth.assertThat((Long)rs.getLong(0)).isEqualTo((Object)1L);
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
        try {
            rs = client.singleUse().executeQuery(Statement.newBuilder((String)"SELECT 1").withQueryOptions(ExecuteSqlRequest.QueryOptions.newBuilder().setOptimizerVersion("100000").build()).build(), new Options.QueryOption[0]);
            try {
                while (rs.next()) {
                    Assert.fail((String)"should not get any results");
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        catch (SpannerException e) {
            Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.INVALID_ARGUMENT);
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"Query optimizer version: 100000 is not supported");
        }
    }

    @Test
    public void executeUpdate() {
        Truth.assertThat((Long)((Long)client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> transaction.executeUpdate(((Statement.Builder)((Statement.Builder)Statement.newBuilder((String)"INSERT INTO TEST (ID, NAME) VALUES (@id, @name)").bind("id").to(1L)).bind("name").to("One")).withQueryOptions(ExecuteSqlRequest.QueryOptions.newBuilder().setOptimizerVersion("1").setOptimizerStatisticsPackage("custom-package").build()).build(), new Options.UpdateOption[0])))).isEqualTo((Object)1L);
        Truth.assertThat((Long)((Long)client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> transaction.executeUpdate(((Statement.Builder)((Statement.Builder)Statement.newBuilder((String)"INSERT INTO TEST (ID, NAME) VALUES (@id, @name)").bind("id").to(2L)).bind("name").to("Two")).withQueryOptions(ExecuteSqlRequest.QueryOptions.newBuilder().setOptimizerVersion("latest").build()).build(), new Options.UpdateOption[0])))).isEqualTo((Object)1L);
        try {
            client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> transaction.executeUpdate(((Statement.Builder)((Statement.Builder)Statement.newBuilder((String)"INSERT INTO TEST (ID, NAME) VALUES (@id, @name)").bind("id").to(3L)).bind("name").to("Three")).withQueryOptions(ExecuteSqlRequest.QueryOptions.newBuilder().setOptimizerVersion("100000").build()).build(), new Options.UpdateOption[0]));
            Assert.fail((String)"missing expected exception");
        }
        catch (SpannerException e) {
            Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.INVALID_ARGUMENT);
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"Query optimizer version: 100000 is not supported");
        }
        Truth.assertThat((Long)client.executePartitionedUpdate(Statement.newBuilder((String)"UPDATE TEST SET NAME='updated' WHERE 1=1").withQueryOptions(ExecuteSqlRequest.QueryOptions.newBuilder().setOptimizerVersion("1").setOptimizerStatisticsPackage("custom-package").build()).build(), new Options.UpdateOption[0])).isEqualTo((Object)2L);
    }

    @Test
    public void spannerOptions() {
        ResultSet rs;
        DatabaseClient client;
        try (Spanner spanner = (Spanner)env.getTestHelper().getOptions().toBuilder().setDefaultQueryOptions(db.getId(), ExecuteSqlRequest.QueryOptions.newBuilder().setOptimizerVersion("1").setOptimizerStatisticsPackage("custom-package").build()).build().getService();){
            client = spanner.getDatabaseClient(db.getId());
            rs = client.singleUse().executeQuery(Statement.of((String)"SELECT 1"), new Options.QueryOption[0]);
            try {
                while (rs.next()) {
                    Truth.assertThat((Long)rs.getLong(0)).isEqualTo((Object)1L);
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        spanner = (Spanner)env.getTestHelper().getOptions().toBuilder().setDefaultQueryOptions(db.getId(), ExecuteSqlRequest.QueryOptions.newBuilder().setOptimizerVersion("latest").build()).build().getService();
        try {
            client = spanner.getDatabaseClient(db.getId());
            rs = client.singleUse().executeQuery(Statement.of((String)"SELECT 1"), new Options.QueryOption[0]);
            try {
                while (rs.next()) {
                    Truth.assertThat((Long)rs.getLong(0)).isEqualTo((Object)1L);
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        finally {
            if (spanner != null) {
                spanner.close();
            }
        }
        spanner = (Spanner)env.getTestHelper().getOptions().toBuilder().setDefaultQueryOptions(db.getId(), ExecuteSqlRequest.QueryOptions.newBuilder().setOptimizerVersion("100000").build()).build().getService();
        try {
            client = spanner.getDatabaseClient(db.getId());
            try {
                rs = client.singleUse().executeQuery(Statement.of((String)"SELECT 1"), new Options.QueryOption[0]);
                try {
                    while (rs.next()) {
                        Assert.fail((String)"should not get any results");
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            catch (SpannerException e) {
                Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.INVALID_ARGUMENT);
                Truth.assertThat((String)e.getMessage()).contains((CharSequence)"Query optimizer version: 100000 is not supported");
            }
        }
        finally {
            if (spanner != null) {
                spanner.close();
            }
        }
    }
}

