/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.SettableApiFuture;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AbstractAsyncTransactionTest;
import com.google.cloud.spanner.AsyncResultSet;
import com.google.cloud.spanner.AsyncRunner;
import com.google.cloud.spanner.DatabaseClientImpl;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.MockSpannerTestUtil;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.spanner.v1.BatchCreateSessionsRequest;
import com.google.spanner.v1.BeginTransactionRequest;
import com.google.spanner.v1.CommitRequest;
import com.google.spanner.v1.ExecuteBatchDmlRequest;
import com.google.spanner.v1.ExecuteSqlRequest;
import io.grpc.Status;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class AsyncRunnerTest
extends AbstractAsyncTransactionTest {
    @Test
    public void testAsyncRunner_doesNotReturnCommitTimestampBeforeCommit() {
        AsyncRunner runner = this.client().runAsync(new Options.TransactionOption[0]);
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> runner.getCommitTimestamp());
        Assert.assertTrue((boolean)e.getMessage().contains("runAsync() has not yet been called"));
    }

    @Test
    public void testAsyncRunner_doesNotReturnCommitResponseBeforeCommit() {
        AsyncRunner runner = this.client().runAsync(new Options.TransactionOption[0]);
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> runner.getCommitResponse());
        Assert.assertTrue((boolean)e.getMessage().contains("runAsync() has not yet been called"));
    }

    @Test
    public void asyncRunnerUpdate() throws Exception {
        AsyncRunner runner = this.client().runAsync(new Options.TransactionOption[0]);
        ApiFuture updateCount = runner.runAsync(txn -> txn.executeUpdateAsync(MockSpannerTestUtil.UPDATE_STATEMENT, new Options.UpdateOption[0]), (Executor)executor);
        Truth.assertThat((Long)((Long)updateCount.get())).isEqualTo((Object)1L);
    }

    @Test
    public void asyncRunnerIsNonBlocking() throws Exception {
        mockSpanner.freeze();
        AsyncRunner runner = this.clientWithEmptySessionPool().runAsync(new Options.TransactionOption[0]);
        ApiFuture res = runner.runAsync(txn -> {
            txn.executeUpdateAsync(MockSpannerTestUtil.UPDATE_STATEMENT, new Options.UpdateOption[0]);
            return ApiFutures.immediateFuture(null);
        }, (Executor)executor);
        ApiFuture ts = runner.getCommitTimestamp();
        mockSpanner.unfreeze();
        Truth.assertThat((Object)res.get()).isNull();
        Truth.assertThat((Comparable)((Timestamp)ts.get())).isNotNull();
    }

    @Test
    public void asyncRunnerInvalidUpdate() throws Exception {
        AsyncRunner runner = this.client().runAsync(new Options.TransactionOption[0]);
        ApiFuture updateCount = runner.runAsync(txn -> txn.executeUpdateAsync(MockSpannerTestUtil.INVALID_UPDATE_STATEMENT, new Options.UpdateOption[0]), (Executor)executor);
        ExecutionException e = (ExecutionException)Assert.assertThrows(ExecutionException.class, () -> updateCount.get());
        Truth.assertThat((Throwable)e.getCause()).isInstanceOf(SpannerException.class);
        SpannerException se = (SpannerException)e.getCause();
        Truth.assertThat((Comparable)se.getErrorCode()).isEqualTo((Object)ErrorCode.INVALID_ARGUMENT);
        Truth.assertThat((String)se.getMessage()).contains((CharSequence)"invalid statement");
    }

    @Test
    public void asyncRunnerFireAndForgetInvalidUpdate() throws Exception {
        AsyncRunner runner = this.client().runAsync(new Options.TransactionOption[0]);
        ApiFuture res = runner.runAsync(txn -> {
            txn.executeUpdateAsync(MockSpannerTestUtil.INVALID_UPDATE_STATEMENT, new Options.UpdateOption[0]);
            return txn.executeUpdateAsync(MockSpannerTestUtil.UPDATE_STATEMENT, new Options.UpdateOption[0]);
        }, (Executor)executor);
        Truth.assertThat((Long)((Long)res.get())).isEqualTo((Object)1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void asyncRunnerUpdateAborted() throws Exception {
        try {
            mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(MockSpannerTestUtil.UPDATE_STATEMENT, 2L));
            AtomicInteger attempt = new AtomicInteger();
            AsyncRunner runner = this.client().runAsync(new Options.TransactionOption[0]);
            ApiFuture updateCount = runner.runAsync(txn -> {
                if (attempt.incrementAndGet() == 1) {
                    mockSpanner.abortNextStatement();
                } else {
                    mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(MockSpannerTestUtil.UPDATE_STATEMENT, 1L));
                }
                return txn.executeUpdateAsync(MockSpannerTestUtil.UPDATE_STATEMENT, new Options.UpdateOption[0]);
            }, (Executor)executor);
            Truth.assertThat((Long)((Long)updateCount.get())).isEqualTo((Object)1L);
            Truth.assertThat((Integer)attempt.get()).isEqualTo((Object)2);
        }
        finally {
            mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(MockSpannerTestUtil.UPDATE_STATEMENT, 1L));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void asyncRunnerCommitAborted() throws Exception {
        try {
            mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(MockSpannerTestUtil.UPDATE_STATEMENT, 2L));
            AtomicInteger attempt = new AtomicInteger();
            AsyncRunner runner = this.client().runAsync(new Options.TransactionOption[0]);
            ApiFuture updateCount = runner.runAsync(txn -> {
                if (attempt.get() > 0) {
                    mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(MockSpannerTestUtil.UPDATE_STATEMENT, 1L));
                }
                ApiFuture updateCount1 = txn.executeUpdateAsync(MockSpannerTestUtil.UPDATE_STATEMENT, new Options.UpdateOption[0]);
                if (attempt.incrementAndGet() == 1) {
                    mockSpanner.abortTransaction(txn);
                }
                return updateCount1;
            }, (Executor)executor);
            Truth.assertThat((Long)((Long)updateCount.get())).isEqualTo((Object)1L);
            Truth.assertThat((Integer)attempt.get()).isEqualTo((Object)2);
        }
        finally {
            mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(MockSpannerTestUtil.UPDATE_STATEMENT, 1L));
        }
    }

    @Test
    public void asyncRunnerUpdateAbortedWithoutGettingResult() throws Exception {
        AtomicInteger attempt = new AtomicInteger();
        AsyncRunner runner = this.clientWithEmptySessionPool().runAsync(new Options.TransactionOption[0]);
        ApiFuture result = runner.runAsync(txn -> {
            if (attempt.incrementAndGet() == 1) {
                mockSpanner.abortNextStatement();
            }
            txn.executeUpdateAsync(MockSpannerTestUtil.UPDATE_STATEMENT, new Options.UpdateOption[0]);
            return ApiFutures.immediateFuture(null);
        }, (Executor)executor);
        Truth.assertThat((Object)result.get()).isNull();
        Truth.assertThat((Integer)attempt.get()).isEqualTo((Object)2);
        Truth.assertThat(mockSpanner.getRequestTypes()).containsExactly(new Object[]{BatchCreateSessionsRequest.class, ExecuteSqlRequest.class, BeginTransactionRequest.class, ExecuteSqlRequest.class, CommitRequest.class});
    }

    @Test
    public void asyncRunnerCommitFails() throws Exception {
        mockSpanner.setCommitExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)Status.RESOURCE_EXHAUSTED.withDescription("mutation limit exceeded").asRuntimeException()));
        AsyncRunner runner = this.client().runAsync(new Options.TransactionOption[0]);
        ApiFuture updateCount = runner.runAsync(txn -> txn.executeUpdateAsync(MockSpannerTestUtil.UPDATE_STATEMENT, new Options.UpdateOption[0]), (Executor)executor);
        ExecutionException e = (ExecutionException)Assert.assertThrows(ExecutionException.class, () -> updateCount.get());
        Truth.assertThat((Throwable)e.getCause()).isInstanceOf(SpannerException.class);
        SpannerException se = (SpannerException)e.getCause();
        Truth.assertThat((Comparable)se.getErrorCode()).isEqualTo((Object)ErrorCode.RESOURCE_EXHAUSTED);
        Truth.assertThat((String)se.getMessage()).contains((CharSequence)"mutation limit exceeded");
    }

    @Test
    public void asyncRunnerWaitsUntilAsyncUpdateHasFinished() throws Exception {
        AsyncRunner runner = this.clientWithEmptySessionPool().runAsync(new Options.TransactionOption[0]);
        ApiFuture res = runner.runAsync(txn -> {
            txn.executeUpdateAsync(MockSpannerTestUtil.UPDATE_STATEMENT, new Options.UpdateOption[0]);
            return ApiFutures.immediateFuture(null);
        }, (Executor)executor);
        res.get();
        Truth.assertThat(mockSpanner.getRequestTypes()).containsExactly(new Object[]{BatchCreateSessionsRequest.class, ExecuteSqlRequest.class, CommitRequest.class});
    }

    @Test
    public void asyncRunnerBatchUpdate() throws Exception {
        AsyncRunner runner = this.client().runAsync(new Options.TransactionOption[0]);
        ApiFuture updateCount = runner.runAsync(txn -> txn.batchUpdateAsync((Iterable)ImmutableList.of((Object)MockSpannerTestUtil.UPDATE_STATEMENT, (Object)MockSpannerTestUtil.UPDATE_STATEMENT), new Options.UpdateOption[0]), (Executor)executor);
        Truth.assertThat((long[])((long[])updateCount.get())).asList().containsExactly(new Object[]{1L, 1L});
    }

    @Test
    public void asyncRunnerIsNonBlockingWithBatchUpdate() throws Exception {
        mockSpanner.freeze();
        AsyncRunner runner = this.clientWithEmptySessionPool().runAsync(new Options.TransactionOption[0]);
        ApiFuture res = runner.runAsync(txn -> {
            txn.batchUpdateAsync((Iterable)ImmutableList.of((Object)MockSpannerTestUtil.UPDATE_STATEMENT), new Options.UpdateOption[0]);
            return ApiFutures.immediateFuture(null);
        }, (Executor)executor);
        ApiFuture ts = runner.getCommitTimestamp();
        mockSpanner.unfreeze();
        Truth.assertThat((Object)res.get()).isNull();
        Truth.assertThat((Comparable)((Timestamp)ts.get())).isNotNull();
    }

    @Test
    public void asyncRunnerInvalidBatchUpdate() throws Exception {
        AsyncRunner runner = this.client().runAsync(new Options.TransactionOption[0]);
        ApiFuture updateCount = runner.runAsync(txn -> txn.batchUpdateAsync((Iterable)ImmutableList.of((Object)MockSpannerTestUtil.UPDATE_STATEMENT, (Object)MockSpannerTestUtil.INVALID_UPDATE_STATEMENT), new Options.UpdateOption[0]), (Executor)executor);
        ExecutionException e = (ExecutionException)Assert.assertThrows(ExecutionException.class, () -> updateCount.get());
        Truth.assertThat((Throwable)e.getCause()).isInstanceOf(SpannerException.class);
        SpannerException se = (SpannerException)e.getCause();
        Truth.assertThat((Comparable)se.getErrorCode()).isEqualTo((Object)ErrorCode.INVALID_ARGUMENT);
        Truth.assertThat((String)se.getMessage()).contains((CharSequence)"invalid statement");
    }

    @Test
    public void asyncRunnerFireAndForgetInvalidBatchUpdate() throws Exception {
        AsyncRunner runner = this.client().runAsync(new Options.TransactionOption[0]);
        ApiFuture res = runner.runAsync(txn -> {
            txn.batchUpdateAsync((Iterable)ImmutableList.of((Object)MockSpannerTestUtil.UPDATE_STATEMENT, (Object)MockSpannerTestUtil.INVALID_UPDATE_STATEMENT), new Options.UpdateOption[0]);
            return txn.batchUpdateAsync((Iterable)ImmutableList.of((Object)MockSpannerTestUtil.UPDATE_STATEMENT, (Object)MockSpannerTestUtil.UPDATE_STATEMENT), new Options.UpdateOption[0]);
        }, (Executor)executor);
        Truth.assertThat((long[])((long[])res.get())).asList().containsExactly(new Object[]{1L, 1L});
    }

    @Test
    public void asyncRunnerBatchUpdateAborted() throws Exception {
        AtomicInteger attempt = new AtomicInteger();
        AsyncRunner runner = this.client().runAsync(new Options.TransactionOption[0]);
        ApiFuture updateCount = runner.runAsync(txn -> {
            if (attempt.incrementAndGet() == 1) {
                return txn.batchUpdateAsync((Iterable)ImmutableList.of((Object)MockSpannerTestUtil.UPDATE_STATEMENT, (Object)MockSpannerTestUtil.UPDATE_ABORTED_STATEMENT), new Options.UpdateOption[0]);
            }
            return txn.batchUpdateAsync((Iterable)ImmutableList.of((Object)MockSpannerTestUtil.UPDATE_STATEMENT, (Object)MockSpannerTestUtil.UPDATE_STATEMENT), new Options.UpdateOption[0]);
        }, (Executor)executor);
        Truth.assertThat((long[])((long[])updateCount.get())).asList().containsExactly(new Object[]{1L, 1L});
        Truth.assertThat((Integer)attempt.get()).isEqualTo((Object)2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void asyncRunnerWithBatchUpdateCommitAborted() throws Exception {
        try {
            mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(MockSpannerTestUtil.UPDATE_STATEMENT, 2L));
            AtomicInteger attempt = new AtomicInteger();
            AsyncRunner runner = this.client().runAsync(new Options.TransactionOption[0]);
            ApiFuture updateCount = runner.runAsync(txn -> {
                if (attempt.get() > 0) {
                    mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(MockSpannerTestUtil.UPDATE_STATEMENT, 1L));
                }
                ApiFuture updateCount1 = txn.batchUpdateAsync((Iterable)ImmutableList.of((Object)MockSpannerTestUtil.UPDATE_STATEMENT, (Object)MockSpannerTestUtil.UPDATE_STATEMENT), new Options.UpdateOption[0]);
                if (attempt.incrementAndGet() == 1) {
                    mockSpanner.abortTransaction(txn);
                }
                return updateCount1;
            }, (Executor)executor);
            Truth.assertThat((long[])((long[])updateCount.get())).asList().containsExactly(new Object[]{1L, 1L});
            Truth.assertThat((Integer)attempt.get()).isEqualTo((Object)2);
        }
        finally {
            mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(MockSpannerTestUtil.UPDATE_STATEMENT, 1L));
        }
    }

    @Test
    public void asyncRunnerBatchUpdateAbortedWithoutGettingResult() throws Exception {
        AtomicInteger attempt = new AtomicInteger();
        AsyncRunner runner = this.clientWithEmptySessionPool().runAsync(new Options.TransactionOption[0]);
        ApiFuture result = runner.runAsync(txn -> {
            if (attempt.incrementAndGet() == 1) {
                mockSpanner.abortNextTransaction();
            }
            txn.executeUpdate(MockSpannerTestUtil.UPDATE_STATEMENT, new Options.UpdateOption[0]);
            txn.batchUpdateAsync((Iterable)ImmutableList.of((Object)MockSpannerTestUtil.UPDATE_STATEMENT, (Object)MockSpannerTestUtil.UPDATE_STATEMENT), new Options.UpdateOption[0]);
            return ApiFutures.immediateFuture(null);
        }, (Executor)executor);
        Truth.assertThat((Object)result.get()).isNull();
        Truth.assertThat((Integer)attempt.get()).isEqualTo((Object)2);
        Truth.assertThat(mockSpanner.getRequestTypes()).containsExactly(new Object[]{BatchCreateSessionsRequest.class, ExecuteSqlRequest.class, ExecuteBatchDmlRequest.class, CommitRequest.class, ExecuteSqlRequest.class, ExecuteBatchDmlRequest.class, CommitRequest.class});
    }

    @Test
    public void asyncRunnerWithBatchUpdateCommitFails() throws Exception {
        mockSpanner.setCommitExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)Status.RESOURCE_EXHAUSTED.withDescription("mutation limit exceeded").asRuntimeException()));
        AsyncRunner runner = this.client().runAsync(new Options.TransactionOption[0]);
        ApiFuture updateCount = runner.runAsync(txn -> txn.batchUpdateAsync((Iterable)ImmutableList.of((Object)MockSpannerTestUtil.UPDATE_STATEMENT, (Object)MockSpannerTestUtil.UPDATE_STATEMENT), new Options.UpdateOption[0]), (Executor)executor);
        ExecutionException e = (ExecutionException)Assert.assertThrows(ExecutionException.class, () -> updateCount.get());
        Truth.assertThat((Throwable)e.getCause()).isInstanceOf(SpannerException.class);
        SpannerException se = (SpannerException)e.getCause();
        Truth.assertThat((Comparable)se.getErrorCode()).isEqualTo((Object)ErrorCode.RESOURCE_EXHAUSTED);
        Truth.assertThat((String)se.getMessage()).contains((CharSequence)"mutation limit exceeded");
    }

    @Test
    public void asyncRunnerWaitsUntilAsyncBatchUpdateHasFinished() throws Exception {
        AsyncRunner runner = this.clientWithEmptySessionPool().runAsync(new Options.TransactionOption[0]);
        ApiFuture res = runner.runAsync(txn -> {
            txn.batchUpdateAsync((Iterable)ImmutableList.of((Object)MockSpannerTestUtil.UPDATE_STATEMENT), new Options.UpdateOption[0]);
            return ApiFutures.immediateFuture(null);
        }, (Executor)executor);
        res.get();
        Truth.assertThat(mockSpanner.getRequestTypes()).containsExactly(new Object[]{BatchCreateSessionsRequest.class, ExecuteBatchDmlRequest.class, CommitRequest.class});
    }

    @Test
    public void closeTransactionBeforeEndOfAsyncQuery() throws Exception {
        SynchronousQueue results = new SynchronousQueue();
        SettableApiFuture finished = SettableApiFuture.create();
        DatabaseClientImpl clientImpl = (DatabaseClientImpl)this.client();
        Truth.assertThat((Integer)clientImpl.pool.getNumberOfSessionsInUse()).isEqualTo((Object)0);
        AsyncRunner runner = clientImpl.runAsync(new Options.TransactionOption[0]);
        CountDownLatch dataReceived = new CountDownLatch(1);
        CountDownLatch dataChecked = new CountDownLatch(1);
        ApiFuture res = runner.runAsync(txn -> {
            try (AsyncResultSet rs = txn.readAsync("TestTable", KeySet.all(), MockSpannerTestUtil.READ_COLUMN_NAMES, new Options.ReadOption[]{Options.bufferRows((int)1)});){
                rs.setCallback((Executor)Executors.newSingleThreadExecutor(), resultSet -> {
                    dataReceived.countDown();
                    try {
                        while (true) {
                            switch (resultSet.tryNext()) {
                                case DONE: {
                                    finished.set((Object)true);
                                    return AsyncResultSet.CallbackResponse.DONE;
                                }
                                case NOT_READY: {
                                    return AsyncResultSet.CallbackResponse.CONTINUE;
                                }
                                case OK: {
                                    dataChecked.await();
                                    results.put(resultSet.getString(0));
                                }
                            }
                        }
                    }
                    catch (Throwable t) {
                        finished.setException(t);
                        return AsyncResultSet.CallbackResponse.DONE;
                    }
                });
            }
            try {
                dataReceived.await();
                return ApiFutures.immediateFuture(null);
            }
            catch (InterruptedException e) {
                return ApiFutures.immediateFailedFuture((Throwable)SpannerExceptionFactory.propagateInterrupt((InterruptedException)e));
            }
        }, (Executor)executor);
        dataReceived.await();
        Truth.assertThat((Integer)clientImpl.pool.getNumberOfSessionsInUse()).isEqualTo((Object)1);
        Truth.assertThat((Boolean)res.isDone()).isFalse();
        dataChecked.countDown();
        ArrayList resultList = new ArrayList();
        do {
            results.drainTo(resultList);
        } while (!finished.isDone() || results.size() > 0);
        Truth.assertThat((Boolean)((Boolean)finished.get())).isTrue();
        Truth.assertThat(resultList).containsExactly(new Object[]{"k1", "k2", "k3"});
        Truth.assertThat((Object)res.get()).isNull();
        Truth.assertThat((Integer)clientImpl.pool.getNumberOfSessionsInUse()).isEqualTo((Object)0);
    }

    @Test
    public void asyncRunnerReadRow() throws Exception {
        AsyncRunner runner = this.client().runAsync(new Options.TransactionOption[0]);
        ApiFuture val = runner.runAsync(txn -> ApiFutures.transform((ApiFuture)txn.readRowAsync("TestTable", Key.of((Object[])new Object[]{1L}), MockSpannerTestUtil.READ_COLUMN_NAMES), input -> input.getString("Value"), (Executor)MoreExecutors.directExecutor()), (Executor)executor);
        Truth.assertThat((String)((String)val.get())).isEqualTo((Object)"v1");
    }

    @Test
    public void asyncRunnerRead() throws Exception {
        AsyncRunner runner = this.client().runAsync(new Options.TransactionOption[0]);
        ApiFuture val = runner.runAsync(txn -> txn.readAsync("TestTable", KeySet.all(), MockSpannerTestUtil.READ_COLUMN_NAMES, new Options.ReadOption[0]).toListAsync(input -> input.getString("Value"), MoreExecutors.directExecutor()), (Executor)executor);
        Truth.assertThat((Iterable)((Iterable)val.get())).containsExactly(new Object[]{"v1", "v2", "v3"});
    }
}

