/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.spanner.BackupId;
import com.google.common.truth.Truth;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class BackupIdTest {
    @Test
    public void basics() {
        String name = "projects/test-project/instances/test-instance/backups/backup-1";
        BackupId bid = BackupId.of((String)name);
        Truth.assertThat((String)bid.getName()).isEqualTo((Object)name);
        Truth.assertThat((String)bid.getInstanceId().getInstance()).isEqualTo((Object)"test-instance");
        Truth.assertThat((String)bid.getBackup()).isEqualTo((Object)"backup-1");
        Truth.assertThat((Object)BackupId.of((String)"test-project", (String)"test-instance", (String)"backup-1")).isEqualTo((Object)bid);
        Truth.assertThat((Object)BackupId.of((String)name)).isEqualTo((Object)bid);
        Truth.assertThat((Integer)BackupId.of((String)name).hashCode()).isEqualTo((Object)bid.hashCode());
        Truth.assertThat((String)bid.toString()).isEqualTo((Object)name);
    }

    @Test
    public void badName() {
        IllegalArgumentException e = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> BackupId.of((String)"bad name"));
        Truth.assertThat((Boolean)e.getMessage().contains("projects"));
    }
}

