/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.spanner.BackupId;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.Restore;
import com.google.cloud.spanner.encryption.EncryptionConfigs;
import com.google.cloud.spanner.encryption.RestoreEncryptionConfig;
import org.junit.Assert;
import org.junit.Test;

public class RestoreTest {
    private static final BackupId BACKUP_ID = BackupId.of((String)"test-project", (String)"test-instance", (String)"test-backup");
    private static final DatabaseId DATABASE_ID = DatabaseId.of((String)"test-project", (String)"test-instance", (String)"test-database");
    private static final String KMS_KEY_NAME = "kms-key-name";
    private static final RestoreEncryptionConfig ENCRYPTION_CONFIG_INFO = EncryptionConfigs.customerManagedEncryption((String)"kms-key-name");

    @Test
    public void testRestore() {
        Restore actualRestore = new Restore.Builder(BACKUP_ID, DATABASE_ID).setEncryptionConfig(ENCRYPTION_CONFIG_INFO).build();
        Restore expectedRestore = new Restore(BACKUP_ID, DATABASE_ID, ENCRYPTION_CONFIG_INFO);
        Assert.assertEquals((Object)expectedRestore, (Object)actualRestore);
    }

    @Test
    public void testEqualsAndHashCode() {
        Restore restore1 = new Restore(BACKUP_ID, DATABASE_ID, ENCRYPTION_CONFIG_INFO);
        Restore restore2 = new Restore(BACKUP_ID, DATABASE_ID, ENCRYPTION_CONFIG_INFO);
        Assert.assertEquals((Object)restore1, (Object)restore2);
        Assert.assertEquals((long)restore1.hashCode(), (long)restore2.hashCode());
    }
}

