/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.spanner.SessionPoolOptions;
import com.google.common.truth.Truth;
import java.util.ArrayList;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.threeten.bp.Duration;

@RunWith(value=Parameterized.class)
public class SessionPoolOptionsTest {
    @Parameterized.Parameter
    public int minSessions;
    @Parameterized.Parameter(value=1)
    public int maxSessions;

    @Parameterized.Parameters(name="min sessions = {0}, max sessions = {1}")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        params.add(new Object[]{1, 1});
        params.add(new Object[]{500, 600});
        params.add(new Object[]{600, 500});
        return params;
    }

    @Test
    public void setMinMaxSessions() {
        try {
            SessionPoolOptions options = SessionPoolOptions.newBuilder().setMinSessions(this.minSessions).setMaxSessions(this.maxSessions).build();
            if (this.minSessions > this.maxSessions) {
                Assert.fail((String)"Expected exception");
            }
            Truth.assertThat((Integer)this.minSessions).isEqualTo((Object)options.getMinSessions());
            Truth.assertThat((Integer)this.maxSessions).isEqualTo((Object)options.getMaxSessions());
        }
        catch (IllegalArgumentException ex) {
            if (this.minSessions <= this.maxSessions) {
                throw ex;
            }
            Assert.assertNotNull((Object)ex.getMessage());
        }
    }

    @Test
    public void setOnlyMaxSessions() {
        int defaultMinSessions = 100;
        SessionPoolOptions options = SessionPoolOptions.newBuilder().setMaxSessions(101).build();
        Truth.assertThat((Integer)options.getMaxSessions()).isEqualTo((Object)101);
        Truth.assertThat((Integer)options.getMinSessions()).isEqualTo((Object)100);
        options = SessionPoolOptions.newBuilder().setMaxSessions(99).build();
        Truth.assertThat((Integer)options.getMaxSessions()).isEqualTo((Object)99);
        Truth.assertThat((Integer)options.getMinSessions()).isEqualTo((Object)99);
    }

    @Test
    public void setValidMinSessions() {
        SessionPoolOptions.newBuilder().setMinSessions(0).build();
        SessionPoolOptions.newBuilder().setMinSessions(1).build();
        SessionPoolOptions.newBuilder().setMinSessions(400).build();
        SessionPoolOptions.newBuilder().setMaxSessions(Integer.MAX_VALUE).setMinSessions(Integer.MAX_VALUE).build();
    }

    @Test(expected=IllegalArgumentException.class)
    public void setNegativeMinSessions() {
        SessionPoolOptions.newBuilder().setMinSessions(-1);
    }

    @Test
    public void setValidMaxSessions() {
        SessionPoolOptions.newBuilder().setMaxSessions(1).build();
        SessionPoolOptions.newBuilder().setMaxSessions(400).build();
        SessionPoolOptions.newBuilder().setMaxSessions(Integer.MAX_VALUE).build();
    }

    @Test(expected=IllegalArgumentException.class)
    public void setZeroMaxSessions() {
        SessionPoolOptions.newBuilder().setMaxSessions(0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void setNegativeMaxSessions() {
        SessionPoolOptions.newBuilder().setMaxSessions(-1);
    }

    @Test
    public void verifyDefaultInactiveTransactionRemovalOptions() {
        SessionPoolOptions sessionPoolOptions = SessionPoolOptions.newBuilder().build();
        SessionPoolOptions.InactiveTransactionRemovalOptions inactiveTransactionRemovalOptions = sessionPoolOptions.getInactiveTransactionRemovalOptions();
        Assert.assertFalse((boolean)sessionPoolOptions.warnInactiveTransactions());
        Assert.assertFalse((boolean)sessionPoolOptions.warnAndCloseInactiveTransactions());
        Assert.assertFalse((boolean)sessionPoolOptions.closeInactiveTransactions());
        Assert.assertEquals((double)0.95, (double)inactiveTransactionRemovalOptions.getUsedSessionsRatioThreshold(), (double)0.0);
        Assert.assertEquals((Object)Duration.ofMinutes((long)2L), (Object)inactiveTransactionRemovalOptions.getExecutionFrequency());
        Assert.assertEquals((Object)Duration.ofMinutes((long)60L), (Object)inactiveTransactionRemovalOptions.getIdleTimeThreshold());
    }

    @Test
    public void setWarnIfInactiveTransactions() {
        SessionPoolOptions sessionPoolOptions = SessionPoolOptions.newBuilder().setWarnIfInactiveTransactions().build();
        Assert.assertTrue((boolean)sessionPoolOptions.warnInactiveTransactions());
        Assert.assertFalse((boolean)sessionPoolOptions.warnAndCloseInactiveTransactions());
        Assert.assertFalse((boolean)sessionPoolOptions.closeInactiveTransactions());
    }

    @Test
    public void setWarnAndCloseIfInactiveTransactions() {
        SessionPoolOptions sessionPoolOptions = SessionPoolOptions.newBuilder().setWarnAndCloseIfInactiveTransactions().build();
        Assert.assertFalse((boolean)sessionPoolOptions.warnInactiveTransactions());
        Assert.assertTrue((boolean)sessionPoolOptions.warnAndCloseInactiveTransactions());
        Assert.assertFalse((boolean)sessionPoolOptions.closeInactiveTransactions());
    }

    @Test
    public void setCloseIfInactiveTransactions() {
        SessionPoolOptions sessionPoolOptions = SessionPoolOptions.newBuilder().setCloseIfInactiveTransactions().build();
        Assert.assertFalse((boolean)sessionPoolOptions.warnInactiveTransactions());
        Assert.assertFalse((boolean)sessionPoolOptions.warnAndCloseInactiveTransactions());
        Assert.assertTrue((boolean)sessionPoolOptions.closeInactiveTransactions());
    }

    @Test(expected=IllegalArgumentException.class)
    public void setNegativeExecutionFrequency() {
        SessionPoolOptions.InactiveTransactionRemovalOptions inactiveTransactionRemovalOptions = SessionPoolOptions.InactiveTransactionRemovalOptions.newBuilder().setExecutionFrequency(Duration.ofMillis((long)-1L)).build();
        SessionPoolOptions.newBuilder().setInactiveTransactionRemovalOptions(inactiveTransactionRemovalOptions);
    }

    @Test(expected=IllegalArgumentException.class)
    public void setNegativeIdleTimeThreshold() {
        SessionPoolOptions.InactiveTransactionRemovalOptions inactiveTransactionRemovalOptions = SessionPoolOptions.InactiveTransactionRemovalOptions.newBuilder().setIdleTimeThreshold(Duration.ofMillis((long)-1L)).build();
        SessionPoolOptions.newBuilder().setInactiveTransactionRemovalOptions(inactiveTransactionRemovalOptions);
    }
}

