/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.ForwardingApiFuture;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.SpannerApiFutures;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.common.truth.Truth;
import java.util.concurrent.CancellationException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SpannerApiFuturesTest {
    @Test
    public void testGet() {
        ApiFuture fut = ApiFutures.immediateFuture((Object)1L);
        Truth.assertThat((Long)((Long)SpannerApiFutures.get((ApiFuture)fut))).isEqualTo((Object)1L);
    }

    @Test
    public void testGetNull() {
        Assert.assertThrows(NullPointerException.class, () -> SpannerApiFutures.get(null));
    }

    @Test
    public void testGetOrNull() {
        Truth.assertThat((Object)SpannerApiFutures.getOrNull((ApiFuture)null)).isNull();
    }

    @Test
    public void testGetSpannerException() {
        ApiFuture fut = ApiFutures.immediateFailedFuture((Throwable)SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.FAILED_PRECONDITION, (String)"test exception"));
        SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> SpannerApiFutures.get((ApiFuture)fut));
        Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)e.getErrorCode());
        Truth.assertThat((String)e.getMessage()).contains((CharSequence)"test exception");
    }

    @Test
    public void testGetOtherException() {
        ApiFuture fut = ApiFutures.immediateFailedFuture((Throwable)new RuntimeException("test runtime exception"));
        SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> SpannerApiFutures.get((ApiFuture)fut));
        Assert.assertEquals((Object)ErrorCode.UNKNOWN, (Object)e.getErrorCode());
        Truth.assertThat((String)e.getMessage()).contains((CharSequence)"test runtime exception");
    }

    @Test
    public void testGetInterruptedException() {
        ForwardingApiFuture<Void> fut = new ForwardingApiFuture<Void>(ApiFutures.immediateFuture(null)){

            public Void get() throws InterruptedException {
                throw new InterruptedException("test interrupted exception");
            }
        };
        SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> SpannerApiFuturesTest.lambda$testGetInterruptedException$3((ApiFuture)fut));
        Assert.assertEquals((Object)ErrorCode.CANCELLED, (Object)e.getErrorCode());
        Truth.assertThat((String)e.getMessage()).doesNotContain((CharSequence)"test interrupted exception");
    }

    @Test
    public void testGetCancellationException() {
        ForwardingApiFuture<Void> fut = new ForwardingApiFuture<Void>(ApiFutures.immediateFuture(null)){

            public Void get() {
                throw new CancellationException("test cancellation exception");
            }
        };
        SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> SpannerApiFuturesTest.lambda$testGetCancellationException$4((ApiFuture)fut));
        Assert.assertEquals((Object)ErrorCode.CANCELLED, (Object)e.getErrorCode());
        Truth.assertThat((String)e.getMessage()).contains((CharSequence)"test cancellation exception");
    }

    private static /* synthetic */ void lambda$testGetCancellationException$4(ApiFuture fut) throws Throwable {
        SpannerApiFutures.get((ApiFuture)fut);
    }

    private static /* synthetic */ void lambda$testGetInterruptedException$3(ApiFuture fut) throws Throwable {
        SpannerApiFutures.get((ApiFuture)fut);
    }
}

