/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.cloud.spanner.AsyncResultSet;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.SpannerApiFutures;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.connection.AsyncStatementResult;
import com.google.cloud.spanner.connection.AsyncStatementResultImpl;
import com.google.cloud.spanner.connection.StatementResult;
import com.google.common.truth.Truth;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class AsyncStatementResultImplTest {
    @Test
    public void testNoResultGetResultSetAsync() {
        AsyncStatementResult subject = AsyncStatementResultImpl.noResult((ApiFuture)ApiFutures.immediateFuture(null));
        Truth.assertThat((Comparable)subject.getResultType()).isEqualTo((Object)StatementResult.ResultType.NO_RESULT);
        try {
            subject.getResultSetAsync();
            Assert.fail((String)"Expected exception");
        }
        catch (SpannerException ex) {
            Truth.assertThat((Comparable)ex.getErrorCode()).isEqualTo((Object)ErrorCode.FAILED_PRECONDITION);
        }
    }

    @Test
    public void testNoResultGetUpdateCountAsync() {
        AsyncStatementResult subject = AsyncStatementResultImpl.noResult((ApiFuture)ApiFutures.immediateFuture(null));
        Truth.assertThat((Comparable)subject.getResultType()).isEqualTo((Object)StatementResult.ResultType.NO_RESULT);
        try {
            subject.getUpdateCountAsync();
            Assert.fail((String)"Expected exception");
        }
        catch (SpannerException ex) {
            Truth.assertThat((Comparable)ex.getErrorCode()).isEqualTo((Object)ErrorCode.FAILED_PRECONDITION);
        }
    }

    @Test
    public void testResultSetGetResultSetAsync() {
        AsyncStatementResult subject = AsyncStatementResultImpl.of((AsyncResultSet)((AsyncResultSet)Mockito.mock(AsyncResultSet.class)));
        Truth.assertThat((Comparable)subject.getResultType()).isEqualTo((Object)StatementResult.ResultType.RESULT_SET);
        Truth.assertThat((Object)subject.getResultSetAsync()).isNotNull();
    }

    @Test
    public void testResultSetGetUpdateCountAsync() {
        AsyncStatementResult subject = AsyncStatementResultImpl.of((AsyncResultSet)((AsyncResultSet)Mockito.mock(AsyncResultSet.class)));
        Truth.assertThat((Comparable)subject.getResultType()).isEqualTo((Object)StatementResult.ResultType.RESULT_SET);
        try {
            subject.getUpdateCountAsync();
            Assert.fail((String)"Expected exception");
        }
        catch (SpannerException ex) {
            Truth.assertThat((Comparable)ex.getErrorCode()).isEqualTo((Object)ErrorCode.FAILED_PRECONDITION);
        }
    }

    @Test
    public void testUpdateCountGetResultSetAsync() {
        AsyncStatementResult subject = AsyncStatementResultImpl.of((ApiFuture)ApiFutures.immediateFuture((Object)1L));
        Truth.assertThat((Comparable)subject.getResultType()).isEqualTo((Object)StatementResult.ResultType.UPDATE_COUNT);
        try {
            subject.getResultSetAsync();
            Assert.fail((String)"Expected exception");
        }
        catch (SpannerException ex) {
            Truth.assertThat((Comparable)ex.getErrorCode()).isEqualTo((Object)ErrorCode.FAILED_PRECONDITION);
        }
    }

    @Test
    public void testUpdateCountGetUpdateCountAsync() {
        AsyncStatementResult subject = AsyncStatementResultImpl.of((ApiFuture)ApiFutures.immediateFuture((Object)1L));
        Truth.assertThat((Comparable)subject.getResultType()).isEqualTo((Object)StatementResult.ResultType.UPDATE_COUNT);
        Truth.assertThat((Long)((Long)SpannerApiFutures.get((ApiFuture)subject.getUpdateCountAsync()))).isEqualTo((Object)1L);
    }
}

