/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.connection.AbstractSqlScriptTest;
import com.google.cloud.spanner.connection.AbstractStatementParser;
import com.google.cloud.spanner.connection.ClientSideStatementImpl;
import com.google.cloud.spanner.connection.ClientSideStatements;
import com.google.cloud.spanner.connection.SqlScriptVerifier;
import com.google.cloud.spanner.connection.StatementResult;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;

public class ClientSideStatementsTest
extends AbstractSqlScriptTest {
    private static PrintWriter writer;

    private static String getScriptFile(Dialect dialect) {
        switch (dialect) {
            case GOOGLE_STANDARD_SQL: {
                return "ClientSideStatementsTest.sql";
            }
            case POSTGRESQL: {
                return "postgresql/ClientSideStatementsTest.sql";
            }
        }
        throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INVALID_ARGUMENT, (String)("Unknown or unsupported dialect: " + dialect));
    }

    @Test
    public void testExecuteClientSideStatementsScript() throws Exception {
        SqlScriptVerifier verifier = new SqlScriptVerifier(new AbstractSqlScriptTest.TestConnectionProvider(this.dialect));
        verifier.verifyStatementsInFile(ClientSideStatementsTest.getScriptFile(this.dialect), this.getClass(), true);
    }

    @Test
    public void testClientSideStatementType() {
        AbstractStatementParser parser = AbstractStatementParser.getInstance((Dialect)this.dialect);
        Assert.assertEquals((Object)StatementResult.ClientSideStatementType.BEGIN, (Object)parser.parse(Statement.of((String)"BEGIN TRANSACTION")).getClientSideStatementType());
        Assert.assertEquals((Object)StatementResult.ClientSideStatementType.COMMIT, (Object)parser.parse(Statement.of((String)"COMMIT TRANSACTION")).getClientSideStatementType());
        Assert.assertEquals((Object)StatementResult.ClientSideStatementType.ROLLBACK, (Object)parser.parse(Statement.of((String)"ROLLBACK TRANSACTION")).getClientSideStatementType());
        if (this.dialect == Dialect.POSTGRESQL) {
            Assert.assertEquals((Object)StatementResult.ClientSideStatementType.ROLLBACK, (Object)parser.parse(Statement.of((String)"ABORT")).getClientSideStatementType());
            Assert.assertEquals((Object)StatementResult.ClientSideStatementType.ROLLBACK, (Object)parser.parse(Statement.of((String)"ABORT TRANSACTION")).getClientSideStatementType());
            Assert.assertEquals((Object)StatementResult.ClientSideStatementType.ROLLBACK, (Object)parser.parse(Statement.of((String)"ABORT WORK")).getClientSideStatementType());
            Assert.assertEquals((Object)StatementResult.ClientSideStatementType.ROLLBACK, (Object)parser.parse(Statement.of((String)"ABORT TRANSACTION and no chain")).getClientSideStatementType());
        }
        for (ClientSideStatementImpl statement : parser.getClientSideStatements()) {
            Assert.assertNotNull((String)(statement.toString() + " misses a statement type"), (Object)statement.getStatementType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void generateTestScript(Dialect dialect) throws Exception {
        AbstractStatementParser parser = AbstractStatementParser.getInstance((Dialect)dialect);
        try {
            ClientSideStatementsTest.openLog(dialect);
            ClientSideStatements statements = ClientSideStatements.getInstance((Dialect)dialect);
            for (ClientSideStatementImpl statement : statements.getCompiledStatements()) {
                ClientSideStatementsTest.generateTestStatements(parser, statement);
            }
        }
        finally {
            ClientSideStatementsTest.closeLog();
        }
    }

    private static void log(List<String> pre, String sql) {
        ClientSideStatementsTest.writeLog("NEW_CONNECTION");
        for (String prerequisite : pre) {
            ClientSideStatementsTest.writeLog(prerequisite);
        }
        ClientSideStatementsTest.writeLog(sql);
    }

    private static void log(List<String> pre, String statement, ErrorCode error) {
        ClientSideStatementsTest.log(pre, "@EXPECT EXCEPTION " + error.name() + "\n" + statement);
    }

    private static void writeLog(String statement) {
        writer.println(statement + ";");
    }

    private static void openLog(Dialect dialect) {
        try {
            writer = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream("src/test/resources/com/google/cloud/spanner/connection/" + ClientSideStatementsTest.getScriptFile(dialect), false), StandardCharsets.UTF_8), true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @AfterClass
    public static void closeLog() {
        if (writer != null) {
            writer.close();
        }
    }

    private static void generateTestStatements(AbstractStatementParser parser, ClientSideStatementImpl statement) {
        for (String sql : statement.getExampleStatements()) {
            String[] replacements;
            boolean anySuffixAllowed;
            ClientSideStatementsTest.log(statement.getExamplePrerequisiteStatements(), sql);
            if (statement.getStatementType() != StatementResult.ClientSideStatementType.RUN_PARTITION) {
                ClientSideStatementsTest.log(statement.getExamplePrerequisiteStatements(), ClientSideStatementsTest.upper(sql));
                ClientSideStatementsTest.log(statement.getExamplePrerequisiteStatements(), ClientSideStatementsTest.lower(sql));
            }
            ClientSideStatementsTest.log(statement.getExamplePrerequisiteStatements(), ClientSideStatementsTest.withLeadingSpaces(sql));
            ClientSideStatementsTest.log(statement.getExamplePrerequisiteStatements(), ClientSideStatementsTest.withLeadingTabs(sql));
            ClientSideStatementsTest.log(statement.getExamplePrerequisiteStatements(), ClientSideStatementsTest.withLeadingLinefeeds(sql));
            ClientSideStatementsTest.log(statement.getExamplePrerequisiteStatements(), ClientSideStatementsTest.withTrailingSpaces(sql));
            ClientSideStatementsTest.log(statement.getExamplePrerequisiteStatements(), ClientSideStatementsTest.withTrailingTabs(sql));
            ClientSideStatementsTest.log(statement.getExamplePrerequisiteStatements(), ClientSideStatementsTest.withTrailingLinefeeds(sql));
            ClientSideStatementsTest.log(statement.getExamplePrerequisiteStatements(), ClientSideStatementsTest.withSpaces(sql));
            ClientSideStatementsTest.log(statement.getExamplePrerequisiteStatements(), ClientSideStatementsTest.withTabs(sql));
            ClientSideStatementsTest.log(statement.getExamplePrerequisiteStatements(), ClientSideStatementsTest.withLinefeeds(sql));
            ClientSideStatementsTest.log(statement.getExamplePrerequisiteStatements(), ClientSideStatementsTest.withInvalidPrefix(sql), ErrorCode.INVALID_ARGUMENT);
            boolean bl = anySuffixAllowed = statement.getStatementType() == StatementResult.ClientSideStatementType.PARTITION || statement.getStatementType() == StatementResult.ClientSideStatementType.RUN_PARTITIONED_QUERY;
            if (anySuffixAllowed) {
                ClientSideStatementsTest.log(statement.getExamplePrerequisiteStatements(), ClientSideStatementsTest.withInvalidSuffix(sql));
            } else {
                ClientSideStatementsTest.log(statement.getExamplePrerequisiteStatements(), ClientSideStatementsTest.withInvalidSuffix(sql), parser.isQuery(ClientSideStatementsTest.withInvalidSuffix(sql)) ? ErrorCode.UNIMPLEMENTED : ErrorCode.INVALID_ARGUMENT);
            }
            for (String replacement : replacements = new String[]{"%", "_", "&", "$", "@", "!", "*", "(", ")", "-", "+", "-#", "/", "\\", "?", "-/", "/#", "/-"}) {
                ClientSideStatementsTest.log(statement.getExamplePrerequisiteStatements(), ClientSideStatementsTest.withPrefix(replacement, sql), ErrorCode.INVALID_ARGUMENT);
                if (anySuffixAllowed) {
                    ClientSideStatementsTest.log(statement.getExamplePrerequisiteStatements(), ClientSideStatementsTest.withSuffix(replacement, sql));
                    continue;
                }
                ClientSideStatementsTest.log(statement.getExamplePrerequisiteStatements(), ClientSideStatementsTest.withSuffix(replacement, sql), parser.isQuery(ClientSideStatementsTest.withSuffix(replacement, sql)) ? ErrorCode.UNIMPLEMENTED : ErrorCode.INVALID_ARGUMENT);
                ClientSideStatementsTest.log(statement.getExamplePrerequisiteStatements(), ClientSideStatementsTest.replaceLastSpaceWith(replacement, sql), parser.isQuery(ClientSideStatementsTest.replaceLastSpaceWith(replacement, sql)) ? ErrorCode.UNIMPLEMENTED : ErrorCode.INVALID_ARGUMENT);
            }
        }
    }

    private static String upper(String statement) {
        return statement.toUpperCase();
    }

    private static String lower(String statement) {
        return statement.toLowerCase();
    }

    private static String withLeadingSpaces(String statement) {
        return "   " + statement;
    }

    private static String withLeadingTabs(String statement) {
        return "\t\t\t" + statement;
    }

    private static String withLeadingLinefeeds(String statement) {
        return "\n\n\n" + statement;
    }

    private static String withTrailingSpaces(String statement) {
        return statement + "  ";
    }

    private static String withTrailingTabs(String statement) {
        return statement + "\t\t";
    }

    private static String withTrailingLinefeeds(String statement) {
        return statement + "\n\n";
    }

    private static String withSpaces(String statement) {
        return statement.replaceAll(" ", "   ");
    }

    private static String withTabs(String statement) {
        return statement.replaceAll(" ", "\t");
    }

    private static String withLinefeeds(String statement) {
        Matcher matcher = Pattern.compile("(.*)('.*')").matcher(statement);
        if (matcher.matches()) {
            return matcher.group(1).replaceAll(" ", "\n") + matcher.group(2);
        }
        return statement.replaceAll(" ", "\n");
    }

    private static String withInvalidPrefix(String statement) {
        return "foo " + statement;
    }

    private static String withInvalidSuffix(String statement) {
        return statement + " bar";
    }

    private static String withPrefix(String prefix, String statement) {
        return prefix + statement;
    }

    private static String withSuffix(String suffix, String statement) {
        return statement + suffix;
    }

    private static String replaceLastSpaceWith(String replacement, String statement) {
        if (statement.lastIndexOf(32) > -1) {
            return statement.substring(0, statement.lastIndexOf(32)) + replacement + statement.substring(statement.lastIndexOf(32) + 1);
        }
        return statement + replacement;
    }
}

