/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection.it;

import com.google.cloud.spanner.AbortedDueToConcurrentModificationException;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ParallelIntegrationTest;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.connection.ITAbstractSpannerTest;
import com.google.cloud.spanner.testing.EmulatorSpannerHelper;
import com.google.common.collect.ImmutableList;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@Category(value={ParallelIntegrationTest.class})
@RunWith(value=JUnit4.class)
public class ITDelayBeginTransactionTest
extends ITAbstractSpannerTest {
    @Override
    public void appendConnectionUri(StringBuilder uri) {
        uri.append(";autocommit=false;delayTransactionStartUntilFirstWrite=true");
    }

    @Override
    public boolean doCreateDefaultTestTable() {
        return true;
    }

    @Before
    public void setupTestData() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.bufferedWrite(Mutation.delete((String)"TEST", (KeySet)KeySet.all()));
            connection.commit();
            connection.bufferedWrite((Iterable)ImmutableList.of((Object)((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"TEST").set("id").to(1L)).set("name").to("One")).build(), (Object)((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"TEST").set("id").to(2L)).set("name").to("Two")).build()));
            connection.commit();
        }
    }

    @Test
    public void testReadExistingData() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            try (ResultSet resultSet = connection.executeQuery(Statement.of((String)"select * from test order by id"), new Options.QueryOption[0]);){
                Assert.assertTrue((boolean)resultSet.next());
                Assert.assertEquals((long)1L, (long)resultSet.getLong("ID"));
                Assert.assertEquals((Object)"One", (Object)resultSet.getString("NAME"));
                Assert.assertTrue((boolean)resultSet.next());
                Assert.assertEquals((long)2L, (long)resultSet.getLong("ID"));
                Assert.assertEquals((Object)"Two", (Object)resultSet.getString("NAME"));
                Assert.assertFalse((boolean)resultSet.next());
            }
            connection.commit();
        }
    }

    @Test
    public void testReadThenWrite() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            try (ResultSet resultSet = connection.executeQuery(Statement.of((String)"select * from test order by id"), new Options.QueryOption[0]);){
                Assert.assertTrue((boolean)resultSet.next());
                Assert.assertEquals((long)1L, (long)resultSet.getLong("ID"));
                Assert.assertEquals((Object)"One", (Object)resultSet.getString("NAME"));
                Assert.assertTrue((boolean)resultSet.next());
                Assert.assertEquals((long)2L, (long)resultSet.getLong("ID"));
                Assert.assertEquals((Object)"Two", (Object)resultSet.getString("NAME"));
                Assert.assertFalse((boolean)resultSet.next());
            }
            connection.executeUpdate(((Statement.Builder)((Statement.Builder)Statement.newBuilder((String)"insert into test (id, name) values (@id, @name)").bind("id").to(3L)).bind("name").to("Three")).build());
            connection.commit();
            resultSet = connection.executeQuery(Statement.of((String)"select count(*) from test"), new Options.QueryOption[0]);
            try {
                Assert.assertTrue((boolean)resultSet.next());
                Assert.assertEquals((long)3L, (long)resultSet.getLong(0));
                Assert.assertFalse((boolean)resultSet.next());
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
    }

    @Test
    public void testWriteThenRead() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.executeUpdate(((Statement.Builder)((Statement.Builder)Statement.newBuilder((String)"insert into test (id, name) values (@id, @name)").bind("id").to(3L)).bind("name").to("Three")).build());
            try (ResultSet resultSet = connection.executeQuery(Statement.of((String)"select * from test where id in (2,3) order by id"), new Options.QueryOption[0]);){
                Assert.assertTrue((boolean)resultSet.next());
                Assert.assertEquals((long)2L, (long)resultSet.getLong("ID"));
                Assert.assertEquals((Object)"Two", (Object)resultSet.getString("NAME"));
                Assert.assertTrue((boolean)resultSet.next());
                Assert.assertEquals((long)3L, (long)resultSet.getLong("ID"));
                Assert.assertEquals((Object)"Three", (Object)resultSet.getString("NAME"));
                Assert.assertFalse((boolean)resultSet.next());
            }
            connection.commit();
            resultSet = connection.executeQuery(Statement.of((String)"select count(*) from test"), new Options.QueryOption[0]);
            try {
                Assert.assertTrue((boolean)resultSet.next());
                Assert.assertEquals((long)3L, (long)resultSet.getLong(0));
                Assert.assertFalse((boolean)resultSet.next());
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
    }

    @Test
    public void testConcurrentReadAndWrites() {
        try (ITAbstractSpannerTest.ITConnection connection1 = this.createConnection();
             ITAbstractSpannerTest.ITConnection connection2 = this.createConnection();){
            int originalRowCount = 0;
            try (ResultSet resultSet = connection1.executeQuery(Statement.of((String)"select * from test order by id"), new Options.QueryOption[0]);){
                while (resultSet.next()) {
                    ++originalRowCount;
                }
            }
            connection2.executeUpdate(((Statement.Builder)((Statement.Builder)Statement.newBuilder((String)"insert into test (id, name) values (@id, @name)").bind("id").to(3L)).bind("name").to("Three")).build());
            int rowCount = 0;
            try (ResultSet resultSet = connection1.executeQuery(Statement.of((String)"select * from test order by id"), new Options.QueryOption[0]);){
                while (resultSet.next()) {
                    ++rowCount;
                }
            }
            Assert.assertEquals((long)originalRowCount, (long)rowCount);
            connection2.commit();
            rowCount = 0;
            resultSet = connection1.executeQuery(Statement.of((String)"select * from test order by id"), new Options.QueryOption[0]);
            try {
                while (resultSet.next()) {
                    ++rowCount;
                }
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            Assert.assertEquals((long)(originalRowCount + 1), (long)rowCount);
            connection1.commit();
        }
    }

    @Test
    public void testConcurrentWrites() {
        Assume.assumeFalse((String)"The emulator does not support concurrent transactions", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        try (ITAbstractSpannerTest.ITConnection connection1 = this.createConnection();
             ITAbstractSpannerTest.ITConnection connection2 = this.createConnection();){
            int originalRowCount = 0;
            try (ResultSet resultSet = connection1.executeQuery(Statement.of((String)"select * from test order by id"), new Options.QueryOption[0]);){
                while (resultSet.next()) {
                    ++originalRowCount;
                }
            }
            connection2.executeUpdate(((Statement.Builder)((Statement.Builder)Statement.newBuilder((String)"insert into test (id, name) values (@id, @name)").bind("id").to(3L)).bind("name").to("Three")).build());
            connection1.executeUpdate(((Statement.Builder)((Statement.Builder)Statement.newBuilder((String)"insert into test (id, name) values (@id, @name)").bind("id").to(4L)).bind("name").to("Four")).build());
            connection2.commit();
            int rowCount = 0;
            try (ResultSet resultSet = connection1.executeQuery(Statement.of((String)"select * from test order by id"), new Options.QueryOption[0]);){
                while (resultSet.next()) {
                    ++rowCount;
                }
            }
            Assert.assertEquals((long)(originalRowCount + 2), (long)rowCount);
            connection1.commit();
        }
    }

    @Test
    public void testConflictingTransactions() {
        Assume.assumeFalse((String)"The emulator does not support concurrent transactions", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        try (ITAbstractSpannerTest.ITConnection connection1 = this.createConnection();
             ITAbstractSpannerTest.ITConnection connection2 = this.createConnection();){
            connection2.executeUpdate(((Statement.Builder)((Statement.Builder)Statement.newBuilder((String)"insert into test (id, name) values (@id, @name)").bind("id").to(3L)).bind("name").to("Three")).build());
            connection1.executeUpdate(((Statement.Builder)((Statement.Builder)Statement.newBuilder((String)"insert into test (id, name) values (@id, @name)").bind("id").to(4L)).bind("name").to("Four")).build());
            try (ResultSet resultSet = connection1.executeQuery(Statement.of((String)"select * from test order by id"), new Options.QueryOption[0]);){
                while (resultSet.next()) {
                }
            }
            connection2.commit();
            Assert.assertThrows(AbortedDueToConcurrentModificationException.class, () -> ((ITAbstractSpannerTest.ITConnection)connection1).commit());
        }
    }
}

