/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection.it;

import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.ParallelIntegrationTest;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.connection.ITAbstractSpannerTest;
import com.google.cloud.spanner.testing.EmulatorSpannerHelper;
import java.util.Arrays;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@Category(value={ParallelIntegrationTest.class})
@RunWith(value=JUnit4.class)
public class ITExplainTest
extends ITAbstractSpannerTest {
    @Override
    public void appendConnectionUri(StringBuilder uri) {
        uri.append(";autocommit=false");
    }

    @BeforeClass
    public static void setupPostgreSQL() {
        Assume.assumeFalse((String)"Emulator does not support PostgreSQL Dialect", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        database = env.getTestHelper().createTestDatabase(Dialect.POSTGRESQL, Collections.emptyList());
    }

    @Override
    @Before
    public void createTestTable() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            if (!this.tableExists(connection, "TEST")) {
                connection.setAutocommit(false);
                connection.startBatchDdl();
                connection.execute(Statement.of((String)"CREATE TABLE TEST (ID INT NOT NULL PRIMARY KEY, NAME VARCHAR(100) NOT NULL)"));
                connection.runBatch();
            }
        }
    }

    @Test
    public void testExplainStatement() {
        Assume.assumeFalse((String)"Emulator does not support PostgreSQL Dialect", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.bufferedWrite(Arrays.asList(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"TEST").set("ID").to(3L)).set("NAME").to("TEST-3")).build(), ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"TEST").set("ID").to(4L)).set("NAME").to("TEST-4")).build()));
            connection.commit();
            ResultSet resultSet = connection.execute(Statement.of((String)"EXPLAIN SELECT * from TEST")).getResultSet();
            while (resultSet.next()) {
                Assert.assertNotNull((Object)resultSet.getString("QUERY PLAN"));
            }
            Assert.assertEquals((long)1L, (long)resultSet.getColumnCount());
        }
    }

    @Test
    public void testExplainAnalyzeStatement() {
        Assume.assumeFalse((String)"Emulator does not support PostgreSQL Dialect", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.bufferedWrite(Arrays.asList(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"TEST").set("ID").to(1L)).set("NAME").to("TEST-1")).build(), ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"TEST").set("ID").to(2L)).set("NAME").to("TEST-2")).build()));
            connection.commit();
            ResultSet resultSet = connection.execute(Statement.of((String)"EXPLAIN ANALYZE SELECT * from TEST")).getResultSet();
            while (resultSet.next()) {
                Assert.assertNotNull((Object)resultSet.getString("QUERY PLAN"));
                Assert.assertNotNull((Object)resultSet.getString("EXECUTION STATS"));
            }
            Assert.assertEquals((long)2L, (long)resultSet.getColumnCount());
        }
    }
}

