/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.v1;

import com.google.api.client.http.HttpTransport;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.testing.MockHttpService;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiExceptionFactory;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.testing.FakeStatusCode;
import com.google.cloud.spanner.v1.SpannerClient;
import com.google.cloud.spanner.v1.SpannerSettings;
import com.google.cloud.spanner.v1.stub.HttpJsonSpannerStub;
import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import com.google.protobuf.Empty;
import com.google.protobuf.Struct;
import com.google.protobuf.Timestamp;
import com.google.rpc.Status;
import com.google.spanner.v1.BatchCreateSessionsResponse;
import com.google.spanner.v1.CommitResponse;
import com.google.spanner.v1.DatabaseName;
import com.google.spanner.v1.ExecuteBatchDmlRequest;
import com.google.spanner.v1.ExecuteBatchDmlResponse;
import com.google.spanner.v1.ExecuteSqlRequest;
import com.google.spanner.v1.KeySet;
import com.google.spanner.v1.ListSessionsResponse;
import com.google.spanner.v1.PartitionOptions;
import com.google.spanner.v1.PartitionQueryRequest;
import com.google.spanner.v1.PartitionReadRequest;
import com.google.spanner.v1.PartitionResponse;
import com.google.spanner.v1.ReadRequest;
import com.google.spanner.v1.RequestOptions;
import com.google.spanner.v1.ResultSet;
import com.google.spanner.v1.ResultSetMetadata;
import com.google.spanner.v1.ResultSetStats;
import com.google.spanner.v1.Session;
import com.google.spanner.v1.SessionName;
import com.google.spanner.v1.Transaction;
import com.google.spanner.v1.TransactionOptions;
import com.google.spanner.v1.TransactionSelector;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class SpannerClientHttpJsonTest {
    private static MockHttpService mockService;
    private static SpannerClient client;

    @BeforeClass
    public static void startStaticServer() throws IOException {
        mockService = new MockHttpService(HttpJsonSpannerStub.getMethodDescriptors(), SpannerSettings.getDefaultEndpoint());
        SpannerSettings settings = ((SpannerSettings.Builder)((SpannerSettings.Builder)SpannerSettings.newHttpJsonBuilder().setTransportChannelProvider((TransportChannelProvider)SpannerSettings.defaultHttpJsonTransportProviderBuilder().setHttpTransport((HttpTransport)mockService).build())).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        client = SpannerClient.create((SpannerSettings)settings);
    }

    @AfterClass
    public static void stopServer() {
        client.close();
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() throws Exception {
        mockService.reset();
    }

    @Test
    public void createSessionTest() throws Exception {
        Session expectedResponse = Session.newBuilder().setName(SessionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SESSION]").toString()).putAllLabels(new HashMap()).setCreateTime(Timestamp.newBuilder().build()).setApproximateLastUseTime(Timestamp.newBuilder().build()).setCreatorRole("creatorRole-190742846").build();
        mockService.addResponse((Object)expectedResponse);
        DatabaseName database = DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]");
        Session actualResponse = client.createSession(database);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createSessionExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            DatabaseName database = DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]");
            client.createSession(database);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createSessionTest2() throws Exception {
        Session expectedResponse = Session.newBuilder().setName(SessionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SESSION]").toString()).putAllLabels(new HashMap()).setCreateTime(Timestamp.newBuilder().build()).setApproximateLastUseTime(Timestamp.newBuilder().build()).setCreatorRole("creatorRole-190742846").build();
        mockService.addResponse((Object)expectedResponse);
        String database = "projects/project-3102/instances/instance-3102/databases/database-3102";
        Session actualResponse = client.createSession(database);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createSessionExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String database = "projects/project-3102/instances/instance-3102/databases/database-3102";
            client.createSession(database);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void batchCreateSessionsTest() throws Exception {
        BatchCreateSessionsResponse expectedResponse = BatchCreateSessionsResponse.newBuilder().addAllSession(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        DatabaseName database = DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]");
        int sessionCount = 185691686;
        BatchCreateSessionsResponse actualResponse = client.batchCreateSessions(database, sessionCount);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void batchCreateSessionsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            DatabaseName database = DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]");
            int sessionCount = 185691686;
            client.batchCreateSessions(database, sessionCount);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void batchCreateSessionsTest2() throws Exception {
        BatchCreateSessionsResponse expectedResponse = BatchCreateSessionsResponse.newBuilder().addAllSession(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        String database = "projects/project-3102/instances/instance-3102/databases/database-3102";
        int sessionCount = 185691686;
        BatchCreateSessionsResponse actualResponse = client.batchCreateSessions(database, sessionCount);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void batchCreateSessionsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String database = "projects/project-3102/instances/instance-3102/databases/database-3102";
            int sessionCount = 185691686;
            client.batchCreateSessions(database, sessionCount);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getSessionTest() throws Exception {
        Session expectedResponse = Session.newBuilder().setName(SessionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SESSION]").toString()).putAllLabels(new HashMap()).setCreateTime(Timestamp.newBuilder().build()).setApproximateLastUseTime(Timestamp.newBuilder().build()).setCreatorRole("creatorRole-190742846").build();
        mockService.addResponse((Object)expectedResponse);
        SessionName name = SessionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SESSION]");
        Session actualResponse = client.getSession(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getSessionExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SessionName name = SessionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SESSION]");
            client.getSession(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getSessionTest2() throws Exception {
        Session expectedResponse = Session.newBuilder().setName(SessionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SESSION]").toString()).putAllLabels(new HashMap()).setCreateTime(Timestamp.newBuilder().build()).setApproximateLastUseTime(Timestamp.newBuilder().build()).setCreatorRole("creatorRole-190742846").build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-199/instances/instance-199/databases/database-199/sessions/session-199";
        Session actualResponse = client.getSession(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getSessionExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-199/instances/instance-199/databases/database-199/sessions/session-199";
            client.getSession(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listSessionsTest() throws Exception {
        Session responsesElement = Session.newBuilder().build();
        ListSessionsResponse expectedResponse = ListSessionsResponse.newBuilder().setNextPageToken("").addAllSessions(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        DatabaseName database = DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]");
        SpannerClient.ListSessionsPagedResponse pagedListResponse = client.listSessions(database);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSessionsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listSessionsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            DatabaseName database = DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]");
            client.listSessions(database);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listSessionsTest2() throws Exception {
        Session responsesElement = Session.newBuilder().build();
        ListSessionsResponse expectedResponse = ListSessionsResponse.newBuilder().setNextPageToken("").addAllSessions(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String database = "projects/project-3102/instances/instance-3102/databases/database-3102";
        SpannerClient.ListSessionsPagedResponse pagedListResponse = client.listSessions(database);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSessionsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listSessionsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String database = "projects/project-3102/instances/instance-3102/databases/database-3102";
            client.listSessions(database);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteSessionTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        SessionName name = SessionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SESSION]");
        client.deleteSession(name);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteSessionExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SessionName name = SessionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SESSION]");
            client.deleteSession(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteSessionTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-199/instances/instance-199/databases/database-199/sessions/session-199";
        client.deleteSession(name);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteSessionExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-199/instances/instance-199/databases/database-199/sessions/session-199";
            client.deleteSession(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void executeSqlTest() throws Exception {
        ResultSet expectedResponse = ResultSet.newBuilder().setMetadata(ResultSetMetadata.newBuilder().build()).addAllRows(new ArrayList()).setStats(ResultSetStats.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        ExecuteSqlRequest request = ExecuteSqlRequest.newBuilder().setSession(SessionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SESSION]").toString()).setTransaction(TransactionSelector.newBuilder().build()).setSql("sql114126").setParams(Struct.newBuilder().build()).putAllParamTypes(new HashMap()).setResumeToken(ByteString.EMPTY).setPartitionToken(ByteString.EMPTY).setSeqno(109325920L).setQueryOptions(ExecuteSqlRequest.QueryOptions.newBuilder().build()).setRequestOptions(RequestOptions.newBuilder().build()).setDataBoostEnabled(true).build();
        ResultSet actualResponse = client.executeSql(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void executeSqlExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ExecuteSqlRequest request = ExecuteSqlRequest.newBuilder().setSession(SessionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SESSION]").toString()).setTransaction(TransactionSelector.newBuilder().build()).setSql("sql114126").setParams(Struct.newBuilder().build()).putAllParamTypes(new HashMap()).setResumeToken(ByteString.EMPTY).setPartitionToken(ByteString.EMPTY).setSeqno(109325920L).setQueryOptions(ExecuteSqlRequest.QueryOptions.newBuilder().build()).setRequestOptions(RequestOptions.newBuilder().build()).setDataBoostEnabled(true).build();
            client.executeSql(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void executeStreamingSqlTest() throws Exception {
    }

    @Test
    public void executeStreamingSqlExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
    }

    @Test
    public void executeBatchDmlTest() throws Exception {
        ExecuteBatchDmlResponse expectedResponse = ExecuteBatchDmlResponse.newBuilder().addAllResultSets(new ArrayList()).setStatus(Status.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        ExecuteBatchDmlRequest request = ExecuteBatchDmlRequest.newBuilder().setSession(SessionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SESSION]").toString()).setTransaction(TransactionSelector.newBuilder().build()).addAllStatements(new ArrayList()).setSeqno(109325920L).setRequestOptions(RequestOptions.newBuilder().build()).build();
        ExecuteBatchDmlResponse actualResponse = client.executeBatchDml(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void executeBatchDmlExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ExecuteBatchDmlRequest request = ExecuteBatchDmlRequest.newBuilder().setSession(SessionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SESSION]").toString()).setTransaction(TransactionSelector.newBuilder().build()).addAllStatements(new ArrayList()).setSeqno(109325920L).setRequestOptions(RequestOptions.newBuilder().build()).build();
            client.executeBatchDml(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void readTest() throws Exception {
        ResultSet expectedResponse = ResultSet.newBuilder().setMetadata(ResultSetMetadata.newBuilder().build()).addAllRows(new ArrayList()).setStats(ResultSetStats.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        ReadRequest request = ReadRequest.newBuilder().setSession(SessionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SESSION]").toString()).setTransaction(TransactionSelector.newBuilder().build()).setTable("table110115790").setIndex("index100346066").addAllColumns(new ArrayList()).setKeySet(KeySet.newBuilder().build()).setLimit(102976443L).setResumeToken(ByteString.EMPTY).setPartitionToken(ByteString.EMPTY).setRequestOptions(RequestOptions.newBuilder().build()).setDataBoostEnabled(true).build();
        ResultSet actualResponse = client.read(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void readExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ReadRequest request = ReadRequest.newBuilder().setSession(SessionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SESSION]").toString()).setTransaction(TransactionSelector.newBuilder().build()).setTable("table110115790").setIndex("index100346066").addAllColumns(new ArrayList()).setKeySet(KeySet.newBuilder().build()).setLimit(102976443L).setResumeToken(ByteString.EMPTY).setPartitionToken(ByteString.EMPTY).setRequestOptions(RequestOptions.newBuilder().build()).setDataBoostEnabled(true).build();
            client.read(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void streamingReadTest() throws Exception {
    }

    @Test
    public void streamingReadExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
    }

    @Test
    public void beginTransactionTest() throws Exception {
        Transaction expectedResponse = Transaction.newBuilder().setId(ByteString.EMPTY).setReadTimestamp(Timestamp.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        SessionName session = SessionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SESSION]");
        TransactionOptions options = TransactionOptions.newBuilder().build();
        Transaction actualResponse = client.beginTransaction(session, options);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void beginTransactionExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SessionName session = SessionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SESSION]");
            TransactionOptions options = TransactionOptions.newBuilder().build();
            client.beginTransaction(session, options);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void beginTransactionTest2() throws Exception {
        Transaction expectedResponse = Transaction.newBuilder().setId(ByteString.EMPTY).setReadTimestamp(Timestamp.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        String session = "projects/project-2078/instances/instance-2078/databases/database-2078/sessions/session-2078";
        TransactionOptions options = TransactionOptions.newBuilder().build();
        Transaction actualResponse = client.beginTransaction(session, options);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void beginTransactionExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String session = "projects/project-2078/instances/instance-2078/databases/database-2078/sessions/session-2078";
            TransactionOptions options = TransactionOptions.newBuilder().build();
            client.beginTransaction(session, options);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void commitTest() throws Exception {
        CommitResponse expectedResponse = CommitResponse.newBuilder().setCommitTimestamp(Timestamp.newBuilder().build()).setCommitStats(CommitResponse.CommitStats.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        SessionName session = SessionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SESSION]");
        ByteString transactionId = ByteString.EMPTY;
        ArrayList mutations = new ArrayList();
        CommitResponse actualResponse = client.commit(session, transactionId, mutations);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void commitExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SessionName session = SessionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SESSION]");
            ByteString transactionId = ByteString.EMPTY;
            ArrayList mutations = new ArrayList();
            client.commit(session, transactionId, mutations);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void commitTest2() throws Exception {
        CommitResponse expectedResponse = CommitResponse.newBuilder().setCommitTimestamp(Timestamp.newBuilder().build()).setCommitStats(CommitResponse.CommitStats.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        SessionName session = SessionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SESSION]");
        TransactionOptions singleUseTransaction = TransactionOptions.newBuilder().build();
        ArrayList mutations = new ArrayList();
        CommitResponse actualResponse = client.commit(session, singleUseTransaction, mutations);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void commitExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SessionName session = SessionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SESSION]");
            TransactionOptions singleUseTransaction = TransactionOptions.newBuilder().build();
            ArrayList mutations = new ArrayList();
            client.commit(session, singleUseTransaction, mutations);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void commitTest3() throws Exception {
        CommitResponse expectedResponse = CommitResponse.newBuilder().setCommitTimestamp(Timestamp.newBuilder().build()).setCommitStats(CommitResponse.CommitStats.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        String session = "projects/project-2078/instances/instance-2078/databases/database-2078/sessions/session-2078";
        ByteString transactionId = ByteString.EMPTY;
        ArrayList mutations = new ArrayList();
        CommitResponse actualResponse = client.commit(session, transactionId, mutations);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void commitExceptionTest3() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String session = "projects/project-2078/instances/instance-2078/databases/database-2078/sessions/session-2078";
            ByteString transactionId = ByteString.EMPTY;
            ArrayList mutations = new ArrayList();
            client.commit(session, transactionId, mutations);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void commitTest4() throws Exception {
        CommitResponse expectedResponse = CommitResponse.newBuilder().setCommitTimestamp(Timestamp.newBuilder().build()).setCommitStats(CommitResponse.CommitStats.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        String session = "projects/project-2078/instances/instance-2078/databases/database-2078/sessions/session-2078";
        TransactionOptions singleUseTransaction = TransactionOptions.newBuilder().build();
        ArrayList mutations = new ArrayList();
        CommitResponse actualResponse = client.commit(session, singleUseTransaction, mutations);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void commitExceptionTest4() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String session = "projects/project-2078/instances/instance-2078/databases/database-2078/sessions/session-2078";
            TransactionOptions singleUseTransaction = TransactionOptions.newBuilder().build();
            ArrayList mutations = new ArrayList();
            client.commit(session, singleUseTransaction, mutations);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void rollbackTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        SessionName session = SessionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SESSION]");
        ByteString transactionId = ByteString.EMPTY;
        client.rollback(session, transactionId);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void rollbackExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SessionName session = SessionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SESSION]");
            ByteString transactionId = ByteString.EMPTY;
            client.rollback(session, transactionId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void rollbackTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        String session = "projects/project-2078/instances/instance-2078/databases/database-2078/sessions/session-2078";
        ByteString transactionId = ByteString.EMPTY;
        client.rollback(session, transactionId);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void rollbackExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String session = "projects/project-2078/instances/instance-2078/databases/database-2078/sessions/session-2078";
            ByteString transactionId = ByteString.EMPTY;
            client.rollback(session, transactionId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void partitionQueryTest() throws Exception {
        PartitionResponse expectedResponse = PartitionResponse.newBuilder().addAllPartitions(new ArrayList()).setTransaction(Transaction.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        PartitionQueryRequest request = PartitionQueryRequest.newBuilder().setSession(SessionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SESSION]").toString()).setTransaction(TransactionSelector.newBuilder().build()).setSql("sql114126").setParams(Struct.newBuilder().build()).putAllParamTypes(new HashMap()).setPartitionOptions(PartitionOptions.newBuilder().build()).build();
        PartitionResponse actualResponse = client.partitionQuery(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void partitionQueryExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            PartitionQueryRequest request = PartitionQueryRequest.newBuilder().setSession(SessionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SESSION]").toString()).setTransaction(TransactionSelector.newBuilder().build()).setSql("sql114126").setParams(Struct.newBuilder().build()).putAllParamTypes(new HashMap()).setPartitionOptions(PartitionOptions.newBuilder().build()).build();
            client.partitionQuery(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void partitionReadTest() throws Exception {
        PartitionResponse expectedResponse = PartitionResponse.newBuilder().addAllPartitions(new ArrayList()).setTransaction(Transaction.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        PartitionReadRequest request = PartitionReadRequest.newBuilder().setSession(SessionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SESSION]").toString()).setTransaction(TransactionSelector.newBuilder().build()).setTable("table110115790").setIndex("index100346066").addAllColumns(new ArrayList()).setKeySet(KeySet.newBuilder().build()).setPartitionOptions(PartitionOptions.newBuilder().build()).build();
        PartitionResponse actualResponse = client.partitionRead(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void partitionReadExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            PartitionReadRequest request = PartitionReadRequest.newBuilder().setSession(SessionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SESSION]").toString()).setTransaction(TransactionSelector.newBuilder().build()).setTable("table110115790").setIndex("index100346066").addAllColumns(new ArrayList()).setKeySet(KeySet.newBuilder().build()).setPartitionOptions(PartitionOptions.newBuilder().build()).build();
            client.partitionRead(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

