/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.ApiFutures;
import com.google.cloud.grpc.GrpcTransportOptions;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.SessionClient;
import com.google.cloud.spanner.SessionImpl;
import com.google.cloud.spanner.SessionPoolOptions;
import com.google.cloud.spanner.SpannerBatchUpdateException;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.SpannerImpl;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TransactionRunnerImpl;
import com.google.cloud.spanner.spi.v1.SpannerRpc;
import com.google.common.base.Preconditions;
import com.google.common.truth.Truth;
import com.google.protobuf.ByteString;
import com.google.protobuf.Duration;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import com.google.rpc.RetryInfo;
import com.google.spanner.v1.BeginTransactionRequest;
import com.google.spanner.v1.CommitRequest;
import com.google.spanner.v1.CommitResponse;
import com.google.spanner.v1.ExecuteBatchDmlRequest;
import com.google.spanner.v1.ExecuteBatchDmlResponse;
import com.google.spanner.v1.ExecuteSqlRequest;
import com.google.spanner.v1.ResultSet;
import com.google.spanner.v1.ResultSetMetadata;
import com.google.spanner.v1.ResultSetStats;
import com.google.spanner.v1.RollbackRequest;
import com.google.spanner.v1.Session;
import com.google.spanner.v1.Transaction;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.protobuf.ProtoUtils;
import io.opencensus.trace.Span;
import java.util.Arrays;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public class TransactionRunnerImplTest {
    @Mock
    private SpannerRpc rpc;
    @Mock
    private SessionImpl session;
    @Mock
    private TransactionRunnerImpl.TransactionContextImpl txn;
    private TransactionRunnerImpl transactionRunner;
    private boolean firstRun;
    private boolean usedInlinedBegin;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.firstRun = true;
        Mockito.when((Object)this.session.newTransaction(Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[0]))).thenReturn((Object)this.txn);
        Mockito.when((Object)this.rpc.executeQuery((ExecuteSqlRequest)Mockito.any(ExecuteSqlRequest.class), Mockito.anyMap(), Mockito.eq((boolean)true))).thenAnswer(invocation -> {
            ResultSet.Builder builder = ResultSet.newBuilder().setStats(ResultSetStats.newBuilder().setRowCountExact(1L).build());
            ExecuteSqlRequest request = (ExecuteSqlRequest)invocation.getArgument(0, ExecuteSqlRequest.class);
            if (request.getTransaction().hasBegin() && request.getTransaction().getBegin().hasReadWrite()) {
                builder.setMetadata(ResultSetMetadata.newBuilder().setTransaction(Transaction.newBuilder().setId(ByteString.copyFromUtf8((String)"test"))).build());
                this.usedInlinedBegin = true;
            }
            return builder.build();
        });
        this.transactionRunner = new TransactionRunnerImpl(this.session, new Options.TransactionOption[0]);
        Mockito.when((Object)this.rpc.commitAsync((CommitRequest)Mockito.any(CommitRequest.class), Mockito.anyMap())).thenReturn((Object)ApiFutures.immediateFuture((Object)CommitResponse.newBuilder().setCommitTimestamp(Timestamp.getDefaultInstance()).build()));
        Mockito.when((Object)this.rpc.rollbackAsync((RollbackRequest)Mockito.any(RollbackRequest.class), Mockito.anyMap())).thenReturn((Object)ApiFutures.immediateFuture((Object)Empty.getDefaultInstance()));
        this.transactionRunner.setSpan((Span)Mockito.mock(Span.class));
    }

    @Test
    public void usesPreparedTransaction() {
        SpannerOptions options = (SpannerOptions)Mockito.mock(SpannerOptions.class);
        Mockito.when((Object)options.getNumChannels()).thenReturn((Object)4);
        GrpcTransportOptions transportOptions = (GrpcTransportOptions)Mockito.mock(GrpcTransportOptions.class);
        Mockito.when((Object)transportOptions.getExecutorFactory()).thenReturn((Object)new TestExecutorFactory());
        Mockito.when((Object)options.getTransportOptions()).thenReturn((Object)transportOptions);
        SessionPoolOptions sessionPoolOptions = SessionPoolOptions.newBuilder().setMinSessions(0).setIncStep(1).build();
        Mockito.when((Object)options.getSessionPoolOptions()).thenReturn((Object)sessionPoolOptions);
        Mockito.when((Object)options.getSessionLabels()).thenReturn(Collections.emptyMap());
        Mockito.when((Object)options.getDatabaseRole()).thenReturn((Object)"role");
        SpannerRpc rpc = (SpannerRpc)Mockito.mock(SpannerRpc.class);
        Mockito.when((Object)rpc.asyncDeleteSession(Mockito.anyString(), Mockito.anyMap())).thenReturn((Object)ApiFutures.immediateFuture((Object)Empty.getDefaultInstance()));
        Mockito.when((Object)rpc.batchCreateSessions(Mockito.anyString(), Mockito.eq((int)1), Mockito.anyString(), Mockito.anyMap(), Mockito.anyMap())).thenAnswer(invocation -> Collections.singletonList(Session.newBuilder().setName(invocation.getArguments()[0] + "/sessions/1").setCreateTime(Timestamp.newBuilder().setSeconds(System.currentTimeMillis() * 1000L)).build()));
        Mockito.when((Object)rpc.beginTransactionAsync((BeginTransactionRequest)Mockito.any(BeginTransactionRequest.class), Mockito.anyMap(), Mockito.eq((boolean)true))).thenAnswer(invocation -> ApiFutures.immediateFuture((Object)Transaction.newBuilder().setId(ByteString.copyFromUtf8((String)UUID.randomUUID().toString())).build()));
        Mockito.when((Object)rpc.commitAsync((CommitRequest)Mockito.any(CommitRequest.class), Mockito.anyMap())).thenAnswer(invocation -> ApiFutures.immediateFuture((Object)CommitResponse.newBuilder().setCommitTimestamp(Timestamp.newBuilder().setSeconds(System.currentTimeMillis() * 1000L)).build()));
        DatabaseId db = DatabaseId.of((String)"test", (String)"test", (String)"test");
        try (SpannerImpl spanner = new SpannerImpl(rpc, options);){
            DatabaseClient client = spanner.getDatabaseClient(db);
            client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> null);
            ((SpannerRpc)Mockito.verify((Object)rpc, (VerificationMode)Mockito.times((int)1))).beginTransactionAsync((BeginTransactionRequest)Mockito.any(BeginTransactionRequest.class), Mockito.anyMap(), Mockito.eq((boolean)true));
        }
    }

    @Test
    public void commitSucceeds() {
        AtomicInteger numCalls = new AtomicInteger(0);
        this.transactionRunner.run(transaction -> {
            numCalls.incrementAndGet();
            return null;
        });
        Truth.assertThat((Integer)numCalls.get()).isEqualTo((Object)1);
        ((TransactionRunnerImpl.TransactionContextImpl)Mockito.verify((Object)this.txn, (VerificationMode)Mockito.never())).ensureTxn();
        ((TransactionRunnerImpl.TransactionContextImpl)Mockito.verify((Object)this.txn)).commit();
    }

    @Test
    public void runAbort() {
        Mockito.when((Object)this.txn.isAborted()).thenReturn((Object)true);
        this.runTransaction((Exception)((Object)this.abortedWithRetryInfo()));
        ((TransactionRunnerImpl.TransactionContextImpl)Mockito.verify((Object)this.txn)).ensureTxn();
    }

    @Test
    public void commitAbort() {
        SpannerException error = SpannerExceptionFactory.newSpannerException((Throwable)this.abortedWithRetryInfo());
        ((TransactionRunnerImpl.TransactionContextImpl)Mockito.doThrow((Throwable[])new Throwable[]{error}).doNothing().when((Object)this.txn)).commit();
        AtomicInteger numCalls = new AtomicInteger(0);
        this.transactionRunner.run(transaction -> {
            numCalls.incrementAndGet();
            return null;
        });
        Truth.assertThat((Integer)numCalls.get()).isEqualTo((Object)2);
        ((TransactionRunnerImpl.TransactionContextImpl)Mockito.verify((Object)this.txn)).ensureTxn();
    }

    @Test
    public void commitFailsWithNonAbort() {
        SpannerException error = SpannerExceptionFactory.newSpannerException((Throwable)SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.UNKNOWN, (String)""));
        ((TransactionRunnerImpl.TransactionContextImpl)Mockito.doThrow((Throwable[])new Throwable[]{error}).when((Object)this.txn)).commit();
        AtomicInteger numCalls = new AtomicInteger(0);
        SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> this.transactionRunner.run(transaction -> numCalls.incrementAndGet()));
        Assert.assertEquals((Object)ErrorCode.UNKNOWN, (Object)e.getErrorCode());
        Assert.assertEquals((long)1L, (long)numCalls.get());
        ((TransactionRunnerImpl.TransactionContextImpl)Mockito.verify((Object)this.txn, (VerificationMode)Mockito.never())).ensureTxn();
        ((TransactionRunnerImpl.TransactionContextImpl)Mockito.verify((Object)this.txn, (VerificationMode)Mockito.times((int)1))).commit();
    }

    @Test
    public void runResourceExhaustedNoRetry() {
        Assert.assertThrows(SpannerException.class, () -> this.runTransaction((Exception)((Object)new StatusRuntimeException(Status.fromCodeValue((int)Status.Code.RESOURCE_EXHAUSTED.value())))));
        ((TransactionRunnerImpl.TransactionContextImpl)Mockito.verify((Object)this.txn)).rollback();
    }

    @Test
    public void batchDmlAborted() {
        long[] updateCount = this.batchDmlException(10);
        Truth.assertThat((Integer)updateCount.length).isEqualTo((Object)2);
        Truth.assertThat((Long)updateCount[0]).isEqualTo((Object)1L);
        Truth.assertThat((Long)updateCount[1]).isEqualTo((Object)1L);
    }

    @Test
    public void batchDmlFailedPrecondition() {
        SpannerBatchUpdateException e = (SpannerBatchUpdateException)Assert.assertThrows(SpannerBatchUpdateException.class, () -> this.batchDmlException(9));
        Assert.assertArrayEquals((long[])new long[]{1L}, (long[])e.getUpdateCounts());
        Assert.assertEquals((long)9L, (long)e.getCode());
    }

    @Test
    public void inlineBegin() {
        SpannerImpl spanner = (SpannerImpl)Mockito.mock(SpannerImpl.class);
        Mockito.when((Object)spanner.getRpc()).thenReturn((Object)this.rpc);
        Mockito.when((Object)spanner.getDefaultQueryOptions((DatabaseId)Mockito.any(DatabaseId.class))).thenReturn((Object)ExecuteSqlRequest.QueryOptions.getDefaultInstance());
        Mockito.when((Object)((SpannerOptions)spanner.getOptions())).thenReturn((Object)((SpannerOptions)Mockito.mock(SpannerOptions.class)));
        SessionImpl session = new SessionImpl(spanner, "projects/p/instances/i/databases/d/sessions/s", Collections.EMPTY_MAP){

            public void prepareReadWriteTransaction() {
                throw new IllegalStateException();
            }
        };
        session.setCurrentSpan((Span)Mockito.mock(Span.class));
        TransactionRunnerImpl runner = new TransactionRunnerImpl(session, new Options.TransactionOption[0]);
        runner.setSpan((Span)Mockito.mock(Span.class));
        Truth.assertThat((Boolean)this.usedInlinedBegin).isFalse();
        runner.run(transaction -> {
            transaction.executeUpdate(Statement.of((String)"UPDATE FOO SET BAR=1 WHERE BAZ=2"), new Options.UpdateOption[0]);
            return null;
        });
        ((SpannerRpc)Mockito.verify((Object)this.rpc, (VerificationMode)Mockito.never())).beginTransaction((BeginTransactionRequest)Mockito.any(BeginTransactionRequest.class), Mockito.anyMap(), Mockito.eq((boolean)true));
        ((SpannerRpc)Mockito.verify((Object)this.rpc, (VerificationMode)Mockito.never())).beginTransactionAsync((BeginTransactionRequest)Mockito.any(BeginTransactionRequest.class), Mockito.anyMap(), Mockito.eq((boolean)true));
        Truth.assertThat((Boolean)this.usedInlinedBegin).isTrue();
    }

    private long[] batchDmlException(int status) {
        Preconditions.checkArgument((status != 0 ? 1 : 0) != 0);
        TransactionRunnerImpl.TransactionContextImpl transaction = ((TransactionRunnerImpl.TransactionContextImpl.Builder)((TransactionRunnerImpl.TransactionContextImpl.Builder)TransactionRunnerImpl.TransactionContextImpl.newBuilder().setSession(this.session)).setTransactionId(ByteString.copyFromUtf8((String)UUID.randomUUID().toString())).setOptions(Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[0])).setRpc(this.rpc)).build();
        Mockito.when((Object)this.session.newTransaction(Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[0]))).thenReturn((Object)transaction);
        Mockito.when((Object)this.session.beginTransactionAsync(true)).thenReturn((Object)ApiFutures.immediateFuture((Object)ByteString.copyFromUtf8((String)UUID.randomUUID().toString())));
        Mockito.when((Object)this.session.getName()).thenReturn((Object)SessionClient.SessionId.of((String)"p", (String)"i", (String)"d", (String)"test").getName());
        TransactionRunnerImpl runner = new TransactionRunnerImpl(this.session, new Options.TransactionOption[0]);
        runner.setSpan((Span)Mockito.mock(Span.class));
        ExecuteBatchDmlResponse response1 = ExecuteBatchDmlResponse.newBuilder().addResultSets(ResultSet.newBuilder().setStats(ResultSetStats.newBuilder().setRowCountExact(1L)).build()).setStatus(com.google.rpc.Status.newBuilder().setCode(status).build()).build();
        ExecuteBatchDmlResponse response2 = ExecuteBatchDmlResponse.newBuilder().addResultSets(ResultSet.newBuilder().setStats(ResultSetStats.newBuilder().setRowCountExact(1L)).build()).addResultSets(ResultSet.newBuilder().setStats(ResultSetStats.newBuilder().setRowCountExact(1L)).build()).setStatus(com.google.rpc.Status.newBuilder().setCode(0).build()).build();
        Mockito.when((Object)this.rpc.executeBatchDml((ExecuteBatchDmlRequest)Mockito.any(ExecuteBatchDmlRequest.class), Mockito.anyMap())).thenReturn((Object)response1, (Object[])new ExecuteBatchDmlResponse[]{response2});
        CommitResponse commitResponse = CommitResponse.newBuilder().setCommitTimestamp(Timestamp.getDefaultInstance()).build();
        Mockito.when((Object)this.rpc.commitAsync((CommitRequest)Mockito.any(CommitRequest.class), Mockito.anyMap())).thenReturn((Object)ApiFutures.immediateFuture((Object)commitResponse));
        Statement statement = Statement.of((String)"UPDATE FOO SET BAR=1");
        AtomicInteger numCalls = new AtomicInteger(0);
        long[] updateCount = (long[])runner.run(transaction1 -> {
            numCalls.incrementAndGet();
            return transaction1.batchUpdate(Arrays.asList(statement, statement), new Options.UpdateOption[0]);
        });
        if (status == 10) {
            Truth.assertThat((Integer)numCalls.get()).isEqualTo((Object)2);
        }
        return updateCount;
    }

    private void runTransaction(Exception exception) {
        this.transactionRunner.run(transaction -> {
            if (this.firstRun) {
                this.firstRun = false;
                throw SpannerExceptionFactory.newSpannerException((Throwable)exception);
            }
            return null;
        });
    }

    private SpannerException abortedWithRetryInfo() {
        Status status = Status.fromCodeValue((int)Status.Code.ABORTED.value());
        return SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.ABORTED, (String)"test", (Throwable)new StatusRuntimeException(status, this.createRetryTrailers()));
    }

    private Metadata createRetryTrailers() {
        Metadata.Key key = ProtoUtils.keyForProto((Message)RetryInfo.getDefaultInstance());
        Metadata trailers = new Metadata();
        RetryInfo retryInfo = RetryInfo.newBuilder().setRetryDelay(Duration.newBuilder().setNanos(0).setSeconds(0L)).build();
        trailers.put(key, (Object)retryInfo);
        return trailers;
    }

    private static final class TestExecutorFactory
    implements GrpcTransportOptions.ExecutorFactory<ScheduledExecutorService> {
        private TestExecutorFactory() {
        }

        public ScheduledExecutorService get() {
            return Executors.newSingleThreadScheduledExecutor();
        }

        public void release(ScheduledExecutorService exec) {
            exec.shutdown();
        }
    }
}

