/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.ByteArray;
import com.google.cloud.Date;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.Value;
import com.google.cloud.spanner.ValueBinder;
import com.google.common.truth.Truth;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ValueBinderTest {
    private static final String JSON_METHOD_NAME = "json";
    private static final String PG_JSONB_METHOD_NAME = "pgJsonb";
    private static final String PG_NUMERIC_METHOD_NAME = "pgNumeric";
    private static final String BYTES_BASE64_METHOD_NAME = "bytesFromBase64";
    public static final String DEFAULT_PG_NUMERIC = "1.23";
    private Value lastValue;
    private int lastReturnValue;
    private ValueBinder<Integer> binder = new BinderImpl();

    @Test
    public void reflection() throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        for (Method method : Value.class.getMethods()) {
            if (!Modifier.isStatic(method.getModifiers()) || !method.getReturnType().equals(Value.class) || method.getParameterTypes().length > 0 && method.getParameterTypes()[0].equals(com.google.protobuf.Value.class)) continue;
            Method binderMethod = ValueBinderTest.findBinderMethod(method);
            Truth.assertWithMessage((String)("Binder for " + method.toString())).that((Object)binderMethod).isNotNull();
            if (method.getName().toLowerCase().contains("struct")) {
                Value expected;
                Struct struct = ((Struct.Builder)Struct.newBuilder().set("f1").to("abc")).build();
                Type structType = struct.getType();
                if (binderMethod.getName().equals("toStructArray")) {
                    Truth.assertThat((Object[])binderMethod.getParameterTypes()).hasLength(2);
                    expected = (Value)method.invoke(Value.class, structType, Collections.singletonList(struct));
                    Truth.assertThat((Object)binderMethod.invoke(this.binder, structType, Collections.singletonList(struct))).isEqualTo((Object)this.lastReturnValue);
                    Truth.assertThat((Object)this.lastValue).isEqualTo((Object)expected);
                    Truth.assertThat((Integer)((Integer)this.binder.to(expected))).isEqualTo((Object)this.lastReturnValue);
                    Truth.assertThat((Object)this.lastValue).isEqualTo((Object)expected);
                    Value expectedNull = (Value)method.invoke(Value.class, structType, null);
                    Truth.assertThat((Object)binderMethod.invoke(this.binder, structType, null)).isEqualTo((Object)this.lastReturnValue);
                    Truth.assertThat((Object)this.lastValue).isEqualTo((Object)expectedNull);
                    Truth.assertThat((Integer)((Integer)this.binder.to(expectedNull))).isEqualTo((Object)this.lastReturnValue);
                    Truth.assertThat((Object)this.lastValue).isEqualTo((Object)expectedNull);
                    continue;
                }
                if (binderMethod.getParameterTypes().length == 2) {
                    Truth.assertThat(binderMethod.getParameterTypes()[0]).isEqualTo(Type.class);
                    Truth.assertThat(binderMethod.getParameterTypes()[1]).isEqualTo(Struct.class);
                    Value expectedNull = (Value)method.invoke(Value.class, structType, null);
                    Truth.assertThat((Object)binderMethod.invoke(this.binder, structType, null)).isEqualTo((Object)this.lastReturnValue);
                    Truth.assertThat((Object)this.lastValue).isEqualTo((Object)expectedNull);
                    Truth.assertThat((Integer)((Integer)this.binder.to(expectedNull))).isEqualTo((Object)this.lastReturnValue);
                    Truth.assertThat((Object)this.lastValue).isEqualTo((Object)expectedNull);
                    continue;
                }
                Truth.assertThat((Object[])binderMethod.getParameterTypes()).hasLength(1);
                Truth.assertThat(binderMethod.getParameterTypes()[0]).isEqualTo(Struct.class);
                expected = (Value)method.invoke(Value.class, struct);
                Truth.assertThat((Object)binderMethod.invoke(this.binder, struct)).isEqualTo((Object)this.lastReturnValue);
                Truth.assertThat((Object)this.lastValue).isEqualTo((Object)expected);
                Truth.assertThat((Integer)((Integer)this.binder.to(expected))).isEqualTo((Object)this.lastReturnValue);
                Truth.assertThat((Object)this.lastValue).isEqualTo((Object)expected);
                continue;
            }
            if (binderMethod.getParameterTypes().length == 1) {
                Object defaultObject;
                if (!binderMethod.getParameterTypes()[0].isPrimitive()) {
                    if (method.getName().equalsIgnoreCase(JSON_METHOD_NAME)) {
                        binderMethod = ValueBinder.class.getMethod("to", Value.class);
                        Truth.assertThat((Object)binderMethod.invoke(this.binder, Value.json(null))).isEqualTo((Object)this.lastReturnValue);
                    } else if (method.getName().equalsIgnoreCase(PG_JSONB_METHOD_NAME)) {
                        binderMethod = ValueBinder.class.getMethod("to", Value.class);
                        Truth.assertThat((Object)binderMethod.invoke(this.binder, Value.pgJsonb(null))).isEqualTo((Object)this.lastReturnValue);
                    } else if (method.getName().equalsIgnoreCase(PG_NUMERIC_METHOD_NAME)) {
                        binderMethod = ValueBinder.class.getMethod("to", Value.class);
                        Truth.assertThat((Object)binderMethod.invoke(this.binder, Value.pgNumeric(null))).isEqualTo((Object)this.lastReturnValue);
                    } else if (method.getName().equalsIgnoreCase(BYTES_BASE64_METHOD_NAME)) {
                        binderMethod = ValueBinder.class.getMethod("to", Value.class);
                        Truth.assertThat((Object)binderMethod.invoke(this.binder, Value.bytesFromBase64(null))).isEqualTo((Object)this.lastReturnValue);
                    } else {
                        Truth.assertThat((Object)binderMethod.invoke(this.binder, new Object[]{null})).isEqualTo((Object)this.lastReturnValue);
                    }
                    Value expected = (Value)method.invoke(Value.class, new Object[]{null});
                    Truth.assertThat((Object)this.lastValue).isEqualTo((Object)expected);
                    Truth.assertThat((Integer)((Integer)this.binder.to(expected))).isEqualTo((Object)this.lastReturnValue);
                    Truth.assertThat((Object)this.lastValue).isEqualTo((Object)expected);
                }
                if (method.getName().equalsIgnoreCase(JSON_METHOD_NAME)) {
                    defaultObject = DefaultValues.defaultJson();
                    binderMethod = ValueBinder.class.getMethod("to", Value.class);
                    Truth.assertThat((Object)binderMethod.invoke(this.binder, Value.json((String)DefaultValues.defaultJson()))).isEqualTo((Object)this.lastReturnValue);
                } else if (method.getName().equalsIgnoreCase(PG_JSONB_METHOD_NAME)) {
                    defaultObject = DefaultValues.defaultPgJsonb();
                    binderMethod = ValueBinder.class.getMethod("to", Value.class);
                    Truth.assertThat((Object)binderMethod.invoke(this.binder, Value.pgJsonb((String)DefaultValues.defaultPgJsonb()))).isEqualTo((Object)this.lastReturnValue);
                } else if (method.getName().equalsIgnoreCase(PG_NUMERIC_METHOD_NAME)) {
                    defaultObject = DEFAULT_PG_NUMERIC;
                    binderMethod = ValueBinder.class.getMethod("to", Value.class);
                    Truth.assertThat((Object)binderMethod.invoke(this.binder, Value.pgNumeric((String)DEFAULT_PG_NUMERIC))).isEqualTo((Object)this.lastReturnValue);
                } else if (method.getName().equalsIgnoreCase(BYTES_BASE64_METHOD_NAME)) {
                    defaultObject = DefaultValues.defaultBytesBase64();
                    binderMethod = ValueBinder.class.getMethod("to", Value.class);
                    Truth.assertThat((Object)binderMethod.invoke(this.binder, Value.bytesFromBase64((String)DefaultValues.defaultBytesBase64()))).isEqualTo((Object)this.lastReturnValue);
                } else {
                    defaultObject = DefaultValues.getDefault(method.getGenericParameterTypes()[0]);
                    Truth.assertThat((Object)binderMethod.invoke(this.binder, defaultObject)).isEqualTo((Object)this.lastReturnValue);
                }
                Value expected = (Value)method.invoke(Value.class, defaultObject);
                Truth.assertThat((Object)this.lastValue).isEqualTo((Object)expected);
                Truth.assertThat((Integer)((Integer)this.binder.to(expected))).isEqualTo((Object)this.lastReturnValue);
                Truth.assertThat((Object)this.lastValue).isEqualTo((Object)expected);
                continue;
            }
            Truth.assertThat((Integer)binderMethod.getParameterTypes().length).isEqualTo((Object)3);
            Truth.assertThat(binderMethod.getParameterTypes()[1]).isEqualTo(Integer.TYPE);
            Truth.assertThat(binderMethod.getParameterTypes()[2]).isEqualTo(Integer.TYPE);
            Value expectedNull = (Value)method.invoke(Value.class, null, -1, -1);
            Truth.assertThat((Object)binderMethod.invoke(this.binder, null, 0, 0)).isEqualTo((Object)this.lastReturnValue);
            Truth.assertThat((Object)this.lastValue).isEqualTo((Object)expectedNull);
            Object defaultObject = DefaultValues.getDefault(method.getGenericParameterTypes()[0]);
            Value expectedNonNull = (Value)method.invoke(Value.class, defaultObject, 0, 2);
            Truth.assertThat((Object)binderMethod.invoke(this.binder, defaultObject, 0, 2)).isEqualTo((Object)this.lastReturnValue);
            Truth.assertThat((Object)this.lastValue).isEqualTo((Object)expectedNonNull);
        }
    }

    static Method findBinderMethod(Method valueMethod) {
        String name = valueMethod.getName().contains("Array") ? "to" + valueMethod.getName().substring(0, 1).toUpperCase() + valueMethod.getName().substring(1) : "to";
        try {
            return ValueBinder.class.getMethod(name, valueMethod.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private class BinderImpl
    extends ValueBinder<Integer> {
        private BinderImpl() {
        }

        Integer handle(Value value) {
            ValueBinderTest.this.lastValue = value;
            return ++ValueBinderTest.this.lastReturnValue;
        }
    }

    static class DefaultValues {
        DefaultValues() {
        }

        public static boolean defaultBooleanPrimitive() {
            return true;
        }

        public static Boolean defaultBooleanWrapper() {
            return true;
        }

        public static long defaultLongPrimitive() {
            return 1234L;
        }

        public static Long defaultLongWrapper() {
            return 1234L;
        }

        public static double defaultDoublePrimitive() {
            return 1.0;
        }

        public static Double defaultDoubleWrapper() {
            return 1.0;
        }

        public static BigDecimal defaultBigDecimal() {
            return BigDecimal.valueOf(123L, 2);
        }

        public static String defaultString() {
            return "x";
        }

        public static String defaultJson() {
            return "{\"color\":\"red\",\"value\":\"#f00\"}";
        }

        public static String defaultPgJsonb() {
            return "{\"color\":\"red\",\"value\":\"#f00\"}";
        }

        public static String defaultBytesBase64() {
            return Base64.getEncoder().encodeToString("test-bytes".getBytes(StandardCharsets.UTF_8));
        }

        public static ByteArray defaultByteArray() {
            return ByteArray.copyFrom((byte[])new byte[]{120});
        }

        public static Timestamp defaultTimestamp() {
            return Timestamp.ofTimeSecondsAndNanos((long)0L, (int)0);
        }

        public static Date defaultDate() {
            return Date.fromYearMonthDay((int)2016, (int)9, (int)15);
        }

        public static boolean[] defaultBooleanArray() {
            return new boolean[]{false, true};
        }

        public static Iterable<Boolean> defaultBooleanIterable() {
            return Arrays.asList(false, true);
        }

        public static long[] defaultLongArray() {
            return new long[]{1L, 2L};
        }

        public static Iterable<Long> defaultLongIterable() {
            return Arrays.asList(1L, 2L);
        }

        public static double[] defaultDoubleArray() {
            return new double[]{1.0, 2.0};
        }

        public static Iterable<Double> defaultDoubleIterable() {
            return Arrays.asList(1.0, 2.0);
        }

        public static Iterable<BigDecimal> defaultBigDecimalIterable() {
            return Arrays.asList(BigDecimal.valueOf(123L, 2), BigDecimal.valueOf(456L, 2));
        }

        public static Iterable<String> defaultStringIterable() {
            return Arrays.asList("a", "b");
        }

        public static Iterable<String> defaultJsonIterable() {
            return Arrays.asList("{}", "[]", "{\"color\":\"red\",\"value\":\"#f00\"}");
        }

        public static Iterable<ByteArray> defaultByteArrayIterable() {
            return Arrays.asList(ByteArray.copyFrom((String)"x"), ByteArray.copyFrom((String)"y"));
        }

        public static Iterable<Timestamp> defaultTimestampIterable() {
            return Arrays.asList(Timestamp.ofTimeSecondsAndNanos((long)0L, (int)0), Timestamp.ofTimeSecondsAndNanos((long)0L, (int)1));
        }

        public static Iterable<Date> defaultDateIterable() {
            return Arrays.asList(Date.fromYearMonthDay((int)2016, (int)9, (int)15), Date.fromYearMonthDay((int)2016, (int)9, (int)14));
        }

        static Object getDefault(java.lang.reflect.Type type) throws InvocationTargetException, IllegalAccessException {
            for (Method method : DefaultValues.class.getMethods()) {
                if (!method.getName().startsWith("default") || !Modifier.isStatic(method.getModifiers()) || !method.getGenericReturnType().equals(type)) continue;
                return method.invoke(DefaultValues.class, new Object[0]);
            }
            throw new AssertionError((Object)("Could not find default value for " + type));
        }
    }
}

