/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.BatchClient;
import com.google.cloud.spanner.BatchReadOnlyTransaction;
import com.google.cloud.spanner.BatchTransactionId;
import com.google.cloud.spanner.CommitResponse;
import com.google.cloud.spanner.CommitStats;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.ForwardingResultSet;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.TransactionContext;
import com.google.cloud.spanner.TransactionManager;
import com.google.cloud.spanner.TransactionRunner;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.connection.AbstractConnectionImplTest;
import com.google.cloud.spanner.connection.AbstractStatementParser;
import com.google.cloud.spanner.connection.AnalyzeMode;
import com.google.cloud.spanner.connection.AutocommitDmlMode;
import com.google.cloud.spanner.connection.Connection;
import com.google.cloud.spanner.connection.ConnectionImpl;
import com.google.cloud.spanner.connection.ConnectionOptions;
import com.google.cloud.spanner.connection.ConnectionStatementExecutorImpl;
import com.google.cloud.spanner.connection.DdlClient;
import com.google.cloud.spanner.connection.ReadOnlyStalenessUtil;
import com.google.cloud.spanner.connection.SpannerPool;
import com.google.cloud.spanner.connection.StatementResult;
import com.google.cloud.spanner.connection.TransactionMode;
import com.google.cloud.spanner.connection.TransactionRetryListener;
import com.google.cloud.spanner.connection.UnitOfWork;
import com.google.common.collect.ImmutableSet;
import com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata;
import com.google.spanner.v1.ExecuteSqlRequest;
import com.google.spanner.v1.ResultSetStats;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

@RunWith(value=JUnit4.class)
public class ConnectionImplTest {
    public static final String URI = "cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database";

    private static ResultSet createSelect1MockResultSet() {
        ResultSet mockResultSet = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)mockResultSet.next()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Mockito.when((Object)mockResultSet.getLong(0)).thenReturn((Object)1L);
        Mockito.when((Object)mockResultSet.getLong("TEST")).thenReturn((Object)1L);
        Mockito.when((Object)mockResultSet.getColumnType(0)).thenReturn((Object)Type.int64());
        Mockito.when((Object)mockResultSet.getColumnType("TEST")).thenReturn((Object)Type.int64());
        return mockResultSet;
    }

    private static DdlClient createDefaultMockDdlClient() {
        try {
            DdlClient ddlClient = (DdlClient)Mockito.mock(DdlClient.class);
            OperationFuture operation = (OperationFuture)Mockito.mock(OperationFuture.class);
            Mockito.when((Object)((Void)operation.get())).thenReturn(null);
            UpdateDatabaseDdlMetadata metadata = UpdateDatabaseDdlMetadata.getDefaultInstance();
            ApiFuture futureMetadata = ApiFutures.immediateFuture((Object)metadata);
            Mockito.when((Object)operation.getMetadata()).thenReturn((Object)futureMetadata);
            Mockito.when((Object)ddlClient.executeDdl(Mockito.anyString())).thenCallRealMethod();
            Mockito.when((Object)ddlClient.executeDdl(Mockito.anyList())).thenReturn((Object)operation);
            return ddlClient;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static ConnectionImpl createConnection(ConnectionOptions options) {
        return ConnectionImplTest.createConnection(options, Dialect.GOOGLE_STANDARD_SQL);
    }

    public static ConnectionImpl createConnection(ConnectionOptions options, Dialect dialect) {
        Spanner spanner = (Spanner)Mockito.mock(Spanner.class);
        SpannerPool spannerPool = (SpannerPool)Mockito.mock(SpannerPool.class);
        Mockito.when((Object)spannerPool.getSpanner((ConnectionOptions)Mockito.any(ConnectionOptions.class), (ConnectionImpl)Mockito.any(ConnectionImpl.class))).thenReturn((Object)spanner);
        DdlClient ddlClient = ConnectionImplTest.createDefaultMockDdlClient();
        DatabaseClient dbClient = (DatabaseClient)Mockito.mock(DatabaseClient.class);
        Mockito.when((Object)dbClient.getDialect()).thenReturn((Object)dialect);
        ReadOnlyTransaction singleUseReadOnlyTx = (ReadOnlyTransaction)Mockito.mock(ReadOnlyTransaction.class);
        ResultSet mockResultSetWithStats = ConnectionImplTest.createSelect1MockResultSet();
        Mockito.when((Object)mockResultSetWithStats.getStats()).thenReturn((Object)ResultSetStats.getDefaultInstance());
        SimpleResultSet select1ResultSet = new SimpleResultSet(ConnectionImplTest.createSelect1MockResultSet());
        SimpleResultSet select1ResultSetWithStats = new SimpleResultSet(mockResultSetWithStats);
        Mockito.when((Object)singleUseReadOnlyTx.executeQuery((Statement)Mockito.argThat(statement -> statement.getSql().toUpperCase().startsWith("SHOW")), new Options.QueryOption[0])).thenThrow(new Throwable[]{SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.UNIMPLEMENTED, (String)"SHOW queries are not supported")});
        Mockito.when((Object)singleUseReadOnlyTx.executeQuery(Statement.of((String)"SELECT 1 AS TEST"), new Options.QueryOption[0])).thenAnswer(invocation -> {
            if (select1ResultSet.nextCalled) {
                return new SimpleResultSet(ConnectionImplTest.createSelect1MockResultSet());
            }
            return select1ResultSet;
        });
        Mockito.when((Object)singleUseReadOnlyTx.analyzeQuery(Statement.of((String)"SELECT 1 AS TEST"), ReadContext.QueryAnalyzeMode.PLAN)).thenReturn((Object)select1ResultSetWithStats);
        Mockito.when((Object)singleUseReadOnlyTx.analyzeQuery(Statement.of((String)"SELECT 1 AS TEST"), ReadContext.QueryAnalyzeMode.PROFILE)).thenReturn((Object)select1ResultSetWithStats);
        Mockito.when((Object)singleUseReadOnlyTx.getReadTimestamp()).then(invocation -> {
            if (select1ResultSet.isNextCalled() || select1ResultSetWithStats.isNextCalled()) {
                return Timestamp.now();
            }
            throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.FAILED_PRECONDITION, (String)"No query has returned with any data yet");
        });
        Mockito.when((Object)dbClient.singleUseReadOnlyTransaction((TimestampBound)Mockito.any(TimestampBound.class))).thenReturn((Object)singleUseReadOnlyTx);
        Mockito.when((Object)dbClient.transactionManager((Options.TransactionOption[])Mockito.any())).thenAnswer(invocation -> {
            TransactionContext txContext = (TransactionContext)Mockito.mock(TransactionContext.class);
            Mockito.when((Object)txContext.executeQuery(Statement.of((String)"SELECT 1 AS TEST"), new Options.QueryOption[0])).thenAnswer(ignored -> {
                if (select1ResultSet.nextCalled) {
                    return new SimpleResultSet(ConnectionImplTest.createSelect1MockResultSet());
                }
                return select1ResultSet;
            });
            Mockito.when((Object)txContext.executeQuery((Statement)Mockito.argThat(statement -> statement.getSql().toUpperCase().startsWith("SHOW")), new Options.QueryOption[0])).thenThrow(new Throwable[]{SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.UNIMPLEMENTED, (String)"SHOW queries are not supported")});
            Mockito.when((Object)txContext.analyzeQuery(Statement.of((String)"SELECT 1 AS TEST"), ReadContext.QueryAnalyzeMode.PLAN)).thenReturn((Object)select1ResultSetWithStats);
            Mockito.when((Object)txContext.analyzeQuery(Statement.of((String)"SELECT 1 AS TEST"), ReadContext.QueryAnalyzeMode.PROFILE)).thenReturn((Object)select1ResultSetWithStats);
            Mockito.when((Object)txContext.executeUpdate(Statement.of((String)"UPDATE foo SET bar=1"), new Options.UpdateOption[0])).thenReturn((Object)1L);
            return new SimpleTransactionManager(txContext, options.isReturnCommitStats());
        });
        Mockito.when((Object)dbClient.readOnlyTransaction((TimestampBound)Mockito.any(TimestampBound.class))).thenAnswer(invocation -> {
            ReadOnlyTransaction tx = (ReadOnlyTransaction)Mockito.mock(ReadOnlyTransaction.class);
            Mockito.when((Object)tx.executeQuery(Statement.of((String)"SELECT 1 AS TEST"), new Options.QueryOption[0])).thenAnswer(ignored -> {
                if (select1ResultSet.nextCalled) {
                    return new SimpleResultSet(ConnectionImplTest.createSelect1MockResultSet());
                }
                return select1ResultSet;
            });
            Mockito.when((Object)tx.analyzeQuery(Statement.of((String)"SELECT 1 AS TEST"), ReadContext.QueryAnalyzeMode.PLAN)).thenReturn((Object)select1ResultSetWithStats);
            Mockito.when((Object)tx.analyzeQuery(Statement.of((String)"SELECT 1 AS TEST"), ReadContext.QueryAnalyzeMode.PROFILE)).thenReturn((Object)select1ResultSetWithStats);
            Mockito.when((Object)tx.getReadTimestamp()).then(ignored -> {
                if (select1ResultSet.isNextCalled() || select1ResultSetWithStats.isNextCalled()) {
                    return Timestamp.now();
                }
                throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.FAILED_PRECONDITION, (String)"No query has returned with any data yet");
            });
            return tx;
        });
        Mockito.when((Object)dbClient.readWriteTransaction(new Options.TransactionOption[0])).thenAnswer((Answer)new Answer<TransactionRunner>(){

            public TransactionRunner answer(InvocationOnMock invocation) {
                return new TransactionRunner(){
                    private CommitResponse commitResponse;

                    public <T> T run(TransactionRunner.TransactionCallable<T> callable) {
                        this.commitResponse = new CommitResponse(Timestamp.ofTimeSecondsAndNanos((long)1L, (int)1));
                        TransactionContext transaction = (TransactionContext)Mockito.mock(TransactionContext.class);
                        Mockito.when((Object)transaction.executeUpdate(Statement.of((String)"UPDATE foo SET bar=1"), new Options.UpdateOption[0])).thenReturn((Object)1L);
                        try {
                            return (T)callable.run(transaction);
                        }
                        catch (Exception e) {
                            throw SpannerExceptionFactory.newSpannerException((Throwable)e);
                        }
                    }

                    public Timestamp getCommitTimestamp() {
                        return this.commitResponse == null ? null : this.commitResponse.getCommitTimestamp();
                    }

                    public CommitResponse getCommitResponse() {
                        return this.commitResponse;
                    }

                    public TransactionRunner allowNestedTransaction() {
                        return this;
                    }
                };
            }
        });
        BatchClient batchClient = (BatchClient)Mockito.mock(BatchClient.class);
        BatchReadOnlyTransaction batchReadOnlyTransaction = (BatchReadOnlyTransaction)Mockito.mock(BatchReadOnlyTransaction.class);
        Mockito.when((Object)batchClient.batchReadOnlyTransaction((TimestampBound)Mockito.any(TimestampBound.class))).thenReturn((Object)batchReadOnlyTransaction);
        Mockito.when((Object)batchClient.batchReadOnlyTransaction((BatchTransactionId)Mockito.any(BatchTransactionId.class))).thenReturn((Object)batchReadOnlyTransaction);
        return new ConnectionImpl(options, spannerPool, ddlClient, dbClient, batchClient);
    }

    @Test
    public void testExecuteSetAutocommitOn() {
        try (ConnectionImpl subject = ConnectionImplTest.createConnection(ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setUri("cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database;autocommit=false").build());){
            MatcherAssert.assertThat((Object)subject.isAutocommit(), (Matcher)CoreMatchers.is((Object)false));
            StatementResult res = subject.execute(Statement.of((String)"set autocommit = true"));
            MatcherAssert.assertThat((Object)res.getResultType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)StatementResult.ResultType.NO_RESULT)));
            MatcherAssert.assertThat((Object)subject.isAutocommit(), (Matcher)CoreMatchers.is((Object)true));
        }
    }

    @Test
    public void testExecuteSetAutocommitOff() {
        try (ConnectionImpl subject = ConnectionImplTest.createConnection(ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setUri(URI).build());){
            MatcherAssert.assertThat((Object)subject.isAutocommit(), (Matcher)CoreMatchers.is((Object)true));
            StatementResult res = subject.execute(Statement.of((String)"set autocommit = false"));
            MatcherAssert.assertThat((Object)res.getResultType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)StatementResult.ResultType.NO_RESULT)));
            MatcherAssert.assertThat((Object)subject.isAutocommit(), (Matcher)CoreMatchers.is((Object)false));
        }
    }

    @Test
    public void testSetAutocommitToTrue_inAutoCommitAndNotInTransaction_noop() {
        try (ConnectionImpl subject = ConnectionImplTest.createConnection(ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setUri(URI).build());){
            MatcherAssert.assertThat((Object)subject.isAutocommit(), (Matcher)CoreMatchers.is((Object)true));
            subject.setAutocommit(true);
            Assert.assertTrue((boolean)subject.isAutocommit());
        }
    }

    @Test
    public void testSetAutocommitToTrue_inAutoCommitAndInTransaction_noop() {
        try (ConnectionImpl subject = ConnectionImplTest.createConnection(ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setUri(URI).build());){
            MatcherAssert.assertThat((Object)subject.isAutocommit(), (Matcher)CoreMatchers.is((Object)true));
            subject.execute(Statement.of((String)"begin transaction"));
            subject.setAutocommit(true);
            Assert.assertTrue((boolean)subject.isAutocommit());
        }
    }

    @Test
    public void testSetAutocommitToFalse_inAutoCommitAndNotInTransaction_autocommitModeChanged() {
        try (ConnectionImpl subject = ConnectionImplTest.createConnection(ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setUri(URI).build());){
            MatcherAssert.assertThat((Object)subject.isAutocommit(), (Matcher)CoreMatchers.is((Object)true));
            subject.setAutocommit(false);
            Assert.assertFalse((boolean)subject.isAutocommit());
        }
    }

    @Test
    public void testSetAutocommitToFalse_inAutoCommitAndInTransaction_throwsException() {
        try (ConnectionImpl subject = ConnectionImplTest.createConnection(ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setUri(URI).build());){
            MatcherAssert.assertThat((Object)subject.isAutocommit(), (Matcher)CoreMatchers.is((Object)true));
            subject.execute(Statement.of((String)"begin transaction"));
            SpannerException exception = (SpannerException)Assert.assertThrows(SpannerException.class, () -> subject.setAutocommit(false));
            Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)exception.getErrorCode());
            Assert.assertTrue((boolean)exception.getMessage().contains("Cannot set autocommit while in a temporary transaction"));
        }
    }

    @Test
    public void testSetAutocommitToFalse_notInAutoCommitAndTransactionNotStarted_noop() {
        try (ConnectionImpl subject = ConnectionImplTest.createConnection(ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setUri("cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database;autocommit=false").build());){
            MatcherAssert.assertThat((Object)subject.isAutocommit(), (Matcher)CoreMatchers.is((Object)false));
            subject.setAutocommit(false);
            Assert.assertFalse((boolean)subject.isAutocommit());
        }
    }

    @Test
    public void testSetAutocommitToFalse_notInAutoCommitAndTransactionStarted_noop() {
        try (ConnectionImpl subject = ConnectionImplTest.createConnection(ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setUri("cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database;autocommit=false").build());){
            MatcherAssert.assertThat((Object)subject.isAutocommit(), (Matcher)CoreMatchers.is((Object)false));
            subject.executeQuery(Statement.of((String)"SELECT 1 AS TEST"), new Options.QueryOption[0]);
            subject.setAutocommit(false);
            Assert.assertFalse((boolean)subject.isAutocommit());
        }
    }

    @Test
    public void testSetAutocommitToTrue_notInAutoCommitAndTransactionNotStarted_autocommitModeChanged() {
        try (ConnectionImpl subject = ConnectionImplTest.createConnection(ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setUri("cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database;autocommit=false").build());){
            MatcherAssert.assertThat((Object)subject.isAutocommit(), (Matcher)CoreMatchers.is((Object)false));
            subject.setAutocommit(true);
            Assert.assertTrue((boolean)subject.isAutocommit());
        }
    }

    @Test
    public void testSetAutocommitToTrue_notInAutoCommitAndTransactionStarted_throwsException() {
        try (ConnectionImpl subject = ConnectionImplTest.createConnection(ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setUri("cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database;autocommit=false").build());){
            MatcherAssert.assertThat((Object)subject.isAutocommit(), (Matcher)CoreMatchers.is((Object)false));
            subject.executeQuery(Statement.of((String)"SELECT 1 AS TEST"), new Options.QueryOption[0]);
            SpannerException exception = (SpannerException)Assert.assertThrows(SpannerException.class, () -> subject.setAutocommit(true));
            Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)exception.getErrorCode());
            Assert.assertTrue((boolean)exception.getMessage().contains("Cannot set autocommit while a transaction is active"));
        }
    }

    @Test
    public void testExecuteGetAutocommit() {
        try (ConnectionImpl subject = ConnectionImplTest.createConnection(ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setUri(URI).build());){
            MatcherAssert.assertThat((Object)subject.isAutocommit(), (Matcher)CoreMatchers.is((Object)true));
            StatementResult res = subject.execute(Statement.of((String)"show variable autocommit"));
            MatcherAssert.assertThat((Object)res.getResultType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)StatementResult.ResultType.RESULT_SET)));
            MatcherAssert.assertThat((Object)res.getResultSet().next(), (Matcher)CoreMatchers.is((Object)true));
            MatcherAssert.assertThat((Object)res.getResultSet().getBoolean("AUTOCOMMIT"), (Matcher)CoreMatchers.is((Object)true));
            subject.execute(Statement.of((String)"set autocommit = false"));
            MatcherAssert.assertThat((Object)subject.isAutocommit(), (Matcher)CoreMatchers.is((Object)false));
            res = subject.execute(Statement.of((String)"show variable autocommit"));
            MatcherAssert.assertThat((Object)res.getResultType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)StatementResult.ResultType.RESULT_SET)));
            MatcherAssert.assertThat((Object)res.getResultSet().next(), (Matcher)CoreMatchers.is((Object)true));
            MatcherAssert.assertThat((Object)res.getResultSet().getBoolean("AUTOCOMMIT"), (Matcher)CoreMatchers.is((Object)false));
        }
    }

    @Test
    public void testExecuteSetReadOnlyOn() {
        try (ConnectionImpl subject = ConnectionImplTest.createConnection(ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setUri(URI).build());){
            MatcherAssert.assertThat((Object)subject.isReadOnly(), (Matcher)CoreMatchers.is((Object)false));
            StatementResult res = subject.execute(Statement.of((String)"set readonly = true"));
            MatcherAssert.assertThat((Object)res.getResultType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)StatementResult.ResultType.NO_RESULT)));
            MatcherAssert.assertThat((Object)subject.isReadOnly(), (Matcher)CoreMatchers.is((Object)true));
        }
    }

    @Test
    public void testExecuteSetReadOnlyOff() {
        try (ConnectionImpl subject = ConnectionImplTest.createConnection(ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setUri("cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database;readonly=true").build());){
            MatcherAssert.assertThat((Object)subject.isReadOnly(), (Matcher)CoreMatchers.is((Object)true));
            StatementResult res = subject.execute(Statement.of((String)"set readonly = false"));
            MatcherAssert.assertThat((Object)res.getResultType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)StatementResult.ResultType.NO_RESULT)));
            MatcherAssert.assertThat((Object)subject.isReadOnly(), (Matcher)CoreMatchers.is((Object)false));
        }
    }

    @Test
    public void testExecuteGetReadOnly() {
        try (ConnectionImpl subject = ConnectionImplTest.createConnection(ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setUri(URI).build());){
            MatcherAssert.assertThat((Object)subject.isReadOnly(), (Matcher)CoreMatchers.is((Object)false));
            StatementResult res = subject.execute(Statement.of((String)"show variable readonly"));
            MatcherAssert.assertThat((Object)res.getResultType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)StatementResult.ResultType.RESULT_SET)));
            MatcherAssert.assertThat((Object)res.getResultSet().next(), (Matcher)CoreMatchers.is((Object)true));
            MatcherAssert.assertThat((Object)res.getResultSet().getBoolean("READONLY"), (Matcher)CoreMatchers.is((Object)false));
            subject.execute(Statement.of((String)"set readonly = true"));
            MatcherAssert.assertThat((Object)subject.isReadOnly(), (Matcher)CoreMatchers.is((Object)true));
            res = subject.execute(Statement.of((String)"show variable readonly"));
            MatcherAssert.assertThat((Object)res.getResultType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)StatementResult.ResultType.RESULT_SET)));
            MatcherAssert.assertThat((Object)res.getResultSet().next(), (Matcher)CoreMatchers.is((Object)true));
            MatcherAssert.assertThat((Object)res.getResultSet().getBoolean("READONLY"), (Matcher)CoreMatchers.is((Object)true));
        }
    }

    @Test
    public void testExecuteSetAutocommitDmlMode() {
        try (ConnectionImpl subject = ConnectionImplTest.createConnection(ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setUri(URI).build());){
            MatcherAssert.assertThat((Object)subject.isAutocommit(), (Matcher)CoreMatchers.is((Object)true));
            MatcherAssert.assertThat((Object)subject.getAutocommitDmlMode(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)AutocommitDmlMode.TRANSACTIONAL)));
            StatementResult res = subject.execute(Statement.of((String)"set autocommit_dml_mode='PARTITIONED_NON_ATOMIC'"));
            MatcherAssert.assertThat((Object)res.getResultType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)StatementResult.ResultType.NO_RESULT)));
            MatcherAssert.assertThat((Object)subject.getAutocommitDmlMode(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)AutocommitDmlMode.PARTITIONED_NON_ATOMIC)));
            res = subject.execute(Statement.of((String)"set autocommit_dml_mode='TRANSACTIONAL'"));
            MatcherAssert.assertThat((Object)res.getResultType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)StatementResult.ResultType.NO_RESULT)));
            MatcherAssert.assertThat((Object)subject.getAutocommitDmlMode(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)AutocommitDmlMode.TRANSACTIONAL)));
        }
    }

    @Test
    public void testExecuteSetAutocommitDmlModeInvalidValue() {
        try (ConnectionImpl subject = ConnectionImplTest.createConnection(ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setUri(URI).build());){
            MatcherAssert.assertThat((Object)subject.isAutocommit(), (Matcher)CoreMatchers.is((Object)true));
            MatcherAssert.assertThat((Object)subject.getAutocommitDmlMode(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)AutocommitDmlMode.TRANSACTIONAL)));
            ErrorCode expected = null;
            try {
                subject.execute(Statement.of((String)"set autocommit_dml_mode='NON_EXISTENT_VALUE'"));
            }
            catch (SpannerException e) {
                expected = e.getErrorCode();
            }
            MatcherAssert.assertThat((Object)expected, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)ErrorCode.INVALID_ARGUMENT)));
        }
    }

    @Test
    public void testExecuteGetAutocommitDmlMode() {
        try (ConnectionImpl subject = ConnectionImplTest.createConnection(ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setUri(URI).build());){
            MatcherAssert.assertThat((Object)subject.isAutocommit(), (Matcher)CoreMatchers.is((Object)true));
            MatcherAssert.assertThat((Object)subject.getAutocommitDmlMode(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)AutocommitDmlMode.TRANSACTIONAL)));
            StatementResult res = subject.execute(Statement.of((String)"show variable autocommit_dml_mode"));
            MatcherAssert.assertThat((Object)res.getResultType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)StatementResult.ResultType.RESULT_SET)));
            MatcherAssert.assertThat((Object)res.getResultSet().next(), (Matcher)CoreMatchers.is((Object)true));
            MatcherAssert.assertThat((Object)res.getResultSet().getString("AUTOCOMMIT_DML_MODE"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)AutocommitDmlMode.TRANSACTIONAL.toString())));
            subject.execute(Statement.of((String)"set autocommit_dml_mode='PARTITIONED_NON_ATOMIC'"));
            res = subject.execute(Statement.of((String)"show variable autocommit_dml_mode"));
            MatcherAssert.assertThat((Object)res.getResultType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)StatementResult.ResultType.RESULT_SET)));
            MatcherAssert.assertThat((Object)res.getResultSet().next(), (Matcher)CoreMatchers.is((Object)true));
            MatcherAssert.assertThat((Object)res.getResultSet().getString("AUTOCOMMIT_DML_MODE"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)AutocommitDmlMode.PARTITIONED_NON_ATOMIC.toString())));
        }
    }

    @Test
    public void testExecuteSetOptimizerVersion() {
        try (ConnectionImpl subject = ConnectionImplTest.createConnection(ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setUri(URI).build());){
            MatcherAssert.assertThat((Object)subject.getOptimizerVersion(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"")));
            StatementResult res = subject.execute(Statement.of((String)"set optimizer_version='1'"));
            MatcherAssert.assertThat((Object)res.getResultType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)StatementResult.ResultType.NO_RESULT)));
            MatcherAssert.assertThat((Object)subject.getOptimizerVersion(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"1")));
            res = subject.execute(Statement.of((String)"set optimizer_version='1000'"));
            MatcherAssert.assertThat((Object)res.getResultType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)StatementResult.ResultType.NO_RESULT)));
            MatcherAssert.assertThat((Object)subject.getOptimizerVersion(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"1000")));
            res = subject.execute(Statement.of((String)"set optimizer_version='latest'"));
            MatcherAssert.assertThat((Object)res.getResultType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)StatementResult.ResultType.NO_RESULT)));
            MatcherAssert.assertThat((Object)subject.getOptimizerVersion(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"latest")));
            res = subject.execute(Statement.of((String)"set optimizer_version=''"));
            MatcherAssert.assertThat((Object)res.getResultType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)StatementResult.ResultType.NO_RESULT)));
            MatcherAssert.assertThat((Object)subject.getOptimizerVersion(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"")));
        }
    }

    @Test
    public void testExecuteSetOptimizerVersionInvalidValue() {
        try (ConnectionImpl subject = ConnectionImplTest.createConnection(ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setUri(URI).build());){
            MatcherAssert.assertThat((Object)subject.getOptimizerVersion(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"")));
            try {
                subject.execute(Statement.of((String)"set optimizer_version='NOT_A_VERSION'"));
                Assert.fail((String)"Missing expected exception");
            }
            catch (SpannerException e) {
                MatcherAssert.assertThat((Object)e.getErrorCode(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)ErrorCode.INVALID_ARGUMENT)));
            }
        }
    }

    @Test
    public void testExecuteGetOptimizerVersion() {
        try (ConnectionImpl subject = ConnectionImplTest.createConnection(ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setUri(URI).build());){
            MatcherAssert.assertThat((Object)subject.getOptimizerVersion(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"")));
            StatementResult res = subject.execute(Statement.of((String)"show variable optimizer_version"));
            MatcherAssert.assertThat((Object)res.getResultType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)StatementResult.ResultType.RESULT_SET)));
            MatcherAssert.assertThat((Object)res.getResultSet().next(), (Matcher)CoreMatchers.is((Object)true));
            MatcherAssert.assertThat((Object)res.getResultSet().getString("OPTIMIZER_VERSION"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"")));
            subject.execute(Statement.of((String)"set optimizer_version='1'"));
            res = subject.execute(Statement.of((String)"show variable optimizer_version"));
            MatcherAssert.assertThat((Object)res.getResultType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)StatementResult.ResultType.RESULT_SET)));
            MatcherAssert.assertThat((Object)res.getResultSet().next(), (Matcher)CoreMatchers.is((Object)true));
            MatcherAssert.assertThat((Object)res.getResultSet().getString("OPTIMIZER_VERSION"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"1")));
        }
    }

    @Test
    public void testExecuteSetOptimizerStatisticsPackage() {
        try (ConnectionImpl subject = ConnectionImplTest.createConnection(ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setUri(URI).build());){
            MatcherAssert.assertThat((Object)subject.getOptimizerStatisticsPackage(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"")));
            StatementResult res = subject.execute(Statement.of((String)"set optimizer_statistics_package='custom-package'"));
            MatcherAssert.assertThat((Object)res.getResultType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)StatementResult.ResultType.NO_RESULT)));
            MatcherAssert.assertThat((Object)subject.getOptimizerStatisticsPackage(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"custom-package")));
            res = subject.execute(Statement.of((String)"set optimizer_statistics_package=''"));
            MatcherAssert.assertThat((Object)res.getResultType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)StatementResult.ResultType.NO_RESULT)));
            MatcherAssert.assertThat((Object)subject.getOptimizerStatisticsPackage(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"")));
        }
    }

    @Test
    public void testExecuteSetOptimizerStatisticsPackageInvalidValue() {
        try (ConnectionImpl subject = ConnectionImplTest.createConnection(ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setUri(URI).build());){
            MatcherAssert.assertThat((Object)subject.getOptimizerVersion(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"")));
            try {
                subject.execute(Statement.of((String)"set optimizer_statistics_package='   '"));
                Assert.fail((String)"Missing expected exception");
            }
            catch (SpannerException e) {
                MatcherAssert.assertThat((Object)e.getErrorCode(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)ErrorCode.INVALID_ARGUMENT)));
            }
        }
    }

    @Test
    public void testExecuteGetOptimizerStatisticsPackage() {
        try (ConnectionImpl subject = ConnectionImplTest.createConnection(ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setUri(URI).build());){
            MatcherAssert.assertThat((Object)subject.getOptimizerStatisticsPackage(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"")));
            StatementResult res = subject.execute(Statement.of((String)"show variable optimizer_statistics_package"));
            MatcherAssert.assertThat((Object)res.getResultType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)StatementResult.ResultType.RESULT_SET)));
            MatcherAssert.assertThat((Object)res.getResultSet().next(), (Matcher)CoreMatchers.is((Object)true));
            MatcherAssert.assertThat((Object)res.getResultSet().getString("OPTIMIZER_STATISTICS_PACKAGE"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"")));
            subject.execute(Statement.of((String)"set optimizer_statistics_package='custom-package'"));
            res = subject.execute(Statement.of((String)"show variable optimizer_statistics_package"));
            MatcherAssert.assertThat((Object)res.getResultType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)StatementResult.ResultType.RESULT_SET)));
            MatcherAssert.assertThat((Object)res.getResultSet().next(), (Matcher)CoreMatchers.is((Object)true));
            MatcherAssert.assertThat((Object)res.getResultSet().getString("OPTIMIZER_STATISTICS_PACKAGE"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"custom-package")));
        }
    }

    @Test
    public void testExecuteSetReturnCommitStats() {
        try (ConnectionImpl subject = ConnectionImplTest.createConnection(ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setUri(URI).build());){
            Assert.assertFalse((boolean)subject.isReturnCommitStats());
            StatementResult result = subject.execute(Statement.of((String)"set return_commit_stats=true"));
            Assert.assertEquals((Object)StatementResult.ResultType.NO_RESULT, (Object)result.getResultType());
            Assert.assertTrue((boolean)subject.isReturnCommitStats());
            result = subject.execute(Statement.of((String)"set return_commit_stats=false"));
            Assert.assertEquals((Object)StatementResult.ResultType.NO_RESULT, (Object)result.getResultType());
            Assert.assertFalse((boolean)subject.isReturnCommitStats());
        }
    }

    @Test
    public void testExecuteSetReturnCommitStatsInvalidValue() {
        try (ConnectionImpl subject = ConnectionImplTest.createConnection(ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setUri(URI).build());){
            Assert.assertFalse((boolean)subject.isReturnCommitStats());
            try {
                subject.execute(Statement.of((String)"set return_commit_stats=yes"));
                Assert.fail((String)"Missing expected exception");
            }
            catch (SpannerException e) {
                Assert.assertEquals((Object)ErrorCode.INVALID_ARGUMENT, (Object)e.getErrorCode());
            }
        }
    }

    @Test
    public void testExecuteGetReturnCommitStats() {
        try (ConnectionImpl subject = ConnectionImplTest.createConnection(ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setUri(URI).build());){
            Assert.assertFalse((boolean)subject.isReturnCommitStats());
            StatementResult returnCommitStatsFalse = subject.execute(Statement.of((String)"show variable return_commit_stats"));
            Assert.assertEquals((Object)StatementResult.ResultType.RESULT_SET, (Object)returnCommitStatsFalse.getResultType());
            Assert.assertTrue((boolean)returnCommitStatsFalse.getResultSet().next());
            Assert.assertFalse((boolean)returnCommitStatsFalse.getResultSet().getBoolean("RETURN_COMMIT_STATS"));
            subject.execute(Statement.of((String)"set return_commit_stats=true"));
            StatementResult returnCommitStatsTrue = subject.execute(Statement.of((String)"show variable return_commit_stats"));
            Assert.assertEquals((Object)StatementResult.ResultType.RESULT_SET, (Object)returnCommitStatsTrue.getResultType());
            Assert.assertTrue((boolean)returnCommitStatsTrue.getResultSet().next());
            Assert.assertTrue((boolean)returnCommitStatsTrue.getResultSet().getBoolean("RETURN_COMMIT_STATS"));
        }
    }

    @Test
    public void testExecuteSetStatementTimeout() {
        try (ConnectionImpl subject = ConnectionImplTest.createConnection(ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setUri(URI).build());){
            MatcherAssert.assertThat((Object)subject.getStatementTimeout(TimeUnit.MILLISECONDS), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)0L)));
            for (TimeUnit unit : ReadOnlyStalenessUtil.SUPPORTED_UNITS) {
                for (Long timeout : new Long[]{1L, 100L, 10000L, 315576000000L}) {
                    StatementResult res = subject.execute(Statement.of((String)String.format("set statement_timeout='%d%s'", timeout, ReadOnlyStalenessUtil.getTimeUnitAbbreviation((TimeUnit)unit))));
                    MatcherAssert.assertThat((Object)res.getResultType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)StatementResult.ResultType.NO_RESULT)));
                    MatcherAssert.assertThat((Object)subject.getStatementTimeout(unit), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)timeout)));
                    MatcherAssert.assertThat((Object)subject.hasStatementTimeout(), (Matcher)CoreMatchers.is((Object)true));
                    StatementResult resNoTimeout = subject.execute(Statement.of((String)"set statement_timeout=null"));
                    MatcherAssert.assertThat((Object)resNoTimeout.getResultType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)StatementResult.ResultType.NO_RESULT)));
                    MatcherAssert.assertThat((Object)subject.getStatementTimeout(unit), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)0L)));
                    MatcherAssert.assertThat((Object)subject.hasStatementTimeout(), (Matcher)CoreMatchers.is((Object)false));
                }
            }
        }
    }

    @Test
    public void testExecuteSetStatementTimeoutInvalidValue() {
        try (ConnectionImpl subject = ConnectionImplTest.createConnection(ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setUri(URI).build());){
            MatcherAssert.assertThat((Object)subject.getStatementTimeout(TimeUnit.MILLISECONDS), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)0L)));
            ErrorCode expected = null;
            try {
                subject.execute(Statement.of((String)"set statement_timeout=-1"));
            }
            catch (SpannerException e) {
                expected = e.getErrorCode();
            }
            MatcherAssert.assertThat((Object)expected, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)ErrorCode.INVALID_ARGUMENT)));
        }
    }

    @Test
    public void testExecuteGetStatementTimeout() {
        try (ConnectionImpl subject = ConnectionImplTest.createConnection(ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setUri(URI).build());){
            MatcherAssert.assertThat((Object)subject.getStatementTimeout(TimeUnit.MILLISECONDS), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)0L)));
            for (TimeUnit unit : ReadOnlyStalenessUtil.SUPPORTED_UNITS) {
                for (Long timeout : new Long[]{1L, 100L, 10000L, 315576000000L}) {
                    subject.execute(Statement.of((String)String.format("set statement_timeout='%d%s'", timeout, ReadOnlyStalenessUtil.getTimeUnitAbbreviation((TimeUnit)unit))));
                    StatementResult res = subject.execute(Statement.of((String)"show variable statement_timeout"));
                    MatcherAssert.assertThat((Object)res.getResultType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)StatementResult.ResultType.RESULT_SET)));
                    MatcherAssert.assertThat((Object)res.getResultSet().next(), (Matcher)CoreMatchers.is((Object)true));
                    TimeUnit appropriateUnit = ReadOnlyStalenessUtil.getAppropriateTimeUnit((ReadOnlyStalenessUtil.DurationValueGetter)new ConnectionStatementExecutorImpl.StatementTimeoutGetter((Connection)subject));
                    MatcherAssert.assertThat((Object)res.getResultSet().getString("STATEMENT_TIMEOUT"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)(subject.getStatementTimeout(appropriateUnit) + ReadOnlyStalenessUtil.getTimeUnitAbbreviation((TimeUnit)appropriateUnit)))));
                    subject.execute(Statement.of((String)"set statement_timeout=null"));
                    StatementResult resNoTimeout = subject.execute(Statement.of((String)"show variable statement_timeout"));
                    MatcherAssert.assertThat((Object)resNoTimeout.getResultType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)StatementResult.ResultType.RESULT_SET)));
                    MatcherAssert.assertThat((Object)resNoTimeout.getResultSet().next(), (Matcher)CoreMatchers.is((Object)true));
                    MatcherAssert.assertThat((Object)resNoTimeout.getResultSet().isNull("STATEMENT_TIMEOUT"), (Matcher)CoreMatchers.is((Object)true));
                }
            }
        }
    }

    @Test
    public void testExecuteGetReadTimestamp() {
        try (ConnectionImpl subject = ConnectionImplTest.createConnection(ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setUri(URI).build());){
            subject.beginTransaction();
            subject.setTransactionMode(TransactionMode.READ_ONLY_TRANSACTION);
            subject.executeQuery(Statement.of((String)"SELECT 1 AS TEST"), new Options.QueryOption[0]);
            StatementResult res = subject.execute(Statement.of((String)"show variable read_timestamp"));
            MatcherAssert.assertThat((Object)res.getResultType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)StatementResult.ResultType.RESULT_SET)));
            MatcherAssert.assertThat((Object)res.getResultSet().next(), (Matcher)CoreMatchers.is((Object)true));
            MatcherAssert.assertThat((Object)res.getResultSet().getTimestamp("READ_TIMESTAMP"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
            subject.commit();
        }
    }

    @Test
    public void testExecuteGetCommitTimestamp() {
        try (ConnectionImpl subject = ConnectionImplTest.createConnection(ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setUri(URI).build());){
            subject.beginTransaction();
            subject.executeQuery(Statement.of((String)"SELECT 1 AS TEST"), new Options.QueryOption[0]).next();
            subject.commit();
            StatementResult res = subject.execute(Statement.of((String)"show variable commit_timestamp"));
            MatcherAssert.assertThat((Object)res.getResultType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)StatementResult.ResultType.RESULT_SET)));
            MatcherAssert.assertThat((Object)res.getResultSet().next(), (Matcher)CoreMatchers.is((Object)true));
            MatcherAssert.assertThat((Object)res.getResultSet().getTimestamp("COMMIT_TIMESTAMP"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        }
    }

    @Test
    public void testExecuteGetCommitResponse() {
        StatementResult response;
        try (ConnectionImpl subject = ConnectionImplTest.createConnection(ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setUri(URI).build());){
            subject.beginTransaction();
            subject.executeQuery(Statement.of((String)"SELECT 1 AS TEST"), new Options.QueryOption[0]).next();
            subject.commit();
            response = subject.execute(Statement.of((String)"show variable commit_response"));
            Assert.assertEquals((Object)StatementResult.ResultType.RESULT_SET, (Object)response.getResultType());
            Assert.assertTrue((boolean)response.getResultSet().next());
            Assert.assertNotNull((Object)response.getResultSet().getTimestamp("COMMIT_TIMESTAMP"));
            Assert.assertTrue((boolean)response.getResultSet().isNull("MUTATION_COUNT"));
            Assert.assertFalse((boolean)response.getResultSet().next());
        }
        subject = ConnectionImplTest.createConnection(ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setUri("cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database;returnCommitStats=true").build());
        try {
            subject.beginTransaction();
            subject.executeQuery(Statement.of((String)"SELECT 1 AS TEST"), new Options.QueryOption[0]).next();
            subject.commit();
            response = subject.execute(Statement.of((String)"show variable commit_response"));
            Assert.assertEquals((Object)StatementResult.ResultType.RESULT_SET, (Object)response.getResultType());
            Assert.assertTrue((boolean)response.getResultSet().next());
            Assert.assertNotNull((Object)response.getResultSet().getTimestamp("COMMIT_TIMESTAMP"));
            Assert.assertFalse((boolean)response.getResultSet().isNull("MUTATION_COUNT"));
            Assert.assertFalse((boolean)response.getResultSet().next());
        }
        finally {
            if (subject != null) {
                subject.close();
            }
        }
    }

    @Test
    public void testExecuteGetReadOnlyStaleness() {
        HashMap<TimestampBound.Mode, Timestamp> timestamps = new HashMap<TimestampBound.Mode, Timestamp>();
        timestamps.put(TimestampBound.Mode.READ_TIMESTAMP, ReadOnlyStalenessUtil.parseRfc3339((String)"2018-10-08T14:05:10Z"));
        timestamps.put(TimestampBound.Mode.MIN_READ_TIMESTAMP, ReadOnlyStalenessUtil.parseRfc3339((String)"2018-10-08T14:05:10.12345Z"));
        HashMap<TimestampBound.Mode, StalenessDuration> durations = new HashMap<TimestampBound.Mode, StalenessDuration>();
        durations.put(TimestampBound.Mode.EXACT_STALENESS, new StalenessDuration(1000L, TimeUnit.MILLISECONDS));
        durations.put(TimestampBound.Mode.MAX_STALENESS, new StalenessDuration(1234567L, TimeUnit.MICROSECONDS));
        List<TimestampBound> stalenesses = Arrays.asList(TimestampBound.strong(), TimestampBound.ofReadTimestamp((Timestamp)((Timestamp)timestamps.get(TimestampBound.Mode.READ_TIMESTAMP))), TimestampBound.ofMinReadTimestamp((Timestamp)((Timestamp)timestamps.get(TimestampBound.Mode.MIN_READ_TIMESTAMP))), TimestampBound.ofExactStaleness((long)((StalenessDuration)durations.get(TimestampBound.Mode.EXACT_STALENESS)).duration, (TimeUnit)((StalenessDuration)durations.get(TimestampBound.Mode.EXACT_STALENESS)).unit), TimestampBound.ofMaxStaleness((long)((StalenessDuration)durations.get(TimestampBound.Mode.MAX_STALENESS)).duration, (TimeUnit)((StalenessDuration)durations.get(TimestampBound.Mode.MAX_STALENESS)).unit));
        try (ConnectionImpl subject = ConnectionImplTest.createConnection(ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setUri(URI).build());){
            for (TimestampBound staleness : stalenesses) {
                subject.setReadOnlyStaleness(staleness);
                StatementResult res = subject.execute(Statement.of((String)"show variable read_only_staleness"));
                MatcherAssert.assertThat((Object)res.getResultType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)StatementResult.ResultType.RESULT_SET)));
                MatcherAssert.assertThat((Object)res.getResultSet().next(), (Matcher)CoreMatchers.is((Object)true));
                MatcherAssert.assertThat((Object)res.getResultSet().getString("READ_ONLY_STALENESS"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)ReadOnlyStalenessUtil.timestampBoundToString((TimestampBound)staleness))));
            }
        }
    }

    @Test
    public void testExecuteSetReadOnlyStaleness() {
        HashMap<TimestampBound.Mode, Timestamp> timestamps = new HashMap<TimestampBound.Mode, Timestamp>();
        timestamps.put(TimestampBound.Mode.READ_TIMESTAMP, ReadOnlyStalenessUtil.parseRfc3339((String)"2018-10-08T12:13:14Z"));
        timestamps.put(TimestampBound.Mode.MIN_READ_TIMESTAMP, ReadOnlyStalenessUtil.parseRfc3339((String)"2018-10-08T14:13:14.1234+02:00"));
        HashMap<TimestampBound.Mode, StalenessDuration> durations = new HashMap<TimestampBound.Mode, StalenessDuration>();
        durations.put(TimestampBound.Mode.EXACT_STALENESS, new StalenessDuration(1000L, TimeUnit.MILLISECONDS));
        durations.put(TimestampBound.Mode.MAX_STALENESS, new StalenessDuration(1234567L, TimeUnit.MICROSECONDS));
        List<TimestampBound> stalenesses = Arrays.asList(TimestampBound.strong(), TimestampBound.ofReadTimestamp((Timestamp)((Timestamp)timestamps.get(TimestampBound.Mode.READ_TIMESTAMP))), TimestampBound.ofMinReadTimestamp((Timestamp)((Timestamp)timestamps.get(TimestampBound.Mode.MIN_READ_TIMESTAMP))), TimestampBound.ofExactStaleness((long)((StalenessDuration)durations.get(TimestampBound.Mode.EXACT_STALENESS)).duration, (TimeUnit)((StalenessDuration)durations.get(TimestampBound.Mode.EXACT_STALENESS)).unit), TimestampBound.ofMaxStaleness((long)((StalenessDuration)durations.get(TimestampBound.Mode.MAX_STALENESS)).duration, (TimeUnit)((StalenessDuration)durations.get(TimestampBound.Mode.MAX_STALENESS)).unit));
        try (ConnectionImpl subject = ConnectionImplTest.createConnection(ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setUri(URI).build());){
            for (TimestampBound staleness : stalenesses) {
                StatementResult res = subject.execute(Statement.of((String)String.format("set read_only_staleness='%s'", ReadOnlyStalenessUtil.timestampBoundToString((TimestampBound)staleness))));
                MatcherAssert.assertThat((Object)res.getResultType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)StatementResult.ResultType.NO_RESULT)));
                MatcherAssert.assertThat((Object)subject.getReadOnlyStaleness(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)staleness)));
            }
        }
    }

    @Test
    public void testExecuteBeginTransaction() {
        try (ConnectionImpl subject = ConnectionImplTest.createConnection(ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setUri(URI).build());){
            MatcherAssert.assertThat((Object)subject.isInTransaction(), (Matcher)CoreMatchers.is((Object)false));
            StatementResult res = subject.execute(Statement.of((String)"begin transaction"));
            MatcherAssert.assertThat((Object)res.getResultType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)StatementResult.ResultType.NO_RESULT)));
            MatcherAssert.assertThat((Object)subject.isInTransaction(), (Matcher)CoreMatchers.is((Object)true));
        }
    }

    @Test
    public void testExecuteCommitTransaction() {
        try (ConnectionImpl subject = ConnectionImplTest.createConnection(ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setUri(URI).build());){
            subject.execute(Statement.of((String)"begin transaction"));
            MatcherAssert.assertThat((Object)subject.isInTransaction(), (Matcher)CoreMatchers.is((Object)true));
            StatementResult res = subject.execute(Statement.of((String)"commit"));
            MatcherAssert.assertThat((Object)res.getResultType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)StatementResult.ResultType.NO_RESULT)));
            MatcherAssert.assertThat((Object)subject.isInTransaction(), (Matcher)CoreMatchers.is((Object)false));
        }
    }

    @Test
    public void testExecuteRollbackTransaction() {
        try (ConnectionImpl subject = ConnectionImplTest.createConnection(ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setUri(URI).build());){
            subject.execute(Statement.of((String)"begin"));
            MatcherAssert.assertThat((Object)subject.isInTransaction(), (Matcher)CoreMatchers.is((Object)true));
            StatementResult res = subject.execute(Statement.of((String)"rollback"));
            MatcherAssert.assertThat((Object)res.getResultType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)StatementResult.ResultType.NO_RESULT)));
            MatcherAssert.assertThat((Object)subject.isInTransaction(), (Matcher)CoreMatchers.is((Object)false));
        }
    }

    @Test
    public void testExecuteSetTransactionReadOnly() {
        try (ConnectionImpl subject = ConnectionImplTest.createConnection(ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setUri(URI).build());){
            subject.execute(Statement.of((String)"begin"));
            MatcherAssert.assertThat((Object)subject.getTransactionMode(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)TransactionMode.READ_WRITE_TRANSACTION)));
            MatcherAssert.assertThat((Object)subject.isInTransaction(), (Matcher)CoreMatchers.is((Object)true));
            StatementResult res = subject.execute(Statement.of((String)"set transaction read only"));
            MatcherAssert.assertThat((Object)res.getResultType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)StatementResult.ResultType.NO_RESULT)));
            MatcherAssert.assertThat((Object)subject.getTransactionMode(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)TransactionMode.READ_ONLY_TRANSACTION)));
        }
    }

    @Test
    public void testExecuteSetTransactionReadWrite() {
        try (ConnectionImpl subject = ConnectionImplTest.createConnection(ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setUri("cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database;readonly=true").build());){
            subject.execute(Statement.of((String)"begin"));
            MatcherAssert.assertThat((Object)subject.getTransactionMode(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)TransactionMode.READ_ONLY_TRANSACTION)));
            MatcherAssert.assertThat((Object)subject.isInTransaction(), (Matcher)CoreMatchers.is((Object)true));
            subject.execute(Statement.of((String)"commit"));
            subject.execute(Statement.of((String)"set readonly = false"));
            subject.execute(Statement.of((String)"begin"));
            StatementResult res = subject.execute(Statement.of((String)"set transaction read only"));
            MatcherAssert.assertThat((Object)res.getResultType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)StatementResult.ResultType.NO_RESULT)));
            MatcherAssert.assertThat((Object)subject.getTransactionMode(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)TransactionMode.READ_ONLY_TRANSACTION)));
            res = subject.execute(Statement.of((String)"set transaction read write"));
            MatcherAssert.assertThat((Object)res.getResultType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)StatementResult.ResultType.NO_RESULT)));
            MatcherAssert.assertThat((Object)subject.getTransactionMode(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)TransactionMode.READ_WRITE_TRANSACTION)));
        }
    }

    @Test
    public void testExecuteStartDdlBatch() {
        try (ConnectionImpl subject = ConnectionImplTest.createConnection(ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setUri(URI).build());){
            StatementResult res = subject.execute(Statement.of((String)"start batch ddl"));
            MatcherAssert.assertThat((Object)res.getResultType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)StatementResult.ResultType.NO_RESULT)));
            MatcherAssert.assertThat((Object)subject.getUnitOfWorkType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)ConnectionImpl.UnitOfWorkType.DDL_BATCH)));
            MatcherAssert.assertThat((Object)subject.isInTransaction(), (Matcher)CoreMatchers.is((Object)false));
        }
    }

    @Test
    public void testDefaultIsAutocommit() {
        try (ConnectionImpl subject = ConnectionImplTest.createConnection(ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setUri(URI).build());){
            MatcherAssert.assertThat((Object)subject.isAutocommit(), (Matcher)CoreMatchers.is((Object)true));
            MatcherAssert.assertThat((Object)subject.isInTransaction(), (Matcher)CoreMatchers.is((Object)false));
        }
    }

    @Test
    public void testDefaultIsReadWrite() {
        try (ConnectionImpl subject = ConnectionImplTest.createConnection(ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setUri(URI).build());){
            MatcherAssert.assertThat((Object)subject.isReadOnly(), (Matcher)CoreMatchers.is((Object)false));
        }
    }

    @Test
    public void testDefaultTransactionIsReadWrite() {
        try (ConnectionImpl subject = ConnectionImplTest.createConnection(ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setUri(URI).build());){
            Boolean[] booleanArray = new Boolean[]{true, false};
            int n = booleanArray.length;
            for (int i = 0; i < n; ++i) {
                boolean autocommit = booleanArray[i];
                subject.setAutocommit(autocommit);
                subject.execute(Statement.of((String)"begin"));
                MatcherAssert.assertThat((Object)subject.getTransactionMode(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)TransactionMode.READ_WRITE_TRANSACTION)));
                subject.commit();
                subject.execute(Statement.of((String)"begin"));
                subject.execute(Statement.of((String)"set transaction read only"));
                MatcherAssert.assertThat((Object)subject.getTransactionMode(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)TransactionMode.READ_ONLY_TRANSACTION)));
                subject.commit();
                subject.execute(Statement.of((String)"begin"));
                MatcherAssert.assertThat((Object)subject.getTransactionMode(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)TransactionMode.READ_WRITE_TRANSACTION)));
                subject.commit();
                subject.execute(Statement.of((String)"start batch ddl"));
                MatcherAssert.assertThat((Object)subject.getUnitOfWorkType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)ConnectionImpl.UnitOfWorkType.DDL_BATCH)));
                subject.runBatch();
                subject.execute(Statement.of((String)"begin"));
                MatcherAssert.assertThat((Object)subject.getTransactionMode(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)TransactionMode.READ_WRITE_TRANSACTION)));
                subject.commit();
            }
        }
    }

    @Test
    public void testDefaultTransactionIsReadOnly() {
        try (ConnectionImpl subject = ConnectionImplTest.createConnection(ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setUri("cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database;readOnly=true").build());){
            Boolean[] booleanArray = new Boolean[]{true, false};
            int n = booleanArray.length;
            for (int i = 0; i < n; ++i) {
                boolean autocommit = booleanArray[i];
                subject.setAutocommit(autocommit);
                subject.execute(Statement.of((String)"begin"));
                MatcherAssert.assertThat((Object)subject.getTransactionMode(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)TransactionMode.READ_ONLY_TRANSACTION)));
                subject.commit();
            }
        }
    }

    @Test
    public void testResetReadOnlyStaleness() {
        try (ConnectionImpl subject = ConnectionImplTest.createConnection(ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setUri(URI).build());){
            MatcherAssert.assertThat((Object)subject.isAutocommit(), (Matcher)CoreMatchers.is((Object)true));
            MatcherAssert.assertThat((Object)subject.getReadOnlyStaleness().getMode(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)TimestampBound.Mode.STRONG)));
            subject.setReadOnlyStaleness(TimestampBound.strong());
            MatcherAssert.assertThat((Object)subject.getReadOnlyStaleness().getMode(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)TimestampBound.Mode.STRONG)));
            subject.setAutocommit(false);
            MatcherAssert.assertThat((Object)subject.getReadOnlyStaleness().getMode(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)TimestampBound.Mode.STRONG)));
            subject.setAutocommit(true);
            MatcherAssert.assertThat((Object)subject.getReadOnlyStaleness().getMode(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)TimestampBound.Mode.STRONG)));
            subject.setReadOnlyStaleness(TimestampBound.ofReadTimestamp((Timestamp)Timestamp.MAX_VALUE));
            subject.setAutocommit(false);
            MatcherAssert.assertThat((Object)subject.getReadOnlyStaleness(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)TimestampBound.ofReadTimestamp((Timestamp)Timestamp.MAX_VALUE))));
            subject.setAutocommit(true);
            MatcherAssert.assertThat((Object)subject.getReadOnlyStaleness(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)TimestampBound.ofReadTimestamp((Timestamp)Timestamp.MAX_VALUE))));
            subject.setReadOnlyStaleness(TimestampBound.ofExactStaleness((long)10L, (TimeUnit)TimeUnit.SECONDS));
            subject.setAutocommit(false);
            MatcherAssert.assertThat((Object)subject.getReadOnlyStaleness(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)TimestampBound.ofExactStaleness((long)10L, (TimeUnit)TimeUnit.SECONDS))));
            subject.setAutocommit(true);
            MatcherAssert.assertThat((Object)subject.getReadOnlyStaleness(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)TimestampBound.ofExactStaleness((long)10L, (TimeUnit)TimeUnit.SECONDS))));
            subject.setReadOnlyStaleness(TimestampBound.ofMinReadTimestamp((Timestamp)Timestamp.MAX_VALUE));
            MatcherAssert.assertThat((Object)subject.getReadOnlyStaleness(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)TimestampBound.ofMinReadTimestamp((Timestamp)Timestamp.MAX_VALUE))));
            subject.setAutocommit(false);
            MatcherAssert.assertThat((Object)subject.getReadOnlyStaleness().getMode(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)TimestampBound.Mode.STRONG)));
            subject.setAutocommit(true);
            MatcherAssert.assertThat((Object)subject.getReadOnlyStaleness().getMode(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)TimestampBound.Mode.STRONG)));
            subject.setReadOnlyStaleness(TimestampBound.ofMaxStaleness((long)10L, (TimeUnit)TimeUnit.SECONDS));
            MatcherAssert.assertThat((Object)subject.getReadOnlyStaleness(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)TimestampBound.ofMaxStaleness((long)10L, (TimeUnit)TimeUnit.SECONDS))));
            subject.setAutocommit(false);
            MatcherAssert.assertThat((Object)subject.getReadOnlyStaleness().getMode(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)TimestampBound.Mode.STRONG)));
            subject.setAutocommit(true);
            MatcherAssert.assertThat((Object)subject.getReadOnlyStaleness().getMode(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)TimestampBound.Mode.STRONG)));
        }
    }

    @Test
    public void testChangeReadOnlyModeInAutocommit() {
        try (ConnectionImpl subject = ConnectionImplTest.createConnection(ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setUri(URI).build());){
            subject.execute(Statement.of((String)"UPDATE foo SET bar=1"));
            MatcherAssert.assertThat((Object)subject.getCommitTimestamp(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
            subject.setReadOnly(true);
            AbstractConnectionImplTest.expectSpannerException("Updates should not be allowed in read-only mode", connection -> connection.execute(Statement.of((String)"UPDATE foo SET bar=1")), (Connection)subject);
            MatcherAssert.assertThat((Object)subject.executeQuery(Statement.of((String)"SELECT 1 AS TEST"), new Options.QueryOption[0]), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
            subject.setReadOnly(false);
            subject.execute(Statement.of((String)"UPDATE foo SET bar=1"));
            MatcherAssert.assertThat((Object)subject.getCommitTimestamp(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
            subject.setReadOnly(true);
            AbstractConnectionImplTest.expectSpannerException("DDL should not be allowed in read-only mode", connection -> connection.execute(Statement.of((String)"CREATE TABLE foo (id INT64 NOT NULL, name STRING(100)) PRIMARY KEY (id)")), (Connection)subject);
            MatcherAssert.assertThat((Object)subject.executeQuery(Statement.of((String)"SELECT 1 AS TEST"), new Options.QueryOption[0]), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        }
    }

    @Test
    public void testChangeReadOnlyModeInTransactionalMode() {
        try (ConnectionImpl subject = ConnectionImplTest.createConnection(ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setUri(URI).build());){
            subject.setAutocommit(false);
            subject.execute(Statement.of((String)"UPDATE foo SET bar=1"));
            subject.commit();
            MatcherAssert.assertThat((Object)subject.getCommitTimestamp(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
            subject.setReadOnly(true);
            AbstractConnectionImplTest.expectSpannerException("Updates should not be allowed in read-only mode", connection -> connection.execute(Statement.of((String)"UPDATE foo SET bar=1")), (Connection)subject);
            MatcherAssert.assertThat((Object)subject.executeQuery(Statement.of((String)"SELECT 1 AS TEST"), new Options.QueryOption[0]), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
            subject.commit();
            subject.setReadOnly(false);
            subject.execute(Statement.of((String)"UPDATE foo SET bar=1"));
            subject.commit();
            MatcherAssert.assertThat((Object)subject.getCommitTimestamp(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
            subject.setReadOnly(true);
            AbstractConnectionImplTest.expectSpannerException("DDL should not be allowed in read-only mode", connection -> connection.execute(Statement.of((String)"CREATE TABLE foo (id INT64 NOT NULL, name STRING(100)) PRIMARY KEY (id)")), (Connection)subject);
            MatcherAssert.assertThat((Object)subject.executeQuery(Statement.of((String)"SELECT 1 AS TEST"), new Options.QueryOption[0]), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        }
    }

    @Test
    public void testAddRemoveTransactionRetryListener() {
        try (ConnectionImpl subject = ConnectionImplTest.createConnection(ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setUri(URI).build());){
            MatcherAssert.assertThat((Object)subject.getTransactionRetryListeners().hasNext(), (Matcher)CoreMatchers.is((Object)false));
            TransactionRetryListener listener = (TransactionRetryListener)Mockito.mock(TransactionRetryListener.class);
            subject.addTransactionRetryListener(listener);
            MatcherAssert.assertThat((Object)subject.getTransactionRetryListeners().hasNext(), (Matcher)CoreMatchers.is((Object)true));
            MatcherAssert.assertThat((Object)subject.removeTransactionRetryListener(listener), (Matcher)CoreMatchers.is((Object)true));
            MatcherAssert.assertThat((Object)subject.getTransactionRetryListeners().hasNext(), (Matcher)CoreMatchers.is((Object)false));
            MatcherAssert.assertThat((Object)subject.removeTransactionRetryListener(listener), (Matcher)CoreMatchers.is((Object)false));
        }
    }

    @Test
    public void testMergeQueryOptions() {
        ConnectionOptions connectionOptions = (ConnectionOptions)Mockito.mock(ConnectionOptions.class);
        SpannerPool spannerPool = (SpannerPool)Mockito.mock(SpannerPool.class);
        DdlClient ddlClient = (DdlClient)Mockito.mock(DdlClient.class);
        DatabaseClient dbClient = (DatabaseClient)Mockito.mock(DatabaseClient.class);
        Mockito.when((Object)dbClient.getDialect()).thenReturn((Object)Dialect.GOOGLE_STANDARD_SQL);
        final UnitOfWork unitOfWork = (UnitOfWork)Mockito.mock(UnitOfWork.class);
        Mockito.when((Object)unitOfWork.executeQueryAsync((UnitOfWork.CallType)Mockito.any(), (AbstractStatementParser.ParsedStatement)Mockito.any(AbstractStatementParser.ParsedStatement.class), (AnalyzeMode)Mockito.any(AnalyzeMode.class), new Options.QueryOption[]{(Options.QueryOption)Mockito.any()})).thenReturn((Object)ApiFutures.immediateFuture((Object)((ResultSet)Mockito.mock(ResultSet.class))));
        try (ConnectionImpl impl = new ConnectionImpl(connectionOptions, spannerPool, ddlClient, dbClient, (BatchClient)Mockito.mock(BatchClient.class)){

            UnitOfWork getCurrentUnitOfWorkOrStartNewUnitOfWork(boolean isInternalMetadataQuery) {
                return unitOfWork;
            }
        };){
            impl.setOptimizerVersion("1");
            impl.setOptimizerStatisticsPackage("custom-package-1");
            impl.executeQuery(Statement.of((String)"SELECT FOO FROM BAR"), new Options.QueryOption[0]);
            ((UnitOfWork)Mockito.verify((Object)unitOfWork)).executeQueryAsync(UnitOfWork.CallType.SYNC, AbstractStatementParser.getInstance((Dialect)Dialect.GOOGLE_STANDARD_SQL).parse(Statement.newBuilder((String)"SELECT FOO FROM BAR").withQueryOptions(ExecuteSqlRequest.QueryOptions.newBuilder().setOptimizerVersion("1").setOptimizerStatisticsPackage("custom-package-1").build()).build()), AnalyzeMode.NONE, new Options.QueryOption[0]);
            impl.setOptimizerVersion("2");
            impl.setOptimizerStatisticsPackage("custom-package-2");
            impl.executeQuery(Statement.of((String)"SELECT FOO FROM BAR"), new Options.QueryOption[0]);
            ((UnitOfWork)Mockito.verify((Object)unitOfWork)).executeQueryAsync(UnitOfWork.CallType.SYNC, AbstractStatementParser.getInstance((Dialect)Dialect.GOOGLE_STANDARD_SQL).parse(Statement.newBuilder((String)"SELECT FOO FROM BAR").withQueryOptions(ExecuteSqlRequest.QueryOptions.newBuilder().setOptimizerVersion("2").setOptimizerStatisticsPackage("custom-package-2").build()).build()), AnalyzeMode.NONE, new Options.QueryOption[0]);
            Options.ReadAndQueryOption prefetchOption = Options.prefetchChunks((int)100);
            impl.setOptimizerVersion("3");
            impl.setOptimizerStatisticsPackage("custom-package-3");
            impl.executeQuery(Statement.of((String)"SELECT FOO FROM BAR"), new Options.QueryOption[]{prefetchOption});
            ((UnitOfWork)Mockito.verify((Object)unitOfWork)).executeQueryAsync(UnitOfWork.CallType.SYNC, AbstractStatementParser.getInstance((Dialect)Dialect.GOOGLE_STANDARD_SQL).parse(Statement.newBuilder((String)"SELECT FOO FROM BAR").withQueryOptions(ExecuteSqlRequest.QueryOptions.newBuilder().setOptimizerVersion("3").setOptimizerStatisticsPackage("custom-package-3").build()).build()), AnalyzeMode.NONE, new Options.QueryOption[]{prefetchOption});
            impl.setOptimizerVersion("4");
            impl.setOptimizerStatisticsPackage("custom-package-4");
            impl.executeQuery(Statement.newBuilder((String)"SELECT FOO FROM BAR").withQueryOptions(ExecuteSqlRequest.QueryOptions.newBuilder().setOptimizerVersion("5").setOptimizerStatisticsPackage("custom-package-5").build()).build(), new Options.QueryOption[]{prefetchOption});
            ((UnitOfWork)Mockito.verify((Object)unitOfWork)).executeQueryAsync(UnitOfWork.CallType.SYNC, AbstractStatementParser.getInstance((Dialect)Dialect.GOOGLE_STANDARD_SQL).parse(Statement.newBuilder((String)"SELECT FOO FROM BAR").withQueryOptions(ExecuteSqlRequest.QueryOptions.newBuilder().setOptimizerVersion("5").setOptimizerStatisticsPackage("custom-package-5").build()).build()), AnalyzeMode.NONE, new Options.QueryOption[]{prefetchOption});
        }
    }

    @Test
    public void testStatementTagAlwaysAllowed() {
        ConnectionOptions connectionOptions = (ConnectionOptions)Mockito.mock(ConnectionOptions.class);
        Mockito.when((Object)connectionOptions.isAutocommit()).thenReturn((Object)true);
        SpannerPool spannerPool = (SpannerPool)Mockito.mock(SpannerPool.class);
        DdlClient ddlClient = (DdlClient)Mockito.mock(DdlClient.class);
        DatabaseClient dbClient = (DatabaseClient)Mockito.mock(DatabaseClient.class);
        Mockito.when((Object)dbClient.getDialect()).thenReturn((Object)Dialect.GOOGLE_STANDARD_SQL);
        final UnitOfWork unitOfWork = (UnitOfWork)Mockito.mock(UnitOfWork.class);
        Mockito.when((Object)unitOfWork.executeQueryAsync((UnitOfWork.CallType)Mockito.any(), (AbstractStatementParser.ParsedStatement)Mockito.any(AbstractStatementParser.ParsedStatement.class), (AnalyzeMode)Mockito.any(AnalyzeMode.class), new Options.QueryOption[]{(Options.QueryOption)Mockito.any()})).thenReturn((Object)ApiFutures.immediateFuture((Object)((ResultSet)Mockito.mock(ResultSet.class))));
        try (ConnectionImpl connection = new ConnectionImpl(connectionOptions, spannerPool, ddlClient, dbClient, (BatchClient)Mockito.mock(BatchClient.class)){

            UnitOfWork getCurrentUnitOfWorkOrStartNewUnitOfWork(boolean isInternalMetadataQuery) {
                return unitOfWork;
            }
        };){
            Assert.assertTrue((boolean)connection.isAutocommit());
            Assert.assertNull((Object)connection.getStatementTag());
            connection.setStatementTag("tag");
            Assert.assertEquals((Object)"tag", (Object)connection.getStatementTag());
            connection.setStatementTag(null);
            Assert.assertNull((Object)connection.getStatementTag());
            connection.setAutocommit(false);
            connection.setStatementTag("tag");
            Assert.assertEquals((Object)"tag", (Object)connection.getStatementTag());
            connection.setStatementTag(null);
            Assert.assertNull((Object)connection.getStatementTag());
            connection.execute(Statement.of((String)"SELECT FOO FROM BAR"));
            connection.setStatementTag("tag");
            Assert.assertEquals((Object)"tag", (Object)connection.getStatementTag());
            connection.setStatementTag(null);
            Assert.assertNull((Object)connection.getStatementTag());
        }
    }

    @Test
    public void testTransactionTagAllowedInTransaction() {
        ConnectionOptions connectionOptions = (ConnectionOptions)Mockito.mock(ConnectionOptions.class);
        Mockito.when((Object)connectionOptions.isAutocommit()).thenReturn((Object)false);
        SpannerPool spannerPool = (SpannerPool)Mockito.mock(SpannerPool.class);
        DdlClient ddlClient = (DdlClient)Mockito.mock(DdlClient.class);
        DatabaseClient dbClient = (DatabaseClient)Mockito.mock(DatabaseClient.class);
        Mockito.when((Object)dbClient.getDialect()).thenReturn((Object)Dialect.GOOGLE_STANDARD_SQL);
        try (ConnectionImpl connection = new ConnectionImpl(connectionOptions, spannerPool, ddlClient, dbClient, (BatchClient)Mockito.mock(BatchClient.class));){
            Assert.assertFalse((boolean)connection.isAutocommit());
            Assert.assertNull((Object)connection.getTransactionTag());
            connection.setTransactionTag("tag");
            Assert.assertEquals((Object)"tag", (Object)connection.getTransactionTag());
            connection.setTransactionTag(null);
            Assert.assertNull((Object)connection.getTransactionTag());
            connection.setTransactionTag("tag");
            Assert.assertEquals((Object)"tag", (Object)connection.getTransactionTag());
            connection.commit();
            Assert.assertNull((Object)connection.getTransactionTag());
            connection.setTransactionTag("tag");
            Assert.assertEquals((Object)"tag", (Object)connection.getTransactionTag());
            connection.rollback();
            Assert.assertNull((Object)connection.getTransactionTag());
            connection.setAutocommit(false);
            connection.beginTransaction();
            Assert.assertNull((Object)connection.getTransactionTag());
            connection.setTransactionTag("tag");
            Assert.assertEquals((Object)"tag", (Object)connection.getTransactionTag());
            connection.commit();
            Assert.assertNull((Object)connection.getTransactionTag());
        }
    }

    @Test
    public void testTransactionTagNotAllowedWithoutTransaction() {
        ConnectionOptions connectionOptions = (ConnectionOptions)Mockito.mock(ConnectionOptions.class);
        Mockito.when((Object)connectionOptions.isAutocommit()).thenReturn((Object)true);
        SpannerPool spannerPool = (SpannerPool)Mockito.mock(SpannerPool.class);
        DdlClient ddlClient = (DdlClient)Mockito.mock(DdlClient.class);
        DatabaseClient dbClient = (DatabaseClient)Mockito.mock(DatabaseClient.class);
        Mockito.when((Object)dbClient.getDialect()).thenReturn((Object)Dialect.GOOGLE_STANDARD_SQL);
        try (ConnectionImpl connection = new ConnectionImpl(connectionOptions, spannerPool, ddlClient, dbClient, (BatchClient)Mockito.mock(BatchClient.class));){
            Assert.assertTrue((boolean)connection.isAutocommit());
            try {
                connection.setTransactionTag("tag");
                Assert.fail((String)"missing expected exception");
            }
            catch (SpannerException e) {
                Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)e.getErrorCode());
            }
        }
    }

    @Test
    public void testTransactionTagNotAllowedAfterTransactionStarted() {
        ConnectionOptions connectionOptions = (ConnectionOptions)Mockito.mock(ConnectionOptions.class);
        Mockito.when((Object)connectionOptions.isAutocommit()).thenReturn((Object)false);
        SpannerPool spannerPool = (SpannerPool)Mockito.mock(SpannerPool.class);
        DdlClient ddlClient = (DdlClient)Mockito.mock(DdlClient.class);
        DatabaseClient dbClient = (DatabaseClient)Mockito.mock(DatabaseClient.class);
        Mockito.when((Object)dbClient.getDialect()).thenReturn((Object)Dialect.GOOGLE_STANDARD_SQL);
        final UnitOfWork unitOfWork = (UnitOfWork)Mockito.mock(UnitOfWork.class);
        Mockito.when((Object)unitOfWork.getState()).thenReturn((Object)UnitOfWork.UnitOfWorkState.STARTED);
        Mockito.when((Object)unitOfWork.executeQueryAsync((UnitOfWork.CallType)Mockito.any(), (AbstractStatementParser.ParsedStatement)Mockito.any(AbstractStatementParser.ParsedStatement.class), (AnalyzeMode)Mockito.any(AnalyzeMode.class), new Options.QueryOption[]{(Options.QueryOption)Mockito.any()})).thenReturn((Object)ApiFutures.immediateFuture((Object)((ResultSet)Mockito.mock(ResultSet.class))));
        Mockito.when((Object)unitOfWork.rollbackAsync((UnitOfWork.CallType)Mockito.any())).thenReturn((Object)ApiFutures.immediateFuture(null));
        try (ConnectionImpl connection = new ConnectionImpl(connectionOptions, spannerPool, ddlClient, dbClient, (BatchClient)Mockito.mock(BatchClient.class)){

            UnitOfWork createNewUnitOfWork(boolean isInternalMetadataQuery) {
                return unitOfWork;
            }
        };){
            connection.execute(Statement.of((String)"SELECT FOO FROM BAR"));
            try {
                connection.setTransactionTag("tag");
                Assert.fail((String)"missing expected exception");
            }
            catch (SpannerException e) {
                Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)e.getErrorCode());
            }
            Assert.assertNull((Object)connection.getTransactionTag());
        }
    }

    @Test
    public void testCheckResultTypeAllowed() {
        AbstractStatementParser parser = AbstractStatementParser.getInstance((Dialect)Dialect.GOOGLE_STANDARD_SQL);
        String query = "select * from foo";
        String dml = "update foo set bar=1 where true";
        String dmlReturning = "insert into foo (id, value) values (1, 'One') then return id";
        String ddl = "create table foo";
        String set = "set readonly=true";
        String show = "show variable readonly";
        String start = "start batch dml";
        ImmutableSet allowedResultTypes = null;
        ConnectionImpl.checkResultTypeAllowed((AbstractStatementParser.ParsedStatement)parser.parse(Statement.of((String)query)), allowedResultTypes);
        ConnectionImpl.checkResultTypeAllowed((AbstractStatementParser.ParsedStatement)parser.parse(Statement.of((String)dml)), allowedResultTypes);
        ConnectionImpl.checkResultTypeAllowed((AbstractStatementParser.ParsedStatement)parser.parse(Statement.of((String)dmlReturning)), allowedResultTypes);
        ConnectionImpl.checkResultTypeAllowed((AbstractStatementParser.ParsedStatement)parser.parse(Statement.of((String)ddl)), allowedResultTypes);
        ConnectionImpl.checkResultTypeAllowed((AbstractStatementParser.ParsedStatement)parser.parse(Statement.of((String)set)), allowedResultTypes);
        ConnectionImpl.checkResultTypeAllowed((AbstractStatementParser.ParsedStatement)parser.parse(Statement.of((String)show)), allowedResultTypes);
        ConnectionImpl.checkResultTypeAllowed((AbstractStatementParser.ParsedStatement)parser.parse(Statement.of((String)start)), allowedResultTypes);
        allowedResultTypes = ImmutableSet.of();
        this.assertThrowResultNotAllowed(parser, query, (ImmutableSet<StatementResult.ResultType>)allowedResultTypes);
        this.assertThrowResultNotAllowed(parser, dml, (ImmutableSet<StatementResult.ResultType>)allowedResultTypes);
        this.assertThrowResultNotAllowed(parser, dmlReturning, (ImmutableSet<StatementResult.ResultType>)allowedResultTypes);
        this.assertThrowResultNotAllowed(parser, ddl, (ImmutableSet<StatementResult.ResultType>)allowedResultTypes);
        this.assertThrowResultNotAllowed(parser, set, (ImmutableSet<StatementResult.ResultType>)allowedResultTypes);
        this.assertThrowResultNotAllowed(parser, show, (ImmutableSet<StatementResult.ResultType>)allowedResultTypes);
        this.assertThrowResultNotAllowed(parser, start, (ImmutableSet<StatementResult.ResultType>)allowedResultTypes);
        allowedResultTypes = ImmutableSet.of((Object)StatementResult.ResultType.RESULT_SET);
        ConnectionImpl.checkResultTypeAllowed((AbstractStatementParser.ParsedStatement)parser.parse(Statement.of((String)query)), (Set)allowedResultTypes);
        this.assertThrowResultNotAllowed(parser, dml, (ImmutableSet<StatementResult.ResultType>)allowedResultTypes);
        ConnectionImpl.checkResultTypeAllowed((AbstractStatementParser.ParsedStatement)parser.parse(Statement.of((String)dmlReturning)), (Set)allowedResultTypes);
        this.assertThrowResultNotAllowed(parser, ddl, (ImmutableSet<StatementResult.ResultType>)allowedResultTypes);
        this.assertThrowResultNotAllowed(parser, set, (ImmutableSet<StatementResult.ResultType>)allowedResultTypes);
        ConnectionImpl.checkResultTypeAllowed((AbstractStatementParser.ParsedStatement)parser.parse(Statement.of((String)show)), (Set)allowedResultTypes);
        this.assertThrowResultNotAllowed(parser, start, (ImmutableSet<StatementResult.ResultType>)allowedResultTypes);
        allowedResultTypes = ImmutableSet.of((Object)StatementResult.ResultType.UPDATE_COUNT);
        this.assertThrowResultNotAllowed(parser, query, (ImmutableSet<StatementResult.ResultType>)allowedResultTypes);
        ConnectionImpl.checkResultTypeAllowed((AbstractStatementParser.ParsedStatement)parser.parse(Statement.of((String)dml)), (Set)allowedResultTypes);
        this.assertThrowResultNotAllowed(parser, dmlReturning, (ImmutableSet<StatementResult.ResultType>)allowedResultTypes);
        this.assertThrowResultNotAllowed(parser, ddl, (ImmutableSet<StatementResult.ResultType>)allowedResultTypes);
        this.assertThrowResultNotAllowed(parser, set, (ImmutableSet<StatementResult.ResultType>)allowedResultTypes);
        this.assertThrowResultNotAllowed(parser, show, (ImmutableSet<StatementResult.ResultType>)allowedResultTypes);
        this.assertThrowResultNotAllowed(parser, start, (ImmutableSet<StatementResult.ResultType>)allowedResultTypes);
        allowedResultTypes = ImmutableSet.of((Object)StatementResult.ResultType.NO_RESULT);
        this.assertThrowResultNotAllowed(parser, query, (ImmutableSet<StatementResult.ResultType>)allowedResultTypes);
        this.assertThrowResultNotAllowed(parser, dml, (ImmutableSet<StatementResult.ResultType>)allowedResultTypes);
        this.assertThrowResultNotAllowed(parser, dmlReturning, (ImmutableSet<StatementResult.ResultType>)allowedResultTypes);
        ConnectionImpl.checkResultTypeAllowed((AbstractStatementParser.ParsedStatement)parser.parse(Statement.of((String)ddl)), (Set)allowedResultTypes);
        ConnectionImpl.checkResultTypeAllowed((AbstractStatementParser.ParsedStatement)parser.parse(Statement.of((String)set)), (Set)allowedResultTypes);
        this.assertThrowResultNotAllowed(parser, show, (ImmutableSet<StatementResult.ResultType>)allowedResultTypes);
        ConnectionImpl.checkResultTypeAllowed((AbstractStatementParser.ParsedStatement)parser.parse(Statement.of((String)start)), (Set)allowedResultTypes);
        allowedResultTypes = ImmutableSet.of((Object)StatementResult.ResultType.RESULT_SET, (Object)StatementResult.ResultType.UPDATE_COUNT);
        ConnectionImpl.checkResultTypeAllowed((AbstractStatementParser.ParsedStatement)parser.parse(Statement.of((String)query)), (Set)allowedResultTypes);
        ConnectionImpl.checkResultTypeAllowed((AbstractStatementParser.ParsedStatement)parser.parse(Statement.of((String)dml)), (Set)allowedResultTypes);
        ConnectionImpl.checkResultTypeAllowed((AbstractStatementParser.ParsedStatement)parser.parse(Statement.of((String)dmlReturning)), (Set)allowedResultTypes);
        this.assertThrowResultNotAllowed(parser, ddl, (ImmutableSet<StatementResult.ResultType>)allowedResultTypes);
        this.assertThrowResultNotAllowed(parser, set, (ImmutableSet<StatementResult.ResultType>)allowedResultTypes);
        ConnectionImpl.checkResultTypeAllowed((AbstractStatementParser.ParsedStatement)parser.parse(Statement.of((String)show)), (Set)allowedResultTypes);
        this.assertThrowResultNotAllowed(parser, start, (ImmutableSet<StatementResult.ResultType>)allowedResultTypes);
        allowedResultTypes = ImmutableSet.of((Object)StatementResult.ResultType.RESULT_SET, (Object)StatementResult.ResultType.NO_RESULT);
        ConnectionImpl.checkResultTypeAllowed((AbstractStatementParser.ParsedStatement)parser.parse(Statement.of((String)query)), (Set)allowedResultTypes);
        this.assertThrowResultNotAllowed(parser, dml, (ImmutableSet<StatementResult.ResultType>)allowedResultTypes);
        ConnectionImpl.checkResultTypeAllowed((AbstractStatementParser.ParsedStatement)parser.parse(Statement.of((String)dmlReturning)), (Set)allowedResultTypes);
        ConnectionImpl.checkResultTypeAllowed((AbstractStatementParser.ParsedStatement)parser.parse(Statement.of((String)ddl)), (Set)allowedResultTypes);
        ConnectionImpl.checkResultTypeAllowed((AbstractStatementParser.ParsedStatement)parser.parse(Statement.of((String)set)), (Set)allowedResultTypes);
        ConnectionImpl.checkResultTypeAllowed((AbstractStatementParser.ParsedStatement)parser.parse(Statement.of((String)show)), (Set)allowedResultTypes);
        ConnectionImpl.checkResultTypeAllowed((AbstractStatementParser.ParsedStatement)parser.parse(Statement.of((String)start)), (Set)allowedResultTypes);
        allowedResultTypes = ImmutableSet.of((Object)StatementResult.ResultType.UPDATE_COUNT, (Object)StatementResult.ResultType.NO_RESULT);
        this.assertThrowResultNotAllowed(parser, query, (ImmutableSet<StatementResult.ResultType>)allowedResultTypes);
        ConnectionImpl.checkResultTypeAllowed((AbstractStatementParser.ParsedStatement)parser.parse(Statement.of((String)dml)), (Set)allowedResultTypes);
        this.assertThrowResultNotAllowed(parser, dmlReturning, (ImmutableSet<StatementResult.ResultType>)allowedResultTypes);
        ConnectionImpl.checkResultTypeAllowed((AbstractStatementParser.ParsedStatement)parser.parse(Statement.of((String)ddl)), (Set)allowedResultTypes);
        ConnectionImpl.checkResultTypeAllowed((AbstractStatementParser.ParsedStatement)parser.parse(Statement.of((String)set)), (Set)allowedResultTypes);
        this.assertThrowResultNotAllowed(parser, show, (ImmutableSet<StatementResult.ResultType>)allowedResultTypes);
        ConnectionImpl.checkResultTypeAllowed((AbstractStatementParser.ParsedStatement)parser.parse(Statement.of((String)start)), (Set)allowedResultTypes);
        allowedResultTypes = ImmutableSet.of((Object)StatementResult.ResultType.RESULT_SET, (Object)StatementResult.ResultType.UPDATE_COUNT, (Object)StatementResult.ResultType.NO_RESULT);
        ConnectionImpl.checkResultTypeAllowed((AbstractStatementParser.ParsedStatement)parser.parse(Statement.of((String)query)), (Set)allowedResultTypes);
        ConnectionImpl.checkResultTypeAllowed((AbstractStatementParser.ParsedStatement)parser.parse(Statement.of((String)dml)), (Set)allowedResultTypes);
        ConnectionImpl.checkResultTypeAllowed((AbstractStatementParser.ParsedStatement)parser.parse(Statement.of((String)dmlReturning)), (Set)allowedResultTypes);
        ConnectionImpl.checkResultTypeAllowed((AbstractStatementParser.ParsedStatement)parser.parse(Statement.of((String)ddl)), (Set)allowedResultTypes);
        ConnectionImpl.checkResultTypeAllowed((AbstractStatementParser.ParsedStatement)parser.parse(Statement.of((String)set)), (Set)allowedResultTypes);
        ConnectionImpl.checkResultTypeAllowed((AbstractStatementParser.ParsedStatement)parser.parse(Statement.of((String)show)), (Set)allowedResultTypes);
        ConnectionImpl.checkResultTypeAllowed((AbstractStatementParser.ParsedStatement)parser.parse(Statement.of((String)start)), (Set)allowedResultTypes);
    }

    private void assertThrowResultNotAllowed(AbstractStatementParser parser, String sql, ImmutableSet<StatementResult.ResultType> allowedResultTypes) {
        SpannerException exception = (SpannerException)Assert.assertThrows(SpannerException.class, () -> ConnectionImpl.checkResultTypeAllowed((AbstractStatementParser.ParsedStatement)parser.parse(Statement.of((String)sql)), (Set)allowedResultTypes));
        Assert.assertEquals((Object)ErrorCode.INVALID_ARGUMENT, (Object)exception.getErrorCode());
        Assert.assertTrue((String)exception.getMessage(), (boolean)exception.getMessage().contains("Only statements that return a result of one of the following types are allowed"));
    }

    private static class SimpleResultSet
    extends ForwardingResultSet {
        private boolean nextCalled = false;
        private boolean onValidRow = false;
        private boolean hasNextReturnedFalse = false;

        SimpleResultSet(ResultSet delegate) {
            super(delegate);
        }

        public boolean next() {
            this.nextCalled = true;
            this.onValidRow = super.next();
            this.hasNextReturnedFalse = !this.onValidRow;
            return this.onValidRow;
        }

        boolean isNextCalled() {
            return this.nextCalled;
        }

        public ResultSetStats getStats() {
            if (this.hasNextReturnedFalse) {
                return super.getStats();
            }
            return null;
        }

        public long getLong(int columnIndex) {
            if (this.onValidRow) {
                return super.getLong(columnIndex);
            }
            throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.FAILED_PRECONDITION, (String)"ResultSet is not positioned on a valid row");
        }
    }

    private static final class StalenessDuration {
        private final long duration;
        private final TimeUnit unit;

        private StalenessDuration(long duration, TimeUnit unit) {
            this.duration = duration;
            this.unit = unit;
        }

        public String toString() {
            ReadOnlyStalenessUtil.GetExactStaleness getExactStalenessFunction = new ReadOnlyStalenessUtil.GetExactStaleness(TimestampBound.ofExactStaleness((long)this.duration, (TimeUnit)this.unit));
            return ReadOnlyStalenessUtil.durationToString((ReadOnlyStalenessUtil.DurationValueGetter)getExactStalenessFunction);
        }
    }

    static class SimpleTransactionManager
    implements TransactionManager {
        private TransactionManager.TransactionState state;
        private CommitResponse commitResponse;
        private TransactionContext txContext;
        private final boolean returnCommitStats;

        private SimpleTransactionManager(TransactionContext txContext, boolean returnCommitStats) {
            this.txContext = txContext;
            this.returnCommitStats = returnCommitStats;
        }

        public TransactionContext begin() {
            this.state = TransactionManager.TransactionState.STARTED;
            return this.txContext;
        }

        public void commit() {
            Timestamp commitTimestamp = Timestamp.now();
            this.commitResponse = (CommitResponse)Mockito.mock(CommitResponse.class);
            Mockito.when((Object)this.commitResponse.getCommitTimestamp()).thenReturn((Object)commitTimestamp);
            if (this.returnCommitStats) {
                CommitStats stats = (CommitStats)Mockito.mock(CommitStats.class);
                Mockito.when((Object)this.commitResponse.hasCommitStats()).thenReturn((Object)true);
                Mockito.when((Object)stats.getMutationCount()).thenReturn((Object)5L);
                Mockito.when((Object)this.commitResponse.getCommitStats()).thenReturn((Object)stats);
            }
            this.state = TransactionManager.TransactionState.COMMITTED;
        }

        public void rollback() {
            this.state = TransactionManager.TransactionState.ROLLED_BACK;
        }

        public TransactionContext resetForRetry() {
            return this.txContext;
        }

        public Timestamp getCommitTimestamp() {
            return this.commitResponse == null ? null : this.commitResponse.getCommitTimestamp();
        }

        public CommitResponse getCommitResponse() {
            return this.commitResponse;
        }

        public TransactionManager.TransactionState getState() {
            return this.state;
        }

        public void close() {
            if (this.state != TransactionManager.TransactionState.COMMITTED) {
                this.state = TransactionManager.TransactionState.ROLLED_BACK;
            }
        }
    }
}

