/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.api.gax.core.CredentialsProvider;
import com.google.auth.Credentials;
import com.google.auth.oauth2.OAuth2Credentials;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.connection.AbstractMockServerTest;
import com.google.cloud.spanner.connection.Connection;
import com.google.cloud.spanner.connection.ConnectionImpl;
import com.google.cloud.spanner.connection.ConnectionOptions;
import com.google.cloud.spanner.connection.ConnectionOptionsTest;
import io.grpc.ManagedChannelBuilder;
import java.io.ObjectStreamException;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CredentialsProviderTest
extends AbstractMockServerTest {
    private static final AtomicInteger COUNTER = new AtomicInteger();

    @BeforeClass
    public static void resetCounter() {
        COUNTER.set(0);
    }

    @Test
    public void testCredentialsProvider() throws Throwable {
        ConnectionOptionsTest.runWithSystemPropertyEnabled("ENABLE_CREDENTIALS_PROVIDER", () -> {
            TestCredentials credentials;
            ConnectionOptions options = ConnectionOptions.newBuilder().setUri(String.format("cloudspanner://localhost:%d/projects/proj/instances/inst/databases/db?credentialsProvider=%s", this.getPort(), TestCredentialsProvider.class.getName())).setConfigurator(spannerOptions -> spannerOptions.setChannelConfigurator(ManagedChannelBuilder::usePlaintext)).build();
            try (Connection connection = options.getConnection();){
                Assert.assertEquals(TestCredentials.class, ((SpannerOptions)((ConnectionImpl)connection).getSpanner().getOptions()).getCredentials().getClass());
                credentials = (TestCredentials)((SpannerOptions)((ConnectionImpl)connection).getSpanner().getOptions()).getCredentials();
                Assert.assertEquals((long)1L, (long)credentials.id);
            }
            connection = options.getConnection();
            try {
                Assert.assertEquals(TestCredentials.class, ((SpannerOptions)((ConnectionImpl)connection).getSpanner().getOptions()).getCredentials().getClass());
                credentials = (TestCredentials)((SpannerOptions)((ConnectionImpl)connection).getSpanner().getOptions()).getCredentials();
                Assert.assertEquals((long)1L, (long)credentials.id);
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
            options = ConnectionOptions.newBuilder().setUri(String.format("cloudspanner://localhost:%d/projects/proj/instances/inst/databases/db?credentialsProvider=%s", this.getPort(), TestCredentialsProvider.class.getName())).setConfigurator(spannerOptions -> spannerOptions.setChannelConfigurator(ManagedChannelBuilder::usePlaintext)).build();
            connection = options.getConnection();
            try {
                Assert.assertEquals(TestCredentials.class, ((SpannerOptions)((ConnectionImpl)connection).getSpanner().getOptions()).getCredentials().getClass());
                credentials = (TestCredentials)((SpannerOptions)((ConnectionImpl)connection).getSpanner().getOptions()).getCredentials();
                Assert.assertEquals((long)2L, (long)credentials.id);
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        });
    }

    static final class TestCredentialsProvider
    implements CredentialsProvider {
        TestCredentialsProvider() {
        }

        public Credentials getCredentials() {
            return new TestCredentials(COUNTER.incrementAndGet());
        }
    }

    private static final class TestCredentials
    extends OAuth2Credentials {
        private final int id;

        private TestCredentials(int id) {
            this.id = id;
        }

        private Object readResolve() throws ObjectStreamException {
            return this;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TestCredentials)) {
                return false;
            }
            return this.id == ((TestCredentials)((Object)obj)).id;
        }

        public int hashCode() {
            return System.identityHashCode(this.id);
        }
    }
}

