/*
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

NEW_CONNECTION;

@EXPECT RESULT_SET 'TEST',1
SELECT 1 AS TEST;

@EXPECT RESULT_SET 'READ_TIMESTAMP'
SHOW VARIABLE READ_TIMESTAMP;


NEW_CONNECTION;
INSERT INTO TEST (ID, NAME) VALUES (1, 'test');

@EXPECT RESULT_SET 'COMMIT_TIMESTAMP'
SHOW VARIABLE COMMIT_TIMESTAMP;


NEW_CONNECTION;

@EXPECT RESULT_SET 'ID',1
SELECT *
FROM TEST;

@EXPECT RESULT_SET 'READ_TIMESTAMP'
SHOW VARIABLE READ_TIMESTAMP;


NEW_CONNECTION;
@EXPECT UPDATE_COUNT 1
INSERT INTO TEST (ID, NAME) VALUES (2, 'FOO');

@EXPECT RESULT_SET 'COMMIT_TIMESTAMP'
SHOW VARIABLE COMMIT_TIMESTAMP;

@EXPECT RESULT_SET
SELECT COUNT(*) AS ACTUAL, 2 AS EXPECTED FROM TEST;

@EXPECT RESULT_SET 'READ_TIMESTAMP'
SHOW VARIABLE READ_TIMESTAMP;

-- Do an update in partitioned_non_atomic mode
SET AUTOCOMMIT_DML_MODE='PARTITIONED_NON_ATOMIC';

@EXPECT UPDATE_COUNT 1
UPDATE TEST SET NAME = 'partitioned' WHERE ID=2;

-- Reset dml mode to transactional
SET AUTOCOMMIT_DML_MODE='TRANSACTIONAL';

@EXPECT RESULT_SET 'NAME','partitioned'
SELECT NAME FROM TEST WHERE ID=2;

-- Set a statement timeout that should never be reached
SET STATEMENT_TIMEOUT = '10000s';

@EXPECT RESULT_SET 'NAME','partitioned'
SELECT NAME FROM TEST WHERE ID=2;

@EXPECT RESULT_SET 'READ_TIMESTAMP'
SHOW VARIABLE READ_TIMESTAMP;

-- Set a statement timeout that should always be exceeded
SET STATEMENT_TIMEOUT = '1ns';

@EXPECT EXCEPTION DEADLINE_EXCEEDED
SELECT NAME FROM TEST WHERE ID=2;

-- Turn off statement timeouts
SET STATEMENT_TIMEOUT = null;
-- There should be no read timestamp available
@EXPECT RESULT_SET 'READ_TIMESTAMP',null
SHOW VARIABLE READ_TIMESTAMP;

-- Set a statement timeout that should never be reached
SET STATEMENT_TIMEOUT = '10000s';

@EXPECT UPDATE_COUNT 1
INSERT INTO TEST (ID, NAME) VALUES (3, 'test');

@EXPECT RESULT_SET 'COMMIT_TIMESTAMP'
SHOW VARIABLE COMMIT_TIMESTAMP;

-- Set a statement timeout that should always be exceeded
SET STATEMENT_TIMEOUT = '1ns';
-- And then try to do an insert
@EXPECT EXCEPTION DEADLINE_EXCEEDED
INSERT INTO TEST (ID, NAME) VALUES (4, 'test');

-- Turn off statement timeouts
SET STATEMENT_TIMEOUT = null;
-- Delete record with id 4 if it exists (even though the statement timed out,
-- there is still a small chance that the statement did succeed)
DELETE FROM TEST WHERE ID=4;

-- Verify that a timeout means there's no commit timestamp
SET STATEMENT_TIMEOUT = '1ns';

@EXPECT EXCEPTION DEADLINE_EXCEEDED
INSERT INTO TEST (ID, NAME) VALUES (4, 'test');

SET STATEMENT_TIMEOUT = null;

@EXPECT RESULT_SET 'COMMIT_TIMESTAMP',null
SHOW VARIABLE COMMIT_TIMESTAMP;


NEW_CONNECTION;
-- Execute a number of statements on one connection
DELETE FROM TEST WHERE ID=4;

@EXPECT UPDATE_COUNT 1
INSERT INTO TEST (ID, NAME) VALUES (4, 'test');

@EXPECT RESULT_SET 'NAME','test'
SELECT * FROM TEST WHERE ID=4;

@EXPECT UPDATE_COUNT 1
UPDATE TEST SET NAME='test18' WHERE ID=4;

@EXPECT RESULT_SET 'NAME','test18'
SELECT * FROM TEST WHERE ID=4;

@EXPECT UPDATE_COUNT 1
DELETE FROM TEST WHERE ID=4;

@EXPECT RESULT_SET
SELECT COUNT(*) AS ACTUAL, 0 AS EXPECTED
FROM TEST
WHERE ID=4;


NEW_CONNECTION;
-- Test primary key violation

@EXPECT UPDATE_COUNT 1
INSERT INTO TEST (ID, NAME) VALUES (4, 'test');

@EXPECT EXCEPTION ALREADY_EXISTS
INSERT INTO TEST (ID, NAME) VALUES (4, 'should not be there');

--Check that the second insert failed
@EXPECT RESULT_SET 'NAME','test'
SELECT * FROM TEST WHERE ID=4;


NEW_CONNECTION;
-- Test multiple timeouts after each other on the same connection
SET STATEMENT_TIMEOUT = '1ns';

@EXPECT EXCEPTION DEADLINE_EXCEEDED
SELECT NAME FROM TEST WHERE ID=2;

@EXPECT EXCEPTION DEADLINE_EXCEEDED
SELECT NAME FROM TEST WHERE ID=2;

@EXPECT EXCEPTION DEADLINE_EXCEEDED
SELECT NAME FROM TEST WHERE ID=2;


NEW_CONNECTION;
-- Execute a DML batch.
START BATCH DML;
@EXPECT UPDATE_COUNT -1
INSERT INTO TEST (ID, NAME) VALUES (10, 'Batched insert 1');
@EXPECT UPDATE_COUNT -1
INSERT INTO TEST (ID, NAME) VALUES (11, 'Batched insert 2');
@EXPECT UPDATE_COUNT -1
INSERT INTO TEST (ID, NAME) VALUES (12, 'Batched insert 3');
@EXPECT RESULT_SET 'UPDATE_COUNTS',[1,1,1]
RUN BATCH;

-- Verify that the records were inserted.
@EXPECT RESULT_SET
SELECT COUNT(*) AS ACTUAL, 3 AS EXPECTED
FROM TEST
WHERE ID IN (10,11,12);


-- Execute a DML batch with an error.
START BATCH DML;
@EXPECT UPDATE_COUNT -1
DELETE FROM TEST WHERE ID IN (10,11,12);
@EXPECT UPDATE_COUNT -1
DELETE FROM TEST_NOT_FOUND WHERE ID IN (10,11,12);
-- Returns an error because of the second statement.
@EXPECT EXCEPTION INVALID_ARGUMENT
RUN BATCH;

-- Verify that the records were not deleted.
@EXPECT RESULT_SET
SELECT COUNT(*) AS ACTUAL, 3 AS EXPECTED
FROM TEST
WHERE ID IN (10,11,12);

START BATCH DML;
@EXPECT UPDATE_COUNT -1
DELETE FROM TEST WHERE ID=10;
DELETE FROM TEST WHERE ID=11;
DELETE FROM TEST WHERE ID=12;
@EXPECT RESULT_SET 'UPDATE_COUNTS',[1,1,1]
RUN BATCH;
